function WHERESUB,subscript,array
;+
; NAME:
;	WHERESUB
;
; PURPOSE:
;	Convert a 1d subscript value or array of value to a pixel position 
;	in the 2d array, or to an array containing the ensemble of these
;	pixel position
;
; CATEGORY:
;	Signal, image processing.
;
; CALLING SEQUENCE:
;	Result = wheresub(subscript,array)
;
; INPUTS:
;	subscript: the subscript or array of subscripts to process
;	array:	The array where to locate the subscript
;
; OUTPUTS:
;	Result = the 2d pixel position :
;	If only one subscript is entered Result is a LONARR(2) with
;	Result(0) = x and Result(1) = y.
;	If several subscripts are entered Result is a complex array 
;	containing all the 2d pixel positions : in such a case, 
;	FLOAT(result(i)) = x value at subscript(i) and
;	IMAGINARY(result(i)) = y value at subscript(i).
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, April  1993.
;-

on_error,2                              ;Return to caller if an error occurs
;check the size of subscript
size_sub=SIZE(subscript)

;get the size of the array
size_arr=SIZE(array)

IF size_sub(0) EQ 0 THEN BEGIN
pos=LONARR(2)
pos(1)=subscript/size_arr(1)
pos(0)=subscript-pos(1)*size_arr(1)
RETURN,pos
ENDIF

IF size_sub(0) EQ 1 THEN BEGIN
pos=COMPLEXARR(size_sub(1))
pos(*)=COMPLEX(subscript-(subscript(*)/size_arr(1))*size_arr(1),$
		subscript/size_arr(1))
RETURN,pos
ENDIF


END

