Function StrParse, line, delim, list

;+
; NAME:
;	STRPARSE
; PURPOSE:
;	Parses the string LINE using the characters in DELIM as delimiters.  
;	Puts individual pieces into consecutive locations in LIST.
; CATEGORY:
;	String Processing
; CALLING SEQUENCE:
;	Result = STRPARSE( LINE, DELIM [, LIST])
; INPUTS:
;    LINE
;	Character string.
;    DELIM
;	Character string.  Each Character of DELIM is used as a delimiter.
; OPTIONAL INPUT PARAMETERS:
;	None.
; KEYWORD PARAMETERS:
;	None.
; OUTPUTS:
;	Returns the number of pieces found minus one i.e. the index of the last
;	element of LIST if LIST is provided.  If LINE is a null string or not a
;	string, the function returns -1.
; OPTIONAL OUTPUT PARAMETERS:
;    LIST
;	Character array.  If name is provided, the pieces of LINE resulting 
;	from the parsing process are returned in consecutive locations in LIST.
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Straightforward.  Using the function TYPE from MIDL.
; MODIFICATION HISTORY:
;	Created 15-JUL-1991 by Mati Meron.
;-

    if Type(line) ne 7 then return, -1
    index = -1
    list = ''
    len = strlen(line)
    for i = 0, len - 1 do begin
	if strpos(delim,strmid(line,i,1)) ne -1 then index = [index,i]
    endfor
    index = [index,len]
    for i = 0, n_elements(index) - 2 do begin
	list = [list,strmid(line,index(i) + 1,index(i+1) - index(i) -1)]
    endfor
    inlist = where(list ne '',items)
    if items ne 0 then list = list(inlist)

    return, fix(items - 1)
end
