pro SORT_MILLER, struc,get_uniq=get_uniq,uniq_m=uniq_m,pntgp=pntgp
;+
; NAME:
;	SORT_MILLER
;
; PURPOSE:
;
;	Sorts struc according to increasing  Miller indices
;
; CATEGORY:
;	Structure managing
;
; CALLING SEQUENCE:
;	Sort_miller,struc,[/get_uniq],[uniq_m=uniq_m],[pntgp=pntgp] ;
;
; INPUTS:
;	struc: the structure to process : must possess the field "m"
;	(Miller indices).
;	get_uniq :  [optional] set this keyword to get the unique reflexion in the
;		point group specified by pntgp
;	uniq_m : if /UNIQ is set, then uniq_m will contain the miller indices of
;		unique reflexions.
;	pntgp : [optional] set this keyword to the point group number of your
;		data. Default to 1 
;
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None
;
; PROCEDURE
;	Simply: 
;	struc = struc(sort = SORT(10.^6*struc.m(0)+10.^3*struc.m(1)+struc.m(2)))
;
; MODIFICATION HISTORY:
;	D.Bourgeois, October 94.
;-

;on_error,2                              ;Return to caller if an error occurs


sort_m = SORT(DOUBLE(10.^8d*struc.m(0))+DOUBLE(10.^4d*struc.m(1))+DOUBLE(struc.m(2)))
struc = struc(sort_m)

IF KEYWORD_SET(get_uniq) THEN BEGIN ; search for unique reflexions
 IF N_ELEMENTS(pntgp) EQ 0 THEN pntgp=1
 PRINT,'Searching for unique miller indices in point group : ',pntgp
 miller = struc.m
 EQUIV_HKL,pntgp,miller
 sort_m=DOUBLE(10.^8d*miller(0,*))+DOUBLE(10.^4d*miller(1,*))+DOUBLE(miller(2,*))
 uniq_m=struc(UNIQ(sort_m, SORT(sort_m))) 
 PRINT,'Number of unique reflexions : ',(SIZE(uniq_m))(1)
ENDIF

END

