function INTERSEC, struc1,struc2,ct,sym=sym,un1=un1,w_un1=w_un1,w_com1=w_com1
;+
; NAME:
;	INTERSEC
;
; PURPOSE:
;
;	Returns the intersection (common spots) between struc1 and struc 2
;
; CATEGORY:
;	Structure managing
;
; CALLING SEQUENCE:
;	InterStruc = INTERSEC(struc1,struc2,ct,/sym) ;
;
; INPUTS:
;	struc1,2 : the structures to process
;
; OUTPUTS:
;	the part of struc1 matching the intersection between the input structures
;	ct : [optionnal] the number of common reflections
;	sym : set this keyword if struc1 is likely to contain several times
;		the same miller indices (for exemple if P212121_UNIQUE has
;		been run on struc1). The value of sym should be set to
;		the maximum number of times a same reflexions is found.
;	un1 : if sym is set, un1 contains the reflexions unique to
;		struc1
;	w_un1 : if sym is set, w_un1 contains the indices in struc1
;		corresponding to the reflexions un1
;	w_com1 : if sym is set, w_com1 contains the indices in struc1
;		also found in struc2
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward
;
; MODIFICATION HISTORY:
;	D.Bourgeois, June 95.
;-

;on_error,2                              ;Return to caller if an error occurs

;produce the right number of reflections
size1 = (SIZE(struc1))(1)
size2 = (SIZE(struc2))(1)
PRINT,'Sorting reflexions ...'
SORT_MILLER,struc1
SORT_MILLER,struc2

max_size = size1 > size2

h1 = struc1.m(0) & k1 = struc1.m(1) & l1 = struc1.m(2)
h2 = struc2.m(0) & k2 = struc2.m(1) & l2 = struc2.m(2)

max_hkl = MAX([h1,k1,l1]) > MAX([h2,k2,l2])
min_hkl = MIN([h1,k1,l1]) < MIN([h2,k2,l2])

;grid will be set to 2 if there is a common reflection
grid = BYTARR(max_hkl - min_hkl + 1,max_hkl - min_hkl + 1,max_hkl - min_hkl + 1)
;i1 contains the indices in struc1 associated with each (h,k,l)
i1 =  LONARR(max_hkl - min_hkl + 1,max_hkl - min_hkl + 1,max_hkl - min_hkl + 1)

grid(h1 - min_hkl,k1 - min_hkl,l1 - min_hkl) = 1
i1(h1 - min_hkl,k1 - min_hkl,l1 - min_hkl) = LINDGEN(size1)
grid(h2 - min_hkl,k2 - min_hkl,l2 - min_hkl) = grid(h2 - min_hkl,k2 - min_hkl,l2 - min_hkl) + 1

w = WHERE(grid EQ 2,ct)

IF ct NE 0 THEN BEGIN
 common_hkl = WHERESUB3(w,grid)
 common_h = common_hkl(0,*)
 common_k = common_hkl(1,*)
 common_l = common_hkl(2,*)

 w = i1(common_h,common_k,common_l)

 final = struc1(w)
 final = final(*)
 IF KEYWORD_SET(sym) THEN BEGIN
  ind_struc1=LONARR(size1)

  final = REPLICATE(struc1(0),size1)
  j = 0
  cr = STRING("15b)
  FOR i=0,ct-1 DO BEGIN
   IF i/100 EQ i/100.0 THEN PRINT,FORMAT="($,I5,' ie : ',F3.0,'%',A)",i,100.*i/FLOAT(ct),cr

   ;wl = WHERE((struc1(w(i):(w(i)+sym-1)<(size1-1)).m(0) EQ struc1(w(i)).m(0)) AND (struc1(w(i):(w(i)+sym-1)<(size1-1)).m(1) EQ struc1(w(i)).m(1)) AND (struc1(w(i):(w(i)+sym-1)<(size1-1)).m(2) EQ struc1(w(i)).m(2)),ctl)

   wl = WHERE((struc1(0>(w(i)-(sym-1)):w(i)).m(0) EQ struc1(w(i)).m(0)) AND (struc1(0>(w(i)-(sym-1)):w(i)).m(1) EQ struc1(w(i)).m(1)) AND (struc1(0>(w(i)-(sym-1)):w(i)).m(2) EQ struc1(w(i)).m(2)),ctl)
   final(j:j+ctl-1) = struc1(0>(w(i)-(sym-1))+wl)

   ind_struc1(0>(w(i)-(sym-1))+wl) = 1

   ;h=final(j).m(0)
   ;k=final(j).m(1)
   ;l=final(j).m(2)
   ;if (h eq 0) and (k eq 0) and (l eq 35) then stop

   j = j + ctl
   ;if (struc1(w(i)).m(0) eq 1) and (struc1(w(i)).m(1) eq 0) and (struc1(w(i)).m(2) eq 20) then print,'added:',ctl,' for:',struc1(w(i)).m
  ENDFOR
  final = final(0:j-1)

  w_com1=WHERE(ind_struc1 EQ 1,ct_com1)
  w_un1=WHERE(ind_struc1 EQ 0,ct_un1)
  PRINT,'Number of reflexions unique to first set : ',ct_un1
  IF ct_un1 GT 0 THEN un1=struc1(w_un1) ELSE un1=0

 ENDIF ; (keyword_set(sym))


 IF (SIZE(final))(1) GT 1 THEN SORT_MILLER,final
 ct = (SIZE(final))(1)
 PRINT,'Total number of common reflections',ct
 RETURN,final
ENDIF ELSE BEGIN
 PRINT,'There is no common reflections !'
 RETURN,0
ENDELSE
END

