function GET_SPIKE,peak,cut,boxsize,spike,p2,show=show
;+
; NAME:
;	GET_SPIKE
;
; PURPOSE:
;	This routine finds out spikes in peak.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	boolean = GET_SPIKE(peak,cut,boxsize,spike,/show)
;
; INPUTS:
;	peak : the background subtracted peak to integrate.
;	cut : the fit_level cutoff [%] as returned by GET_BOXLEVEL.PRO
;	boxsize : the size of peak (normaly par.boxsize)
;	show : set this keyword is a message is to be displayed
;
; OUTPUTS:
;	boolean : 0 if no spike, 1 if any.
;	spike : [optional] Contains the coordinates in peak of the first
;		found spike, if any. If none, set to 0.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	All the pixels with an intensity > 2*(cut>2.5) intensity are set to 1,
;	 all
;	the others to zero. Then the program looks for "1" pixels which are 
;	surrounded by more than 23 "0" pixels. These pixels are called spike.
;	It could also happen that a spike is still surrounded by
;	"1" pixels. In such a case it is checked which "1" pixels are 
;	surrounded by 8 lower value pixels. If two such pixels are found
;	(the original peak + another one) then a spike is detected.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, February 1995.
;-


;here :
spike = REPLICATE({xy : [0,0]},2)
p2 = peak
p2(*) = 0

cutoff = cut > 2.5
;cutoff = 20

w = WHERE(peak GE MAX(peak)*1*cutoff/100.,count)
c = WHERESUB(w,peak)
p2(w) = 1

;is there one isolated pixel in p2 ?

FOR i=0,count-1 DO BEGIN
x = FLOAT(c(i))
y = IMAGINARY(c(i))

surround = p2(0>(x-2):(x+2)<(boxsize.x-1),0>(y-2):(y+2)<(boxsize.y-1))
;if more than 6 pixels of surround are 0, then it is a spike
dummy = WHERE(surround EQ 0, n_zero)
IF n_zero GE ((SIZE(surround))(4)-2) THEN BEGIN
IF KEYWORD_SET(show) THEN PRINT,'Spike (type 1) found!'
;find the coordinates of the spike in peak
spike(0).xy = [x, y]
spike = spike(0)
;stop
;goto,here
RETURN,1
ENDIF

ENDFOR

;are there two peaks in peak ?
n_peak = 0
FOR i=0,count-1 DO BEGIN
x = FLOAT(c(i))
y = IMAGINARY(c(i))
surround = peak(0>(x-1):(x+1)<(boxsize.x-1),0>(y-1):(y+1)<(boxsize.y-1))
;if all pixels of surround are lower than the central pixel, then there is a peak
dummy = WHERE(surround LT peak(x,y), n_lower)
IF n_lower EQ ((SIZE(surround))(4)-1) THEN BEGIN
n_peak = n_peak + 1
spike(n_peak-1).xy = [x, y]
IF n_peak GE 2 THEN BEGIN
IF KEYWORD_SET(show) THEN PRINT,'Spike (type 2) found!'
;find the coordinates of the spike in peak
;stop
;goto,here
RETURN,1
ENDIF
ENDIF

ENDFOR

;is the peak not centered ?

wmax = WHERE(peak EQ MAX(peak))
wmaxc = WHERESUB(wmax,peak)
wcen = COMPLEX(FIX(boxsize.x/2.),FIX(boxsize.y/2.))

IF (MAX(FLOAT(wmaxc - wcen)) > MAX(IMAGINARY(wmaxc - wcen))) GE 3 THEN BEGIN
IF KEYWORD_SET(show) THEN PRINT,'Spike (type 3) found!'
RETURN,1
ENDIF

;if this point reached, there was no spike
spike = 0
RETURN,0
END









