FUNCTION GET_INTERP_PROFILE,adapted_profile,x,y,SHOW=SHOW,REVERSE=REVERSE
;+
; NAME:
;	GET_INTERP_PROFILE
;
; PURPOSE:
;	Interpolates a profile in order to shift it towards a position
;	defined by x,y, by steps of a quarter of a pixel.
;
; CATEGORY:
;	Data processing.
;
; CALLING SEQUENCE:
;	adapted_profile2=GET_INTERP_PROFILE(adapted_profile,x,y,SHOW=SHOW,REVERSE=REVERSE)	
;
; INPUTS:
;	adapted_profile : a 2D array
;	x		: predicted x spot position [raster]
;	y		: predicted y spot position [raster]
;	show : keyword set to look at what happens
;	reverse : keyword set if the shift is done in opposite direction : this is used if
;		a non centered profile is to be brought back to the center of the box. 
;
; OUTPUTS:
;	adapted_profile2 : the shifted profile
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Based on cubic interpolation.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, June 97.
;-

sx=(SIZE(adapted_profile))(1) & sy=(SIZE(adapted_profile))(2)

x2 = (x MOD 1) - 0.5
y2 = (y MOD 1) - 0.5

IF KEYWORD_SET(reverse) THEN BEGIN
 x2=-x2
 y2=-y2
ENDIF

adapted_profile2 = INTERPOLATE(adapted_profile,INDGEN(sx) - x2, INDGEN(sy) - y2, CUBIC=-0.5,/GRID)

GOTO,skip_orig

p = CONGRID(adapted_profile,4*sx,4*sy,/CUBIC)

orig_xind = REPLICATE(1,sx) # INDGEN(sy)*16*sx
orig_yind = INDGEN(sx)*4 # REPLICATE(1,sy)
orig_ind=orig_xind + orig_yind 

x2 = x MOD 1
y2 = y MOD 1

IF KEYWORD_SET(reverse) THEN BEGIN
 x2=1-x2
 y2=1-y2
ENDIF

IF x2 GE 0 AND x2 LT 0.125 THEN BEGIN ; move x left 0.5

 IF y2 GE 0 AND y2 LT 0.125 THEN BEGIN ; move y left 0.5 move x left 0.5
  p=SHIFT(p,-2,-2)
 ENDIF

 IF y2 GE 0.125 AND y2 LT 0.375 THEN BEGIN ; move y left 0.25 move x left 0.5
  p=SHIFT(p,-2,-1)
 ENDIF

 IF y2 GE 0.375 AND y2 LT 0.625 THEN BEGIN ; don't move y move x left 0.5
  p=SHIFT(p,-2,0)
 ENDIF

 IF y2 GE 0.625 AND y2 LT 0.875 THEN BEGIN ; move y right 0.25 move x left 0.5
  p=SHIFT(p,-2,1)
 ENDIF

 IF y2 GE 0.875 AND y2 LT 1 THEN BEGIN ; move y right 0.5 move x left 0.5
  p=SHIFT(p,-2,2)
 ENDIF

ENDIF

IF x2 GE 0.125 AND x2 LT 0.375 THEN BEGIN ; move left 0.25

 IF y2 GE 0 AND y2 LT 0.125 THEN BEGIN ; move y left 0.5 move x left 0.25
  p=SHIFT(p,-1,-2)
 ENDIF

 IF y2 GE 0.125 AND y2 LT 0.375 THEN BEGIN ; move y left 0.25 move x left 0.25
  p=SHIFT(p,-1,-1)
 ENDIF

 IF y2 GE 0.375 AND y2 LT 0.625 THEN BEGIN ; don't move y move x left 0.25
  p=SHIFT(p,-1,0)
 ENDIF

 IF y2 GE 0.625 AND y2 LT 0.875 THEN BEGIN ; move y right 0.25 move x left 0.25
  p=SHIFT(p,-1,1)
 ENDIF

 IF y2 GE 0.875 AND y2 LT 1 THEN BEGIN ; move y right 0.5 move x left 0.25
  p=SHIFT(p,-1,2)
 ENDIF

ENDIF

IF x2 GE 0.375 AND x2 LT 0.625 THEN BEGIN ; don't move

 IF y2 GE 0 AND y2 LT 0.125 THEN BEGIN ; move y left 0.5 don't move x
  p=SHIFT(p,0,-2)
 ENDIF

 IF y2 GE 0.125 AND y2 LT 0.375 THEN BEGIN ; move y left 0.25 don't move x
  p=SHIFT(p,0,-1)
 ENDIF

 IF y2 GE 0.375 AND y2 LT 0.625 THEN BEGIN ; don't move y don't move x
  p=SHIFT(p,0,0)
 ENDIF

 IF y2 GE 0.625 AND y2 LT 0.875 THEN BEGIN ; move y right 0.25 don't move x
  p=SHIFT(p,0,1)
 ENDIF

 IF y2 GE 0.875 AND y2 LT 1 THEN BEGIN ; move y right 0.5 don't move x
  p=SHIFT(p,0,2)
 ENDIF

ENDIF

IF x2 GE 0.625 AND x2 LT 0.875 THEN BEGIN ; move right 0.25

 IF y2 GE 0 AND y2 LT 0.125 THEN BEGIN ; move y left 0.5 move x right 0.25
  p=SHIFT(p,1,-2)
 ENDIF

 IF y2 GE 0.125 AND y2 LT 0.375 THEN BEGIN ; move y left 0.25 move x right 0.25
  p=SHIFT(p,1,-1)
 ENDIF

 IF y2 GE 0.375 AND y2 LT 0.625 THEN BEGIN ; don't move y move x right 0.25
  p=SHIFT(p,1,0)
 ENDIF

 IF y2 GE 0.625 AND y2 LT 0.875 THEN BEGIN ; move y right 0.25 move x right 0.25
  p=SHIFT(p,1,1)
 ENDIF

 IF y2 GE 0.875 AND y2 LT 1 THEN BEGIN ; move y right 0.5 move x right 0.25
  p=SHIFT(p,1,2)
 ENDIF

ENDIF

IF x2 GE 0.875 AND x2 LT 1 THEN BEGIN ; move right 0.5

 IF y2 GE 0 AND y2 LT 0.125 THEN BEGIN ; move y left 0.5 move x right 0.5
  p=SHIFT(p,2,-2)
 ENDIF

 IF y2 GE 0.125 AND y2 LT 0.375 THEN BEGIN ; move y left 0.25 move x right 0.5
  p=SHIFT(p,2,-1)
 ENDIF

 IF y2 GE 0.375 AND y2 LT 0.625 THEN BEGIN ; don't move y move x right 0.5
  p=SHIFT(p,2,0)
 ENDIF

 IF y2 GE 0.625 AND y2 LT 0.875 THEN BEGIN ; move y right 0.25 move x right 0.5
  p=SHIFT(p,2,1)
 ENDIF

 IF y2 GE 0.875 AND y2 LT 1 THEN BEGIN ; move y right 0.5 move x right 0.5
  p=SHIFT(p,2,2)
 ENDIF

ENDIF

adapted_profile2 = p(orig_ind)


skip_orig :

IF KEYWORD_SET(show) THEN BEGIN
 PRINT,'REFERENCE PROFILE :'
 PRINT,'Original reference profile + New reference profile : '
 PRINT,'X/Y values [pixels] : ',x,y
 temp = adapted_profile
 temp2 = adapted_profile2
 CONTOUR,temp,LEVELS=[(INDGEN(10)+1)*MAX(temp)/10.],C_COLORS=!D.N_COLORS - 150
 CONTOUR,temp2,LEVELS=[(INDGEN(10)+1)*MAX(temp2)/10.],/NOERASE,C_COLORS=!D.N_COLORS - 60

 OK=''
 READ,'OK ? [Y/N]',OK

ENDIF

RETURN,adapted_profile2
END


