function GET_DENZO_SPOTS2,struc,image,red,par,show=show
;+
; NAME:
;	GET_DENZO_SPOTS2
;
; PURPOSE:
;
;	Returns the original data image corresponding to a reflexion list 
;	(from a DENZO .x file)
;	Useful to study a few spots
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	spotimage = GET_DENZO_SPOTS2(struc,image,red,par,/show)
;
; INPUTS:
;	image : the image
;	red : a rebinned version of image
;	struc : the reflection list (a structure produced with the
;	        routine READ_DENZOX, or equivalent. The structure 
;		must contain the following fields : .x ; .y

;	par : the parameters from the routine READ_DENZOX, or equivalent.
;	      Must contain the following fields : .boxsize ; .cenx ;
;	      .ceny ; .yscale ; .raster ; .noise_percentage ; .bg_gain ;
;	      .dark_current
;	show : keyword set to visualize the spot
;
; OUTPUTS:
;	spotimage : a structure containing all information on the spots
;		defined in 'struc'.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	For background subtraction, uses the routine BACK2D_POLY4.PRO
;
; MODIFICATION HISTORY:
;	D.Bourgeois, February 1994.
;-

;the size of the box around peak center
tempimage=FLTARR(par.boxsize,par.boxsize)


!ERR = 0
;position of the beam center on the original Laue image [pixels] 
centerX = par.cenx - 1
centerY = par.ceny - 1

scaleY = par.yscale

;original pixel size [micrometers]
pix_size = par.raster
pix_sizeX = 0.001*pix_size
pix_sizeY = 0.001*pix_size/scaleY


;size of "image"
imageX = (size(image))(1)
imageY = (size(image))(2)

;position of the studied area relative to the center of the beam [mm]
minX = pix_sizeX*(-centerX)
minY = pix_sizeY*(-centerY)
maxX = pix_sizeX*(-centerX+imageX-1)
maxY = pix_sizeY*(-centerY+imageY-1)

;create a window containing the simulated data and a small for 3D surface
;representation
;save the window numbers
main_window = !D.WINDOW
IF KEYWORD_SET(show) THEN BEGIN
WIN,512,512
sim_window = !D.WINDOW
ENDIF

;create a reduced structure array which contains only the spots of interest
;  The criteria of selection is that the position of the spot be inside
;  the box defined by minX, maxX, minY and maxY
spots = struc(WHERE((struc(*).x GE minX) AND $
		    (struc(*).x LE maxX) AND $
		    (struc(*).y GE minY) AND $
		    (struc(*).y LE maxY)))

;create the images as a structure

area = REPLICATE({	sp : LONARR(par.boxsize,par.boxsize), $
		 	bc : LONARR(par.boxsize,par.boxsize), $
			m: INTARR(3), $
			x: 0.0, $
			y: 0.0, $
			xpix: 0.0, $
			ypix: 0.0, $
			lp: 0.0, $
			strength: 0.0, $
			partiality: 0.0, $
			cosine: 0.0, $
			chisquare: 0.0, $
			par1: 0.0, $
			par2: 0.0, $
			l: 0.0, $
			mul: 0, $
			nodal: 0, $
			ovlp: 0,$
			id:0, $
			connect: INTARR(24), $
			close:0, $
			m2: INTARR(3), $
			nidx: 0, $
			l2: 0.0,$
			ipoint: 0, $
			dminth: 0.0, $
			intb: FLTARR(6), $
			isigb: FLTARR(6), $
			intp: FLTARR(6), $
			isigp: FLTARR(6),$
			tth: 0.0, $
			res: 0.0, $
			bc_coeff : FLTARR(3), $
		  	flag : 0, $ ; set to 1 if bad background 
		  	fwhm : 0.0 },$
		  			(SIZE(spots))(1))

FOR i=0,(size(spots))(1)-1 DO BEGIN
	;xpos = ROUND(spots(i).x/pix_sizeX+centerX)
	;ypos = ROUND(spots(i).y/pix_sizeY+centerY)
	xpos = FIX(spots(i).x/pix_sizeX+centerX)
	ypos = FIX(spots(i).y/pix_sizeY+centerY)
;select the right area on the image
        area(i).sp = image(xpos - par.boxsize/2:xpos + par.boxsize/2-1 ,ypos - par.boxsize/2:ypos + par.boxsize/2-1)

;select the allowed indices
first_bc = BACK2D_POLY4(area(i).sp,par.noise_percentage,par.bg_gain,par.dark_current,flag,bc_coeff,bc_mean,n_back,max_cycle=2)
first_bcsub = area(i).sp-first_bc
scale_factor = 1

;REPEAT BEGIN
;allowed_indices = WHERE(first_bcsub LE MAX(first_bcsub)*0.01*scale_factor,ct)
;scale_factor = 2*scale_factor
;ENDREP UNTIL (ct GT 0.3*(SIZE(first_bcsub))(4))

;&&&NEW
maxsub = (WHERE(first_bcsub EQ MAX(first_bcsub)))(0)
maxpos = WHERESUB(maxsub,first_bcsub)

cutoff = GET_BOXLEVEL(first_bcsub,n_back,bc_mean,par.dark_current)
REPEAT BEGIN
allowed_indices = SEARCH2D(first_bcsub,maxpos(0),maxpos(1),MAX(first_bcsub)*cutoff/100.*scale_factor,MAX(first_bcsub))
ct = (SIZE(allowed_indices))(1)
scale_factor = 2*scale_factor
ENDREP UNTIL (ct LE 0.7*(SIZE(first_bcsub))(4))
tmp = first_bcsub
tmp(allowed_indices)=0
allowed_indices = WHERE(tmp NE 0)
;&&&NEW

;ok=''
;tmp=first_bcsub
;tmp(*)=0
;tmp(allowed_indices)=1
;surface,tmp
;read,'ok ?',ok

;get backgr
area(i).bc = BACK2D_POLY5(area(i).sp,allowed_indices,par.noise_percentage,par.bg_gain,par.dark_current,flag,bc_coeff,bc_mean,n_back)
area(i).flag = flag
area(i).bc_coeff = [0,n_back,bc_mean]

dum = WHERE((area(i).sp - area(i).bc) GE MAX(area(i).sp - area(i).bc)/2.0,count)
area(i).fwhm = 0.001*pix_size*SQRT(count)

area(i).m = spots(i).m
area(i).x = spots(i).x
area(i).y = spots(i).y

area(i).chisquare = spots(i).chisquare
area(i).cosine = spots(i).cosine
area(i).lp = spots(i).lp
area(i).xpix = spots(i).xpix
area(i).ypix = spots(i).ypix
area(i).partiality = spots(i).partiality
area(i).strength = spots(i).strength
area(i).par1 = spots(i).par1
area(i).par2 = spots(i).par2

area(i).l = spots(i).l
area(i).mul = spots(i).mul
area(i).nodal = spots(i).nodal
area(i).ovlp = spots(i).ovlp
area(i).id = spots(i).id
area(i).connect = spots(i).connect
area(i).close = spots(i).close
area(i).m2 = spots(i).m2
area(i).nidx = spots(i).nidx
area(i).l2 = spots(i).l2
area(i).ipoint = spots(i).ipoint
area(i).dminth = spots(i).dminth
area(i).intb = spots(i).intb
area(i).isigb = spots(i).isigb
area(i).intp = spots(i).intp
area(i).isigp = spots(i).isigp
area(i).tth = spots(i).tth
area(i).res = spots(i).res

IF KEYWORD_SET(show) THEN BEGIN
WSET,sim_window
SURFACE,area(i).sp
WSET,main_window
dummy = PIXLAUE2(area(i),red,image,par,draw=8)
OK=''
READ,'OK ? [Y/N]',OK
WSET,sim_window
ENDIF

ENDFOR

temp=area(0:(size(spots))(1)-1)
RETURN,temp
END















