function GET_DENZO_SPOTS,struc,image,reb,par,show=show,old_spots=old_spots
;+
; NAME:
;	GET_DENZO_SPOTS
;
; PURPOSE:
;
;	Returns the original data image corresponding to a reflexion list 
;	(from a DENZO .x file)
;	Useful to study a few spots
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	spotimage = GET_DENZO_SPOTS(struc,image,reb,par,[/show,old_spots=old_spots])
;
; INPUTS:
;	image : the image
;	reb : the rebinning factor
;	struc : the reflection list (a structure produced with the
;	        routine READ_DENZOX, or equivalent. The structure 
;		must contain the following fields : .x ; .y

;	par : the parameters from the routine READ_DENZOX, or equivalent.
;	      Must contain the following fields : .boxsize ; .cenx ;
;	      .ceny ; .yscale ; .raster ; .noise_percentage ; .bg_gain ;
;	      .dark_current
;	show : keyword set to visualize the spot
;	old_spots : old_spots for which all calculations done in this routine have been already performed (saves time)
;
; OUTPUTS:
;	spotimage : a structure containing all information on the spots
;		defined in 'struc'.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	For background subtraction, uses the routine BACK2D_POLY4.PRO
;
; MODIFICATION HISTORY:
;	D.Bourgeois, February 1994, March 98.
;-

;the size of the box around peak center
tempimage=FLTARR(par.boxsize.x,par.boxsize.y)


!ERR = 0
;position of the beam center on the original Laue image [pixels] 
centerX = par.cenx - 1
centerY = par.ceny - 1

scaleY = par.yscale

;original pixel size [micrometers]
pix_size = par.raster
pix_sizeX = 0.001*pix_size
pix_sizeY = 0.001*pix_size/scaleY


;size of "image"
imageX = (size(image))(1)
imageY = (size(image))(2)

;position of the studied area relative to the center of the beam [mm]
minX = pix_sizeX*(-centerX)
minY = pix_sizeY*(-centerY)
maxX = pix_sizeX*(-centerX+imageX-1)
maxY = pix_sizeY*(-centerY+imageY-1)

;create a window containing the simulated data and a small for 3D surface
;representation
;save the window numbers
main_window = !D.WINDOW
IF KEYWORD_SET(show) THEN BEGIN
WIN,512,512
sim_window = !D.WINDOW
ENDIF

;create a reduced structure array which contains only the spots of interest
;  The criteria of selection is that the position of the spot be inside
;  the box defined by minX, maxX, minY and maxY
spots = struc(WHERE((struc(*).x GE minX) AND $
		    (struc(*).x LE maxX) AND $
		    (struc(*).y GE minY) AND $
		    (struc(*).y LE maxY)))

;create the images as a structure

;area = REPLICATE({	ref_spots, $ ; anonymous structure is preferable !
area = REPLICATE({	$
			sp : LONARR(par.boxsize.x,par.boxsize.y,/NOZERO), $
		 	bc : LONARR(par.boxsize.x,par.boxsize.x,/NOZERO), $
			m: INTARR(3,/NOZERO), $
			x: 0.0, $
			y: 0.0, $
			xpix: 0.0, $
			ypix: 0.0, $
			lp: 0.0, $
			strength: 0.0, $
			partiality: 0.0, $
			cosine: 0.0, $
			chisquare: 0.0, $
			par1: 0.0, $
			par2: 0.0, $
			l: 0.0, $
			mul: 0, $
			nodal: 0, $
			ovlp: 0,$
			id:0L, $
			connect: LONARR(24,/NOZERO), $
			close:0, $
			m2: INTARR(3,/NOZERO), $
			nidx: 0, $
			l2: 0.0,$
			phi: 0.0,$
			ipoint: 0, $
			dminth: 0.0, $
			intb: FLTARR(6,/NOZERO), $
			isigb: FLTARR(6,/NOZERO), $
			intp: FLTARR(6,/NOZERO), $
			isigp: FLTARR(6,/NOZERO),$
			tth: 0.0, $
			res: 0.0, $
			bc_coeff : FLTARR(3,/NOZERO), $
		  	flag : 0, $ ; set to 1 if bad background 
		  	sector : 0, $ ; the sector in the image
			spike_tested : 0, $
		  	fwhm : 0.0 },$
		  			(SIZE(spots))(1))


;if some old spots were already studied, do not repeat calculations
number_old_spots = N_ELEMENTS(old_spots)
IF number_old_spots GT 0 THEN BEGIN
 new_spots = DIFF_STRUC(spots,old_spots)
 ;do area(0:number_old_spots-1)=old_spots
 FOR loc_i = 0, n_tags(old_spots(0))-1 DO BEGIN
    result=EXECUTE('area(0:number_old_spots-1).'+(tag_names(old_spots(0)))(loc_i)+' = old_spots.'+(tag_names(old_spots(0)))(loc_i))
 ENDFOR
 IF (SIZE(new_spots))(0) GT 0 THEN BEGIN
  spots=new_spots 
  PRINT,'Number of new spots tested : ', (size(spots))(1)
 ENDIF ELSE BEGIN
;  PRINT,'No new spot added !'
  RETURN,old_spots
 ENDELSE
ENDIF

FOR i=0,(size(spots))(1)-1 DO BEGIN
	;xpos = ROUND(spots(i).x/pix_sizeX+centerX)
	;ypos = ROUND(spots(i).y/pix_sizeY+centerY)
	xpos = FIX(spots(i).x/pix_sizeX+centerX)
	ypos = FIX(spots(i).y/pix_sizeY+centerY)
;select the right area on the image
        area(number_old_spots+i).sp = image(xpos - FIX(par.boxsize.x/2.):xpos + FIX(par.boxsize.x/2.) ,ypos - FIX(par.boxsize.y/2.):ypos + FIX(par.boxsize.y/2.))

;stop
;get backgr
area(number_old_spots+i).bc = BACK2D_POLY4(area(number_old_spots+i).sp,par.noise_percentage,par.bg_gain,par.dark_current,flag,bc_coeff,bc_mean,n_back)
area(number_old_spots+i).flag = flag
area(number_old_spots+i).bc_coeff = [0,n_back,bc_mean]

dum = WHERE((area(number_old_spots+i).sp - area(number_old_spots+i).bc) GE MAX(area(number_old_spots+i).sp - area(number_old_spots+i).bc)/2.0,count)
area(number_old_spots+i).fwhm = 0.001*pix_size*SQRT(count)

area(number_old_spots+i).m = spots(i).m
area(number_old_spots+i).x = spots(i).x
area(number_old_spots+i).y = spots(i).y

area(number_old_spots+i).chisquare = spots(i).chisquare
area(number_old_spots+i).cosine = spots(i).cosine
area(number_old_spots+i).lp = spots(i).lp
area(number_old_spots+i).xpix = spots(i).xpix
area(number_old_spots+i).ypix = spots(i).ypix
area(number_old_spots+i).partiality = spots(i).partiality
area(number_old_spots+i).strength = spots(i).strength
area(number_old_spots+i).par1 = spots(i).par1
area(number_old_spots+i).par2 = spots(i).par2

area(number_old_spots+i).l = spots(i).l
area(number_old_spots+i).mul = spots(i).mul
area(number_old_spots+i).nodal = spots(i).nodal
area(number_old_spots+i).ovlp = spots(i).ovlp
area(number_old_spots+i).sector = spots(i).sector-1
area(number_old_spots+i).id = spots(i).id
area(number_old_spots+i).connect = spots(i).connect
area(number_old_spots+i).close = spots(i).close
area(number_old_spots+i).m2 = spots(i).m2
area(number_old_spots+i).nidx = spots(i).nidx
area(number_old_spots+i).l2 = spots(i).l2
area(number_old_spots+i).phi = spots(i).phi
area(number_old_spots+i).ipoint = spots(i).ipoint
area(number_old_spots+i).dminth = spots(i).dminth
area(number_old_spots+i).intb = spots(i).intb
area(number_old_spots+i).isigb = spots(i).isigb
area(number_old_spots+i).intp = spots(i).intp
area(number_old_spots+i).isigp = spots(i).isigp
area(number_old_spots+i).tth = spots(i).tth
area(number_old_spots+i).res = spots(i).res

IF KEYWORD_SET(show) THEN BEGIN
WSET,sim_window
SURFACE,area(number_old_spots+i).sp
WSET,main_window
dummy = PIXLAUE2(area(number_old_spots+i),reb,image,par,draw=8)
OK=''
READ,'OK ? [Y/N]',OK
WSET,sim_window
ENDIF

ENDFOR

RETURN,area(0:number_old_spots+(size(spots))(1)-1)
END















