function GET_COMMON_PIX, struc1,struc2,j
;+
; NAME:
;	GET_COMMON_PIX
;
; PURPOSE:
;	Returns the sum of the products of the common pixel values between
;	struc1 and struc2. The structures
;	must contain the fields "indices" and "adapted_profile". 
;	The sorting is done according to "indices".
;
; CATEGORY:
;	Structure managing
;
; CALLING SEQUENCE:
;	tot = GET_COMMON_PIX(struc1,struc2,j) ;
;
; INPUTS:
;	struc1,2 : the structures to process. These are structures, not array
;		of structures.
;
; OUTPUTS:
;	tot : The sum of the products of the common pixel values between
;	struc1 and struc2.
;	j : [optionnal] returns the number of common pixels
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward
;
; MODIFICATION HISTORY:
;	D.Bourgeois, November 94.
;-

;on_error,2                              ;Return to caller if an error occurs

;number of pixels to process
num_pixel = (SIZE(struc2.indices))(1)
final = {adap_pro1 : FLTARR(num_pixel),adap_pro2 : FLTARR(num_pixel)}
j = 0

;Check the intersection between struc1.indices and struc2.indices

FOR i=0,num_pixel-1 DO BEGIN
;IF i/100 EQ i/100.0 THEN PRINT,i,' ie :',100.*i/FLOAT(num_pixel),'%'
 index = WHERE(struc1.indices EQ struc2.indices(i), count)

 IF count NE 0 THEN BEGIN
    final.adap_pro1(j) = struc1.adapted_profile(index)
    final.adap_pro2(j) = struc2.adapted_profile(i)
   j = j + 1
 ENDIF
ENDFOR

;PRINT,'Number of common pixels : ',j
;PRINT,'Percentage : ', 100*j/FLOAT(num_pixel)
;plot,final.adap_pro1(0:j-1)
;oplot,final.adap_pro2(0:j-1),linestyle=2
;OK=''
;PRINT,'OK ? [Y/N]'
;READ,OK

IF j NE 0 THEN RETURN,TOTAL(final.adap_pro1(0:j-1)*final.adap_pro2(0:j-1)) ELSE RETURN,0.
END

