PRO xop_environment, Group=group, Edit=edit

;+
; NAME:
;       XOP_ENVIRONMENT
;
; PURPOSE:
;       Presents a window with the XOP environment variables.
;	Optionally (see edit keyword) allows editing.
;
; CATEGORY:
;       XOP
;
; CALLING SEQUENCE:
;       Xop_Environment
;
; INPUTS:
;
;
; KEYWORD PARAMETERS:
;       GROUP:  The widget ID of the group leader of the widget.  If this
;               keyword is specified, the death of the group leader results in
;               the death of widgets created by XOP_ENVIRONMENT.
;	EDIT: If set, allows to edit the parameters
;
; OUTPUTS:
;       None
;
; SIDE EFFECTS:
;	Modify environment variables (is edit keyword is set and 
;	changes are typed).
;
; PROCEDURE:
;       Straightforward.
;
; USE:
;	It is launched from the main XOP window for debugging and 
;	customization purposes. 
;
; EXAMPLES:
;       Xop_Environment
;
; MODIFICATION HISTORY:
;       Written by:     Manuel Sanchez del Rio (srio@esrf.fr) 98/11/05
;	99-04-10 srio@esrf.fr adds XOP_ENV and removes HOME. Only resets 
;	variables if user selects "Quit and accept changes".
;	03-01-07 srio@esrf.fr Added text with description. 
;
;-

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   IF SDep(/W) THEN itmp = Dialog_Message(Dialog_Parent=group, $
   /Error,'XOP_ENVIRONMENT: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   RETURN
ENDIF

vars = ['XOP_HOME',$
	'XOP_MODE',$
	'XOP_TASK',$
;	'XOP_ENV',$
	'IDL_DIR',$
	'DABAX_PATH',$
	'DABAX_HELP',$
	'XOP_IFC',$
	'XOP_WD',$
;	'XOP_USER_HOME',$
	'XOP_BINARIES',$
	'XOP_BINARIES_DEBUG',$
	'XOP_ANNOUNCE',$
	'XOP_VERSION',$
;	'XOP_WEB_BROWSER',$
	'XOP_DEFAULTS_DIR', $
	'XPLOT_DEFAULTS', $
	'XOP_BARTITLE', $
	'XOP_PROJECT' ]


helptxt = [';XOP_HOME is the main root directory for the XOP installation',$
	';XOP_MODE = EMBEDDED (default) or DEVELOPPER (if using an idl license)',$
	';XOP_TASK the application to be started when launching xop (default=xop)',$
;	';XOP_ENV **NOT LONGER USED **',$
	';IDL_DIR root directory of idl installation',$
	';DABAX_PATH path where to find DABAX data files (must be defined)',$
	';DABAX_HELP ** in xop_ini.pro - TO BE DELETED ?? **',$
	';XOP_IFC dir with interface files (not defined=defaut=$XOP_HOME/ifc)',$
	';XOP_WD Working directory (not defined=default=. in unix, $XOP_HOME\tmp in WIndows)',$
;	';XOP_USER_HOME ** in xop_ini.pro - TO BE DELETED ?? **',$
	';XOP_BINARIE dir where executable files are sitting',$
	';XOP_BINARIES_DEBUG debug flag: nothing=defaut=normal mode; set to 1 for verbose mode  ',$
	';XOP_ANNOUNCE file to be displayed when main xop window is started (defaut=none)',$
	';XOP_VERSION ** TO BE DELETED ?? **',$
;	';XOP_WEB_BROWSER ** TO BE DELETED **',$
	';XOP_DEFAULTS_DIR dir to store customized input files', $
	';XPLOT_DEFAULTS xplot attributes file (default=none)', $
	';XOP_BARTITLE string with text for the main xop window (default=none=XOP 2.1)', $
	';XOP_PROJECT project files to be loaded ($XOP_HOME/ifc/$XOP_PROJECT.*) (default=xop) ' ]


FOR i=0,N_Elements(vars)-1 DO vars[i]=vars[i]+'='+Xop_GetEnv(vars[i])

text = [';','; XOP environment variables ',';']
FOR i=0,N_Elements(vars)-1 DO BEGIN
  text=[text,';',';',helptxt[i],vars[i]]
ENDFOR

action=''
XDisplayFile1,Text=text,group=group, Title='XOP environment', $
  Modal=edit, Action=action

IF Keyword_Set(edit) AND action EQ 'DO' THEN BEGIN
  Message,/Info,'Resetting variables.'
  FOR i=0,N_Elements(text)-1 DO BEGIN
     IF strMid(StrCompress(text[i],/Rem),0,1) NE ';' THEN Xop_SetEnv,text[i]
  ENDFOR
ENDIF

END ; Xop_Environment
