;
; Copyright (c) 1993-1996, ESRF.  All rights reserved.
;	Unauthorized reproduction prohibited.
; Copyright (c) 1991, Research Systems, Inc.  All rights reserved.
;	Unauthorized reproduction prohibited.
;+
; NAME:
;	XSCRMENU
; PURPOSE:
;	This routine provides an editor for any IDL variable.
; CATEGORY:
;	Widgets
; CALLING SEQUENCE:
;	XSCRMENU, VAR
; INPUTS:
;	VAR = The variable that is to be edited.
; KEYWORD PARAMETERS:
;	NAME = The NAME of the variable.  This keyword is overwritten with the
;		structure name if the variable is a structure.
;	GROUP = The widget ID of the widget that calls XSCRMENU.  When this
;		ID is specified, a death of the caller results in a death of
;		XSCRMENU.
;
;	The following keywords have been added at the ESRF in order to 
;	use XSCRMENU for creating user-interfaces 
;
;	NCOLUMN = number of column widget where to arrange the result
;	NROW = number of row widget where to arrange the result
;	ACTION = returns the string 'DO' or 'DONT' if the users exits
;		with ACCEPT od CANCEL respectively.
;	TITLES = (only works with structures) An array of strings
;	 with dimension equals to the number of tags, containing
;	 the titles of the tags to be displayed.
;	NOTYPE  = (only works with structures) When set to 1, then do not
;	 display the type of variable (string, float etc...)
;	INTERP  = (only works with structures) When set to one, INTERprets
;	 the tags which are defines as an array of strings as a pull-down
;	 menu whose label shows the widget's current value. The possibles
;	 value of the buttons are placed starting from the 1st index of
;	 the string array. The 0-th index is kept for a string containing
;	 the order of following elements to be display as defaul value.
;	 The following example will create a window with 3 widgets, one
;		with the title and the others with a pull-down menu, whereas
;		the default values are 'a4' and 'b0' respectively.
;
;		out	  =  { Stuct_name, $			; define
;		TITLE: 'ESRF XSCRMENU test', $			; structure
;		ITYPE: ['4','a0','a1','a2','a3','a4'] , $
;		KTYPE: ['0','b0','b1','b2','b3','b4','b5'] }
;		titles = [' This is the title: ', $
;			'5 possible values of a',$		; set the
;			'6 possible values of b']		; titles
;		XSCRMENU,out,/interpret,titles=titles,/notype
;	WTITLES = title for the main window.
;	FIELDLEN = the size of the text fields (for structure input) in
;		number of characters.
;	HELP  = A string with either a string or string-vector.
;		Depending on which one is chosen, the functionaly is different:
;		1) A string is interpreted as a command to be executed. i.e. 
;		   xscrmenu,5,help="print,'socorro'" 
;		   will print "socorro" on your terminal when "help" is pressed.
;		2) A string-vector is interpreted as a text to be displayed. 
;		   i.e. xscrmenu,5,help=['help','me'] will open a window with 
;		   a 2-lines text (help me) when pressing help.
;		clicking on the "Help" button.
;	SCROLL  = When set, forces scroll bar.
;	W_SIZE  = [w_size_x,w_size_y] the window size in pixels. This 
;		value is only used when the SCROLL keyword is set.
;		Default: w_size = (tmp(0) * [5,5]) /9  where tmp is got from: 
;		device, GET_SCREEN = tmp.
;	APPLY_BUTTON  = When set to 1, creates a new button labelled "Apply".
;		When pressed, the effect is the same that "Accept"
;		except the ACTION keyword that is set to "DO_APPLY".
;		This keyword can be used to simulate an "apply function"
;		by the caller program. XScrMenu is a modal widget that 
;		cannot send events to the caller, but with the "Apply"
;		button we can tell the caller that we want to recreate
;		the XScrMenu window. This action must be coded in the
;		caller program.
;		For example, a simple program to enter a number
;		(norte the use of get/set_frame to force the XScrMenu
;		to sit at the same screen position).
;		  PRO xnumber,i
;		  action = ' '
;		  frame=0
;		  XScrMenu,i,action=action,get_frame=frame,/apply_button
;		  while action EQ 'DO_APPLY' do $
;		   XScrMenu,i,action=action,set_frame=frame,/apply_button
;		  end
;	GET_FRAME = Set this keyword to a named variable to get the
;		Main XScrMenu window offset (get_frame(0) and get_frame(1)) and 
;		the window size (get_frame(2) and get_frame(3)).
;		(Note: this is an approximate value, see comment in code)
;	SET_FRAME = Set this keyword to 4-element array with:
;		set_frame(0) the XOFFSET value for the main base window,
;		set_frame(1) the YOFFSET value for the main base window,
;		set_frame(2) the XSIZE value for the main base window,
;		set_frame(3) the YSIZE value for the main base window.
;	DIALOG_PARENT: this keyword is passed to dialogs for centering
;		the widget with a parent widget.
;
; OUTPUTS:
;	VAR= The variable that has been edited, or the original when the user
;		selects the "Cancel" button in the editor.
; COMMON BLOCKS:
;	Xvarcom - stores the state of the variable that is being edited.
; SIDE EFFECTS:
;	Initiates the XManager if it is not already running.
; RESTRICTIONS:
;	If the variable is exceedingly large such as a giant structure or
;	huge array, the editor will not fit on the screen and may not be able
;	to create enough widget components to edit the whole variable.
; PROCEDURE:
;	Create and register the widget and then exit.
;	If the user selects "accept", the values in the editor are written
;	to the variable passed in, otherwise, they are ignored.
; MODIFICATION HISTORY:
;	Written by: Steve Richards,	February, 1991
;	Nov 1993 M. Sanchez del Rio includes NROW , NCOLUMN , ACTION , 
;		TITLES , NOTYPE and INTERPRET keywords
;		for the ESRF applications. 
;	94-02-14 MSR renames from Xvaredit [modified] to XscrMenu
;	96-04-12 MSR automatic scrollbars when ntags > 15. Adds fieldlen kw
;	96-11-13 MSR supresses the error message "Unable to convert given 
;		STRING to Float". Includes xscrmenu_flags0 in xscrmenu.pro file.
;	97-01-06 MSR adds the "help" button
;	97-02-05 MSR adds automatic resizing.
;	97-03-24 MSR adds SCROLL and W_SIZE keywords.
;	97-08-26 MSR modified the HELP keyword, adds GET/SET_FRAME and 
;		APPLY_BUTTON keywords.
;	97-08-29 MSR adds frame_origin in common block to store the frame
;		origin when apply button is pressed. This value is used to 
;		create the next XScrMenu window at the same position.
;	97-10-16 MSR fix a bug with get_frame (it didn't give the right
;		result when the window was moved/resized by the user)
;	97-11-07 MSR changes the windows dimension keyword when scroll
;		is set: from scr_xsize to x_scroll_size (in windows the
;		window didn't appear).
;	00-02-15 MSR (srio@esrf.fr) adds Dialog_Parent keyword
;	01-12-01 favre@esrf.fr added non_modal keyword.
;	14-02-10 dejus@aps.anl.gov changed code in call to xmanager to use 
;		the no_block keyword instead of the modal keyword.
;		Code works the same except only the first event of xmanager
;		is now blocking. All subsequent events, such as a call to the
;		help routine is no longer blocked. NOTE: revert, does not work
;		because many routines such as xinpro and xwiggler etc. do not
;		start with the /no_block set. Currently leave unchanged because
;		it will take lots of efforts to ensure that it works correctly.
;-
;
;-

PRO xscrmenu_flags0,struct,result,FLAGS=FLAGS
;
; returns numerical flags (result) given the logical flags (flags)
; and the structure (to get the values)
;
; Updated MSR 96/11/6 to avoid error message when converting rr(0) to float 
;
nt = n_tags(struct)
w = fltarr(nt)

for i=0,nt-1 do begin
  rr = struct.(i)
  ; if rr(0) is text, examine the first character. If the first
  ; character is numerical, put it in w, otherwise put 0
  if type(rr(0)) EQ 7 then begin ; text
    if Strparse(' .+-0123456789 ',strmid(strcompress(rr(0),/rem),0,1)) $
	gt 0 then w(i) = rr(0) else w(i) = 0
  endif else w(i) = rr(0) ;numbers
endfor

result = strarr(nt)
for i=0,nt-1 do begin
  text = flags(i)
  ;print,'::Executing:: ','fflag = '+text
  tmp = EXECUTE('fflag = '+text)
  IF (fflag) THEN ival = 1 ELSE ival = 0
  result(i) =  strcompress(ival,/remove_all)
endfor
end

;------------------------------------------------------------------------------
;	procedure XscrMenu_ev
;------------------------------------------------------------------------------
; This procedure processes the events being sent by the XManager.
;------------------------------------------------------------------------------
PRO XscrMenu_ev, event

COMMON Xvarcom, thevar, initialvar, entries, eventval2, interp, flags, help1,$
  wtitle1, frame_origin, get_frame1

WIDGET_CONTROL, event.id, GET_UVALUE = eventval		;find the user value
							;of the widget where
							;the event occured
eventval2 = eventval
if eventval EQ 'DO_APPLY' then begin
  eventval='DO'            				;the apply button
							; acts as Accept.
  ; when apply button is pressed, store the frame origins in the 
  ; common block. The purpose is to create a new XScrMenu window at the 
  ; same position the next time that XScrMenu is called.
  aa1=0 & aa2=0
  widget_control,event.top,tlb_get_offset=aa1,tlb_get_size=aa2
  frame_origin = [aa1(0)-5,aa1(1)-24]
endif

IF(eventval EQ "Resize") THEN BEGIN
	widget_control,event.id, scr_xsize=event.x,scr_ysize=event.y
ENDIF

if eventval EQ 'DO' or eventval EQ 'DONT' then begin
	; frame position
	aa1=0 & aa2=0
	widget_control,event.top,tlb_get_offset=aa1,tlb_get_size=aa2
	; warning the (5,23) shift is for the window frame. It has been placed
	; by eye and can behave differently in different systems.
	; How to get the frame width in Unix? I do not know. If you know
	; please tell me (srio@esrf.fr)
	get_frame1 = [aa1(0)-5,aa1(1)-23,aa2(0),aa2(1)]
endif

CASE eventval OF

  "HELP": BEGIN						;the help
	  if n_elements(help1) EQ 1 then $
	    itmp = execute(help1) else $
	    Xdisplayfile1,text=help1,group=event.top,Title='Help on '+$
		wtitle1,/NoMenuBar,Dialog_Parent=dialog_parent
	  END
  "DONT": BEGIN						;the user chose the 
	    thevar = initialvar				;cancel button so just
	    WIDGET_CONTROL, event.top, /DESTROY		;return the initial
	  END						;variable

  "DO": BEGIN						;the user chose accept
          i = 0						;so go ahead and modify
 	  WHILE(i LT N_ELEMENTS(entries))DO BEGIN	;the user's variable to

	    IF(entries(i).type NE 6)THEN BEGIN		;reflect his or her 
	      WIDGET_CONTROL, entries(i).widid, $	;choice
			GET_VALUE = newval
	      error = EXECUTE(entries(i).name  + $
			"= newval(0)")
	    ENDIF ELSE BEGIN				;when the user's 
	      WIDGET_CONTROL, entries(i).widid, $	;variable has a complex
			GET_VALUE = realval		;value, the real and
	      i = i + 1					;imaginary components
	      WIDGET_CONTROL, entries(i).widid, $	;must be reassembled
			GET_VALUE = imagval		;from its respective
	      error = EXECUTE(entries(i).name  + $	;editable widget
				"= complex(" + $	;components
				string(realval(0)) + $
				"," + $
				string(imagval(0)) + $
				")")
	    ENDELSE
	    i = i + 1
	  ENDWHILE
	  WIDGET_CONTROL, event.top, /DESTROY		;once the variables 
	END						;have been retrieved, 
							;the widget heiarchy
  ELSE: BEGIN						;can be destroyed
		;
		; if FLAGS are define, then MAP the widgets after
		; any action
		;
		IF (N_ELEMENTS(flags) GT 1) THEN BEGIN
          	i = 0	
		w = 0.0
	 	WHILE(i LT N_ELEMENTS(entries))DO BEGIN
	    	  IF(entries(i).type NE 6)THEN BEGIN	
	      	    WIDGET_CONTROL, entries(i).widid, $	
			GET_VALUE = wtmp
  			;print,'wtmp before: ',wtmp
  			; if wtmp is text, examine the first character. 
			; If the first character is numerical, keep it, 
			; otherwise put 0
  			wtmp2 = wtmp(0)
  			if type(wtmp2) EQ 7 then begin ; text
			  ;print,'<<text>>'
			  ;print,'char: ',strmid(strcompress(wtmp2,/rem),0,1)
    			  if Strparse(' .+-0123456789 ',$
			  strmid(strcompress(wtmp2,/rem),0,1)) le 0 then $
			  wtmp2 = 0
  			endif
			;print,'wtmp after: ',wtmp2
			;w = [w,wtmp]
			w = [w,wtmp2]
	    	  ENDIF ELSE BEGIN			
	      	    WIDGET_CONTROL, entries(i).widid, $	
				GET_VALUE = wtmp	
		    w = [w,wtmp]
	      	    i = i + 1				
	      	    WIDGET_CONTROL, entries(i).widid, $
			GET_VALUE = wtmp	
		    w = [w,wtmp]
	    	  ENDELSE
	    	  i = i + 1
	  	ENDWHILE
		w = w(1:n_elements(w)-1)
		;
          	i = 0					;so go ahead and modify
 		WHILE(i LT N_ELEMENTS(entries))DO BEGIN  ;the user's variable to
            	IF(entries(i).type NE 6)THEN BEGIN       ;reflect his or her
		  IF (flags(i) NE '1') THEN BEGIN
                    text = flags(i)
		    tmp = EXECUTE('fflag = '+text)
		    IF (fflag) THEN ival = 1 ELSE ival = 0
              	    WIDGET_CONTROL, entries(i).widid, $       ;choice
                        MAP = ival
		  ENDIF
            	ENDIF ELSE BEGIN                            ;when the user's
            	ENDELSE
            	i = i + 1
          	ENDWHILE
		ENDIF
	END


ENDCASE

END ;============= end of XSCRMENU event handling routine task =============


;------------------------------------------------------------------------------
;	procedure AddEditEntry
;------------------------------------------------------------------------------
; This procedure adds an entry to the list that contains the variables names
; and the widget id for the edit field corresponding to the variable name.
;------------------------------------------------------------------------------

PRO AddEditEntry, thename, thetype, thewidid

COMMON Xvarcom, thevar, initialvar, entries, eventval2, interp, flags, help1,$
  wtitle1, frame_origin, get_frame1

IF N_ELEMENTS(thewidid) EQ 0 THEN thewidid = 0L
newelt = {entstr, name:thename, $			;first create a record
		  widid:thewidid, $			;and then 
		  type:thetype}				;just create a list
numents = N_ELEMENTS(entries)				;with one more element
IF(NOT(KEYWORD_SET(entries)))THEN ENTRIES = newelt $	;and replace the old 
ELSE BEGIN						;one
  newentries = REPLICATE(newelt, numents + 1)
  newentries(0:numents - 1) = entries
  newentries(numents) = newelt
  entries = newentries
ENDELSE
END ;============== end of XSCRMENU event handling routine task ===============


;------------------------------------------------------------------------------
;	procedure XscrMenuField
;------------------------------------------------------------------------------
;  This routine is used to create the widget or widgets needed for a given 
;  variable type.  It could call itself recursively if the variable was itself
;  a structure comprised of other IDL variables.
;------------------------------------------------------------------------------

FUNCTION XscrMenuField, base, type, val, NAME = NAME, $
	fieldlen=fieldlen        	;this is a dummy 
RETURN,0						;declaration so that
END							;this routine can call
							;itself recursively
FUNCTION XscrMenuField, base, val, NAME = NAME, $
 RECNAME = RECNAME, NCOLUMN=ncolumn, NROW=nrow, TITLES=titles, $
 NOTYPE=NOTYPE, INTERP = interp, FLAGS_INI=flags_ini,fieldlen=fieldlen


if not(keyword_set(INTERP)) then interp = 0 else interp = 1
if not(keyword_set(NCOLUMN)) then ncolumn = 0
if not(keyword_set(NROW)) then nrow = 0
if not(keyword_set(fieldlen)) then fieldlen = 12
if ((NCOLUMN EQ 0) AND (NROW EQ 0) ) then begin
  NCOL = 0  &  NCOLUMN = 1
endif
 
dimarr = [18, 4, 7, 10, 12, 16, 12, fieldlen]			;an array of lengths of
							;each type

typarr = ["Undefined", "Byte", "Integer", $		;an array of names of 
	  "Longword Integer", "Floating Point", $	;each type
	  "Double Precision Floating", $
	  "Complex Floating Point", $
	  "String", "Structure"]

varsize = size(val)					;determine the size and
vardims = N_ELEMENTS(varsize) - 2			;type of the variable
type = varsize(vardims)
numelements = varsize(vardims + 1)

IF(numelements GE 10) THEN $				;if the array is larger
  scrollval = 1 $					;than 10 elements, use
ELSE scrollval = 0					;a scrolling base to
							;conserve screen space

abase = WIDGET_BASE(base, $				;create a base for the
		/FRAME, $				;variable to live in
		COLUMN=ncolumn, $
		ROW=nrow, $
		XPAD = 8, $
		YPAD = 8, $
		SCROLL = scrollval)

IF(numelements GT 1) THEN BEGIN				;if the variable is an
  suffix = " Array("					;array, then say so and
  FOR j = 1, varsize(0) DO BEGIN			;show the array
    suffix = suffix + strtrim(varsize(j), 2)		;dimensions.
    IF j NE varsize(0) THEN suffix = suffix + ", "
  ENDFOR
  suffix = suffix + ")"
ENDIF ELSE suffix = ""


IF(type EQ 8) THEN NAME = TAG_NAMES(val, /STRUCTURE)	;if the variable is a 
							;structure, use its 
							;name
if not(keyword_set(notype)) then begin
  IF(KEYWORD_SET(NAME)) THEN $				;build up the name of
    lbl = WIDGET_LABEL(abase, $				;variable with the 
		  VALUE = NAME + $			;type in parenthesese
			  " (" + $
			  typarr(type) + $
			  suffix + $
			  ")") $
  ELSE lbl = WIDGET_LABEL(abase, $
		  value = typarr(type) + suffix)
endif else begin
  IF(KEYWORD_SET(NAME)) THEN $
    lbl = WIDGET_LABEL(abase,VALUE = NAME) $
  ELSE lbl = WIDGET_LABEL(abase, value = '')
endelse



IF(NOT(KEYWORD_SET(RECNAME))) THEN RECNAME = "thevar"	;establish the name
							;if not being called 
							;recursively

IF(varsize(0) GT 1) THEN BEGIN
  moduli = LONARR(varsize(0)-1) + 1
  FOR i = varsize(0), 2,-1 DO BEGIN
    FOR j = 1,i-1 DO $
      moduli(i - 2) = moduli(i - 2) * varsize(j)
  ENDFOR
ENDIF

FOR element = 0, numelements - 1 DO BEGIN		;for each array element

  IF(numelements NE 1) THEN BEGIN			;use array subscripting
    indexname = "("					;if variable is an
    indexname = indexname + $
		strtrim(element mod varsize(1),2)
    IF(varsize(0) GT 1) THEN BEGIN
      indexarr = lonarr(varsize(0) - 1)
      flatindex = element
      FOR i = varsize(0) - 2, 0, -1 DO BEGIN
	indexarr(i) = flatindex / moduli(i)
	flatindex = flatindex mod moduli(i)
      ENDFOR
      FOR i = 0, varsize(0) - 2 DO $
	indexname = indexname + ", " + $
		strtrim(indexarr(i), 2)
    ENDIF
    indexname = indexname + ")"
    thename = RECNAME + indexname			;build up the name from
    thebase = WIDGET_BASE(abase, $			;any previous recursive
		/FRAME, $				;names
		/ROW)
    alabel = WIDGET_LABEL(thebase, $
		VALUE = indexname + ": ")
    FRAMESETTING = 0
  ENDIF ELSE BEGIN
    FRAMESETTING = 1
    thename = RECNAME
    thebase = abase
  ENDELSE

  CASE type OF						;depending on the type,
							;build a string 
							;variable with proper
							;formatting

    0: thevalue = "Undefined Variable"			;Undefined

    1: thevalue = string(val(element), $		;Byte
		FORMAT = '(I3)')

    6: BEGIN						;Complex Float
	 rowbase = WIDGET_BASE(thebase, $		;here the variable must
		/ROW)					;be displayed in two
	 lable = WIDGET_LABEL(rowbase, $		;separate widgets for
		VALUE = "Real: ")			;its real and imaginary
	 id = WIDGET_TEXT(rowbase, $			;components
		VALUE = STRING(FLOAT(val(element))), $
		FRAME = FRAMESETTING, $
		YSIZE = 1, $
		XSIZE = dimarr(type), $
		/EDITABLE, $
		UVALUE = ' ')
	 AddEditEntry, thename, type, id
	 lable = WIDGET_LABEL(rowbase, $
		VALUE = "Imaginary: ")
	 id = WIDGET_TEXT(rowbase, $
		VALUE = STRING(IMAGINARY(val(element))), $
		FRAME = FRAMESETTING, $
		YSIZE = 1, $
		XSIZE = dimarr(type), $
		/EDITABLE, $
		UVALUE = ' ')
	AddEditEntry, thename, type, id
      END
    
    7: thevalue = val(element)				;String

    8: BEGIN						;Structure
	 tags = TAG_NAMES(val(element))
	 FOR i = 0, N_ELEMENTS(tags) - 1 DO BEGIN
	   error = EXECUTE("fieldvalue = val(element)." + tags(i))
	   fldsize = size(fieldvalue)
	   flddims = N_ELEMENTS(fldsize) - 2
	   if keyword_set(titles) then ccname = titles(i) else ccname=tags(i)
	   ttype = fldsize(fldsize(0)+1)
	   IF ( (ttype EQ 7) AND $
		(N_ELEMENTS(fieldvalue) GT 1 AND interp EQ 1) ) THEN BEGIN
	     id = cw_bselector(thebase,fieldvalue(1:n_elements(fieldvalue)-1), $
		/frame,label_top=ccname, set_value=fix(fieldvalue(0)) ,  $
		return_uvalue=fieldvalue(1:n_elements(fieldvalue)-1) )
	     AddEditEntry, thename + "." +tags(i)+"(0)", ttype, id
	   ENDIF ELSE BEGIN
	     id = XscrMenuField(thebase, $
		fieldvalue, $
		;NAME = tags(i), $
		NAME = ccname, $
		RECNAME = thename + "." + tags(i), NOTYPE=notype, $
		fieldlen=fieldlen)
	   ENDELSE
	   IF KEYWORD_SET(FLAGS_INI) THEN WIDGET_CONTROL,id,MAP=flags_ini(i)
	 ENDFOR
	END

    ; added by srio@esrf.fr 98/06/24 to manage floats with more decimals
    4: thevalue = strtrim( string(val(element),format='(G15.8)'), 2)
    5: thevalue = strtrim( string(val(element),format='(G15.8)'), 2)

    ELSE: thevalue = strtrim(val(element), 2)
  ENDCASE

  IF((type NE 6) AND (type NE 8)) THEN BEGIN		;here the actual widget
    id = WIDGET_TEXT(thebase, $				;is created if it was
		value = thevalue, $			;neither a structure or
		FRAME = FRAMESETTING, $			;a complex value
		YSIZE = 1, $
		XSIZE = dimarr(type), $
		/EDITABLE, $
		UVALUE = ' ')
    AddEditEntry, thename, type, id
  END

ENDFOR

return,id

END ;============= end of XSCRMENU event handling routine task =============


;------------------------------------------------------------------------------
;	procedure XSCRMENU
;------------------------------------------------------------------------------
; this is the actual routine that is called.  It builds up the variable editing
; fields by calling other support routines and then registers the widget 
; heiarchy with the XManager.  Notice that the widget is registered as a MODAL
; widget so it will desensitize all other current widgets until it is done.
;------------------------------------------------------------------------------
PRO XSCRMENU, var, GROUP = GROUP, NAME = NAME, NCOLUMN=NCOLUMN, $
NROW=NROW, ACTION=ACTION, TITLES=TITLES, NOTYPE=NOTYPE, INTERPRET=INTERPRET, $
FLAGS=flagsb, WTITLE=wtitle,FIELDLEN=fieldlen,HELP=help,$
SCROLL=scroll,W_SIZE=w_size,APPLY_BUTTON=apply_button,SET_FRAME=set_frame,$
GET_frame=get_frame,DIALOG_PARENT=dialog_parent,NON_MODAL=NON_MODAL

COMMON Xvarcom, thevar, initialvar, entries, eventval2, interp, flags, help1,$
  wtitle1, frame_origin, get_frame1

if not(keyword_set(scroll)) then scroll=0
if not(keyword_set(frame_origin)) then frame_origin = [0,0]

if not(keyword_set(fieldlen)) then fieldlen=12
if type(var) EQ 8 then $
  if n_tags(var) gt 15 then scroll = 1 
if not(keyword_set(flagsb)) then begin
  flags = 0 
endif else begin
  flags=flagsb
  XscrMenu_flags0,var,flags_ini,FLAGS=FLAGS
endelse
if not(keyword_set(INTERPRET)) then interp = 0 else interp = 1
if not(keyword_set(WTITLE)) then wtitle='XSCRMENU'
wtitle1=wtitle
if not(keyword_set(NCOLUMN)) then ncolumn = 0
if not(keyword_set(NROW)) then nrow = 0
if ((NROW EQ 0) and (NCOLUMN EQ 0)) then begin
  NROW = 0  &  NCOLUMN = 1
endif
if(n_params() ne 1) THEN $
  MESSAGE, "Must have one parameter"

IF(XRegistered("XSCRMENU")) THEN RETURN			;only one instance of
							;the XSCRMENU widget
							;is allowed.  If it is
							;already managed, do
							;nothing and return


if keyword_set(scroll) then scroll=1
if sdep() EQ 'WINDOWS' and sdep(/vf) EQ '5.0B5' then scroll=0
if keyword_set(set_frame) then begin
  if n_elements(set_frame) ne 4 then message,/info,$
    'Error in setting frame attributes.'
  xoffset = set_frame(0) & yoffset = set_frame(1)
  xsize = set_frame(2) & ysize = set_frame(3)
endif else begin
  if keyword_set(apply_button) then xoffset = frame_origin(0) else xoffset = 0
  if keyword_set(apply_button) then yoffset = frame_origin(1) else yoffset = 0
  xsize = 0
  ysize = 0
endelse

if scroll then begin
  if not(keyword_set(w_size)) then begin
    device, GET_SCREEN = w_size
    ;w_size = (w_size(0) * [5,4]) /9
    w_size = (w_size(0) * [5,5]) /9
  endif
  XscrMenubase = WIDGET_BASE(TITLE = wtitle, $	;create the main base
		/COLUMN, $
		/scroll,x_scroll_size=w_size(0),y_scroll_size=w_size(1),$
	;	/COLUMN,/scroll,scr_xsize=w_size(0),scr_ysize=w_size(1) );,$
		/TLB_SIZE_EVENTS,UVALUE='Resize',$
;;		XOFFSET=xoffset,YOFFSET=yoffset, $
		XSIZE=xsize,YSIZE=ysize) 
endif else begin
  XscrMenubase = WIDGET_BASE(TITLE = wtitle, /COLUMN,$
		/TLB_SIZE_EVENTS,UVALUE='Resize',$
;;		XOFFSET=xoffset,YOFFSET=yoffset, $
		XSIZE=xsize,YSIZE=ysize)
endelse

; changed order srio 98/08/26
;buttons = [    '"Cancel"               DONT',  $       ;create the menu
;                '"Accept"               DO']           ;selections
buttons = [    '"Accept"               DO',  $       ;create the menu
                '"Cancel"               DONT']           ;selections

if keyword_set(apply_button) then begin
  buttons = [buttons, $
                '"Apply"                DO_APPLY']     ;apply
endif
if keyword_set(help) then begin
  help1 = help
  buttons = [buttons, $
                '"Help"                 HELP']         ;help
endif

XPdMenu, buttons,XscrMenubase

initialvar = var
thevar = var
varsize = size(var)
vardims = N_ELEMENTS(varsize) - 2

ids = XscrMenuField(XscrMenubase, var, NAME = NAME ,NCOLUMN=ncolumn, $
  NROW=nrow, TITLES=TITLES, NOTYPE=NOTYPE, INTERP=interp, $
  FLAGS_INI=flags_ini,fieldlen=fieldlen)

IF Keyword_Set(dialog_parent) THEN $
	Widget_Center,XscrMenubase,Parent=dialog_parent
WIDGET_CONTROL, XscrMenubase, /REALIZE			;create the widgets
							;that are defined
; frame position
aa1=0 & aa2=0
widget_control,XscrMenubase,tlb_get_offset=aa1,tlb_get_size=aa2
; warning the (5,23) shift is for the window frame. It has been placed
; by eye and can behave differently in different systems.
; How to get the frame width in Unix? I do not know. If you know
; please tell me (srio@esrf.fr)
get_frame1 = [aa1(0)-5,aa1(1)-23,aa2(0),aa2(1)]
;
if keyword_set(NON_MODAL) then begin
	 XManager, "XSCRMENU", XscrMenubase, $			;register the widgets
		        EVENT_HANDLER = "XscrMenu_ev", $	;with the XManager
		        GROUP_LEADER = GROUP	 		;and pass through the
; RJD, Feb. 10, 2014,the /no_block should be used but keep unchanged for now
;		        /no_block				;group leader if this
                                                		;routine is to be 
                                                		;called from some group
                                                		;leader.
endif else begin
; RJD, Feb. 10, 2014,the /modal keyword to xmanager is obsolete but keep for now
	 XManager, "XSCRMENU", XscrMenubase, $			;register the widgets
		        EVENT_HANDLER = "XscrMenu_ev", $	;with the XManager
		        GROUP_LEADER = GROUP , $		;and pass through the
		        /MODAL					;group leader if this
;                                                		;routine is to be 
;                                                		;called from some group
;                                                		;leader.
; RJD, Feb. 10, 2014,this is a blocking event by default, but it won't block subsequent widgets (such as help), which is what we want
; Actually, won't work unless calling routines such as xinpro.pro and xwigger.pro etc. are started with xmanager and the /no_block keyword.
; There are many more routines which do not have /no_block set and thus currently will leave this section commented.
;	 XManager, "XSCRMENU", XscrMenubase, $			;register the widgets
;		        EVENT_HANDLER = "XscrMenu_ev", $	;with the XManager
;		        GROUP_LEADER = GROUP		      	;and pass through the
		        					;group leader if this
                                                		;routine is to be 
                                                		;called from some group
                                                		;leader.
endelse

entries = 0
var = thevar
action = eventval2

get_frame=get_frame1

END ;================== end of XSCRMENU main routine =======================
