;+ 
; main:
; PRO xplot2d_setdetector,id, $
;   interactive=interactive, $
;   norefresh=norefresh, $
;   pixelsize=pixelsize, energy=energy, $
;   x0=x0, y0=y0, $ ; beam center
;   xS=xS, yS=yS, zS=zS, $
;   useEllipses=useEllipses  , $
;   parent=parent ; output
; auxiliar:
; PRO xplot2d_setdetectorpar,id,name,value, norefresh=norefresh
; PRO Xplot2d_SetDetector_Interactive_UpdatePanel, Xplot2Did
; PRO Xplot2d_SetDetector_Interactive_UpdateFromPanel,id
; PRO Xplot2d_SetDetector_Interactive_Event,event
; PRO Xplot2d_SetDetector_Interactive, id , Group=group, No_Block=no_Block, $
;   Parent=wTop
;
; manages the detector parameters
;
; for internal use of xplot2d.pro
;
; origin: 
; 05-05-30 srio@xanum.uam.mx initial version from xplot code.
;
; released: 
; 2007-12-19 srio@esrf.eu for xplot2d 2.00
;
; modified:
; 2011-02-25 srio@esrf.eu added xplot2d <> fit2d conversion
; 
;-

;
;=========================================================================
;
PRO xplot2d_setdetectorpar,id,name,value, norefresh=norefresh

catch, error_status
if error_status ne 0 then begin
  message,/info,'error caught: '+!error_state.msg
  itmp=Dialog_Message(/Error, $
    'XPLOT2D_DETECTORPAR: error caught: '+!error_state.msg)
  catch, /cancel
  goto,out
endif

widget_control, id , GET_UVALUE = info ; , /NO_COPY
infoDet = info.str.detector
tagnames = tag_names(infoDet)
junk = where(tagnames EQ strUpCase(name))

IF junk[0] LT 0 THEN BEGIN
  Message,'Not found in info.str.detector structure: '+name
ENDIF

;;;;;;;;;infoDet.(junk[0]) = value
(infoDet.(junk[0]))[0] = value
info.str.detector=infoDet

out:
widget_control, id , SET_UVALUE = info ; , /NO_COPY
if not(keyword_set(norefresh)) then xplot2d_display_image,id
END ; Xplot2d_SetDetector_Par
;
;
;=========================================================================
;
PRO Xplot2d_SetDetector_Interactive_UpdatePanel, Xplot2Did

widget_control, xplot2did , GET_UVALUE = xplot2dinfo
IF Widget_Info(xplot2dinfo.wids.setdetector,/Valid_Id) THEN BEGIN
  widget_control, xplot2dinfo.wids.SetDetector , GET_UVALUE = DetInfo
  str = xplot2dinfo.str.detector
  DetInfo.str = str
  ;FOR i=0,N_Elements(DetInfo.widsArr)-1 DO BEGIN
  FOR i=0,7 DO BEGIN
    tmp = DetInfo.str.(i)
    Widget_Control,DetInfo.widsArr[i],Set_Value=tmp
  ENDFOR
  tmp = DetInfo.str.useEllipses
  Widget_Control,DetInfo.widsArr[i],Set_Value=tmp[0]

;help,str.useEllipses
  IF Fix( (str.useEllipses)[0] ) EQ 1 THEN BEGIN
    dist = StrCompress(norm([str.x0-str.xS,str.y0-str.yS,str.zS])*$
       str.pixelsize*1D-3,/Rem) 
    rotAngle=''
    tiltAngle=''
;print,'<><> mmapping...'
;    Widget_Control,DetInfo.widsArr[4],map=0
;    Widget_Control,DetInfo.widsArr[5],map=0
  ENDIF ELSE BEGIN
    ;dist = StrCompress(str.zS*str.pixelsize*1D-3,/Rem) 
    ;rotAngle = StrCompress(atan( (str.yS-str.y0)/(str.xS-str.x0) ) *180.0D0/!dpi)
    tmp1 = xplot2d2fit2d([str.x0,str.y0,str.xs,str.ys,str.zs],pixel=str.pixelsize)
    dist=StrCompress(tmp1[2])
    rotAngle = StrCompress(tmp1[3])
    tiltAngle = StrCompress(tmp1[4])
;print,'<><> mmapping...'
;    Widget_Control,DetInfo.widsArr[4],map=1
;    Widget_Control,DetInfo.widsArr[5],map=1
  ENDELSE
  Widget_Control,info.wDist,Set_Value='Distance Sample-BeamCenterOnDetector [mm]: '+dist
  Widget_Control,info.wRotAngle,Set_Value= rotAngle
  Widget_Control,info.wTiltAngle,Set_Value= tiltAngle

  widget_control, xplot2dinfo.wids.SetDetector , SET_UVALUE = DetInfo
ENDIF

END ; Xplot2d_SetDetector_Interactive_UpdatePanel

;
;=========================================================================
;
PRO Xplot2d_SetDetector_Interactive_UpdateFromPanel,id

Widget_Control,id,Get_UValue=info
tmp=0
str = info.str
;FOR i=0,N_Elements(info.widsArr)-1 DO BEGIN
FOR i=0,6 DO BEGIN
  Widget_Control,info.widsArr[i],Get_Value=tmp
  str.(i)=Float(tmp[0])
ENDFOR
Widget_Control,info.widsArr[7],Get_Value=tmp
useEllipses=str.useEllipses
useEllipses[0]=tmp
str.useEllipses=useEllipses

IF Fix( (str.useEllipses)[0]) EQ 1 THEN BEGIN
   Widget_Control,info.widsArr[4],map=1
   Widget_Control,info.widsArr[5],map=1
ENDIF ELSE BEGIN
   Widget_Control,info.widsArr[4],map=0
   Widget_Control,info.widsArr[5],map=0
ENDELSE


info.str = str
Widget_Control,id,Set_UValue=info

;
; Update Xplot2d Structure
;
IF Widget_Info(info.Xplot2dId ,/Valid_Id) THEN BEGIN
  Widget_control, info.Xplot2DId , GET_UVALUE = xplot2dinfo ;, /NO_COPY
  xplot2dInfo.str.detector = str
  Widget_Control, info.xplot2did,SET_UVALUE = xplot2dinfo
  xplot2d_REFRESH,info.xplot2did
ENDIF
;
; update dist
;
str = xplot2dinfo.str.detector
;help,str.useEllipses
IF Fix( (str.useEllipses)[0] ) EQ 1 THEN BEGIN
  ;dist = StrCompress(norm([str.x0-str.xS,str.y0-str.yS,str.zS])*$
  ;   str.pixelsize*1D-3,/Rem) 
  tmp1 = xplot2d2fit2d([str.x0,str.y0,str.xs,str.ys,str.zs],pixel=str.pixelsize)
  dist=StrCompress(tmp1[2])
  rotAngle = 'Rotation angle [deg]: '+$
       StrCompress(tmp1[3])
  ;   strCompress(atan( (str.yS-str.y0)/(str.xS-str.x0) ) *180.0D0/!dpi)
  tiltAngle = 'Tilt angle [deg]: '+$
       StrCompress(tmp1[4])
  ;   strCompress(0.000000)
ENDIF ELSE BEGIN
  dist = StrCompress(str.zS*str.pixelsize*1D-3,/Rem) 
  rotAngle=''
  TiltAngle=''
ENDELSE
Widget_Control,info.wDist,Set_Value='Distance Sample-BeamCenterOnDetector [mm]: '+dist
Widget_Control,info.wRotAngle,Set_Value= rotAngle
Widget_Control,info.wTiltAngle,Set_Value= tiltAngle

;action = 'update'
END ; Xplot2d_SetDetector_Interactive_UpdateFromPanel
;
;
;
;=========================================================================
;
PRO Xplot2d_SetDetector_Interactive_Event,event

FORWARD_FUNCTION xplot2d_text

Catch, error_status
IF error_status NE 0 THEN BEGIN
  Message,/Info,'error caught: '+!error_state.msg
  itmp = Dialog_Message(/Error,Dialog_Parent=event.top,$
    'XPLOT2D_SETDETECTOR_INTERACTIVE_EVENT: '+'error caught: '+!error_state.msg)
  Catch, /Cancel
  RETURN
ENDIF
;
;
infoid = event.handler
action = ''

CASE Tag_Names(event,/Structure_Name) OF
  'WIDGET_BUTTON':BEGIN
    val = ''
    Widget_Control,event.id,Get_value=val
    CASE val OF
      'Dismiss': BEGIN
                 Widget_Control,event.top,/Destroy
                 RETURN
                 END
      'Apply': BEGIN
               Xplot2d_SetDetector_Interactive_UpdateFromPanel,infoid
               RETURN
               END
      'Scan...': BEGIN
               Widget_control, event.handler,  Get_uValue=info ;,/No_copy
               xplot2d_calibrate_scan,info.Xplot2DId
               END

      'Set angles...': BEGIN
               Widget_control, event.handler,  Get_uValue=info ;,/No_copy
               Widget_Control,info.xplot2dId,Get_UValue=infoXplot2d
               str=infoXplot2d.str.detector
               CASE StrCompress( (str.useEllipses)[0],/Remove_all) OF
                 '0':  tmp0 = [str.x0,str.y0,str.x0,str.y0,str.zs]
                 else: tmp0 = [str.x0,str.y0,str.xs,str.ys,str.zs]
               ENDCASE
               tmp1 = xplot2d2fit2d(tmp0,pixel=str.pixelSize)
               tmp2 = {x0:tmp1[0],y0:tmp1[1],dist:tmp1[2],rot:tmp1[3],tilt:tmp1[4]}
               xscrmenu,tmp2,Action=act,Titles= ['Beam X center','Beam Y center', $
                    'Distance [mm]','Rot angle [deg]','Tilt angle [deg]'], $
                    /NoType,/Interp, WTitle='Set angles (as used by fit2d)',dialog_Parent=info.xplot2dId
               IF act EQ 'DONT' THEN RETURN
               tmp3=[tmp2.x0,tmp2.y0,tmp2.dist,tmp2.rot,tmp2.tilt]
               tmp4 = fit2d2xplot2d(tmp3,pixel=str.pixelSize)
               itmp = Dialog_Message(/Question,['New coordinates are: ', $
                       'x0='+StrCompress(tmp4[0]), $
                       'y0='+StrCompress(tmp4[1]), $
                       'xs='+StrCompress(tmp4[2]), $
                       'ys='+StrCompress(tmp4[3]), $
                       'zs='+StrCompress(tmp4[4]), 'Use these coordinates? '],$
                       Dialog_Parent=event.top)
               IF itmp EQ 'No' THEN RETURN
                Widget_Control,info.widsArr[2],Set_Value=tmp4[0]
                Widget_Control,info.widsArr[3],Set_Value=tmp4[1]
                Widget_Control,info.widsArr[4],Set_Value=tmp4[2]
                Widget_Control,info.widsArr[5],Set_Value=tmp4[3]
                Widget_Control,info.widsArr[6],Set_Value=tmp4[4]
                Widget_Control,info.widsArr[7],Set_Value=1
                Xplot2d_SetDetector_Interactive_UpdateFromPanel,infoId

               END

      'One Ring Analysis': BEGIN
              Widget_control, event.handler,  Get_uValue=info 
              xplot2d_calibrate_onering,info.Xplot2DId
              END

      'Get Center from Circle': BEGIN
              Widget_control, event.handler,  Get_uValue=info 
              itmp = Dialog_Message(/Info,'Click 3 points on the circle',$
                 Dialog_Parent=event.top,/Cancel) 
              IF itmp EQ 'Cancel' THEN RETURN
              xplot2d_roi_mouse,info.Xplot2DId,iFlag=3
              xplot2d_roi_plot,info.Xplot2DId, noPlot=noPlot,$
                 center=center
              itmp = Dialog_Message(/Question,$
                'Do you want to set the selected points '+$
                vect2string(center)+' as beam center?',$
                 Dialog_Parent=event.top) 
              IF  itmp EQ 'Yes' THEN BEGIN
                Widget_Control,info.widsArr[2],Set_Value=center[0]
                Widget_Control,info.widsArr[3],Set_Value=center[1]
                Xplot2d_SetDetector_Interactive_UpdateFromPanel,infoId
                ;Xplot2d_SetDetector_Interactive_UpdateFromPanel,infoXplot2D.wids.detector
 ;Widget_Control,Xplot2DId,Set_UValue=infoXplot2D

;                 Widget_Control,info.xplot2dId,Get_UValue=infoXplot2d
;                 infoXplot2d.str.detector.x0 = center[0]
;                 infoXplot2d.str.detector.y0 = center[1]
;                 Widget_Control,info.xplot2dId,Set_UValue=infoXplot2d
;                 xplot2d_refresh,info.xplot2dId

              ENDIF


              END

      'Multi Ring Analysis': BEGIN
              Widget_control, event.handler,  Get_uValue=info 
              xplot2d_calibrate_multiring,info.Xplot2DId
              END

      'Help': BEGIN
              XDisplayFile1,Text=XPlot2D_Text('xplot2d_setdetector'), $
                 Group=event.top,Title='Help: Xplot2D: Set Detector'
              RETURN
              END

      else: 
    ENDCASE
    END
  else: BEGIN
        update = 1
        Widget_control, event.handler,  Get_uValue=info ;,/No_copy
        CASE event.id OF
           info.wElectronE: BEGIN
             ;print,'<><> changed electronE'
             Widget_Control,info.wElectronE,Get_Value=electronE
             lambda = electron_e2w(electronE)*1D10
             photonE = physical_constants('HC')/lambda
             neutronE = physical_constants('HCN')/Sqrt(lambda)
             Widget_Control,info.wNeutronE,Set_Value=neutronE
             Widget_Control,info.wLambda,Set_Value=lambda
             Widget_Control,(info.widsArr)[0],Set_Value=photonE
             update = event.update
             END
           info.wLambda: BEGIN
             ;print,'<><> changed Lambda'
             Widget_Control,info.wLambda,Get_Value=lambda
             electronE = electron_e2w(lambda*1D-10,-1)
             photonE = physical_constants('HC')/lambda
             neutronE = physical_constants('HCN')/sqrt(lambda)
             Widget_Control,info.wNeutronE,Set_Value=neutronE
             Widget_Control,info.wElectronE,Set_Value=electronE
             Widget_Control,(info.widsArr)[0],Set_Value=photonE
             update = event.update
             END
           info.wNeutronE: BEGIN
             ;print,'<><> changed neutronE'
             Widget_Control,info.wNeutronE,Get_Value=neutronE
             lambda = physical_constants('HCN')/sqrt(neutronE)
             electronE = electron_e2w(lambda*1D-10,-1)
             photonE = physical_constants('HC')/lambda
             Widget_Control,info.wElectronE,Set_Value=electronE
             Widget_Control,(info.widsArr)[0],Set_Value=photonE
             Widget_Control,info.wLambda,Set_Value=lambda
             update = event.update
             END
           (info.widsArr)[0]: BEGIN
             ;print,'<><> changed photon energy'
             Widget_Control,(info.widsArr)[0],Get_Value=photonE
             lambda = physical_constants('HC')/photonE
             electronE = electron_e2w(lambda*1D-10,-1)
             neutronE = physical_constants('HCN')/sqrt(lambda)
             Widget_Control,info.wElectronE,Set_Value=electronE
             Widget_Control,info.wLambda,Set_Value=lambda
             Widget_Control,info.wNeutronE,Set_Value=neutronE
             update = event.update
             END
           else: ;print,'<><> changed other thing'

        ENDCASE
        IF update THEN Xplot2d_SetDetector_Interactive_UpdateFromPanel,infoid
        END
ENDCASE


END ; Xplot2d_SetDetector_Interactive_Event

;
;============================================================================
;
PRO Xplot2d_SetDetector_Interactive, id , Group=group, No_Block=no_Block, $
  Parent=wTop

;
catch, error_status
if error_status ne 0 then begin
  message,/info,'error caught: '+!error_state.msg
  itmp=Dialog_Message(/Error, $
    'XPLOT2D_SETDETECTOR_INTERACTIVE: error caught: '+!error_state.msg)
  catch, /cancel
  RETURN
endif


IF N_Elements(No_Block) EQ 0 THEN No_Block=1
IF N_Elements(id) EQ 0 THEN id=0L
;
; create structure with data
;
IF Widget_Info(id,/Valid_Id) THEN BEGIN
  Widget_control, id , GET_UVALUE = xplot2dinfo ; , /NO_COPY
  tmp=xplot2dinfo.str.detector
  ; exits if the application is already opened
  IF Widget_Info(xplot2dinfo.wids.detector,/Valid_Id) THEN BEGIN
     ; bring the window to front
     tmp = xregistered('Xplot2d_SetDetector_Interactive')
     ; exit
     RETURN
  ENDIF
  ; window already opened
ENDIF ELSE BEGIN
   tmp={$
         energy:10000D0, $     ; photon energy in eV
         pixelsize:78.94D0,$   ; pixel size in microns
         x0:0D0, $         ; beam intersection with detector plane
         y0:0D0, $         ; beam intersection with detector plane
         xS:0D0,$          ; sample position [pixels] in detector reference
         yS:0D0,$          ; sample position [pixels] in detector reference
         zS:1000D0,$       ; sample position [pixels] in detector reference
         useEllipses:['0','No','Yes'] }   ; use ellipses flag
ENDELSE

; create widgets
wTop = Widget_Base(Title='Detector and beam parameters',/Col)


wBaseButtons = Widget_Base(wTop,/Row)
  wtmp = Widget_Button(wBaseButtons,Value='Dismiss')
  wtmp = Widget_Button(wBaseButtons,Value='Apply')
  ;wtmp = Widget_Button(wBaseButtons,Value='Reset')
  wtmp = Widget_Button(wBaseButtons,Value='Scan...')
  wtmp = Widget_Button(wBaseButtons,Value='Set angles...')
  wtmp = Widget_Button(wBaseButtons,Value='Help')


wBaseXY = Widget_Base(wTop,/ROW)

widsArr =  LonArr(8)
titles = String([' or Photon energy [eV]',$
                'Pixel size [microns]',$
                'Beam X center [pixels]', $
                'Beam Y center [pixels]', $
                'Sample X [pixels]',$
                'Sample Y [pixels]',$
                'Sample Z [pixels]',$
                'Use Ellipses?'],Format='(A22)')
wBaseX = Widget_Base(wBaseXY,/Col,/Frame)

;
; Added this ones (for neutron and electron beams)
;
   wTmp = Widget_base(wBaseX,/Row)
      lambda = physical_constants('hc')/tmp.energy
      wLambda=CW_Field(wTmp,Value=lambda, $
        /Floating,Row=1, Title='Set beam Wavelength[A]', /All_Events)

   wTmp = Widget_base(wBaseX,/Row)
      widsArr[0]=CW_Field(wTmp,Value=tmp.energy,/Floating,Row=1, $
        Title=titles[0], /All_Events)

      neutronE = physical_constants('hcn')/lambda
      wNeutronE=CW_Field(wTmp,Value=neutronE, $
        /Floating,Row=1, Title='or Neutron energy [eV]', /All_Events)

      electronE = electron_e2w(lambda*1d-10,-1)
      wElectronE=CW_Field(wTmp,Value=electronE, $
        /Floating,Row=1, Title='or Electron energy [eV]', /All_Events)

   wTmp = Widget_base(wBaseX,/Row)
      widsArr[1]=CW_Field(wTmp,Value=tmp.pixelsize,/Floating,Row=1, $
        Title=titles[1], /Return_Events)

   wTmp = Widget_base(wBaseX,/Row)
     widsArr[2]=CW_Field(wTmp,Value=tmp.x0,/Floating,Row=1, $
        Title=titles[2], /Return_Events)
     widsArr[3]=CW_Field(wTmp,Value=tmp.y0,/Floating,Row=1, $
        Title=titles[3], /Return_Events)

   wTmp = Widget_base(wBaseX,/Row)
     widsArr[4]=CW_Field(wTmp,Value=tmp.xS,/Floating,Row=1, $
       Title=titles[4], /Return_Events)
     widsArr[5]=CW_Field(wTmp,Value=tmp.yS,/Floating,Row=1, $
       Title=titles[5], /Return_Events)
     widsArr[6]=CW_Field(wTmp,Value=tmp.zS,/Floating,Row=1, $
       Title=titles[6], /Return_Events)
   wTmp = Widget_base(wBaseX,/Row)
     widsArr[7]=CW_DropList(wTmp,Value=tmp.useEllipses, $
       Title=titles[7])

   wTmp = Widget_base(wBaseX,/Col)
     IF Fix( (tmp.useEllipses)[0] ) EQ 1 THEN BEGIN
       tmp1 = xplot2d2fit2d([tmp.x0,tmp.y0,tmp.xs,tmp.ys,tmp.zs],pixel=tmp.pixelsize)
       dist=StrCompress(tmp1[2])
       ;dist = StrCompress(norm([tmp.x0-tmp.xS,tmp.y0-tmp.yS,tmp.zS])*$
       ;   tmp.pixelsize*1D-3,/Rem)
       rotAngle =  'Rotation angle [deg]: '+$
         StrCompress(tmp1[3])
       ;  StrCompress(atan( (tmp.yS-tmp.y0)/(tmp.xS-tmp.x0) ) * $
       ; 180.0D0/!dpi)
       tiltAngle = 'Tilt angle [deg]:     '+$
         StrCompress(tmp1[4])
       ;  StrCompress(atan( (tmp.yS-tmp.y0)/(tmp.xS-tmp.x0) ) * $
       ; 180.0D0/!dpi)
     ENDIF ELSE BEGIN
       dist = StrCompress(tmp.zS*tmp.pixelsize*1D-3,/Rem)
       rotAngle=''
       tiltAngle=''
     ENDELSE
     wDist=Widget_Label(wTmp,Value='----------- distances and angles -----------------------------------')
     wDist=Widget_Label(wTmp,Value='Distance Sample-BeamCenterOnDetector [mm]: '+dist,/align_left)
   wTmp = Widget_base(wBaseX,/Col)
     wRotAngle=Widget_Label(wTmp,Value=rotAngle,/align_left)
     wTiltAngle=Widget_Label(wTmp,Value=tiltAngle,/align_left)

   wTmp = Widget_base(wBaseX,/Row)
;     wTmp0=Widget_Button(wTmp,Value='Center of Mass')
     wTmp0=Widget_Button(wTmp,Value='Get Center from Circle')
     wTmp0=Widget_Button(wTmp,Value='One Ring Analysis')
     wTmp0=Widget_Button(wTmp,Value='Multi Ring Analysis')

;
;   widsArr[6]=CW_DropList(wBaseX,Value=str0.xStyle4,Title='Origin ')
;


Widget_Control,wTop,/Realize

IF N_Elements(id) EQ 0 THEN id=0L

info = {widsArr:widsArr, wDist:wDist, wRotAngle:wRotAngle, wTiltAngle:wTiltAngle,  $
        wElectronE:wElectronE, wNeutronE:wNeutronE, wLambda:wLambda, $
        str:tmp, str_init:tmp, Xplot2DId:id }

Widget_control,wTop,set_uValue=info


IF Widget_Info(id,/Valid_Id) THEN BEGIN
  xplot2dinfo.wids.detector=wTop
  Widget_control, id , SET_UVALUE = xplot2dinfo
ENDIF

IF  Fix((tmp.useEllipses)[0]) EQ 0 THEN BEGIN
  Widget_Control,widsArr[4],Map=0
  Widget_Control,widsArr[5],Map=0
ENDIF


XManager, 'Xplot2d_SetDetector_Interactive', wTop, GROUP_LEADER=group, $
  No_Block=no_block

END ; Xplot2d_SetDetector_Interactive

;
;=========================================================================
;
PRO xplot2d_setdetector,id, $
  interactive=interactive, $
  norefresh=norefresh, $
  pixelsize=pixelsize, energy=energy, $
  x0=x0, y0=y0, $ ; beam center
  xS=xS, yS=yS, zS=zS, $
  useEllipses=useEllipses  , $
  parent=parent ; output

; old entries
;  detector_dist=detector_dist,  $
;  xcenter=xcenter, ycenter=ycenter, center=center, $
;  e1 = e1

catch, error_status
if error_status ne 0 then begin
  message,/info,'error caught: '+!error_state.msg
  itmp=Dialog_Message(/Error, $
    'XPLOT2D_SETDETECTOR: error caught: '+!error_state.msg)
  catch, /cancel
  return
endif
IF N_Elements(interactive) EQ 0 THEN interactive=1
if keyword_set(pixelsize) then interactive = 0
if keyword_set(energy) then interactive = 0
if keyword_set(x0) then interactive = 0
if keyword_set(y0) then interactive = 0
if keyword_set(xS) then interactive = 0
if keyword_set(yS) then interactive = 0
if keyword_set(zS) then interactive = 0
if N_Elements(useEllipses) then interactive = 0

IF interactive  THEN BEGIN
  Xplot2d_SetDetector_Interactive,id,parent=parent
  RETURN
ENDIF


if keyword_set(energy) then  $
   xplot2d_setdetector_par,id, 'ENERGY',energy,/NoRefresh
if keyword_set(pixelsize) then  $
   xplot2d_setdetector_par,id, 'PIXELSIZE',pixelsize,/NoRefresh
if keyword_set(x0) then  xplot2d_setdetector_par,id, 'x0',x0,/NoRefresh
if keyword_set(y0) then  xplot2d_setdetector_par,id, 'y0',y0,/NoRefresh
if keyword_set(xS) then  xplot2d_setdetector_par,id, 'xS',xS,/NoRefresh
if keyword_set(yS) then  xplot2d_setdetector_par,id, 'yS',yS,/NoRefresh
if keyword_set(zS) then  xplot2d_setdetector_par,id, 'zS',zS,/NoRefresh
if N_Elements(useEllipses) NE 0 then  $
   xplot2d_setdetector_par,id,'USEELLIPSES',useEllipses,/NoRefresh

;
; update SetDetector window
;
xplot2d_setdetector_interactive_updatepanel,id

if not(keyword_set(norefresh)) then xplot2d_REFRESH,id

END ; Xplot2d_SetDetector
