
;+
;
;	NAME:
;		XOP_MACRO
;	PURPOSE:
;		Edits and runs an XOP macro
; 	CATEGORY:
;		Widgets. 
;	CALLING SEQUENCE:
;		XOP_MACRO [,inCode]
;	INPUTS: 
;		inCode: an array of strings with the code to be processed.
;	KEYWORD_PARAMETERS:
;		GROUP:	The widget ID of the group leader of the widget.  
;			If this keyword is specified, the death of the group 
;			leader results in the death of XOP_MACRO.
;		No_Block: If this keyword is set, then it is passed to 
;			XManager. 
;		File: name of the file with the code to be loaded (if
;			this keyword is set, the inCode variable is not 
;			considered).
;		Title: the window title (Default: XOP_MACRO)		
;
;	OUTPUTS:
;		Open the widget utility.
;	COMMON BLOCKS:
;		None
;	SIDE EFFECTS:
;		If not active, starts Xmanager
;	RESTRICTIONS:
;		Unknown.
;	PROCEDURE
;		Uses xop_macro_compact for creating the compacted code 
;               and xop_execute to execute it.
;
;
;  COPYRIGHT:
;       XOP_MACRO belongs to XOP package and it is distributed within XOP.
; 	PLEASE REFER TO THE XOP COPYRIGHT NOTICE
; 
;  REFERENCE:
; 	Published calculations made with XOP should refer:
; 
; 	M. Sanchez del Rio and R. J. Dejus 
;         "Status of XOP: an x-ray optics software toolkit"
;         SPIE Proceedings Vol. 5536 (2004) pp.171-174
; 
;         http://dx.doi.org/10.1117/12.560903
; 
;  LAST MODIFICATION: srio@esrf.eu 2008-02-01
; 
; 
;	MODIFICATION HISTORY:
;		Written by  Manuel Sanchez del Rio. ESRF. 22 May 2000
;		
;		2007-10-11 srio@esrf.eu adds option to track/copy
;			variables to main level. Use of xop_execute()
;
;-
;
;========================================================================
;
PRO Xop_Macro_event,event
COMMON Xop_Macro_Buffer, edit_buffer

CATCH, error_status
IF error_status NE 0 THEN BEGIN
   Message,/info,'error caught: '+!err_string
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
	'XOP_MACRO_EVENT: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   GoTo,out
ENDIF

;
;
Widget_Control, event.id, get_UValue=eventUValue
;Widget_Control, event.id, get_Value=Value
 
IF N_Elements(eventuvalue) EQ 0 THEN eventuvalue = ''
IF NOT(keyword_set(eventuvalue)) THEN eventuvalue = ''
 
stateid = Widget_Info(event.handler,/Child)
Widget_Control, stateid, get_UValue=state, /No_Copy

 
Case eventUValue OF
    'QUIT': BEGIN
	IF state.saveneeded EQ 1 THEN BEGIN
	  itmp = Dialog_Message(/Cancel,Dialog_Parent=event.top, $
	    ['Modifications have not been saved.','Exit anyway?'])
	  IF itmp EQ 'Cancel' THEN GoTo,out
	ENDIF
	; IF Ptr_Valid(state.ptrBuffer) THEN Ptr_Free,state.ptrBuffer
	Widget_Control,event.handler,/destroy
	END
    'IMPORT': BEGIN
	  file = Dialog_PickFile(Title='Select a macro file',$
	    Dialog_Parent=event.top,PATH=dir,GET_PATH=dir)
	  IF file EQ '' THEN GoTo,out
	  Widget_Control,/Hourglass
	  tmp = Read_TextFile(file)
	  state.file=file
	  IF Ptr_Valid(state.ptrCode) THEN *(state.ptrCode)=tmp
	  state.saveNeeded=0
	  Widget_Control,state.wids.prog1,Set_Value=tmp
	  Widget_Control,state.wids.prog2,Set_Value=''
	  Widget_Control,state.wids.base,Tlb_set_title=state.title+' '+file
	END
    'SAVE': BEGIN
	tmp =''
	Widget_Control, state.wids.prog1, Get_Value=tmp
	;
	; input from pointer
	;
	IF Ptr_Valid(state.ptrCode) THEN BEGIN
	  *(state.ptrCode)=tmp   
	  state.saveNeeded=0
	  GoTo,out
	ENDIF
	;
	; input from variable or file
	;
	IF StrCompress(state.file,/Rem) EQ '' THEN BEGIN
	  itmp = Dialog_Message(/Error, Dialog_Parent=event.top, $
	    ['File name not defined.','Use File->Save as... option before.'])
	  GoTo,out
	ENDIF
	OpenW,unit,state.file,/Get_Lun
	FOR i=0,N_Elements(tmp)-1 DO PrintF,unit,tmp[i]
	Free_Lun,unit
	Message,/Info,'File written: '+state.file
	state.saveNeeded=0
;IF Ptr_Valid(state.ptrCode) THEN *(state.ptrCode)=tmp 
	END
    'SAVEAS': BEGIN
	file = Dialog_PickFile(Title='Select a macro file',$
	  Dialog_Parent=event.top,PATH=dir,GET_PATH=dir)
	IF file EQ '' THEN GoTo,out
	tmp =''
	state.file=file
	Widget_Control, state.wids.prog1, Get_Value=tmp
	OpenW,unit,state.file,/Get_Lun
	FOR i=0,N_Elements(tmp)-1 DO PrintF,unit,tmp[i]
	Free_Lun,unit
	Message,/Info,'File written: '+state.file
	IF Ptr_Valid(state.ptrCode) THEN *(state.ptrCode)=tmp 
	state.saveNeeded=0
	Widget_Control,state.wids.base,Tlb_set_title=state.title+' '+file
	END
    'SELECTALL': BEGIN
	nn = Widget_Info(state.wids.prog1,/Text_Number)
	Widget_Control,state.wids.prog1,Set_Text_Select=[0,nn]
	END
    'COPYBUFFER': BEGIN
	Widget_Control,state.wids.prog1,/Use_Text_Select,Get_Value=tmp
	; *(state.ptrBuffer)=tmp
	edit_buffer = tmp
	END
    'PASTEBUFFER': BEGIN
	prog1 = ''
	Widget_Control,state.wids.prog1,Get_Value=prog1
	; tmp = *(state.ptrBuffer)
	IF N_Elements(edit_buffer) EQ 0 THEN GoTo,out
	tmp = edit_buffer
	lOffset = Widget_Info(state.wids.prog1,Text_Offset_To_XY=state.offset)
	lOffset[1] = lOffset[1] < N_Elements(prog1)-1
	tmp1 = $
	  [prog1[0:lOffset[1]],tmp,prog1[lOffset[1]:(N_Elements(prog1)-1)]]
	Widget_Control,state.wids.prog1,Set_Value=tmp1
	state.saveNeeded=1
	END
    'SHOWBUFFER': BEGIN
	IF N_Elements(edit_buffer) EQ 0 THEN GoTo,out
	XDisplayFIle1,Text=edit_buffer, Title='Macro edit buffer', $
	  Group=event.top
	END
    'COMPACT': BEGIN
	Widget_Control, state.wids.prog2, Set_Value='',/HourGlass
	Wait,0.25
	tmp = ''
	Widget_Control, state.wids.prog1, Get_Value=tmp 
	Widget_Control, state.wids.track, Get_Value=track
	IF N_Elements(tmp) EQ 1 AND StrCompress(tmp[0],/Rem) EQ '' THEN GoTo,out
	tmp1 = xop_macro_compact(tmp,Group=event.top, Track=track)
	Widget_Control, state.wids.prog2, Set_Value=tmp1 
	END
    'RUN': BEGIN
	tmp = ''
	Widget_Control, state.wids.prog1, Get_Value=tmp 
	IF N_Elements(tmp) EQ 1 AND StrCompress(tmp[0],/Rem) EQ '' THEN GoTo,out
	Widget_Control, state.wids.track, Get_Value=track
	tmp1 = xop_macro_compact(tmp,track=track)
	Widget_Control, state.wids.prog2, Set_Value=tmp1 
	Widget_Control, state.wids.track, Get_Value=iTrack 
	tmp1 = xop_macro_compact(tmp,/Execute,HighlightId=state.wids.prog2, $
	  Group=event.top,Track=iTrack)
	END
    'PROG1': BEGIN
	state.saveNeeded=1
	state.offset=event.offset
	END
    'HELP': XHelp,'xop_macro',Group=event.top
    else:
EndCase


out:
IF Widget_Info(stateid,/Valid_ID) THEN $
  Widget_Control, stateid, Set_UValue=state, /No_Copy

END ; XOP_MACRO_EVENT
;
;====================================================================
;

PRO xop_macro, inCode, group=group, No_Block=no_Block, File=file, $
  Title=title, PtrCode=ptrCode, Track=track

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
	'XOP_MACRO: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF

IF N_Elements(no_block) EQ 0 THEN no_block=1
IF N_Elements(title) EQ 0 THEN title='XOP_MACRO 1.01'
IF N_Elements(track) EQ 0 THEN track=0


prog1 = ''

IF N_Elements(inCode) NE 0 THEN prog1 = inCode
IF Keyword_Set(file) THEN BEGIN
  prog1 = read_textfile(file)
  title= title+' '+file
ENDIF ELSE file=''

IF Keyword_Set(ptrCode) THEN BEGIN
  prog1 = *ptrCode
ENDIF ELSE ptrCode = Ptr_New()

;
; define widgets
;
wBase=Widget_Base(/Col,Title=title,MBar=wMenuBar)

wtmp = Widget_Base(wBase) ; to store state

wFileMenu = Widget_Button(wmenuBar,Value='File',/Menu)
  wtmp = Widget_Button(wFileMenu,Value='Load Macro',UValue='IMPORT')
  IF Ptr_Valid(ptrCode) THEN $
    wtmp= Widget_Button(wFileMenu,Value='Save (keep changes)',UValue='SAVE') $
    ELSE $
    wtmp= Widget_Button(wFileMenu,Value='Save (to file)',UValue='SAVE')
  wtmp= Widget_Button(wFileMenu,Value='Save as new file...',UValue='SAVEAS')
  wtmp = Widget_Button(wFileMenu,Value='Quit',UValue='QUIT',/Separator)

wEditMenu = Widget_Button(wmenuBar,Value='Edit',/Menu)
  wtmp = Widget_Button(wEditMenu,Value='Select all',UValue='SELECTALL')
  wtmp = Widget_Button(wEditMenu,Value='Copy',UValue='COPYBUFFER')
  wtmp = Widget_Button(wEditMenu,Value='Paste',UValue='PASTEBUFFER')
  wtmp = Widget_Button(wEditMenu,Value='Show buffer',UValue='SHOWBUFFER')

wHelpMenu = Widget_Button(wmenuBar,Value='Help',/Help)
  wtmp = Widget_Button(wHelpMenu,Value='xop_macro',UValue='HELP')


wBaseButtons = Widget_Base(wBase,/Row)
  wtmp= Widget_Button(wBaseButtons,Value='Quit',UValue='QUIT')
  wtmp= Widget_Button(wBaseButtons,Value='Run',UValue='RUN')
  wtmp= Widget_Button(wBaseButtons,Value='Save',UValue='SAVE')
  wTrack= CW_DropList(wBaseButtons, $
    Value=[StrCompress(track,/Rem),'No','Yes'], $
    Title='  Track/copy variables to $MAIN$ level:',UValue='')

wtmp = Widget_Label(wBase,Value='Enter your code: ',UValue='')
wProg1 = Widget_Text(wBase,/Editable,Value=prog1,UValue='PROG1',$
  ySize=30,xSize=80,/Scroll,/All_Events)

wBaseButtons = Widget_Base(wBase,/Row)
  wtmp= Widget_Button(wBaseButtons,Value='Compact',UValue='COMPACT')
wtmp = Widget_Label(wBase,Value='Compacted code: ',UValue='')
wProg2 = Widget_Text(wBase,Value='',UValue='PROG2',$
  ySize=15,xSize=80,/Scroll,/All_Events)


;
; parameters to store
;
;ptrBuffer = Ptr_New(/Allocate_Heap)
wids = {Base: wBase, prog1:wProg1, prog2:wProg2, track:wTrack}
state = {wids:wids, no_block:no_block, saveNeeded:0, file:file, $
  offset:0L, title:title, ptrCode:ptrCode }
;   ptrBuffer:ptrBuffer, offset:0L, title:title, ptrCode:ptrCode }

;
;
Widget_Control,Widget_Info(wbase,/Child),set_uvalue=state,/no_copy

Widget_Control,wbase,/realize
XManager,'xop_macro',wbase,GROUP=group,No_Block=no_block

END ; XOP_MACRO
