;+
;===============================  ScreenSize  ========================================
;
;   Function to return the screen size used for XOP. It calls the routine 
;   GetPrimaryScreenSize to get the size of the primary monitor for a multimonitor setup.
;   It then sets the screen size as a fraction of the monitor size subject to a minimum
;   view size.
;
; LAST MODIFICATION DATE: RJD 05-FEB-2014
;
;-
;
;	Author: Roger J. Dejus (dejus@aps.anl.gov), ASD/APS, February, 2014.
;	MODIFICATION HISTORY:
;
;        Date     | Name  | Description
; ----------------+-------+-----------------------------------------------------
; 05-FEB-2014     | RJD   | Created from ITTVIS example multimon_exs1.pro
; ----------------+-------+-----------------------------------------------------
;
FUNCTION ScreenSize, Exclude_Taskbar=exclude_Taskbar

; Define max screen size
; WUXGA:1920 (h) x 1200 (v) pixels as maximum size of the primary sceen
; UXGA: 1600 (h) x 1200 (v) pixels as maximum size of the primary sceen
  screen_size_max = [1920,1200]
  view_size_min   = [960,540]       ; use aspect ratio 1.7

;  Determine primary screen size
;  The keyword /Exclude_Taskbar is only valid for Windows and is ignored for other systems
  ssz = GetPrimaryScreenSize(numMons=numMons,namesMon=namesMon,Exclude_Taskbar=exclude_Taskbar)  ; this is the proper call

; one may use the device call instead but not sure if this reports the size of the primary monitor
;  DEVICE, GET_SCREEN_SIZE=ssz

; limit the screen size (primarily for Sun Solaris 10 and xinerama, which does not detect multimonitor setups)
  IF (float(ssz[0])/float(ssz[1])) gt 1.78 THEN ssz = ssz < screen_size_max
;  set size of window as a fraction of the screen size (and always larger than the min. view size)
  ssz = round(ssz*[0.60,0.60]) > view_size_min

  RETURN, ssz ; width and height in pixels of screen size

END
