PRO Pack_Files,files,packed_files=packed_files,fileout=fileout, Free=free, $
  group=group

;+
; NAME:
;	PACK_FILES 
; PURPOSE:
;	This procedure packs a number of disk files in an IDL structure.
;	It optionally writes it in a .sav file.
;	Use UnPack_Files procedure for unpacking.
; CATEGORY:
;	utilities.
; CALLING SEQUENCE:
;	Pack_Files,files
; INPUTS:
;	files   An array of strings with file (if undefined, it launches
;		a file browser to select them) 
; OUTPUT KEYWORD:
;	packed_files: a named variable where to store the files. 
;		This is an array of structures, each structure contains
;		two tags: file, with the file name, and ptr, a pointer
;		to the byte array containing the whole file. 
; KEYWORD PARAMETERS:
;	FileOut: The name of the IDL .sav file where to write the packed files
;	Free:    Only used if FileOut is set. If set, the pointers of the
;		 variable packed_files are freed to avoid unused heap
;		 variables.
;       Group: The parent id for the caller widget (used to positioning
;               error and information windows).
;
; EXAMPLES:
;		pack_files,['Letter.doc','begin.dat'],file='tmp.sav',/free
;		unpack_files,'tmp.sav',/free
;
; MODOFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble, 12 May 2006
;	2006-05-19 srio@esrf.fr centers pickfile window
;-

IF N_Elements(files) EQ 0 THEN BEGIN
   files=Dialog_PickFile(/Multiple_Files,Title='Select files to pack',$
	Dialog_Parent=group)
   IF files[0] EQ '' THEN RETURN
ENDIF

FOR i=0L,N_Elements(files)-1 DO BEGIN
   file = files[i]
   inf = File_Info(file)
   IF inf.exists THEN BEGIN
     tmp = BytArr(inf.size)
     OpenR,unit,file,/Get_Lun
     ReadU,unit,tmp
     Free_Lun,unit
     islash = strpos(file,SDep(/DS),/Reverse_Search)
     file2 = file
     IF islash[0] GE 0 THEN file2=strmid(file,islash+1) ELSE file2=file
     iout={file:file2, ptr:Ptr_New(tmp)}
     IF i GT 0 THEN packed_files=[packed_files,iout] ELSE packed_files=iout
   ENDIF
ENDFOR

; 
; write .sav file
;
IF Keyword_Set(fileout) THEN BEGIN
  Save,/Verbose,packed_files,File=fileout,/Compress
  IF KeyWord_Set(free) THEN BEGIN
     For i=0L,N_Elements(packed_files)-1 DO $
	IF Ptr_Valid(packed_files[i].ptr) THEN Ptr_Free,packed_files[i].ptr
  ENDIF
ENDIF
END

