;+
;===============================  GetPrimaryScreenSize  ========================================
;
;   Function to return the screen size of the primary monitor for a multimonitor setup.
;
; LAST MODIFICATION DATE: RJD 27-JAN-2014
;
;-
;
;	Author: Roger J. Dejus (dejus@aps.anl.gov), ASD/APS, August, 2008.
;	MODIFICATION HISTORY:
;
;        Date     | Name  | Description
; ----------------+-------+-----------------------------------------------------
; 08-AUG-2008     | RJD   | Created from ITTVIS example multimon_exs1.pro
;                 |       | IDL clients running on Solaris 10 do not support XINERAMA,
;                 |       | even though the server may support it. This means that
;                 |       | IDL detects an extented desktop with monitor information
;                 |       | for a single desktop spanning all monitors. Individual
;                 |       | monitor information is not available.
; 27-JAN-2014     | RJD   | Added keyword Exclude_Taskbar, which is valid for Windows only.
; ----------------+-------+-----------------------------------------------------
;
FUNCTION GetPrimaryScreenSize, numMons=numMons, namesMon=names, Exclude_Taskbar=exclude_Taskbar

   ; Get Monitor information
   oInfo = OBJ_NEW('IDLsysMonitorInfo')
   numMons = oinfo->GetNumberOfMonitors()
   names = oinfo->GetMonitorNames()
   rects = oInfo->GetRectangles(Exclude_Taskbar=exclude_Taskbar)
   primaryIndex = oInfo->GetPrimaryMonitorIndex()
   OBJ_DESTROY, oInfo

   RETURN, rects[[2,3],primaryIndex]	; width and height in pixels of the primary monitor

END
