
;+
; 
; NAME: 
;	DOSPATH
;
; PURPOSE:
;	This function returns the directory (or file) in the
;       old DOS style, i.e., without blanks and with suffix ~1
;
; CATEGORY:
;	strings
;
; CALLING SEQUENCE:
;	out = dospath(input)
;
; INPUTS:
;     input:	A scalar string that contains the filename or directory
;		to convert.  
;
; KEYWORD PARAMETERS:
;     force: If set, force conversion for non-windows systems
;
; OUTPUTS:
;	The converted string
;
;
; RESTRICTIONS:
;	For non-windows system, out=input
;       No recusrsive substotution done (i.e., no ~2, ~3 etc)
;
; EXAMPLE:
;       IDL> print,dospath('c:\Program Files\tmp.exe',/force)
;       c:\Progra~1\tmp.exe
;
; MODIFICATION HISTORY:
;	Written By Manuel Sanchez del Rio (srio@esrf.eu), 4 April 2008
;-
;
FUNCTION dospath,input,force=force

IF Not(Keyword_Set(force)) AND $
   StrUpCase(!version.os_Family) NE 'WINDOWS' THEN RETURN,input

delim = '\'
lastChar = strmid(input,0,1,/REV)
n = StrParse(input,delim,list)
bindir2 = ''
FOR i=0,n DO BEGIN
 IF StrEgex(list[i],' ') NE -1 THEN list[i]= $
    StrMid(StrCompress(list[i],/Rem),0,6)+'~1'
    IF (i EQ n) AND (lastChar NE '\') THEN $
      bindir2 = bindir2+list[i]     ELSE $
      bindir2 = bindir2+list[i]+delim 
ENDFOR
RETURN,bindir2
END
