
;+
; NAME:
;	CONIC_PARS2COEFFS
; PURPOSE:
;	this function calculates the conic coefficients
;       from the conic parameters (center semiaxes and rotation) 
; CATEGORY:
;	Maths: conics
;
; CALLING SEQUENCE:
;	c=conic_pars2coeffs(x,y,a,b,theta)
; INPUTS:
;       x: center abscissa
;       y: center ordinate
;       a: major semiaxis
;       b: minor semiaxis
;       theta: rotation angle [rad]
; OUTPUTS:
;	c:  An 6-dim array with the quadric coefficients: 
;           c[0] + c[1] y + c[2] x + c[3] x y + c[4] y^2 + c[5] x^2
;	
; MODIFICATION HISTORY:
;	by M. Sanchez del Rio. ESRF. Grenoble, Nov 2007
;-	
FUNCTION conic_pars2coeffs,xc1,yc1,a1,b1,t1

;a = axis1
;b = axis2
;xc = Xcent
;yc = Ycent
;t =  phi
IF N_Elements(t1) EQ 0 THEN t=0D ELSE t=Double(t1)
IF N_Elements(a1) EQ 0 THEN a=1D ELSE a=Double(a1)
IF N_Elements(b1) EQ 0 THEN b=a ELSE b=Double(b1)
IF N_Elements(xc1) EQ 0 THEN xc=0D ELSE xc=Double(xc1)
IF N_Elements(yc1) EQ 0 THEN yc=xc ELSE yc=Double(yc1)

c =  [ $ ; x->(x-xc) cos + (y-yc) sin ; y-> -(x-xc) sin + (y-yc) cos
             a^2*b^2*(-1 + (yc*Cos(t) - xc*Sin(t))^2/b^2 +  $
           (xc*Cos(t) + yc*Sin(t))^2/a^2), $
        -2*(a^2*yc*Cos(t)^2 +  $
           (-a^2 + b^2)*xc*Cos(t)*Sin(t) + b^2*yc*Sin(t)^2), $
        -2*(b^2*xc*Cos(t)^2 +  $
           (-a^2 + b^2)*yc*Cos(t)*Sin(t) + a^2*xc*Sin(t)^2), $
        (-a^2 + b^2)*Sin(2*t),a^2*Cos(t)^2 + b^2*Sin(t)^2, $
        b^2*Cos(t)^2 + a^2*Sin(t)^2]

RETURN,c

END
