
;+
; NAME:
;	CONIC_COEFFS2PTS
; PURPOSE:
;	this function calculates points along a conic curve
; CATEGORY:
;	Maths: conics
;
; CALLING SEQUENCE:
;	center=conic_coeffs2pts(c,x)
; INPUTS:
;	c:  An 6-dim array with the quadric coefficients: 
;           c[0] + c[1] y + c[2] x + c[3] x y + c[4] y^2 + c[5] x^2
;       x: The abscissas array
; OUTPUTS:
;       an [X,Y] array with the X and Y point positions
;	
; MODIFICATION HISTORY:
;	by M. Sanchez del Rio. ESRF. Grenoble, Nov 2007
;-	
FUNCTION conic_coeffs2pts,coeff,xx
       ; 
       ; Compute points by evaluating the explicit equation 
       ; y=f(x)
       ;
       discr= (coeff[1] + coeff[3]*xx)^2 - 4*coeff[4]*(coeff[0] + coeff[2]*xx + coeff[5]*xx^2)
       igood = where(discr GE 0)
       IF igood[0] EQ -1 THEN BEGIN
         print,'Using coeff: ',coeff
         print,'Min,Max of abscissas: ',Min(xx),Max(xx)
         Message,'No good points found!'
       ENDIF
       xx=xx[igood]
       discr=discr[igood]
       yy1 = (-coeff[1] -coeff[3]*xx - Sqrt(discr))/2/coeff[4]
       yy2 = (-coeff[1] -coeff[3]*xx + Sqrt(discr))/2/coeff[4]
       points = Make_Set([xx,Reverse(xx)],[yy1,Reverse(yy2)])

RETURN,points
END
