;+
;
;      IDL version of the RANECU Random Number Generator
;      Translated from FORTRAN by Manuel Sanchez del Rio
;      (srio@esrf.fr) on April 2006
;
;	
;      FUNCTION r_myRAND,DUMMY,initseed=initseed,onlyInit=onlyInit
;C  *********************************************************************
;C                         r_myRAND
;C  *********************************************************************
;C
;C  This is an adapted version of subroutine RANECU written by F. James
;C  (Comput. Phys. Commun. 60 (1990) 329-344), which has been modified to
;C  give a single random number at each call.
;C
;C  The 'seeds' ISEED1 and ISEED2 may be initialized in the main program
;C  and transferred through a first call: 
;C              tmp=r_myrand(initseed=[ISEED1,ISEED2])
;C
;C  Some compilers incorporate an intrinsic random number generator with
;C  the same name (but with different argument lists). To avoid conflict,
;C  it is advisable to declare r_myRAND as an external function in all sub-
;C  programs that call it.
;C
;-
      FUNCTION r_myRAND,DUMMY,initseed=initseed,onlyInit=onlyInit
      USCALE=1.0D0/2.0D0^31
      COMMON RSEED,ISEED1,ISEED2

      IF KEYWORD_SET(initseed) THEN BEGIN
	ISEED1 = Long(initseed[0])
	ISEED2 = Long(initseed[1])
        IF KEYWORD_SET(onlyInit) THEN RETURN,0.0D0
      ENDIF

;C
      I1=ISEED1/53668L
      ISEED1=40014L*(ISEED1-I1*53668L)-I1*12211L
      IF (ISEED1 LT 0L) THEN ISEED1=ISEED1+2147483563L
;C
      I2=ISEED2/52774L
      ISEED2=40692L*(ISEED2-I2*52774L)-I2*3791L
      IF (ISEED2 LT 0L) THEN ISEED2=ISEED2+2147483399L
;C
      IZ=ISEED1-ISEED2
      IF (IZ LT 1L) THEN IZ=IZ+2147483562L
;print,'<><><>',iseed1,iseed2,iz,uscale
      RETURN,IZ*USCALE
      END
