; $Id: profiles2.pro,v 1.2 2008/02/07 13:39:04 srio Exp $
;
; Copyright (c) 1988-2007, ITT Visual Information Solutions. All
;       rights reserved. Unauthorized reproduction is prohibited.

pro profiles2, image, margin_space = margin_space, wsize = wsize, order = order, $
  scale=scale, wExodus=wExodus, image_position=pos, xrange=xrange, yrange=yrange
;+
; NAME:
;	PROFILES2
;
; PURPOSE:
;	Interactively draw row or column profiles of an image in a separate
;	window.
;
; CATEGORY:
;	Image analysis.
;
; CALLING SEQUENCE:
;	PROFILES2, Image 
;
; INPUTS:
;	Image:	The variable that represents the image displayed in current
;		window.  This data need not be scaled into bytes.
;		The profile graphs are made from this array.
;
; KEYWORD PARAMETERS:
;	MARGIN_SPACE:	Starting positions of the image in the window.  
;               If this keyword is omitted, [0,0] is assumed.
;
;       IMAGE_POSITION:    The origen of the image
;               If this keyword is omitted, [0,0] is assumed.
;
;	WSIZE:	The size of the PROFILES window as a fraction or multiple
;		of 640 by 512.
;
;	ORDER:	Set this keyword param to 1 for images written top down or
;		0 for bottom up.  Default is the current value of !ORDER.
;
;       SCALE: The scale factor (used within XPlot2d)
;
;       wExodus: The widget Id of an existing (or not) Exodus window
;
; OUTPUTS:
;	No explicit outputs.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	A new window is created and used for the profiles.  When done,
;	the new window is deleted.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	A new window is created and the mouse location in the original
;	window is used to plot profiles in the new window.  Pressing the
;	left mouse button toggles between row and column profiles.
;	The right mouse button exits.
;
; EXAMPLE:
;	Create and display an image and use the PROFILES routine on it.
;	Create and display the image by entering:
;
;		A = BYTSCL(DIST(256))
;		TV, A
;
;	Run the PROFILES routine by entering:
;
;		PROFILES, A
;
;	The PROFILES window should appear.  Move the cursor over the original
;	image to see the profile at the cursor position.  Press the left mouse
;	button to toggle between row and column profiles.  Press the right
;	mouse button (with the cursor over the original image) to exit the
;	routine.
;
; MODIFICATION HISTORY:
;	DMS, Nov, 1988.
;       2007/12/07 srio@esrf.eu adapts it for xplot2d: added scale keyword and
;            store profiles in Exodus by center-click. Allows resizing. 
;            Renamed to profiles2 to avoid conflict with the original one.
;
;-
COMPILE_OPT strictarr


on_error,2                              ;Return to caller if an error occurs
if n_elements(margin_space) NE 2 then margin_space = [0.0,0.0]	;Default start of image
if n_elements(wsize) eq 0 then wsize = .75
IF N_Elements(scale) EQ 0 THEN scale=1.0
IF N_Elements(pos) NE 2 THEN pos=[0.0,0.0] ELSE pos=Float(pos)

sx = Float(margin_space[0])
sy = Float(margin_space[1])

; variables for exodus
IF N_Elements(wExodus) EQ 0 THEN wExodus=0L ; for exodus
xxOld=-1.0
yyOld=-1.0

s = size(image)
;
; this is to deal with mask...
;
maxv = max(image>0,min=minv) 			;Get extrema
;minv = min(image)
IF minv EQ 0 THEN minv=-0.1*maxv


orig_w = !d.window
nx = s[1]				;Cols in image
ny = s[2]				;Rows in image
IF (!Version.Os NE 'MacOS') THEN tvcrs,sx+nx/2,sy+ny/2,/dev ELSE tvcrs,1
tickl = 0.1				;Cross length
print,'Left mouse button to toggle between rows and columns.'
print,'Right mouse button to Exit.'
print,'Center mouse to save profile (in Exodus).'
window,/free ,xs=wsize*640, ys=wsize*512,title='Profiles' ;Make new window
x_size=!d.x_size
y_size=!d.y_size
new_w = !d.window
old_mode = -1				;Mode = 0 for rows, 1 for cols
old_font = !p.font			;Use hdw font
!p.font = 0
mode = 0
if n_elements(order) eq 0 then order = !order	;Image order


while 1 do begin
	wset,orig_w		;Image window
	cursor,x,y,2,/dev	;Read position

	if !mouse.button eq 1 then begin
		mode = 1-mode	;Toggle mode
		repeat cursor,x,y,0,/dev until !mouse.button eq 0
		endif

	x = (x - sx)/scale		;Remove bias
	y = (y - sy)/scale
	
        x=x+pos[0]/scale
        y=y+pos[1]/scale

        device, window_state = ws
	wins = where(ws ne 0)
	if ((where(wins eq new_w))[0] ge 0) then $
	  wset, new_w else $ ;Graph window
    	  return

	if !mouse.button eq 4 then begin		;Quit
		wset,orig_w
		IF (!Version.Os NE 'MacOS') THEN $
			tvcrs,nx/2,ny/2,/dev	;curs to old window
		tvcrs,0				;Invisible
		wdelete, new_w
		!p.font = old_font
		return
		endif
	if mode ne old_mode then begin
		old_mode = mode
		first = 1
		if mode then begin	;Columns?
			plot,[minv,maxv],[0,ny-1],/nodat,title='Column Profile',$
                          position=[0.07,0.07,0.93,0.93], yrange=yrange, xrange=[minv,maxv], $
                          /ystyle
			vecy = findgen(ny)
			crossx = [-tickl, tickl]*(maxv-minv)
			crossy = [-tickl, tickl]*ny
                        iWhat=0
		end else begin
			plot,[0,nx-1],[minv,maxv],/nodata,title='Row Profile',$
                          position=[0.07,0.07,0.93,0.93], xrange=xrange, yrange=[minv,maxv], $
                          /xstyle
			vecx = findgen(nx)
			crossx = [-tickl, tickl]*nx
			crossy = [-tickl, tickl]*(maxv-minv)
                        iWhat=1
		endelse
	endif

	if (x lt nx) and (y lt ny) and $
		(x ge 0) and (y ge 0) then begin	;Draw it
                ; 
                ; check for resize
                ;
                IF (!d.x_size NE x_size) OR (!d.y_size NE y_size) THEN BEGIN
                  CASE iWhat OF
                   0:plot,[minv,maxv],[0,ny-1],/nodat,title='Column Profile',$
                          position=[0.07,0.07,0.93,0.93], yrange=yrange, xrange=[minv,maxv], /ystyle
                   1:plot,[0,nx-1],[minv,maxv],/nodata,title='Row Profile',$
                          position=[0.07,0.07,0.93,0.93], xrange=xrange, yrange=[minv,maxv], /xstyle
                  ENDCASE
                  x_size=!d.x_size
                  y_size=!d.y_size
                ENDIF

		if order then y = (ny-1)-y	;Invert y?
		if first eq 0 then begin	;Erase?
			plots, vecx, vecy, col=0	;Erase graph
			plots, old_x, old_y, col=0	;Erase cross
			plots, old_x1, old_y1, col=0
			xyouts,.1,0,/norm,value,col=0	;Erase text
			empty
		  endif else first = 0
;;;;		value = string([x,y],format="('(',i4,',',i4,')')")
;;;;		value = strtrim(x,2) + string(y)
		;value = strmid(x,8,4)+strmid(y,8,4)
		value = string([x,y],format="('(',i4,',',i4,')')")+String(image[x,y])
		ixy = image[x,y]		;Data value
		if mode then begin		;Columns?
			vecx = image[x,*]	;get column
			old_x = crossx + ixy
			old_y = [y,y]
			old_x1 = [ixy, ixy]
			old_y1 = crossy + y
		  endif else begin
			vecy = image[*,y]	;get row
			old_x = [ x,x]
			old_y = crossy + ixy
			old_x1 = crossx + x
			old_y1 = [ixy,ixy]
		  endelse
		xyouts,.1,0,/norm,value	;Text of locn
		plots,vecx,vecy		;Graph
		plots,old_x, old_y	;Cross
		plots,old_x1, old_y1



                IF !mouse.button EQ 2 THEN BEGIN
                   ;xplot,parent=wXplot,vecx,vecy,/No_Block
	           IF Not(Widget_Info(wExodus,/Valid_Id)) THEN $
                      exodus,/only,/quit,parent=wExodus
	            tmp = Make_Set(Reform(vecx),Reform(vecy))
                    CASE iWhat OF
                     0: title='Vertical profile at:'+ vect2string([x,y])
                     1: title='Horizontal profile at:'+ vect2string([x,y])
                    ENDCASE
                    IF (x NE xxOld) OR (y NE yyOld) THEN BEGIN
	              exodus_loadfile,wExodus,data=tmp,title=title
                      xxOld=x
                      yyOld=y
                    ENDIF
                ENDIF
		endif
endwhile
end
