
;+
; NAME:
;	CONIC_DETECTOR2COEFFS
; PURPOSE:
;	this function calculates the conic coefficients
;	from the detector parameters (direct beam position and 
;       sample position) and cone's semiaperture angle
; CATEGORY:
;	Maths: conics
;
; CALLING SEQUENCE:
;	c=conic_detector2coeffs(v0,vS,theta)
; INPUTS:
;	v0: [X,Y] positions of the direct beam
;       vS: [Xs,Ys,Zs] position of the sample 
;	theta: cone apertute (twoThetaBragg) in rad
; OUTPUTS:
;       conic coefficients in the form: 
;           c[0] + c[1] y + c[2] x + c[3] x y + c[4] y^2 + c[5] x^2
;	
; MODIFICATION HISTORY:
;	by M. Sanchez del Rio. ESRF. Grenoble, Nov 2007
;-	
FUNCTION conic_detector2coeffs,v0,vs,theta

; theta in rads

;v0=[200D0,250]
;vs=[0D0,200,800]
;v0=[2095D0,1373.00]
;vs=[0D0,111,1855.01]
;theta = theta1*!dpi/
;theta=5 * !dpi/ 180


xs = vs[0]
ys = vs[1]
zs = vs[2]
x0 = v0[0]
y0 = v0[1]
coeff = [ $
        (-(x0*xs) + xs^2 - y0*ys + ys^2 + zs^2)^2 -  $
         ((x0 - xs)^2 + (y0 - ys)^2 + zs^2)* $
          (xs^2 + ys^2 + zs^2)*Cos(theta)^2, $
        -2*(y0 - ys)*((x0 - xs)*xs + (y0 - ys)*ys - zs^2) +  $
         2*ys*((x0 - xs)^2 + (y0 - ys)^2 + zs^2)* $
          Cos(theta)^2,-2*(x0 - xs)* $
          ((x0 - xs)*xs + (y0 - ys)*ys - zs^2) +  $
         2*xs*((x0 - xs)^2 + (y0 - ys)^2 + zs^2)* $
          Cos(theta)^2,2*(x0 - xs)*(y0 - ys), $
        (y0 - ys)^2 - ((x0 - xs)^2 + (y0 - ys)^2 + zs^2)* $
          Cos(theta)^2,(x0 - xs)^2 -  $
         ((x0 - xs)^2 + (y0 - ys)^2 + zs^2)*Cos(theta)^2]

RETURN,coeff
END


