C
C This program is taken from diff_pattern, available in XOP as
C XCRYSTAL. It has been adapted to the same inputs/outputs
C as the other BENT crystal programs and the purpose is ONLY
C comparison of the BENT crystal with the FLAT crystals  results.
C
C MSR/97/10/08
C
C
C
C This program calculates the diffraction pattern of a crystal.
C It replaces the old second part of the Bragg program.
C Now is an independent module to keep independency of the first part of BRAGG
C and is sharing the CRYSTAL routine with SHADOW. This allows no 
C duplication of code between BRAGG and CRYSTAL, as it was before.
C I avoid to use the term 'rocking curve' as in the old BRAGG, because
C strictly speaking a rocking curve is the result of the combined action
C of two crystal, the crystal to be analyzed, and the analyzer, which is
C scanned to register the transmitted intensity. As this program calculates
C ONE single crystal profile, is more exact to call it "diffraction
C profile" or "diffraction pattern"
C
C MSR/94/03/25
C
	PROGRAM		DIFF_PATTERN

	implicit	none

        real*8  pi,pihalf,twopi,todeg,torad,tocm,toangs
        DATA    PI      /  3.1415 92653 58979 32384 62643 D0 /
        DATA    PIHALF  /  1.5707 96326 79489 66192 31322 D0 /
        DATA    TWOPI   /  6.2831 85307 17958 64679 25287 D0 /
        DATA    TODEG   / 57.2957 79513 08232 08767 98155 D0 /
        DATA    TORAD   /  0.0174 53292 51994 32957 69237 D0 /
C        DATA    TOCM    /  1.239 852    D-4                  /
C        DATA    TOANGS  /  1.239 852    D+4                  /
        DATA    TOCM    /  1.2398 4187572794035    D-4        /
        DATA    TOANGS  /  1.2398 4187572794035    D+4        /
C        DATA    E2_MC2  /  2.817939 D-13                     / ! e^2/mc^2
C                                                               !classical e-
C                                                               !radius in cm
C        DATA    AVOG    /  6.022098 D+23                     /


	character*80	rstring
	integer*4	irint,scan_mode,scanunit,scanpoints,i,kwhat
	integer*4	iunits(3),iunit
	real*8		rnumber,phot,q_phot
	real*8		r_s, r_p,phase_s, phase_p, depht_mfp_s
	real*8		depht_mfp_p
	real*8		delta_ref, theta_b
	real*8		scanmin,scanmax,scanstep,theta,graze,scanval
	real*8		scanval2,ssr,spr
	real*8		vvin(3), vvout(3), bh(3), vnor(3)	!vectors

	character*80	file_refl                           !as in common.blk
	character*160	top_title
	integer*4	f_mosaic,f_bragg_a,f_refrac
	integer*4	iblank2
	real*8		spread_mos,thickness,a_bragg,d_spacing
	real*8		sin_ref,theta_b_ref,scanval_ref,graze_ref
	real*8		cbent_tmp,cbent_y0,cbent_y1,cbent_ystep
	real*8		cbent_tmp2

	common	/dpattern/	
     $file_refl,f_mosaic,f_bragg_a,
     $			spread_mos,thickness,a_bragg,f_refrac,d_spacing,
     $			ssr,spr
C
C
C

c
c open output files
c
        OPEN    (23,FILE='cryst_za.inf',STATUS='UNKNOWN')
        OPEN   (20,FILE='cryst_za.dat',STATUS='UNKNOWN')

	iunits(1) = 6
	iunits(2) = 23
	iunits(3) = 20


	DO i=1,2
	write(iunits(i),*) ' '
	write(iunits(i),*) ' '
	write(iunits(i),*) ' '
	write(iunits(i),*) 
     $'*****************************************************'
	write(iunits(i),*) 
     $'*               CRYST_ZA                            *'
	write(iunits(i),*) 
     $'*Calculation of a single crystal diffraction profile*'
	write(iunits(i),*) 
     $'*          (derived from DIFF_PATTERN)              *'
	write(iunits(i),*) 
     $'*                                                   *'
	write(iunits(i),*) 
     $'*****************************************************'
	write(iunits(i),*) ' '
	ENDDO

C
C reads file with inputs
C
C        cbent_tmp = RNUMBER(' [useless] <?> ')

	iunit = 25
	OPEN    (iunit,FILE='cryst_za.inp',STATUS='old')
	read(iunit,'(a)') file_refl
	read(iunit,'(a)') top_title
	read(iunit,*) phot
	read(iunit,*) f_refrac
        read(iunit,*) cbent_y0 
        read(iunit,*) cbent_y1 
        read(iunit,*) cbent_ystep 
        read(iunit,*) cbent_tmp 
        read(iunit,*) cbent_tmp 
        read(iunit,*) a_bragg 
	read(iunit,*) thickness
        read(iunit,*) cbent_tmp 
	close(iunit)

C
C immediate redefinitions
C
	f_refrac = f_refrac - 1
	a_bragg = a_bragg*torad
	thickness = thickness/10.0
	if (thickness.eq.0) thickness=1000.0 ! t=0 means thick
	f_mosaic = 0
c
c write info
c

      WRITE (23,*) '**Input section:'
      write(23,*) 'crystal input file: ',file_refl
      write(23,*) 'photon energy [eV]: ',PHOT
      write(23,*) 'geometry [0: Bragg, 1: Laue]',F_REFRAC
      write(23,*) 'Y min: ',CBENT_Y0
      write(23,*) 'Y max: ',CBENT_Y1
      write(23,*) 'Y step: ',CBENT_YSTEP
c      write(23,*) 'Polarization [1=s,2=p,3=unpolarized]: ',1
      write(23,*) 'crystal curvature radius [m]: INFINITY'
      write(23,*) 'asymmetry angle [rad]: ',a_bragg
      write(23,*) 'asymmetry angle [deg]: ',a_bragg/torad
      write(23,*) 'crystal thickness [mm]: ',Thickness
c      write(23,*) 'Poisson ratio   : ',kstar
      write(23,*) ' '


	 write(20,'(a)') '#F crystal_za.dat'
	 write(20,'(a)') '#S 1 crystal_za run'
	 write(20,'(a)') '#C results of crystal_za [Zachariasen]  run'
	 write(20,'(a)') '#UT0 '//top_title(1:iblank2(top_title))
	 write(20,'(a)') '#N 6'
	 write(20,'(a)') '#L theta_inc[mrad]  theta_ref[mrad]  
     1theta_inc[deg]  y  Reflectivity-p  Reflectivity-s'


C
C Inquires about the scanning variable
C
cbent	write (6,*) 'Please select scanning variable: '
cbent	write (6,*) ' [1] Incident/Reflected angle [absolute] '
cbent	write (6,*) ' [2] Incident/Reflected angle minus '
cbent     $              //'theta Bragg corrected'
cbent	write (6,*) ' [3] Incident/Reflected angle minus '
cbent     $              //'theta Bragg'
cbent	write (6,*) ' [4] Photon energy '
cbent	write (6,*) ' [5] y variable [Zachariasen] '
cbent	scan_mode = irint('<?> ')
	scan_mode = 3
	if (scan_mode.lt.4) then
cbent	  PHOT    = RNUMBER ('... at what energy (eV) ? ')
	  Q_PHOT  = PHOT*TWOPI/TOCM       ! 2 pi / lambda
	else if (scan_mode.eq.4) then
	  THETA = RNUMBER ('... at what grazing angle [deg]: ')
	  THETA = THETA*torad
	else if (scan_mode.eq.5) then
	  PHOT    = RNUMBER ('... at what energy (eV) ? ')
	  Q_PHOT  = PHOT*TWOPI/TOCM       ! 2 pi / lambda
	endif
C
C Inquires about Reflection (Bragg) or Transmission (Laue) geometry.
C If the crystal is perfect we also allow to calculate the transmitted
C (not diffracted beams.
C
cbent        write (6,*) 'What do you want to calculate ?: '
cbent        if (f_mosaic.eq.0) then
cbent          write (6,*) '[0] Diffracted beam in Reflection (Bragg) '
cbent     $                //'geometry'
cbent          write (6,*) '[1] Diffracted beam in Transmission (Laue) '
cbent     $                //'geometry'
cbent          write (6,*) '[2] Transmitted beam in Bragg case'
cbent          write (6,*) '[3] Transmitted beam in Laue case'
cbent        else if (f_mosaic.eq.1) then
cbent          write (6,*) '[0] Diffracted beam in Reflection (Bragg) '
cbent     $                //'geometry  '
cbent          write (6,*) '[1] Diffracted beam in Transmission (Laue) '
cbent     $                //'geometry '
cbent        endif
cbent	write (6,*) '[1] Diffracted beam in Reflection (Bragg) '
cbent     $                //'geometry'
cbent	write (6,*) '[2] Diffracted beam in Transmission (Laue) '
cbent     $                //'geometry'
cbent        f_refrac = irint(' <?> ')
cbent	f_refrac = f_refrac - 1

C
C Inquires about mosaic crystal values.
C
cbent        if (f_mosaic.eq.1) then
cbent         spread_mos  = RNUMBER('mosaic angle spread (FWHM) [deg] ? ')
cbent         spread_mos = torad*spread_mos/2.35
cbent        else
cbent         spread_mos   = 0.0d0
cbent        end if
C
C Inquires crystal Thickness. In the Perfect crystal case, we allow
C to use the thick crystal approximation. In such case, the user must
C input any negative value.
C
cbent        WRITE(6,*) 'Input the thickness of the crystal [cm] '
cbent        if (f_mosaic.eq.0) then
cbent           write(6,*) ' [Type a negative value for using the thick '
cbent     $                //'crystal approximation] '
cbent        endif
cbent         thickness = RNUMBER(' <?> ')
C
C Inquires about asymmetrical diffraction
C
cbent        IF (F_MOSAIC.NE.1) THEN
cbent          WRITE(6,*) 'Asymmetric cut angle (deg) between face and '
cbent     $               //'bragg planes (CW)= '
cbent          READ(*,*) A_BRAGG
cbent	 a_bragg = a_bragg*torad
cbent         if (a_bragg.eq.0.0) then
cbent           f_bragg_a = 0
cbent         else
cbent           f_bragg_a = 1
cbent         endif
cbent        ELSE                                  ! mosaic case
cbent	 if (f_refrac.EQ.1) a_bragg = 90.0
cbent	 if (f_refrac.EQ.0) a_bragg = 0.0
cbent	ENDIF


	f_bragg_a = 1
C
C Call CRYSTAL to read the file with the crystal data
C
	call crystal  (q_phot, vvin, vvout, bh, vnor, 
     $r_s, r_p,phase_s, phase_p, depht_mfp_s, depht_mfp_p,
     $delta_ref, theta_b, -1)
C
C Call CRYSTAL to calculate useful parameters
C
        WRITE(*,*) ' '
        WRITE(*,*) 'So far, we are working with:'

	write(23,*) ' '
	write(23,*) '##########################################'
	write(23,*) 'Starts data from Struct Fact calculation.'
	call crystal  (q_phot, vvin, vvout, bh, vnor, 
     $r_s, r_p,phase_s, phase_p, depht_mfp_s, depht_mfp_p,
     $delta_ref, theta_b, 0)
	call crystal  (q_phot, vvin, vvout, bh, vnor, 
     $r_s, r_p,phase_s, phase_p, depht_mfp_s, depht_mfp_p,
     $delta_ref, theta_b, 1)
	write(23,*) 'Ends data from Struct Fact calculation.'
	write(23,*) '#######################################'
	write(23,*) ' '


	graze = asin(pi/q_phot/d_spacing) + a_bragg
	graze_ref = asin(pi/q_phot/d_spacing) - a_bragg
	write (23,*) 
     $'>> incident angle [deg]: ',graze*TODEG
	write (23,*) 
     $'>> reflected angle [deg]: ',graze_ref*TODEG
	write (23,*) 
     $'>> incidence angle corrected for refraction: theta_b = ',
     $theta_b*todeg

C
C	store the shift of the corrected angle for forther calls
C
	call cryst_za_dy(1,graze-theta_b)
C
C Units for the scanning variable
C
cbent	if (scan_mode.lt.4) then 
cbent	  write(6,*) 'Select units for the scanning variable (angle):'
cbent	  write(6,*) '[0] radians'
cbent	  write(6,*) '[1] microradians'
cbent	  write(6,*) '[2] degrees'
cbent	  write(6,*) '[3] arc sec'
cbent	  scanunit = irint(' <?>')
cbentc	  SCANUNIT = 1
cbentc	else
cbent	endif
	SCANUNIT = 1  ! microrads

cbent	write(6,*) 'Input scanning variable limits in the chosen units.'
cbent	scanmin = rnumber('Minimum ? ')
cbent	scanmax = rnumber('Maximum ? ')
cbent	scanpoints = irint('Number of points ? ')
cbent	scanstep = (scanmax - scanmin) / (scanpoints - 1)

	call cryst_za_y(0,cbent_tmp)
	call cryst_za_dy(0,cbent_tmp2)

	write (23,*) ' '
	write (23,*) '1*y [microrads]=',abs(cbent_tmp)
	write (23,*) 'dy [microrads]=',cbent_tmp2*1.0D6
	write (23,*) ' '
	
	scanmin = cbent_y0*abs(cbent_tmp)-cbent_tmp2*1.0D6
	scanmax = cbent_y1*abs(cbent_tmp)-cbent_tmp2*1.0D6
	scanstep = cbent_ystep*abs(cbent_tmp)
	scanpoints = (scanmax - scanmin) / (scanstep)
	scanpoints = scanpoints + 1

	write (23,*) ' '
	write (23,*) 'scanmin [microrads]= ',scanmin
	write (23,*) 'scanmax [microrads]= ',scanmax
	write (23,*) 'scanpoints = ',scanpoints
	write (23,*) 'scanstep [microrads]= ',scanstep
	write (23,*) ' '
c
c initialize the vectors 
c
	vvin(1) = 0.0D0
	 vvin(2) = cos(theta_b)
	  vvin(3) = -sin(theta_b)

	vnor(1) = 0.0D0
	 vnor(2) = 0.0D0
	  vnor(3) = 1.0D0

	bh(1) = 0.0D0*TWOPI/d_spacing
	 bh(2) = sin(a_bragg)*TWOPI/d_spacing
	  bh(3) = cos(a_bragg)*TWOPI/d_spacing

	call scat_direction (vvin,bh,vnor,q_phot,vvout)
	call dot (vvout,vnor, sin_ref)
	theta_b_ref = asin(sin_ref)
c
c main loop over the scanning points ===== starts ====
c
	do i=1,scanpoints
c
	scanval = scanmin + scanstep*(i-1)
c
c convert user unit to shadow units (rads, eV)
c
        if (scanunit.eq.1) then
          scanval2 = scanval*1D-6
        else if (scanunit.eq.2) then
          scanval2 = scanval*torad
        else if (scanunit.eq.3) then
          scanval2 = scanval*torad/3600D0
        else
	  scanval2 = scanval
	end if
c
c convert user mode to theta[abs]
c
        if (scan_mode.eq.4) then                  ! energy scan
          PHOT    = scanval2
          Q_PHOT  = PHOT*TWOPI/TOCM       	  ! 2 pi / lambda
        else					  ! angle scan
	  if (scan_mode.EQ.1) then 
	    theta = scanval2
	  else if (scan_mode.EQ.2) then
	    theta = theta_b + scanval2
	  else if (scan_mode.EQ.3) then
	    theta = graze + scanval2
	  else if (scan_mode.EQ.4) then
c	    theta = theta_b + (scanval2)
	  else if (scan_mode.EQ.5) then
	    theta = theta_b + scanval2*ssr
	  endif
	endif

c
c calculate output direction 
c
	vvin(2) = cos(theta)
	  vvin(3) = -1.0D0*sin(theta)
	call scat_direction(vvin,bh,vnor,q_phot,vvout)

	call dot (vvout,vnor,sin_ref)

c
c calculate reflectivity
c
	call crystal  (q_phot, vvin, vvout, bh, vnor, 
     $r_s, r_p,phase_s, phase_p, depht_mfp_s, depht_mfp_p,
     $delta_ref, theta_b, 2)

c
c if asymmetric is selected, calculate and write down
c the output angle
c
	if (f_bragg_a.EQ.1) then
          call dot (vvout,vnor,sin_ref)

csrio	write(*,*) '<><> theta,theta_ref: ',theta,asin(sin_ref)

          if (scan_mode.EQ.1) then
            scanval_ref = asin(sin_ref)
          else if (scan_mode.EQ.2) then
            scanval_ref =  - theta_b_ref + asin(sin_ref)
          else if (scan_mode.EQ.3) then
            scanval_ref =  - graze_ref + asin(sin_ref)
          else if (scan_mode.EQ.4) then
c           scanval_ref = scanval
          endif

          if (scanunit.eq.1) then
            scanval_ref = scanval_ref/1D-6
          else if (scanunit.eq.2) then
            scanval_ref = scanval_ref/torad
          else if (scanunit.eq.3) then
            scanval_ref = scanval_ref/torad*3600D0
          else
            scanval_ref = scanval_ref
          end if
	else
          scanval_ref = scanval
	endif  
	if (scan_mode.EQ.4) scanval_ref = TOANGS/scanval
C
C prepare and write outputs
C
C scanval in microrads
c retrieve dy in rads
	call cryst_za_dy(0,cbent_tmp)
	cbent_tmp = scanval+cbent_tmp*1.0D6
c retrieve y in microrads
	call cryst_za_y(0,cbent_tmp2)
	cbent_tmp = cbent_tmp/cbent_tmp2
C pass to mrad
	scanval = scanval*1.0D-3
	scanval_ref = scanval_ref*1.0D-3
	write(20,'(6(g15.8,1x))') scanval,scanval_ref,
     1scanval*180.0D-3/PI,cbent_tmp,r_p**2,r_s**2
c
c main loop over the scanning points ===== ends ====
c
	enddo

c
c close files and exit
c
	close(20)
c	close(21)
cbent	write (*,*) '>> '
cbent	write (*,*) '>> Files diff_pattern.inf (parameters) and '
cbent	if (scan_mode.EQ.4) then 
cbent	  write (*,*) 
cbent     $  '>> diff_pattern.dat (E [eV],Lambda [A],s-pol,p-pol)'
cbent	else
cbent	  write (*,*) 
cbent     $  '>> diff_pattern.dat (Scan in,Scan out,s-pol,p-pol)'
cbent	endif
cbent	write (*,*) '>> writtem  to disk.'
cbent	write (*,*) '>> '

	end
	
c========================================================================
c
c	subroutine scat_direction
c	calculates the output scattering direction applying the
c	equations k_out_par = k_in_par + BH_par and |k_in| = |k_out|
c
c	kk% = ( 2 pi / lambda )  * vv%
c	vv% direction versor
c	q_phot = 2 pi / lambda [cm**-1]
c	bh = ( 2 pi / d_spacing )  normal_to_bragg_planes
c	vnor = surface_normal
c
	subroutine scat_direction (vvin,bh,vnor,q_phot,vvout)

        implicit        none

        real*8          vvin(3),vvout(3),bh(3),vnor(3),q_phot
	real*8		vkkin(3),vkkin_par(3),vkkin_perp(3)
	real*8		vkkout(3),vkkout_par(3),vkkout_perp(3)
	real*8		bh_par(3),bh_perp(3)
	real*8		mod2_vkkout_par,mod_vkkout_perp

	call norm (vnor,vnor)

c	write(*,*) 'SCAT: vvin = ',vvin
c	write(*,*) 'SCAT: vnor = ',vnor
c vkkin par and perp components
	call norm (vvin,vvin)
	call scalar (vvin,q_phot,vkkin)

	call proj (vkkin,vnor,vkkin_perp)
	call vector (vkkin_perp,vkkin,vkkin_par)

	call proj (bh,vnor,bh_perp)
	call vector (vkkin_perp,vkkin,vkkin_par)

c	write(*,*) 'SCAT: vkkin = ',vkkin
c	write(*,*) 'SCAT: vkkin_par = ',vkkin_par
c	write(*,*) 'SCAT: vkkin_perp = ',vkkin_perp
c bh par and perp components
	call proj (bh,vnor,bh_perp)
	call vector (bh_perp,bh,bh_par)
c	write(*,*) 'SCAT: bh = ',bh
c	write(*,*) 'SCAT: bh_perp = ',bh_perp
c	write(*,*) 'SCAT: bh_par = ',bh_par

c vkkout
	call sum (vkkin_par,bh_par,vkkout_par)
	call dot(vkkout_par,vkkout_par,mod2_vkkout_par )
#if lahey
	mod_vkkout_perp = sqrt(q_phot**2 - mod2_vkkout_par)
#else
	mod_vkkout_perp = dsqrt(q_phot**2 - mod2_vkkout_par)
#endif

c	write(*,*) 'SCAT: q_phot = ',q_phot
c	write(*,*) 'SCAT: mod2_vkkout_par = ',mod2_vkkout_par
c	write(*,*) 'SCAT: mod_vkkout_perp = ',mod_vkkout_perp

	call scalar (vnor,mod_vkkout_perp,vkkout_perp)
	call sum (vkkout_par,vkkout_perp,vkkout)
	call norm (vkkout,vvout)
c	write(*,*) 'SCAT: vkkout_par = ',vkkout_par
c	write(*,*) 'SCAT: vkkout_perp = ',vkkout_perp
c	write(*,*) 'SCAT: vkkout = ',bh_par
c	write(*,*) 'SCAT: **************************'
c	write(*,*) ' '
c
	return
	end
c
c#if unix
c#include  "/civa/users/b/shadow/shadow2.0/src/trace/./../include/header.txt"
c#elif vms
c     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
c#endif
c
C
C
C+++
C	SUBROUTINE	CRYSTAL
C
C	PURPOSE		Computes the reflectivity of a symmetric Bragg crystal 
C			according to the dynamic theory of x-ray diffraction.
C
C	ALGORITHM	Reference B.E.Warren, X-Ray Diffraction, 
C			Addison-Wesley 1969.  See also M.J.Bedzyk, G.Materlik 
C			and M.V.Kovalchuk, Phy. Rev. B30, 2453(1984).
C			For mosaic crystal reflectivity see Zachariasen, 
C			Theory of x-ray diffraction in crystals, Dover (1966)
C			formula 4.24, and Bacon and Lowde, Acta Crystall.1
C			pag 303 (1948) formula 17. 
C
C	MODIFIED	July 1989, M. Sanchez del Rio for asymmetry part,
C			July 1990, mosaic part.
C			August 1992, laue part.
C
C---
     	SUBROUTINE	CRYSTAL	 (Q_PHOT, VIN, VOUT, BH, SURFNOR,
     $R_S, R_P,PHASE_S, PHASE_P, L_EXT_S, L_EXT_P, 
     $DELTA_REF, THETA_B, KWHAT)
C
C kwhat: flag:
C	<0 read crystal file (call crystal_fh)
C	0 info mode (call crystal_info)
C	1 set mode (call crystal_set)
C	2 reflectivity mode (call crystal_{perfect,mosaic})

c#if unix
CCC     	INCLUDE	'./../../include/common.blk'
c#elif vms
c     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
c#endif
c
CCC
	implicit none
                                       

CCC
        real*8  pi,pihalf,twopi,todeg,torad,tocm,toangs
        DATA    PI      /  3.1415 92653 58979 32384 62643 D0 /
        DATA    PIHALF  /  1.5707 96326 79489 66192 31322 D0 /
        DATA    TWOPI   /  6.2831 85307 17958 64679 25287 D0 /
        DATA    TODEG   / 57.2957 79513 08232 08767 98155 D0 /
        DATA    TORAD   /  0.0174 53292 51994 32957 69237 D0 /
C        DATA    TOCM    /  1.239 852    D-4                  /
C        DATA    TOANGS  /  1.239 852    D+4                  /
        DATA    TOCM    /  1.2398 4187572794035    D-4        /
        DATA    TOANGS  /  1.2398 4187572794035    D+4        /
C        DATA    E2_MC2  /  2.817939 D-13                     / ! e^2/mc^2
C                                                               !classical e-
C                                                               !radius in cm
C        DATA    AVOG    /  6.022098 D+23                     /


        integer*4	i_debug
	real*8		Q_PHOT                              !Arguments
	real*8		VIN(3), VOUT(3), BH(3), SURFNOR(3)
	real*8		R_S, R_P,PHASE_S, PHASE_P
	real*8		L_EXT_S, L_EXT_P
	real*8		DELTA_REF, THETA_B
	integer*4	KWHAT

        character*80    file_refl                           !as in common.blk
        integer*4       f_mosaic,f_bragg_a,f_refrac
        real*8          spread_mos,thickness,a_bragg
        real*8          d_spacing,ass_fac


	real*8		rn,rn1,d_spacing1

	real*8		phot,r_lam0
	complex*16	ci,F_0,FH,FH_BAR,REFRAC

	real*8		graze
	real*8		absorp    !,theta_inc_o
	real*8		ssr,spr, q_mos

	complex*16	psi_h,psi_hbar,psi_0

	real*8		theta_b_h,theta_b_sym

        common  /dpattern/   
     $file_refl,f_mosaic,f_bragg_a,
     $spread_mos,thickness,a_bragg,f_refrac,d_spacing, 
     $ssr,spr
	save	rn



C
	i_debug = 0
	if (i_debug.EQ.1) write (*,*) 
     $'<><>CRYSTAL: ******** crystal called with flag ********',kwhat
	CI	= (0.0D0,1.0D0)
C**************************************************************
C If flag is < 0, reads in the reflectivity data, and store the
C returned RN1 in the variable RN (saved) and D_SPACING1 in the
C variable D_SPACING (common block) for further calls.
C**************************************************************
     	IF (KWHAT.LT.0) THEN
	if (i_debug.EQ.1) write (*,*) 
     $'<><> CRYSTAL: file is: ',FILE_REFL

	call crystal_fh (KWHAT, FILE_REFL, PHOT, THETA_B
     $,FH,FH_BAR,F_0,PSI_H,PSI_HBAR,PSI_0,REFRAC
     $,RN1,D_SPACING1)
	RN = RN1
	D_SPACING = D_SPACING1
	RETURN
	ENDIF

C***************************************************
C If flag is >= 0, general calculation
C***************************************************
C
C
	PHOT	= Q_PHOT/TWOPI*TOCM
	R_LAM0 	= TWOPI/Q_PHOT
	GRAZE = ASIN(R_LAM0/d_spacing/2.0D0)

	if (i_debug.EQ.1) write (*,*) 
     $'<><>CRYSTAL: working at energy: ',phot
C	IF (PHOT.LT.ENERGY(1).OR.PHOT.GT.ENERGY(npoint)) THEN
C 	  CALL	MSSG ('CRYSTAL ',
C     $			'Incoming photon energy is out of range.',IERR)
C	  R_S	= 0.0D0
C	  R_P	= 0.0D0
C	  PHASE_S = 0.0D0
C	  PHASE_P = 0.0D0
C	  THETA_B = 0.0D0
C	  RETURN
C	END IF	  
C
C call crystal_fh to get the structure factor
C
	if (i_debug.EQ.1) 
     $	  write (*,*) '<><>CRYSTAL: calling crystal_fh: ',kwhat
	RN1 = -1
	D_SPACING1 = -1.
	call crystal_fh (KWHAT, FILE_REFL, PHOT, GRAZE
     $,FH,FH_BAR,F_0,PSI_H,PSI_HBAR,PSI_0,REFRAC
     $,RN1,D_SPACING1)
	if (i_debug.EQ.1) then
	  write(*,*) '<><>CRYSTAL: back crystal_fh, d_spacing: '
     $       ,d_spacing
	  write(*,*) '<><>CRYSTAL: back crystal_fh, rn: ',rn
	end if

C
C call crystal_set to get THETA_B and L_EXT
C returns also the ssr and spr needed in diff_pattern
C
	if (kwhat.eq.0) then
          CALL      CRYSTAL_SET      (Q_PHOT,
     $F_MOSAIC,D_SPACING,F_REFRAC,A_BRAGG,RN,THICKNESS,SPREAD_MOS,
     $THETA_B,THETA_B_H,THETA_B_SYM,L_EXT_S,L_EXT_P,SSR,SPR,ASS_FAC)
	end if
C
C call crystal_info to print and display parameters.
C
	if (kwhat.eq.0) then
          CALL  CRYSTAL_INFO  (Q_PHOT,
     $    F_MOSAIC,D_SPACING,F_REFRAC,A_BRAGG,RN,THICKNESS,SPREAD_MOS)
	endif
C
C Main calculation
C
	if (kwhat.eq.2) then
        IF (F_MOSAIC.EQ.1) THEN
	  Q_MOS = pi**2*abs(psi_h*psi_hbar)/r_lam0/sin(2*graze)
          CALL      CRYSTAL_MOSAIC   (
     $		Q_PHOT, VIN,
     $		BH, SURFNOR, D_SPACING, THICKNESS, F_REFRAC,SPREAD_MOS,
     $		Q_MOS,REFRAC,
     $		R_S, R_P,PHASE_S, PHASE_P, L_EXT_S, L_EXT_P)
        ELSE
     	  call	CRYSTAL_PERFECT	 (Q_PHOT, VIN, VOUT, 
     $		BH, SURFNOR,D_SPACING, THICKNESS, F_REFRAC,
     $		PSI_0,PSI_H,PSI_HBAR,
     $		R_S, R_P,PHASE_S, PHASE_P)
	END IF
	end if

	RETURN
     	END

C+++
C	SUBROUTINE	CRYSTAL_INFO
C
C	PURPOSE		C
C
C	ALGORITHM	Reference B.E.Warren, X-Ray Diffraction, 
C
C	MODIFIED	M. Sanchez del Rio
C
C---

     	SUBROUTINE CRYSTAL_INFO	 (Q_PHOT, 
     $F_MOSAIC,D_SPACING,F_REFRAC,A_BRAGG,RN,THICKNESS,SPREAD_MOS)

	implicit none
                                       

CCC
        real*8  pi,pihalf,twopi,todeg,torad,tocm,toangs
        DATA    PI      /  3.1415 92653 58979 32384 62643 D0 /
        DATA    PIHALF  /  1.5707 96326 79489 66192 31322 D0 /
        DATA    TWOPI   /  6.2831 85307 17958 64679 25287 D0 /
        DATA    TODEG   / 57.2957 79513 08232 08767 98155 D0 /
        DATA    TORAD   /  0.0174 53292 51994 32957 69237 D0 /
C        DATA    TOCM    /  1.239 852    D-4                  /
C        DATA    TOANGS  /  1.239 852    D+4                  /
        DATA    TOCM    /  1.2398 4187572794035    D-4        /
        DATA    TOANGS  /  1.2398 4187572794035    D+4        /
C        DATA    E2_MC2  /  2.817939 D-13                     / ! e^2/mc^2
C                                                               !classical e-
C                                                               !radius in cm
C        DATA    AVOG    /  6.022098 D+23                     /


        integer*4	i_debug
	real*8		Q_PHOT                              !Arguments
	real*8		L_EXT_S, L_EXT_P
	real*8		THETA_B

        character*80    file_refl                           !as in common.blk
        integer*4       f_mosaic,f_bragg_a,f_refrac
        real*8          spread_mos,thickness,a_bragg
        real*8          d_spacing


	real*8		rn,rn1,d_spacing1

	integer*4	i
	real*8		phot,r_lam0
	complex*16	F_0,FH,FH_BAR,REFRAC

	real*8		graze,sin_gra,ass_fac
	real*8		absorp    !,theta_inc_o
	real*8		ssr,spr, q_mos
	real*8		tmax_mos
	real*8		texts,textp

	complex*16	psi_h,psi_hbar,psi_0

	real*8		theta_b_sym,theta_b_h
	real*8		sigma_gamma,biga_mosaic,omega,kpolsqrt

C
C Computes reflectivities at given wavelength and angle.
C
	i_debug = 0
	PHOT	= Q_PHOT/TWOPI*TOCM
	R_LAM0 	= TWOPI/Q_PHOT
	SIN_GRA = R_LAM0/d_spacing/2.0D0
	GRAZE = ASIN(SIN_GRA)

	RN1 = -1.
	D_SPACING1 = -1.
        call crystal_fh (1, FILE_REFL, PHOT, GRAZE
     $,FH,FH_BAR,F_0,PSI_H,PSI_HBAR,PSI_0,REFRAC
     $,RN1,D_SPACING1)
#if lahey
	ABSORP  = 2.0d0 * TWOPI *(-AIMAG(REFRAC)) / R_LAM0
#else
	ABSORP  = 2.0d0 * TWOPI *(-IMAG(REFRAC)) / R_LAM0
#endif

     	CALL CRYSTAL_SET	 (Q_PHOT, 
     $F_MOSAIC,D_SPACING,F_REFRAC,A_BRAGG,RN,THICKNESS,SPREAD_MOS,
     $THETA_B,THETA_B_H,THETA_B_SYM,L_EXT_S,L_EXT_P,SSR,SPR,ASS_FAC)

	if (i_debug.eq.1) then
	  write (*,*) '<><>CRYSTAL_INFO ssr: ',ssr
	  write (*,*) '<><>CRYSTAL_INFO spr: ',spr
	  write (*,*) '<><>CRYSTAL_INFO theta_b: ',theta_b
	end if


C***************************************************
c display results on screen (unit=6) and in unit 27 
C***************************************************
C

C
C Calculate mosaic parameters
C
	if (f_mosaic.EQ.1) then
	  if (f_refrac.eq.0) then
	    biga_mosaic = thickness*absorp/sin(torad*graze)    !bragg
	  else if (f_refrac.eq.1) then
	    biga_mosaic = thickness*absorp/cos(torad*graze)    !laue(alpha=90)
	  else 
	    write (*,*) 'CRYSTAL_INFO Error: Option not implemented.'
	    stop
	  endif
	  omega   = (1/sqrt(twopi))*(1/spread_mos)
C
C Q_mos is the mosaic q variable (Zachariasen's [4.33b])
C Sigma_Gamma refers to Zachariasen's formula 4.33a
C
	  q_mos = pi**2*abs(psi_h*psi_hbar)/r_lam0/sin(2*graze)
          sigma_gamma =  omega*q_mos
          kpolsqrt = (cos(2*graze))**2

	  tmax_mos = cos(graze)*dexp(1+2*sigma_gamma/absorp)/2/
     $sigma_gamma/absorp/absorp
	  texts= r_lam0**2/pi/sin(2*graze)/ssr/2/d_spacing
	  textp= r_lam0**2/pi/sin(2*graze)/spr/2/d_spacing
	end if

	DO i=6,23,17       ! write output in units 6(screen) and 23
          WRITE(i,*) ' '
	  RN1 = -1.
	  D_SPACING1 = -1.
          call crystal_fh (i, FILE_REFL, PHOT, GRAZE
     $,FH,FH_BAR,F_0,PSI_H,PSI_HBAR,PSI_0,REFRAC
     $,RN1,D_SPACING1)


          WRITE(i,*) 'Theta (graz)         = ',GRAZE,' rads'
          WRITE(i,*) '                     = ',GRAZE*TODEG,' degrees'
          WRITE(i,*) 'Symmetric Bragg angle (corrected) = ',
     $			THETA_B_SYM,' rad'
          WRITE(i,*) '                                  = ',
     $			THETA_B_SYM*TODEG,' degrees'
          WRITE(i,*) 'Asymmetry factor b=  ',ass_fac
          WRITE(i,*) 'Asymmetry angle alpha= ',a_bragg*todeg,' degrees'
          WRITE(i,*) ' '
          WRITE(i,*) 'Extinction length sigma= ',L_EXT_S*1D4,' microns'
          WRITE(i,*) 'Extinction length pi= ',L_EXT_P*1D4,' microns'
          WRITE(i,*) ' '

cbent
cbent added this part to pass this value to tha main program
cbent
	call cryst_za_y(1,SSR*1.0D+6)
c	  OPEN	(45,FILE='cbent.y',STATUS='UNKNOWN')
c	  write(45,*) SSR*1.0D+6
c	  write(45,*) SPR*1.0D+6
c	  write(45,*) SSR*1.0D+6/sqrt(abs(ass_fac))
c	  write(45,*) SPR*1.0D+6/sqrt(abs(ass_fac))
c	  write(45,*) SSR*1.0D+6*sqrt(abs(ass_fac))
c	  write(45,*) SPR*1.0D+6*sqrt(abs(ass_fac))
c	  CLOSE(45)
          WRITE(i,*) ' 1*y s-pol symmetrical [microrad] ',
     $SSR*1.0D+6*sqrt(abs(ass_fac))
          WRITE(i,*) ' 1*y p-pol symmetrical [microrad] ',
     $SPR*1.0D+6*sqrt(abs(ass_fac))
          WRITE(i,*) ' 1*y s-pol inc-beam [microrad] ',
     $SSR*1.0D+6
          WRITE(i,*) ' 1*y p-pol inc-beam [microrad] ',
     $SPR*1.0D+6
          WRITE(i,*) ' 1*y s-pol ref-beam [microrad] ',
     $SSR*1.0D+6*abs(ass_fac)
          WRITE(i,*) ' 1*y p-pol ref-beam [microrad] ',
     $SPR*1.0D+6*abs(ass_fac)

	  if (f_bragg_a.eq.0) then

           WRITE(i,*) 'width of asymmetric Rock Curve  s-pol  =  ',
     $              2.0D0*SSR*1.0D+6,' microradians'
           WRITE(i,*) '                                =  ',
     $              2.0D0*SSR*TODEG*3600D0,' arc sec'
           WRITE(i,*) 'width of asymmetric Rock Curve  p-pol  =  ',
     $              2.0D0*SPR*1.0D+6,' microradians'
           WRITE(i,*) '                                =  ',
     $              2.0D0*SPR*TODEG*3600D0,' arc sec'
	  else
           WRITE(i,*)
     $'The width of the Rock Curve as a function of incident angle is'
           WRITE(i,*)  'width for s-pol  = ',
     $         2.0D0*SSR*1.0D+6/sqrt(abs(ass_fac)),' microradians'
           WRITE(i,*)  '                     =  ',
     $         2.0D0*SSR/sqrt(abs(ass_fac))*TODEG*3600D0,' arc sec'
           WRITE(i,*)  'width for p-pol  = ',
     $         2.0D0*SPR*1.0D+6/sqrt(abs(ass_fac)),' microradians'
           WRITE(i,*)  '                     =  ',
     $         2.0D0*SPR/sqrt(abs(ass_fac))*TODEG*3600D0,' arc sec'
           WRITE(i,*)  'Incident Grazing Angle = ',
     $                (a_bragg+graze)*todeg,' deg'
           WRITE(i,*)  'Incident Corrected Angle = ',
     $                (theta_b)*todeg,' deg'
           WRITE(i,*)   ' '
           WRITE(i,*)   
     $'The width of the Rock Curve as a function of reflected angle is'
           WRITE(i,*)  'width for s-pol  = ',
     $        2.0D0*SSR*1.0D+6*sqrt(abs(ass_fac)),' microradians'
           WRITE(i,*)  '                     = ',
     $         2.0D0*SSR*sqrt(abs(ass_fac))*TODEG*3600D0,' arc sec'
           WRITE(i,*)  'width for p-pol  = ',
     $         2.0D0*SPR*1.0D+6*sqrt(abs(ass_fac)),' microradians'
           WRITE(i,*)  '                     = ',
     $         2.0D0*SPR*sqrt(abs(ass_fac))*TODEG*3600D0,' arc sec'
           WRITE(i,*)  'Reflected Grazing Angle = ',
     $                (graze-a_bragg)*todeg,' deg'
           WRITE(i,*)  'Reflected Corrected Angle = ',
     $                (theta_b_h)*todeg,' deg'
	  endif
	END DO
	i = 23 ! only to file
	if (f_mosaic.EQ.1) then
	  write (i,*) '  '
	  write (i,*) '***********  MOSAIC PARAMETERS  ***************'
	  write (i,*) '  '
	  write (i,*) 'spread_mos= ',2.35*spread_mos/TORAD ,' deg fwhm'
	  write (i,*) 'true absorp depth = ',sin(graze)/absorp*1d4,
     $		' microns'
	  write (i,*) 'true absorp length = ',1d4/absorp,' microns'
	  write (i,*) 'peak thickness = ',tmax_mos,' cm'
	  write (i,*) ' '
	  write (i,*) 'For parallel polarization we have: '
	  write (i,*) '   Q      = ',q_mos,' cm^-1 '
C	  write (i,*) '   Peak reflectivity = ',r_s
	  write (i,*) '   Primary extinction:'
	  write (i,*) '      mu =',sin(graze)/texts,'cm^-1'
	  write (i,*) '      length =',texts/sin(graze)*1d4,'microns'
	  write (i,*) '      depth =',texts*1d4,'microns'
	  write (i,*) '   Secondary extinction:'
	  write (i,*) '      mu =',sigma_gamma,'cm^-1'
	  write (i,*) '      length =',1d4/sigma_gamma,' microns'
	  write (i,*) '      depth =',sin(graze)/sigma_gamma*1d4,
     $			' microns'

	  write (i,*) ' '
	  write (i,*) 'For perpendicular polarization we have: '
	  write (i,*) '   Q     = ',q_mos*kpolsqrt,' cm^-1 '
C	  write (i,*) '   Peak reflectivity = ',r_p
	  write (i,*) '   Primary extinction:'
	  write (i,*) '      mu =',sin(graze)/textp,'cm^-1'
	  write (i,*) '      length =',textp/sin(graze)*1d4,'microns'
	  write (i,*) '      depth =',textp*1d4,'microns'
	  write (i,*) '   Secondary extinction:'
	  write (i,*) '      mu =',sigma_gamma*kpolsqrt,'cm^-1'
	  write (i,*) '      length =',1d4/sigma_gamma/kpolsqrt,
     $       ' microns'
	  write (i,*) '      depth ='
     $         ,sin(graze)/sigma_gamma/kpolsqrt*1d4,' microns'
	  write (i,*) '  '
	endif

	end
C

C+++
C	SUBROUTINE	CRYSTAL_SET
C
C	PURPOSE		C
C
C	ALGORITHM	Reference B.E.Warren, X-Ray Diffraction, 
C
C	MODIFIED	M. Sanchez del Rio
C
C---

     	SUBROUTINE CRYSTAL_SET	 (Q_PHOT, 
     $F_MOSAIC,D_SPACING,F_REFRAC,A_BRAGG,RN,THICKNESS,SPREAD_MOS,
C     $PSI_H,PSI_HBAR,PSI_0,STRUCT,ABSORP,FH,
     $THETA_B,THETA_B_H,THETA_B_SYM,L_EXT_S,L_EXT_P,SSR,SPR,ASS_FAC)

	implicit none
                                       

CCC
        real*8  pi,pihalf,twopi,todeg,torad,tocm,toangs
        DATA    PI      /  3.1415 92653 58979 32384 62643 D0 /
        DATA    PIHALF  /  1.5707 96326 79489 66192 31322 D0 /
        DATA    TWOPI   /  6.2831 85307 17958 64679 25287 D0 /
        DATA    TODEG   / 57.2957 79513 08232 08767 98155 D0 /
        DATA    TORAD   /  0.0174 53292 51994 32957 69237 D0 /
C        DATA    TOCM    /  1.239 852    D-4                  /
C        DATA    TOANGS  /  1.239 852    D+4                  /
        DATA    TOCM    /  1.2398 4187572794035    D-4        /
        DATA    TOANGS  /  1.2398 4187572794035    D+4        /
C        DATA    E2_MC2  /  2.817939 D-13                     / ! e^2/mc^2
C                                                               !classical e-
C                                                               !radius in cm
C        DATA    AVOG    /  6.022098 D+23                     /


        integer*4	i_debug
	real*8		Q_PHOT                              !Arguments
	real*8		L_EXT_S, L_EXT_P
	real*8		DELTA_REF, THETA_B

        character*80    file_refl                           !as in common.blk
        integer*4       f_mosaic,f_refrac
        real*8          spread_mos,thickness,a_bragg
        real*8          d_spacing


	real*8		rn,rn1,d_spacing1

	real*8		phot,r_lam0
	complex*16	F_0,FH,FH_BAR,STRUCT,REFRAC

	real*8		graze,sin_gra,theta_o,theta_h,ass_fac
	real*8		absorp    !,theta_inc_o
	complex*16	ssvar,spvar
	real*8		ssr,spr, gammaf, ppol
	real*8		tmp

	complex*16	psi_h,psi_hbar,psi_0

	real*8		theta_b_sym,theta_b_h

C
C Computes reflectivities at given wavelength and angle.
C
	i_debug = 0
	PHOT	= Q_PHOT/TWOPI*TOCM
	R_LAM0 	= TWOPI/Q_PHOT
	SIN_GRA = R_LAM0/d_spacing/2.0D0
	GRAZE = ASIN(SIN_GRA)

	if (i_debug.EQ.1) write (*,*) 
     $'<><>CRYSTAL_SET working at energy: ',phot
C
C call crystal_fh to get the structure factor
C
	RN1 = -1
	D_SPACING1 = -1.
	call crystal_fh (1, FILE_REFL, PHOT, GRAZE
     $,FH,FH_BAR,F_0,PSI_H,PSI_HBAR,PSI_0,REFRAC
     $,RN1,D_SPACING1)
	if (i_debug.EQ.1) write (*,*) 
     $'<><>CRYSTAL_SET back crystal_fh, d_spacing: ',d_spacing
	if (i_debug.EQ.1) write (*,*) 
     $'<><>CRYSTAL_SET back crystal_fh, rn: ',rn

	STRUCT 	= sqrt(FH * FH_BAR) 
	if (i_debug.EQ.1) write (*,*) '<><>CRYSTAL_SET FH = ',FH
	if (i_debug.EQ.1) write (*,*) '<><>CRYSTAL_SET f_0 = ',f_0
	if (i_debug.EQ.1) write (*,*) '<><>CRYSTAL_SET FH_BAR = ',
     $FH_BAR
	if (i_debug.EQ.1) write (*,*) '<><>CRYSTAL_SET STRUCT = ',
     $STRUCT
	if (i_debug.EQ.1) write (*,*) '<><>CRYSTAL_SET PSI_H = ',
     $PSI_H
	if (i_debug.EQ.1) write(*,*) '<><>CRYSTAL_SET PSI_HBAR = ',
     $PSI_HBAR
	if (i_debug.EQ.1) write (*,*) '<><>CRYSTAL_SET PSI_0 = ',
     $PSI_0

#if lahey
	DELTA_REF  = 1.0D0 - REAL(REFRAC,8)
	ABSORP	= 2.0d0 * TWOPI *(-AIMAG(REFRAC)) / R_LAM0
#else
	DELTA_REF  = 1.0D0 - DREAL(REFRAC)
	ABSORP	= 2.0d0 * TWOPI *(-IMAG(REFRAC)) / R_LAM0
#endif
C
C Calculates the reflection angles and other useful parameters
C


	if (i_debug.EQ.1) write (*,*) 
     $'<><>CRYSTAL_SET A_BRAGG : ',todeg*a_bragg
C
C Asymmetry factor B
C
        if (f_refrac.eq.0) then                !bragg diffracted
           THETA_O      = GRAZE + A_BRAGG
           THETA_H      = GRAZE - A_BRAGG
        else if (f_refrac.eq.1) then           !laue diffracted
           theta_o      = abs( - graze + a_bragg )
           theta_h      = abs(   graze + a_bragg )
        else if (f_refrac.eq.2) then           !bragg transmitted
           theta_o      = GRAZE + A_BRAGG
           theta_h      = GRAZE - A_BRAGG
        else if (f_refrac.eq.3) then           !laue transmitted
           theta_o      = abs( - graze + a_bragg )
           theta_h      = abs(   graze + a_bragg )
        endif

	if (i_debug.EQ.1) write (*,*) 
     $'<><>CRYSTAL_SET Uncorrected Bragg angle : ',todeg*theta_o

	ASS_FAC = ABS( sin(theta_o)/sin(theta_h) )
        if ((f_refrac.eq.0).or.(f_refrac.eq.3)) ass_fac = -1.0d0*ass_fac

	if (i_debug.EQ.1) write (*,*) 
     $'<><>CRYSTAL_SET Asymmetry factor is: ',ASS_FAC

C
C THETA_B is the Bragg angle corrected for refraction for sym case,
C following Warren
C
C	THETA_B_SYM = R_LAM0/(1-(DELTA_REF/SIN_GRA**2))/2.0D0/D_SPACING
C	THETA_B_SYM = ASIN(THETA_B_SYM)
C	write (*,*) ' '
C	write (*,*) 'THETA_B_SYM(old) : ',THETA_B_SYM
C Changed to Zachariasen expression ([3.181] when y=0 and b=-1)
#if lahey
	THETA_B_SYM = (real(PSI_0,8)/2/sin_gra)+sin_gra
#else
	THETA_B_SYM = (Dreal(PSI_0)/2/sin_gra)+sin_gra
#endif
	THETA_B_SYM = ASIN(THETA_B_SYM)
C	write (*,*) 'THETA_B_SYM(new) : ',THETA_B_SYM
C
C	delta_theta_s = THETA_B_SYM-GRAZE
C        delta_theta_o = 0.5D0*(1.0D0-1.0D0/ASS_FAC)*delta_theta_s
C        delta_theta_h = 0.5D0*(1.0D0-ASS_FAC)*delta_theta_s
C	if (i_debug.EQ.1) then 
C	  write (*,*) '<><>CRYSTAL_SET THETA_B_SYM: ',THETA_B_SYM
C	  write (*,*) '<><>CRYSTAL_SET DELTA_REF: ',DELTA_REF
C	  write (*,*) '<><>CRYSTAL_SET SIN_GRA: ',SIN_GRA
C	  write (*,*) '<><>CRYSTAL_SET D_SPACING: ',D_SPACING
C	endif
C
c	write(*,*) 'theta_b_sim = ',theta_b*todeg
c	write(*,*) 'delta_theta_s = ',delta_theta_s*todeg
c	write(*,*) 'delta_theta_o = ',delta_theta_o*todeg
c	write(*,*) 'delta_theta_h = ',delta_theta_h*todeg
C	if ((f_refrac.eq.0).or.(f_refrac.eq.2)) then
C	  if (f_bragg_a.eq.1) then
C            THETA_B = GRAZE + A_BRAGG + delta_theta_o
C            THETA_B_H = GRAZE - A_BRAGG + delta_theta_h
C	  else
C	    THETA_B = THETA_B_SYM
C	  endif
C	else if ((f_refrac.eq.1).or.(f_refrac.eq.3)) then
c
c please check the minus sign !!!!!!
c
C	  THETA_B = GRAZE + A_BRAGG -  delta_theta_o
C          THETA_B_H =  GRAZE - A_BRAGG - delta_theta_h
C	endif
C
C	write (*,*) 'THETA_B(old): ',THETA_B
C	write (*,*) 'THETA_B_H(old): ',THETA_B_H
C Changed to Zachariasen expression ([3.181] when y=0)
#if lahey
	THETA_B = (ass_fac-1)/ass_fac*(real(PSI_0,8)/4/sin_gra)+sin_gra
	THETA_B = ASIN(THETA_B) + A_BRAGG
	THETA_B_H = (1-ass_fac)*(real(PSI_0,8)/4/sin_gra)+sin_gra
#else
	THETA_B = (ass_fac-1)/ass_fac*(Dreal(PSI_0)/4/sin_gra)+sin_gra
	THETA_B = ASIN(THETA_B) + A_BRAGG
	THETA_B_H = (1-ass_fac)*(Dreal(PSI_0)/4/sin_gra)+sin_gra
#endif
	THETA_B_H = ASIN(THETA_B_H) - A_BRAGG
C	write (*,*) 'THETA_B(new): ',THETA_B
C	write (*,*) 'THETA_B_H(new): ',THETA_B_H
C	write (*,*) ' '



	if (i_debug.EQ.1) then 
	  write (*,*)
     $'<><>CRYSTAL_SET Corrected Bragg angle : ',todeg*THETA_B
	  write (*,*) '<><>CRYSTAL_SET GRAZE: ',GRAZE
	  write (*,*) '<><>CRYSTAL_SET A_BRAGG: ',A_BRAGG
C	  write (*,*) '<><>CRYSTAL_SET delta_theta_o: ',delta_theta_o
	endif


C
C S%VAR is the variable "s" of Warren.
C S%VAR is the angular width corresponding a y=1 in the Zachariasen notation.
C This value corresponds to the half-width of the Bragg symmetrical 
C reflection in the case of no absorption. 
C This value corresponds to y=1 (y is the Zachariasen variable defined
C in [3.181] under the assumptions [3.180] and [3.116].
C
	gammaf   = RN*(R_LAM0**2)/PI
	PPOL    = ABS(COS(2.0D0*GRAZE))
	L_EXT_S = R_LAM0*cos(theta_b)/gammaf/abs(fh)
	L_EXT_P = L_EXT_S/PPOL
C
C width of Bragg reflection
C
C Warren formalism: SSR is the half-width
C        SSVAR   = RN*(R_LAM0**2)*STRUCT/PI/SIN(2.0D0*GRAZE)
	SSVAR   = gammaf*STRUCT/SIN(2.0D0*GRAZE)
        SPVAR   = SSVAR*PPOL
#if lahey
        SSR     = REAL(SSVAR,8)
        SPR     = REAL(SPVAR,8)
#else
        SSR     = DREAL(SSVAR)
        SPR     = DREAL(SPVAR)
#endif


C Zachariasen formalism: SSR is the half-width
C angular value corresponding to y=1
	SSR = sin_gra- (d_spacing/r_lam0/ass_fac/2) *
     $( 2*sqrt(abs(ass_fac)*abs(psi_h*psi_hbar)) +
#if lahey
     $(ass_fac-1)*real(PSI_0,8) )
#else
     $(ass_fac-1)*Dreal(PSI_0) )
#endif
	SSR = ASIN(SSR)


C angular value corresponding to y=-1
	tmp = sin_gra- (d_spacing/r_lam0/ass_fac/2) *
     $( -2*sqrt(abs(ass_fac)*abs(psi_h*psi_hbar)) +
#if lahey
     $(ass_fac-1)*real(PSI_0,8) )
#else
     $(ass_fac-1)*Dreal(PSI_0) )
#endif
	TMP = ASIN(TMP)
C width (2y)
	SSR = (SSR - TMP)/2.0D0
	if (i_debug.eq.1) then
	  write (*,*) ' '
	  write (*,*) '<><>CRYSTAL_SET THETA_B: ',THETA_B
	  write (*,*) 'SSR(new): ',SSR
	end if
C p-pol
C Zachariasen formalism: SSR is the half-width
C angular value corresponding to y=1
        SPR = sin_gra- (d_spacing/r_lam0/ass_fac/2) *
     $( 2*ppol*sqrt(abs(ass_fac)*abs(psi_h*psi_hbar)) +
#if lahey
     $(ass_fac-1)*real(PSI_0,8) )
#else
     $(ass_fac-1)*Dreal(PSI_0) )
#endif
        SPR = ASIN(SPR)
C        write (*,*) 'SPR1(new): ',SPR
C angular value corresponding to y=-1
        tmp = sin_gra- (d_spacing/r_lam0/ass_fac/2) *
     $( -2*ppol*sqrt(abs(ass_fac)*abs(psi_h*psi_hbar)) +
#if lahey
     $(ass_fac-1)*real(PSI_0,8) )
#else
     $(ass_fac-1)*Dreal(PSI_0) )
#endif
        TMP = ASIN(TMP)
C width (2y)
        SPR = (SPR - TMP)/2.0D0
	if (i_debug.eq.1) then
	  write (*,*) ' '
	  write (*,*) '<><>CRYSTAL_SET THETA_B: ',THETA_B
	  write (*,*) '<><>CRYSTAL_SET SSR: ',SSR
	  write (*,*) '<><>CRYSTAL_SET SPR: ',SPR
	end if

	end
C
c
c#if unix
c#include  "./../../include/header.txt"
c#elif vms
c     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
c#endif
c
C
C
C+++
C	SUBROUTINE	CRYSTAL_PERFECT
C
C	PURPOSE		Computes the reflectivity of a perfect crystal 
C			according to the dynamic theory of x-ray diffraction.
C
C	ALGORITHM	Reference 
C			W. H. Zachariasen
C			"Theory of X-Ray diffraction in crystals"
C			Dover, New York, 1967.
C
C       MODIFIED        M. Sanchez del Rio, Feb 1996. This routine was
C			a part of crystal.F, and now is independent.
C
C---
     	SUBROUTINE	CRYSTAL_PERFECT	 (
     $Q_PHOT, VIN, VOUT, 				! inputs (ray)
     $BH, SURFNOR, D_SPACING, THICKNESS, F_REFRAC, 	! inputs (crystal)
     $PSI_0,PSI_H,PSI_HBAR,				! inputs (struct fact)
     $R_S, R_P,PHASE_S, PHASE_P)			! output (reflectivity)
C
C INPUT PARAMETERS:
C   Q_PHOT: Photon wavelength
C   VIN:     Photon incident direction
C   VOUT:    Photon outcoming direction
C   BH:		Bragg planes normal
C   SURFNOR:	Crystal surface normal
C   D_SPACING:	crystal d-spacing
C   THICKNESS:	crystal thickness
C   F_REFRAC:	Mode flag: 0:BraggDiff, 1:LaueDiff, 2:BraggTrans, 3:LaueTrans
C   PSI_0:	|
C   PSI_H:	| Electrical susceptibility (proportional to structure factor)
C   PSI_HBAR:	|
C
C OUTPUT PARAMETERS:
C   R_S:	Sigma reflectivity
C   R_P:	Pi reflectivity
C   PHASE_S:	Sigma phase shift
C   PHASE_P:	Pi phase shift
C
C
	implicit none
        real*8         OEXP		!exponential overflow limit
        parameter      (OEXP=100.0D0)

CCC
        real*8  pi,pihalf,twopi,todeg,torad,tocm,toangs
        DATA    PI      /  3.1415 92653 58979 32384 62643 D0 /
        DATA    PIHALF  /  1.5707 96326 79489 66192 31322 D0 /
        DATA    TWOPI   /  6.2831 85307 17958 64679 25287 D0 /
        DATA    TODEG   / 57.2957 79513 08232 08767 98155 D0 /
        DATA    TORAD   /  0.0174 53292 51994 32957 69237 D0 /
C        DATA    TOCM    /  1.239 852    D-4                  /
C        DATA    TOANGS  /  1.239 852    D+4                  /
        DATA    TOCM    /  1.2398 4187572794035    D-4        /
        DATA    TOANGS  /  1.2398 4187572794035    D+4        /


        integer*4	i_debug
	real*8		Q_PHOT                              !Arguments
	real*8		VIN(3), VOUT(3), BH(3), SURFNOR(3)
	real*8		R_S, R_P,PHASE_S, PHASE_P

        integer*4       f_refrac
        real*8          thickness    !,a_bragg
        real*8          d_spacing


	real*8		r_lam0,phot
	complex*16	ci

	real*8		graze,sin_gra

	real*8		vtemp(3),sin_brg,alpha_zac,mod2_bh
	real*8		vtemp2(3),tmp
	real*8		sin_q_ang,sin_q_ref,gamma_0,gamma_h
	real*8		cry_b,cry_t,cry_a,cry_alpha
	complex*16	psi_h,psi_hbar,psi_0
	complex*16	cry_q,cry_z,ctemp,br_x1,br_x2
	complex*16	br_delta1,br_delta2,br_c1,br_c2
	complex*16	rcs,rcp
	real*8		c_ppol,pp,qq
c	real*8		oexp            ! exponential overflow limit


C
	i_debug = 0
	if (i_debug.EQ.1) write (*,*) 
     $'<><>CRYSTAL_PERFECT: ******** crystal_perfect called ********'
	CI	= (0.0D0,1.0D0)

	PHOT	= Q_PHOT/TWOPI*TOCM
	R_LAM0 	= TWOPI/Q_PHOT
	SIN_GRA = R_LAM0/d_spacing/2.0D0
	GRAZE = ASIN(SIN_GRA)

	if (i_debug.EQ.1) write (*,*) 
     $'<><>CRYSTAL_PERFECT: working at energy: ',phot
	if (i_debug.EQ.1) write (*,*) 
     $'<><>CRYSTAL_PERFECT: d_spacing: ',d_spacing

	if (i_debug.EQ.1) write (*,*) '<><>CRYSTAL_PERFECT: PSI_H = ',
     $		PSI_H
	if (i_debug.EQ.1) write(*,*) '<><>CRYSTAL_PERFECT: PSI_HBAR = ',
     $		PSI_HBAR
	if (i_debug.EQ.1) write (*,*) '<><>CRYSTAL_PERFECT: PSI_0 = ',
     $		PSI_0


C	DELTA_REF  = 1.0D0 - DREAL(REFRAC)
C	ABSORP	= 2.0d0 * TWOPI *(-DIMAG(REFRAC)) / R_LAM0

	call norm (bh,vtemp)
	call dot (vin,vtemp,sin_brg)	
	call dot (vin,surfnor,sin_q_ang)
	call dot (vout,surfnor,sin_q_ref)
	gamma_0 = sin_q_ang        ! sign changed
c	write(*,*) '<<>> gamma_0: ',gamma_0

C
C >>>>>>>>>>>>>>>>>>>> Perfect crystal calculation <<<<<<<<<<<<<<<<<<<
C
C Main calculation (symmetrical case and asym incident case)
C I change to reflectivity formulae of Zachariasen,
C for a definition of ETA taking into account the angle with
C Bragg planes. MSR 6/28/90
C
	ALPHA_ZAC =-((R_LAM0/D_SPACING)**2+2*R_LAM0*
     $SIN_BRG/D_SPACING)
	if (i_debug.EQ.1) 
     $write (*,*) '<><>CRYSTAL_PERFECT: !!!!! sin_brg: ',sin_brg
	if (i_debug.EQ.1) write (*,*) 
     $'<><>CRYSTAL_PERFECT: !!!!! alpha_zac_old: ',alpha_zac

	call dot (bh,bh,mod2_bh)
	call dot (vin,bh,alpha_zac)
	alpha_zac = -1D0*(1D0/q_phot)**2 * (mod2_bh -2*q_phot*alpha_zac)
	if (i_debug.EQ.1) write (*,*) 
     $'<><>CRYSTAL_PERFECT: !!!!! alpha_zac: ',alpha_zac

*
* Transmission (Laue) case and general Reflection (Bragg) case
* NB: The general Bragg case is commented (cc). It is not yet being
* used. We still use the Thick Crystal Approximation case.
*
C
C   This part has been written by G.J. Chen and M. Sanchez del Rio. 
C   We use the formula [3.130] of Zachariasen's book.
C
	gamma_h = -1.0*sin_q_ref
c
	if ((f_refrac.eq.0).or.(f_refrac.eq.2)) gamma_h = - gamma_h
c	write(*,*) '<<>> gamma_h: ',gamma_h
C
C changed b factor to its vectorial value (Zachariasen, [3.115])
C
	cry_b = gamma_0/gamma_h
c	write(*,*) '<<>> b: ',cry_b
	if (i_debug.EQ.1) then
	  write (*,*) 'CRYSTAL_PERFECT: b(approx)= ',cry_b
	end if
c numerator
	call dot (surfnor,vin,cry_b)
	cry_b = cry_b*q_phot
c denominator
	call scalar(vin,q_phot,vtemp)
	call sum (vtemp,bh,vtemp2)
	call dot (surfnor,vtemp2,tmp)
c ratio
	cry_b = cry_b / tmp
	if (i_debug.EQ.1) then
	  write (*,*) 'CRYSTAL_PERFECT: b(exact)= ',cry_b
	end if


	cry_t = 0.5*(1./abs(gamma_0) +1./abs(gamma_h))*thickness 
	cry_a = pi/r_lam0*(thickness/gamma_0)
	cry_alpha = -((r_lam0/d_spacing)**2+2*r_lam0*
     $sin_brg/d_spacing)
c

	cry_q = cry_b*psi_h*psi_hbar
	cry_z = (1.-cry_b)*0.5*psi_0 + cry_b*0.5*cry_alpha
	if (i_debug.EQ.1) then
	  write(*,*) '<><>CRYSTAL_PERFECT: cry_b: ',cry_b
	  write(*,*) '<><>CRYSTAL_PERFECT: psi_0: ',psi_0
	  write(*,*) '<><>CRYSTAL_PERFECT: cry_alpha: ',cry_alpha
	  write(*,*) '<><>CRYSTAL_PERFECT: cry_z: ',cry_z
	endif


c
c s-polarization
c
	ctemp = sqrt(cry_q  + cry_z**2)
	br_x1 = (-1.0d0*cry_z+ctemp)/psi_hbar
	br_x2 = (-1.0d0*cry_z-ctemp)/psi_hbar
	br_delta1 = 0.5d0*(psi_0-cry_z+ctemp)
	br_delta2 = 0.5d0*(psi_0-cry_z-ctemp)
	br_c1 = -1.d0*ci*thickness*twopi/(-1.*abs(gamma_0))/
     $		r_lam0*br_delta1
	br_c2 = -1.d0*ci*thickness*twopi/(-1.*abs(gamma_0))/
     $		r_lam0*br_delta2
	if (i_debug.EQ.1) then
	  write(*,*) '<><>CRYSTAL_PERFECT: ctemp: ',ctemp
	endif
c
c a very big exponential produces numerical overflow. If so, the value
c is changed artificially to avoid the overflow. This is equivalent to 
c use the thick crystal approximation
c
c	oexp = 100.d0
#if lahey
	if (real(br_c1,8).gt.oexp.or.real(br_c2,8).gt.oexp) then
	  if (i_debug.EQ.1) write(*,*) 
     $'CRYSTAL: exponential overflow. Corrected.'
	  if (real(br_c1,8).gt.oexp) br_c1 = oexp+ci*aimag(br_c1)
	  if (real(br_c2,8).gt.oexp) br_c2 = oexp+ci*aimag(br_c2)
#else
	if (Dreal(br_c1).gt.oexp.or.Dreal(br_c2).gt.oexp) then
	  if (i_debug.EQ.1) write(*,*) 
     $'CRYSTAL: exponential overflow. Corrected.'
	  if (Dreal(br_c1).gt.oexp) br_c1 = oexp+ci*imag(br_c1)
	  if (Dreal(br_c2).gt.oexp) br_c2 = oexp+ci*imag(br_c2)
#endif
	endif
c
	br_c1 = exp(br_c1)
	br_c2 = exp(br_c2)
c
	if (f_refrac.eq.0) then
	  rcs = br_x1*br_x2*(br_c1-br_c2)/(br_c2*br_x2-br_c1*br_x1) ! bragg D
	else if (f_refrac.eq.1) then 
	  rcs = br_x1*br_x2*(br_c1-br_c2)/(br_x2-br_x1)             ! laue D
	else if (f_refrac.eq.2) then 
	  rcs = br_c1*br_c2*(br_x1-br_x2)/(br_c2*br_x2-br_c1*br_x1) ! bragg T
	else if (f_refrac.eq.3) then 
	  rcs = (br_x2*br_c1-br_x1-br_c2)/(br_x2-br_x1)             ! laue T
	endif
	if (i_debug.EQ.1) then
	  write(*,*) '<><>CRYSTAL_PERFECT: br_c1: ',br_c1
	  write(*,*) '<><>CRYSTAL_PERFECT: br_c2: ',br_c2
	  write(*,*) '<><>CRYSTAL_PERFECT: br_x1: ',br_x1
	  write(*,*) '<><>CRYSTAL_PERFECT: br_x2: ',br_x2
	endif

c	r_s = (1.0d0/abs(cry_b))*rcs*dconjg(rcs)
c	r_s1 = sqrt((1.0d0/abs(cry_b))*rcs*dconjg(rcs))
c	rcs = rcs/dsqrt(abs(cry_b))
c
c p-polarization
c
	c_ppol = abs(cos(2.0d0*graze))

	ctemp = sqrt(cry_q*c_ppol**2  + cry_z**2)
	br_x1 = (-1.0d0*cry_z+ctemp)/(psi_hbar*c_ppol)
	br_x2 = (-1.0d0*cry_z-ctemp)/(psi_hbar*c_ppol)
	br_delta1 = 0.5d0*(psi_0-cry_z+ctemp)
	br_delta2 = 0.5d0*(psi_0-cry_z-ctemp)
	br_c1 = -1.0d0*ci*thickness*twopi/(-1.0*abs(gamma_0))/
     $		r_lam0*br_delta1
	br_c2 = -1.0d0*ci*thickness*twopi/(-1.0*abs(gamma_0))/
     $		r_lam0*br_delta2
c
c a very big exponential produces numerical overflow. If so the value
c is changed to avoid the overflow. This is equivalent to the thick
c crystal approximation
c
#if lahey
	if (real(br_c1,8).gt.oexp.or.real(br_c2,8).gt.oexp) then
	  if (i_debug.EQ.1) write(*,*) 
     $'CRYSTAL: exponential overflow. Corrected.'
	  if (real(br_c1,8).gt.oexp) br_c1 = oexp+ci*aimag(br_c1)
	  if (real(br_c2,8).gt.oexp) br_c2 = oexp+ci*aimag(br_c2)
#else
	if (Dreal(br_c1).gt.oexp.or.Dreal(br_c2).gt.oexp) then
	  if (i_debug.EQ.1) write(*,*) 
     $'CRYSTAL: exponential overflow. Corrected.'
	  if (Dreal(br_c1).gt.oexp) br_c1 = oexp+ci*imag(br_c1)
	  if (Dreal(br_c2).gt.oexp) br_c2 = oexp+ci*imag(br_c2)
#endif
	endif
c
	br_c1 = exp(br_c1)
	br_c2 = exp(br_c2)

c	if (f_refrac.eq.1) then
c	  rcp = br_x1*br_x2*(br_c1-br_c2)/(br_x2-br_x1)             ! laue
c	else if (f_refrac.eq.0) then
c	  rcp = br_x1*br_x2*(br_c1-br_c2)/(br_c2*br_x2-br_c1*br_x1) ! bragg
c	endif

	if (f_refrac.eq.0) then
	  rcp = br_x1*br_x2*(br_c1-br_c2)/(br_c2*br_x2-br_c1*br_x1) ! bragg D
	else if (f_refrac.eq.1) then 
	  rcp = br_x1*br_x2*(br_c1-br_c2)/(br_x2-br_x1)             ! laue D
	else if (f_refrac.eq.2) then 
	  rcp = br_c1*br_c2*(br_x1-br_x2)/(br_c2*br_x2-br_c1*br_x1) ! bragg T
	else if (f_refrac.eq.3) then 
	  rcp = (br_x2*br_c1-br_x1-br_c2)/(br_x2-br_x1)             ! laue T
	endif
	
	rcs = (1.0d0/sqrt(abs(cry_b)))*rcs
	rcp = (1.0d0/sqrt(abs(cry_b)))*rcp
	if (i_debug.EQ.1) then
	  write(*,*) '<><>CRYSTAL_PERFECT: rcs: ',rcs
	  write(*,*) '<><>CRYSTAL_PERFECT: rcp: ',rcp
	endif

c please check
c	  IF (GRAZE.GT.45*TORAD) 	RCP = -RCP

	R_S	= ABS(RCS)
#if lahey
	PP	= REAL(RCS,8)
	QQ	= AIMAG(RCS)
#else
	PP	= DREAL(RCS)
	QQ	= IMAG(RCS)
#endif
	CALL	ATAN_2	(QQ,PP,PHASE_S)
	R_P	= ABS(RCP)
#if lahey
	PP	= REAL(RCP,8)
	QQ	= AIMAG(RCP)
#else
	PP	= DREAL(RCP)
	QQ	= IMAG(RCP)
#endif
	CALL	ATAN_2	(QQ,PP,PHASE_P)

1122   	RETURN
     	END
c
c#if unix
c#include  "./../../include/header.txt"
c#elif vms
c     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
c#endif
c
C
C
C+++
C	SUBROUTINE	CRYSTAL_MOSAIC
C
C	PURPOSE		Computes the reflectivity of a mosaic crystal 
C			according to the dynamic theory of x-ray diffraction.
C
C	ALGORITHM	Reference 
C			W. H. Zachariasen
C			"Theory of X-Ray diffraction in crystals"
C			Dover, New York, 1967.
C			and
C                       Bacon and Lowde, Acta Crystall. 1 pag 303 (1948) for 17
C
C       MODIFIED        M. Sanchez del Rio, Feb 1996. This routine was
C			a part of crystal.F, and now is independent.
C
C---
     	SUBROUTINE	CRYSTAL_MOSAIC	 (
     $Q_PHOT, VIN, 				! inputs (ray)
     $BH, SURFNOR, D_SPACING, THICKNESS, F_REFRAC,SPREAD_MOS,! inputs (crystal)
     $Q_MOS,REFRAC,				! inputs (struct fact)
     $R_S, R_P,PHASE_S, PHASE_P, L_EXT_S, L_EXT_P)	! output (reflectivity)
C
C INPUT PARAMETERS:
C   Q_PHOT: Photon wavelength
C   VIN:     Photon incident direction
C   BH:		Bragg planes normal
C   SURFNOR:	Crystal surface normal
C   THICKNESS:	crystal thickness
C   F_REFRAC:	Mode flag: 0:BraggDiff, 1:LaueDiff, 2:BraggTrans, 3:LaueTrans
C   PSI_0:	|
C   PSI_H:	| Electrical susceptibility (proportional to structure factor)
C   PSI_HBAR:	|
C
C OUTPUT PARAMETERS:
C   R_S:	Sigma reflectivity
C   R_P:	Pi reflectivity
C   PHASE_S:	Sigma phase shift
C   PHASE_P:	Pi phase shift
C
C

	implicit none
                                       

        real*8  pi,pihalf,twopi,todeg,torad,tocm,toangs
        DATA    PI      /  3.1415 92653 58979 32384 62643 D0 /
        DATA    PIHALF  /  1.5707 96326 79489 66192 31322 D0 /
        DATA    TWOPI   /  6.2831 85307 17958 64679 25287 D0 /
        DATA    TODEG   / 57.2957 79513 08232 08767 98155 D0 /
        DATA    TORAD   /  0.0174 53292 51994 32957 69237 D0 /
C        DATA    TOCM    /  1.239 852    D-4                  /
C        DATA    TOANGS  /  1.239 852    D+4                  /
        DATA    TOCM    /  1.2398 4187572794035    D-4        /
        DATA    TOANGS  /  1.2398 4187572794035    D+4        /


	real*8		Q_PHOT                              !Arguments
	real*8		VIN(3), BH(3), SURFNOR(3)
	real*8		R_S, R_P,PHASE_S, PHASE_P
	real*8		L_EXT_S, L_EXT_P

        integer*4       f_refrac
        real*8          spread_mos,thickness,d_spacing


	real*8		phot,r_lam0

	real*8		graze,sin_gra
	real*8		absorp    
	real*8		q_mos

	real*8		vtemp(3),sin_brg
	real*8		sin_q_ang !,sin_q_ref

	real*8		sigma_gamma,biga_mosaic,ep,omega,kpolsqrt
	real*8		smallas_mosaic,smallap_mosaic,rs_mosaic
        real*8          rp_mosaic
	complex*16	refrac


C
C >>>>>>>>>>>>>>>>>>>> Mosaic crystal calculation <<<<<<<<<<<<<<<<<<<<<<
C
        PHOT    = Q_PHOT/TWOPI*TOCM
        R_LAM0  = TWOPI/Q_PHOT
        SIN_GRA = R_LAM0/d_spacing/2.0D0
        GRAZE = ASIN(SIN_GRA)

#if lahey
	ABSORP  = 2.0d0 * TWOPI *(-AIMAG(REFRAC)) / R_LAM0
#else
	ABSORP  = 2.0d0 * TWOPI *(-IMAG(REFRAC)) / R_LAM0
#endif

	call norm (bh,vtemp)
	call dot (vin,vtemp,sin_brg)	
	call dot (vin,surfnor,sin_q_ang)
C	call dot (vout,surfnor,sin_q_ref)

        EP      = abs(ASIN(SIN_BRG)) - graze ! scalar def

        BIGA_MOSAIC  = -1.0d0*THICKNESS*ABSORP/SIN_Q_ANG


        OMEGA =(DEXP(-EP**2/2.0D0/(SPREAD_MOS)**2))
     $               /SQRT(TWOPI)/SPREAD_MOS
CCC	Q_MOS = pi**2*cdabs(psi_h*psi_hbar)/r_lam0/sin(2*graze)
	SIGMA_GAMMA =  OMEGA*Q_MOS
	KPOLSQRT = (cos(2*graze))**2

        SMALLAS_MOSAIC = SIGMA_GAMMA/absorp
        SMALLAP_MOSAIC = SMALLAS_MOSAIC*KPOLSQRT

c	write (*,*) '>> SMALLAS_MOSAIC: ',SMALLAS_MOSAIC
c	write (*,*) '>> SMALLAP_MOSAIC: ',SMALLAP_MOSAIC
c	write (*,*) ' '
*
* Transmission case
*
	if (f_refrac.eq.1) then
	  rs_mosaic = sinh(smallas_mosaic*biga_mosaic) * 
     $     exp(-biga_mosaic*(1+smallas_mosaic))
	  rp_mosaic = sinh(smallap_mosaic*biga_mosaic) * 
     $     exp(-biga_mosaic*(1+smallap_mosaic))
*
* Reflection case
*
	else  if (f_refrac.eq.0) then
          RS_MOSAIC = 1+SMALLAS_MOSAIC+(SQRT(1+2*SMALLAS_MOSAIC))/
     $		DTANH(bigA_MOSAIC*SQRT(1+2*SMALLAS_MOSAIC))
          RP_MOSAIC = 1+SMALLAP_MOSAIC+(SQRT(1+2*SMALLAP_MOSAIC))/
     $		DTANH(bigA_MOSAIC*SQRT(1+2*SMALLAP_MOSAIC))
          RS_MOSAIC = SMALLAS_MOSAIC / RS_MOSAIC
          RP_MOSAIC = SMALLAP_MOSAIC / RP_MOSAIC
*
* other (not implemented) cases
*
	else
	  write(*,*) 'CRYSTAL_MOSAIC: Error: '
     $		//'Mode (f_refrac) not implemented.'
	  stop
	endif
        R_S     = SQRT(RS_MOSAIC)
        R_P     = SQRT(RP_MOSAIC)
*
* Mean value of depht into the crystal. To be used in MIRROR
*
        L_EXT_S = 1.0D0 /SIGMA_GAMMA
        L_EXT_P = 1.0D0 /SIGMA_GAMMA/KPOLSQRT
*
*No phase change are introduced by now. (The formulae of reflectivity 
*are already intensity, and no complex coefficient are considered).
*This is not important because a mosaic crystal breaks always coherence
*
        PHASE_S = 0.0D0
        PHASE_P = 0.0D0
	RETURN
	END
C
C
C
	SUBROUTINE cryst_za_y(flag,tmp)
C FLAG=1=SET, FLAG=0=RETRIEVE
	REAL*8	TMP,TMPSAVED
	INTEGER FLAG
	SAVE TMPSAVED
	IF (FLAG.EQ.1) THEN
	  TMPSAVED = TMP
c	  write(*,*) '$$$$ in cryst_za_y(saving): ',TMPSAVED
	ELSE IF (FLAG.EQ.0) THEN
	  TMP = TMPSAVED
c	  write(*,*) '$$$$ in cryst_za_y(retrieving): ',TMP
	ENDIF
	END
	
C
C
C
	SUBROUTINE cryst_za_dy(flag,tmp)
C FLAG=1=SET, FLAG=0=RETRIEVE
	REAL*8	TMP,TMPSAVED
	INTEGER FLAG
	SAVE TMPSAVED
	IF (FLAG.EQ.1) THEN
	  TMPSAVED = TMP
c	  write(*,*) '$$$$ in cryst_za_dy(saving): ',TMPSAVED
	ELSE IF (FLAG.EQ.0) THEN
	  TMP = TMPSAVED
c	  write(*,*) '$$$$ in cryst_za_dy(retrieving): ',TMP
	ENDIF
	END
	
