PRO tt_font_manager,get_list=get_list,set_index=set_index,group=group, $
 set_name=set_name, err=err, CharRatio=charRatio, OldChar=oldChar

;+
; NAME:
;	TT_FONT_MANAGER
;
; PURPOSE:
;	This procedures allows manipulation, setting  and info
;	of the TrueType fonts.
;
; CATEGORY:
;	General utilities.
;
; CALLING SEQUENCE:
;
;	TT_Font_Manage
;
; INPUTS:
;	None
;	
; KEYWORD PARAMETERS:
;	Get_List: Set to a named variable to return the list of the 
;		available TrueType fonts (obtained from the file:
;		!dir+'/resources/fonts/ttfont.map')
;	Set_Index: Sets to an integer number indicating the index
;		of the desired font in the list. The current TT font 
;		is "permanently" set to that font.
;	Set_name: string containing the name of the font for setting.
;	Err: set to a named variable to return an error flag
;		(err=0: No error, err=1 Error)
;	CharRatio: set to a float number indicating the ration of the
;		desired fort respect to the current one. The desired
;		font is set.
;	OldChar: set a named variable to return a 2-elements array
;		containing [!d.x_ch_size,!d.y_ch_size]
;	Group: The widget id of the called. Used for centering the 
;		Dialog_Message window in case of error messages.
;	
;		
;
; OUTPUTS:
;
; SIDE EFFECTS:
;	Changes the font device setting
;
; PROCEDURE:
;	Straightforward.
;
; EXAMPLE:
;	tt_font_manager,get_list=flist
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio (srio@esrf.fr) 98-12-20
;
;	
;-
common tt_font_manager, list

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!error_state.msg
   if sdep(/w) then itmp = Dialog_Message(/Error,Dialog_Parent=group,$
	'TT_FONT_MANAGER: error caught: '+!error_state.msg)
   catch, /cancel
   on_error,2
   err=1
   return
endif

err=0
if n_elements(list) EQ 0 then begin
 ds = SDep(/ds)
 file = !dir+ds+'resource'+ds+'fonts'+ds+'tt'+ds+'ttfont.map'

 if checkfile(file) NE 1 then begin
  itmp = Dialog_Message(/Error,Dialog_Parent=group,$
	['File with TrueType fonts not installed:',file])
  err=1
  return
 endif
 txt = read_textfile(file)
 for i=0,n_elements(txt)-1 do begin
   line=txt[i]
   ii_start = strpos(line,'"')
   ii_end = strpos(line,'"',1)
   if ii_start[0] NE -1 then begin
     tmp = strmid(line,ii_start[0]+1,ii_end[0]-ii_start[0]-1)
     if n_elements(list) EQ 0 then list=tmp else list=[list,tmp]
   endif
 endfor
endif

get_list=list
;help,get_list
;print,'>>> ',get_list



if n_elements(set_index) GT 0 then  begin
  IF !p.font NE 1 THEN BEGIN
    Message,/Info,'Executing: !p.font=1'
    !p.font=1
  ENDIF
  fontName= list[set_index]
  Message,/Info,"Executing: Device,Set_Font='"+fontName+"',/TT_Font"
  Device,Set_Font=fontName,/TT_Font
endif

if n_elements(set_name) GT 0 then  begin
  IF !p.font NE 1 THEN BEGIN
    Message,/Info,'Executing: !p.font=1'
    !p.font=1
  ENDIF
  Message,/Info,"Executing: Device,Set_Font='"+set_Name+"',/TT_Font"
  Device,Set_Font=set_Name,/TT_Font
endif

if n_elements(charRatio) GT 0 then  begin
  IF !p.font NE 1 THEN BEGIN
    Message,/Info,'Executing: !p.font=1'
    !p.font=1
  ENDIF
  oldChar=[!d.x_ch_size,!d.y_ch_size]
  Message,/Info,'Executing: Device,Set_Character_Size='+Vect2String(oldChar)+'*'+$
	String(charRatio,Format='(F3.1)')+',/TT_Font'
  Device,Set_Character_Size=oldChar*charRatio,/TT_Font
endif
end

