FUNCTION read_mar,file,scale=scale

;+
; NAME:
;	READ_MAR
; PURPOSE:
;	this function reads a file in the MAR format (used at ESRF/ID18F:
;		header of 4096 bytes plus 2048x2048 pixels of unsigned 
;		integer data)
; CATEGORY:
;
; CALLING SEQUENCE:
;	a=read_mar(input)
; INPUTS:
;	input:  name of the file with data (between quotes). 
;		It automatically handles compresses (gzip) files. They
;		must have the .gz file extension. 
; KEYWORD PARAMETERS:
;
;	SCALE: scaling factor. The read file is transormed using 
;		congrid. 
;
;	
; MODIFICATION HISTORY:
;	by M. Sanchez del Rio. ESRF. Grenoble, March 2003
;	2004-06-10 Documented. Handles compressed files 
;	2004-07-3 srio@esrf.fr problem with swapping bytes fixed.
;	2011-02-25 srio@esrf.eu makes an up/down mirror image to 
;                  agree with the mar application on id18f.
;-	

IF N_Elements(file) EQ 0 THEN file = Dialog_PickFile(filter='*.mccd*')
IF file EQ '' THEN RETURN,0

IF StrLowCase(StrMid(file,StrLen(file)-3,3))  EQ '.gz' THEN  $
	compress=1 ELSE compress=0
openr,unit,file,/get_lun,compress=compress
a=bytarr(4096)
readu,unit,a
b=uintarr(2048,2048)
readu,unit,b
free_lun,unit


LITTLE_ENDIAN = (BYTE (1, 0, 1))[0]
IF LITTLE_ENDIAN EQ 0 THEN BEGIN
  message,/info,'Swapping bytes.'
  b = swap_endian(b)
ENDIF


IF N_Elements(scale) NE 0 THEN b=congrid(b,2048.*scale,2048.*scale)

;
; srio@esrf.eu 2011-02-25 
; up/down mirror image to fit real image
;
b=rotate(temporary(b),7)


RETURN,b
END
