

;+
; NAME:
;	CONIC_COEFFS2PARS
; PURPOSE:
;	this function calculates the conic parameters (center
;		semiaxes and rotation) from the quadric coeffs. 
; CATEGORY:
;	Maths: conics
;
; CALLING SEQUENCE:
;	center=conic_coeffs2pars(c)
; INPUTS:
;	c:  An 6-dim array with the quadric coefficients: 
;           c[0] + c[1] y + c[2] x + c[3] x y + c[4] y^2 + c[5] x^2
; OUTPUTS:
;       center: [Xcenter,Ycenter] with the center of the conic
; OUTPUT KEYWORD PARAMETERS:
;       phi: The rotation angle in rads.
;	axes: [axisMinor,axisMajor]
;	radius: axisMinor (for circles)
;
;	
; MODIFICATION HISTORY:
;	by M. Sanchez del Rio. ESRF. Grenoble, Nov 2007
;-	


FUNCTION conic_coeffs2pars,coeff,phi=phi,axes=axes,radius=radius

; Returns [Xcent,Ycent]. Phi and axes are returnev via keywords

;       ;
;       ; compute ellipse center
;       ; 
       gg = coeff[0]
       ff = coeff[1]/2
       dd = coeff[2]/2
       cc = coeff[4]
       bb = coeff[3]/2
       aa = coeff[5]
deno = bb*bb-aa*cc
Xcent = (cc*dd-bb*ff)/deno
Ycent = (aa*ff-dd*bb)/deno
;print,'<><> X center ',Xcent
;print,'<><> Y center ',Ycent
       IF abs(aa-cc) LE 1D-10 THEN phi=!dpi/4 ELSE $
          phi = 0.5D0*atan(2*bb/(aa-cc))
;print,'<><> Phi [deg] : ',phi*180/!dpi

;
; coeffs in frame where the ellipse is not rotated
; via derivative of ellipse eq.
;

IF coeff[3] EQ 0 THEN BEGIN
  coeffNo = coeff
ENDIF ELSE BEGIN
A1=coeff[5]
B1=coeff[4]
C1=coeff[3]
D1=coeff[2]
F1=coeff[1]
G1=coeff[0]
t = phi
coeffNo = [$
        G1, $
        F1*Cos(t) - D1*Sin(t), $
        D1*Cos(t) + F1*Sin(t), $
        C1*Cos(2*t) + (-A1 + B1)*Sin(2*t), $
        B1*Cos(t)^2 - C1*Cos(t)*Sin(t) + A1*Sin(t)^2, $
        A1*Cos(t)^2 + C1*Cos(t)*Sin(t) + B1*Sin(t)^2]
ENDELSE
coeffNo = -coeffNo/coeffNo[0]
;print,'<><> Phi: ',Phi
;print,'<><> CoeffNo (not rotated):',coeffNo

;
; calculate center and semiaxes via partial derivatives
;
AAA = coeffNo[5]
BBB = coeffNo[4]
DDD = coeffNo[2]
FFF = coeffNo[1]
GGG = coeffNo[0]

sq1 = Sqrt(DDD^2-4*AAA*(GGG-FFF^2/2/BBB+BBB*FFF^2/4/BBB^2))
sq2 = Sqrt(FFF^2-4*BBB*(GGG-DDD^2/2/AAA+AAA*DDD^2/4/AAA^2))
axis2a = (-1D0/2/AAA)*sq1
axis2b = (-1D0/2/BBB)*sq2
;print,'axis major: ',axis2a
;print,'axis minor: ',axis2b

;; center
;xTmp=-DDD/2/AAA
;yTmp=-FFF/2/BBB
;; unrotate this center to original coordinates
;Xcent2 = xTmp*cos(-phi)+yTmp*sin(-phi)
;Ycent2 = -xTmp*sin(-phi)+yTmp*cos(-phi)
;
;print,'Xcent2 : ',Xcent2
;print,'Ycent2 : ',Ycent2

axes = [axis2a,axis2b]
radius = axis2a
RETURN,[Xcent,Ycent]
END


