;
; SORTEX (sort experiment)
; A program to sort-out and visualize simultaneously fluorescence and 
; diffraction data (for ESRF/ID18F, for example)
;
; Still in alpha version. Undocumented. 
;


PRO sortex_thumb,id1=id1,id2=id2,file=file

IF Keyword_Set(id1) THEN BEGIN
               buff = '    '
               xplot_refresh,id1,printbuffer=buff
               buff = ["th=!d.name","set_plot,'ps'",$
                  "device,file='"+file+'.ps'+"'",$
                  'device,/encapsulated,/color,bits=8',buff,$
                  'device,/close','set_plot,th']
               FOR i=0,N_Elements(buff)-1 DO BEGIN
                  itmp = Execute(buff[i])
                  IF itmp NE 1 THEN BEGIN
                    tt = Dialog_Message('Error executing: '+buff[0])
                  ENDIF
               ENDFOR
               print,'SORTEX_THUMB: written file: ',file+'.ps'
ENDIF 
END


;
;
;
FUNCTION sortex_line,lineIn
COMMON sortex, regEx

;
;print,' '
;print,'** LineIn: ',lineIn

;
; forget blanks and comments
;
text1 = StrCompress(lineIn,/Remove_All)
IF text1 EQ '' THEN RETURN,''
IF STrMid(text1,0,1) EQ ';' THEN RETURN,''

; 
nLine = strParse(lineIn,' ',list)

IF nLine EQ 0 THEN BEGIN
   ;print,'** Ret: ',lineIn
   return,''
ENDIF


;
; return the same line for "1"
;
IF Long(list[0]) EQ 1 THEN BEGIN
   tmp = ''
   FOR i=1,nLine DO tmp=tmp+' '+list[i]
   ;print,'** Ret: ',tmp
   return,tmp
ENDIF

nn = Long(list[0])
line = list[1:nLine]
;
; set regEx for "-1" and return ''
;
IF nn EQ -1 THEN BEGIN
  regEx = line
  print,'FILEX_LINE: Set Regular expression to : ',RegEx
  RETURN,''
ENDIF



index_old = Replicate(-1,nLine) 
len = Replicate(-1,nLine) 
pos = Replicate(-1,nLine) 

IF N_Elements(regEx) EQ 0 THEN BEGIN
   itmp = Dialog_Message('Undefined Regular Expression')
   RETURN,LineIn
ENDIF
;
; compute first index
;
FOR i=0,nLine-1 DO BEGIN
    ipos = stregex(line[i], regEx[i], len=ilen)
    itmp = Long(STRMID(line[i], ipos, ilen))
    index_old[i] = itmp
    pos[i] = ipos
    tmp = strmid(regEx[i],strpos(regEx[i],'{')+1, $
                 strpos(regEx[i],'}')-strpos(regEx[i],'{')-1)
    len[i] = long(tmp)
ENDFOR
;  print,'***************** index_old',index_old
;  print,'***************** len',len
;  print,'***************** pos',pos
;;
;
lineOut=StrArr(nn)
FOR i=0L,nn-1 DO BEGIN
  tmpline = ''
  FOR iline=0L,nLine-1 DO BEGIN
    IF pos[iline] EQ -1 THEN BEGIN
       line2=line[iline]
    ENDIF ELSE BEGIN
      index_new = StrCompress(i+index_old[iLine],/Rem)
      nzeroes = len[iLine]-StrLen(index_new)
      tmp = ''
      IF nzeroes[0] GE 1 THEN FOR j=0L,nzeroes[0]-1 DO tmp=tmp+'0'
      index_new=tmp+index_new
;      print,' '
;      print,'***i,iline,index_new',i,iline,' ',index_new
      line2 = StrMid(line[iLine],0,pos[iLine])+index_new+$
         StrMid(line[iLine],pos[iLine]+len[iLine])
    ENDELSE
    tmpline = tmpline+' '+line2
    ;print,i,iLine,line2
  ENDFOR
    lineOut[i]=tmpline
    ;print,'***************** tmpline'+tmpline
ENDFOR
;
;
RETURN,lineOut
END ; sortex_line



;
;========================================================================
;
PRO sortex_event,event

Widget_Control, event.id, get_UValue=UValue
Widget_Control, event.handler, get_UValue=state 
;help,UValue

;help,Tag_Names(event,/Structure_Name)
IF Tag_Names(event,/Structure_Name) EQ 'WIDGET_KILL_REQUEST' THEN BEGIN
  sortex_Quit,event.top
  RETURN
ENDIF


iExecute = 0
iThumb = 0
CASE UValue OF
  'QUIT': sortex_quit,event.top
  'OPENFILE': BEGIN
     file = Dialog_Pickfile(Filter='*.alis',Title='Setect an ALIS file',$
       Dialog_Parent=event.top)
     IF file EQ '' THEN RETURN
     text = read_textfile(file)
     Widget_Control,state.wids.PRList,Set_value=text
     *state.ptrText = text
     state.alisFile = file
     Widget_Control,event.top,Set_UValue=state
     END
  'RELOAD': BEGIN
     IF state.alisFile EQ '' THEN BEGIN
       itmp = Dialog_Message('No file to reload',Dialog_Parent=event.top)
     ENDIF ELSE BEGIN
       print,'Reloading file: ',state.alisFile
       text = read_textfile(state.alisFile)
       Widget_Control,state.wids.PRList,Set_value=text
       *state.ptrText = text
       Widget_Control,state.wids.PRList,Set_List_Top=N_Elements(text)-30
     ENDELSE
     END
  'EDITALIS': BEGIN
     text = *state.ptrText
     XDisplayFIle1,text=text,/modal,action=action
     IF action EQ 'DONT' THEN RETURN
     Widget_Control,state.wids.PRList,Set_value=text
     *state.ptrText=text
     Widget_Control,event.top,Set_UValue=state
     END
  'SAVE': BEGIN
     IF state.alisFile EQ '' THEN BEGIN
       itmp = Dialog_Message('No file defined. Use Save As...',$
              Dialog_Parent=event.top)
     ENDIF ELSE BEGIN
       text = *state.ptrText
       Openw,unit,state.alisFile,/Get_Lun
       FOR i=0L,N_Elements(text)-1 DO printf,unit,text[i]
       Free_Lun,unit
       print,'File written to disk: ',state.alisFile
     ENDELSE
     END

  'SAVEAS': BEGIN
     file = Dialog_Pickfile(Filter='*.alis', $
         Title='Setect ALIS file for writing',Dialog_Parent=event.top)
     IF file EQ '' THEN RETURN
     IF checkfile(file) THEN BEGIN
      itmp = Dialog_Message([ 'File exists: '+file,' ',' ', $
         'Overwrite it? '],/Cancel,Dialog_Parent=event.top)
      IF itmp EQ 'Cancel' THEN RETURN
     ENDIF
     text = *state.ptrText
     state.alisFile = file
     Widget_Control,event.top,Set_UValue=state
     Openw,unit,state.alisFile,/Get_Lun
     FOR i=0L,N_Elements(text)-1 DO printf,unit,text[i]
     Free_Lun,unit
     print,'File written to disk: ',state.alisFile
     END

  'PRLIST': BEGIN
    IF event.clicks EQ 2 THEN iExecute=1
     END
  'GO': iExecute=1
  'THUMBNAILS': BEGIN
      iExecute=1
      iThumb=1
      END
  'VIEWERS': BEGIN
     Widget_Control,event.id,Get_Value=value
     CASE Value OF
       'Xplot': BEGIN
          Xplot,p=p
          state.wids.xplot=p
          Widget_Control,event.top,Set_UValue=state
          END
       'Xplot2D': BEGIN
          Xplot2d,p=p
          state.wids.xplot2d=p
          Widget_Control,event.top,Set_UValue=state
          END
       'Links to Xplot and Xplot2d': BEGIN
          tmp = {idXplot:0L, idXplot2d:0L}
          XScrMenu,tmp,titles=['Xplot ID','Xplot2D ID'],/NoType,/Interp,$
             Dialog_Parent=event.top,Action=action,WTitle=$
                'ID of the destination Xplot window'
          IF action EQ 'DONT' THEN Return
          state.wids.xplot=tmp.idXplot
          state.wids.xplot2d=tmp.idXplot2d
          Widget_Control,event.top,Set_UValue=state
          END
       else:
     ENDCASE
     END
     'LISTALLFILES': BEGIN
     text = *state.ptrText
     allText = ''
     FOR i=0L,N_Elements(text)-1 DO BEGIN
       out = sortex_line(text[i])
       For j=0,N_Elements(out)-1 DO BEGIN
         n = strparse(out[j],' ',list)
         allText=[allText,list]
       ENDFOR
     ENDFOR
     xdisplayfile1,text=allText
     itmp = Dialog_Message(/Question,'Create stcripts?')
     IF itmp EQ 'No' THEN RETURN
     tmp = StrCompress(allText,/Rem)
     itmp = Where(tmp NE '')
     IF itmp[0] NE -1 THEN tmp=tmp[itmp]

     itmp = StrPos(tmp,'<none>')
     itmp = where(itmp EQ -1)
     IF itmp[0] NE -1 THEN tmp=tmp[itmp]
     xdisplayfile1,text=['#!/bin/sh','TO=../Good/XXX/',$
        'cp --preserve=timestamps '+tmp+' $TO']
     xdisplayfile1,text=['#!/bin/sh',$
        'rm '+tmp]

     END
  else: 
ENDCASE


IF iExecute THEN BEGIN
  iList = Widget_Info(state.wids.PRList,/List_Select)
  text = *state.ptrText
  lines = Text[iList]

  IF N_Elements(lines) EQ 1 THEN BEGIN
;    print,'<><> Calling sortex_line: ',lines
    out = sortex_line(lines)
    IF out[0] EQ '' THEN RETURN

    ; One line: display it
    IF N_ELEMENTS(out) EQ 1 THEN BEGIN
      n = strparse(out,' ',list)
      files = StrCompress(list,/Rem)
      ; xplot2d
      IF Widget_Info(state.wids.xplot2d,/Valid_Id) THEN BEGIN
         CASE files[0] OF
           '<none>': xplot2d_add_image,state.wids.xplot2d,fltarr(2048,2048),/subst
           else: BEGIN
              xplot2d_loadimage,state.wids.xplot2d,file=files[0],imageArr2=img2
              IF ithumb THEN BEGIN
               write_jpeg,files[0]+'.jpg',img2
               print,'SORTEX: written file: ',files[0]+'.jpg'
              ENDIF
              END
         ENDCASE
      ENDIF
      ; xplot
      IF Widget_Info(state.wids.xplot,/Valid_Id) THEN BEGIN
         CASE files[1] OF
           '<none>': xplot_cleardata,state.wids.xplot
           else: BEGIN
              xplot_loadfile,state.wids.xplot,spec=files[1]
              IF ithumb THEN sortex_thumb,id1=state.wids.xplot,file=files[1]
             END
         ENDCASE
      ENDIF

    ; Multiple lines: inyect in a new window
    ENDIF ELSE BEGIN
      tmp = [';','; Expanded line: ','; '+lines,'; '] 
      sortex,text=[tmp,'1 '+out],xplotId=state.wids.xplot, $
             xplot2dId=state.wids.xplot2d,/quit_button
    ENDELSE
  ENDIF ELSE BEGIN
;   print,'<><> Multiple selection...'
   out = ''
   FOR i=0L,N_Elements(lines)-1 DO BEGIN
;    print,'<><> Calling sortex_line: ',i,lines[i]
    iout = sortex_line(lines[i])
    IF iout[0] NE '' THEN out = [out,iout]
   ENDFOR
   out = out[1:N_Elements(out)-1]
;help,out
   ; 
   ; get recurrently MCA data
   ; 
   IF Widget_Info(state.wids.xplot,/Valid_Id) THEN BEGIN
     exodus,/only,/quit,parent=p
     FOR i=0L,N_Elements(out)-1 DO BEGIN
;PRINT,'<><>>> : ',out[i]
      n = strparse(out[i],' ',list)
      IF n LE 0 THEN BEGIN
        itmp = Dialog_Message('Error getting files : '+out[i], $
               Dialog_Parent= event.top )
        RETURN
      ENDIF
      xplot_loadfile,state.wids.xplot,spec=list[1]
      xplot_getcurrentdata,state.wids.xplot, tmp
      exodus_loadfile,p,data=tmp,title='MCA '+list[1]
      IF ithumb THEN sortex_thumb,id1=state.wids.xplot,file=list[1]
     ENDFOR
   ENDIF

   ; 
   ; calculate recurrently diffractogram
   ; 
   IF Widget_Info(state.wids.xplot2d,/Valid_Id) THEN BEGIN
     ;exodus,/only,/quit,parent=p
     FOR i=0L,N_Elements(out)-1 DO BEGIN
;PRINT,'<><>>> : ',out[i]
      n = strparse(out[i],' ',list)
      IF n LE 0 THEN BEGIN
        itmp = Dialog_Message('Error getting files : '+out[i], $
               Dialog_Parent= event.top )
        RETURN
      ENDIF
      xplot2d_loadimage,state.wids.xplot2d,file=list[0],ImageArr2=img2
      xplot2d_azimuth_integral,state.wids.xplot2d,diff=diff,id_xplot=id_xplot
      exodus_loadfile,p,data=diff,title='DIFF: '+list[0]
      IF ithumb THEN BEGIN
        write_jpeg,list[0]+'.jpg',img2
        print,'SORTEX: written file: ',list[0]+'.jpg'
        sortex_thumb,id1=id_xplot,file=list[0]
      ENDIF
     ENDFOR
   ENDIF
  ENDELSE

ENDIF


END
;
;========================================================================
;
PRO sortex_quit,id
;
Catch, error_status
IF error_status NE 0 THEN BEGIN
  Message,/Info,'error caught: '+!error_state.msg
  itmp = Dialog_Message(/Error, $
    'Sortex_quit: error caught: '+!error_state.msg)
  Catch, /Cancel
  RETURN
ENDIF

Widget_Control,id,Get_UValue=state
IF Ptr_Valid(state.ptrText) EQ 1 THEN Ptr_Free,state.ptrText

;Widget_Control, event.handler, get_UValue=state 
Widget_Control,id,/Destroy

END ; SOrtex_quit

;
;====================================================================
;

PRO sortex, file, text=text, group=group, No_Block=no_Block,  $
  Parent=parent,xplotId=xplotId,xplot2dId=xplot2dId, $
  quit_button=quit_button

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!err_string
   if sdep(/w) then itmp = Dialog_Message(/Error,$
	'SORTEX: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   return
endif

IF N_Elements(no_block) EQ 0 THEN no_block=1


;
; define widgets
;
wbase=widget_base(/col,title='SORTEX 0.1 alpha 1',MBar=wMenuBar, $
	 /TLB_KILL_REQUEST_EVENTS, Event_Pro='Sortex_Quit')

wtmp = widget_base(wbase) ; to store state

wFileMenu = Widget_Button(wmenuBar,Value='File',/Menu)
  wtmp = Widget_Button(wFileMenu,Value='Open alis file...',UValue='OPENFILE')
  wtmp = Widget_Button(wFileMenu,Value='Reload alis file...',UValue='RELOAD')
  wtmp = Widget_Button(wFileMenu,Value='Save',UValue='SAVE')
  wtmp = Widget_Button(wFileMenu,Value='Save as...',UValue='SAVEAS')
  wtmp = Widget_Button(wFileMenu,Value='Quit',UValue='QUIT',/Separator)

wEditMenu = Widget_Button(wmenuBar,Value='Edit',/Menu)
  wtmp = Widget_Button(wEditMenu,Value='ALIS text',UValue='EDITALIS')

wViewersMenu = Widget_Button(wmenuBar,Value='Viewers',/Menu)
  wtmp = Widget_Button(wViewersMenu,Value='Xplot',UValue='VIEWERS')
  wtmp = Widget_Button(wViewersMenu,Value='Xplot2D',UValue='VIEWERS')
  wtmp = Widget_Button(wViewersMenu,Value='Links to Xplot and Xplot2d',$
         UValue='VIEWERS')

wHelpMenu = Widget_Button(wmenuBar,Value='Help',/Help)
  wtmp = Widget_Button(wHelpMenu,Value='sortex',UValue='HELP')

wPannelMain = Widget_Base(wBase,Row=1)
wPannelRight = Widget_Base(wPannelMain,Col=1,/Frame)

;
; Right Pannel
; 
wPRBaseTop = Widget_Base(wPannelRight,/Row)
;  wtmp = Widget_DropList(wPRBaseTop, UValue='IMPORT', $
;    Value=['Import from: ','List File'] )

IF Keyword_Set(quit_button) THEN BEGIN
  wtmp = Widget_Button(wPRBaseTop,Value='Quit',UValue='QUIT')
ENDIF
wtmp = Widget_Label(wPRBaseTop, Value='Use File-Open to import an ALIS file ')

yListSize = 40
xListSize= 80
wPRList = Widget_List(wPannelRight,value=SIndGen(yListSize),UValue='PRLIST',$
  ysize=yListSize,xsize=xListSize,/Multiple)
wPRBaseBottom = Widget_Base(wPannelRight,/Col)
  wtmp1= Widget_Base(wPRBaseBottom,/Row)
    wtmp= Widget_Button(wtmp1,Value='Go',UValue='GO')
    wtmp= Widget_Button(wtmp1,Value='Go + thumbnails',UValue='THUMBNAILS')
    wtmp= Widget_Button(wtmp1,Value='List All Files',UValue='LISTALLFILES')
;
; set widget values
;

IF keyword_Set(file) THEN text = read_textfile(file)
IF N_Elements(file) EQ 0 THEN file=''
IF N_Elements(text) EQ 0 THEN text = ['']

Widget_Control,wPRList,Set_value=text
IF N_Elements(xplotId) EQ 0 THEN xplotId=0L
IF N_Elements(xplot2dId) EQ 0 THEN xplot2dId=0L

wids = {Base: wBase, PRList:wPRList, XPlot:xplotId, xplot2D:xplot2dId}
state = {wids:wids, ptrText:ptr_new(text), alisFile:file }

;
;
widget_control,wbase,set_uvalue=state 

widget_control,wbase,/realize
xmanager,'sortex',wbase,GROUP=group,No_Block=no_block
end
