PRO mare_calc, str1, group=group, verbose=verbose,error=error

;+
;
; PRO mare_calc, str1, group=group
;
; makes calculations for MARE
; for internal use only 
;
; Written Dec.2006 Jan. 2007 by M. Sanchez del Rio, with the help
; of Davide Bianchi. 
;
;-

; alpha means phi

on_error,2

IF N_ELEMENTS(verbose) EQ 0 THEN verbose=0
error=0


;fhEdge= 1d-8
fhEdge=str1.fhEdge
fhMax=-1D0
fhMaxIndex=-1

flg_s = 0
flg_u = 0
flg_g = 0
CASE Fix( (str1.display)[0] ) OF
  0: BEGIN
     flg_s = 1
     END
  1: BEGIN
     flg_s = 1
     flg_u = 1
     END
  2: BEGIN
     flg_s = 1
     flg_g = 1
     END
  3: BEGIN
     flg_s = 1
     flg_u = 1
     flg_g = 1
     END
  else: 
ENDCASE
; 
; get crystal data from DABAX
;
;hcell = dabax_access('CrystalCell.dat',group=group)
;n = spec_access(hcell)
;crystalnames = strarr(n)
;for i=0,n-1 do crystalnames(i)=spec_name(hcell,i+1,/index)

;hstr = dabax_access('CrystalStructures.dat',group=group)

crystalIndex=Fix(str1.crystal[0])  ; index starts from zero
dabax_crystals,crystalIndex,list=crystalnames,str=crystalStr,$
	cell=crystalCell
;crystalStr = double(spec_data(hstr,crystalIndex+1,/index))
;crystalCell = double(spec_data(hcell,crystalIndex+1,/index))


; 
; compute the metric tensor in the reciprocal space
;
ginv = bragg_metrictensor(crystalCell)


;
; wavelength (for intersections: unweg pattern)
;
lambda = str1.lambda ; for intersections
deltalambda = str1.deltaLambda
lambdas = [lambda-deltalambda,lambda,lambda+deltalambda]


;
; phi (for intersections: glitches pattern)
;
phi = str1.phi
deltaPhi=str1.DeltaPhi
phis=[phi-deltaPhi,phi,phi+deltaPhi]

;
; Main reflection
;
P=Double([str1.h,str1.k,str1.l])
 pn=norm(p)
 p2=pn^2


;
; Calculate Reference axis (corresponding to phi =0)
; This is a vector perpendicular to P
;
;M0 = [1D,-1,0]
mm1 = Reform(ginv##transpose(p))
mm2 =[mm1[1],-mm1[0],0] 
mm3 = min(abs( mm1[where(mm1 NE 0)]  ))
M0 = (mm2/mm3)
;m0new = (mm2/mm3)
;m0=m0new
;print,'<><>M0: ',vect2String(M0)
;print,'<><>M0new: ',vect2String(M0new)
;print,'<><>P dot M0: ',p##ginv##transpose(M0)
;print,'<><>P dot M0new: ',p##ginv##transpose(M0new)


;
; operational reflections (for permutations)
;
pmax = Double([str1.hmax,str1.kmax,str1.lmax])
 hh = DIndGen(pmax[0])+1
 hh = [-hh,0,hh]
 kk = DIndGen(pmax[1])+1
 kk = [-kk,0,kk]
 ll = DIndGen(pmax[2])+1
 ll = [-ll,0,ll]


;
; calculate the structure needed for intensity calculations
;

bragginp = bragg_inp(ask=0)
bragginp.parameters.ilattice[0]=StrCompress(crystalIndex,/Rem)
bragginp.parameters.hmiller=p[0]
bragginp.parameters.kmiller=p[1]
bragginp.parameters.lmiller=p[2]

energy = physical_constants('hc')/lambda
bragginp.parameters.emin=energy-1000
bragginp.parameters.emax=energy+1000
bragginp.parameters.estep=10


;
; first call to bragg_inp for reading files for subsequential calls
; 
; crystalCell=0 ; must be defined to zero and will hold the loaded values
; crystalStr=0
f0=0
f1=0
f2=0
fhinp = bragg_calc(bragginp,crystalCell=crystalCell,crystalStr=crystalStr, $
  f0=f0,f1=f1,f2=f2,verbose=1,anomalous=0)


;
; calculates the intensity of the main reflection
;
crystal_fh,fhinp,energy,text=text,out=outint
print,'STRUCT of main reflection: ',Real_Part(outInt.struct)
bragg_angle = 180D/!dpi*asin(lambda*1D-8/2/fhinp.d_spacing)
fhMain = Real_Part(outInt.struct)
intMain = bragg_lorentz(bragg_angle)*(fhMain^2)

print,'Main reflection d-spacing [A]: ',fhinp.d_spacing*1D8
print,'Main reflection 1/2d=sin(theta)/lambda: ',1D0/(2D0*fhinp.d_spacing*1D8)
print,'Main reflection Bragg angle (using lambda Umweg): ',outInt.theta*180/!dpi
print,'Main reflection Lorentz: ',bragg_lorentz(outInt.theta*180/!dpi)
print,'Main reflection fh (real part): ',fhMain
print,'Main reflection intensity: ',intMain

;
; creates abscissas for spaghettis
;
parms = {n:500L, xmin:-90.,xmax:90.,ymin:0.,ymax:3.5}

alpha = makearray1(parms.n,parms.xmin,parms.xmax,/double)

;
; main loop over permutations on operatinal reflections
;
out = DblArr(18,15000)
ngood=0
print,'MARE_CALC: loop over ',N_Elements(hh)*N_Elements(kk)*N_Elements(ll),$
      'reflections...'
for ih=0L,N_Elements(hh)-1 do begin
for ik=0L,N_Elements(kk)-1 do begin
for il=0L,N_Elements(ll)-1 do begin
  r=[hh[ih],kk[ik],ll[il]]
  ;;r=[1D,3,1]
  ;rn = norm(r)
  ;r2=rn^2
  ;
  ; rp=r||
  ;
  rp=total(r*p)/p2*p
  rpn=norm(rp)
  rp2=rpn^2

  p2new=p##ginv##transpose(p)
  rpnew= (r##ginv##transpose(p)) /p2new
  rpnew= rpnew[0]*p

  ; 
  ; Alpha0
  ; 
  cos_alpha0 = Total( (r-rp)*M0)/norm(r-rp)/norm(M0)
  alpha0rad = acos(cos_alpha0)

  ; NOTA BENE: alpha0 is calculating using the orthonormal scalar 
  ; product. Should this be changed using the metric tensor for a
  ; generic structure? 
  ;
  ;nn1 =  (r-rpnew)##ginv##transpose(r-rpnew)
  ;nn2 =  (M0)##ginv##transpose(M0)
  ;cos_alpha0new = (r-rpnew)##ginv##transpose(M0)/nn1[0]/nn2[0]
  ;alpha0radnew = acos(cos_alpha0new)
  ;print,'r-rp: ',vect2string(r-rp)
  ;print,'r-rp NEW: ',vect2string(r-rpnew)
  ;print,'rper dot M:',Total( (r-rp)*M0)
  ;print,'rper dot M new:',(r-rpnew)##ginv##transpose(M0)
  ;print,'nn1, nn2: ',nn1[0],nn2[0]
  ;print,'cos(alpha): ',cos_alpha0
  ;print,'cos(alpha) NEW: ',cos_alpha0new
  ;print,'Alpha0: ',alpha0rad*180/!dpi
  alpha0 = alpha0rad*180/!dpi
  
  ; 
  ; k
  ; 
  ;k = 0.5D0*(r2-rpn*pn)/sqrt(r2-rp2)
  ;k = 0.5D0*(r2-total(r*p))/sqrt(r2-rp2)

  knew1 = 0.5D0*( r##ginv##transpose(r)-r##ginv##transpose(p) )
  knew22=r##ginv##transpose(r)-rpnew##ginv##transpose(rpnew)
  knew2 = sqrt( knew22 )
  knew = knew1[0] / knew2[0]

  IF abs(knew22) GT 1d-8 THEN BEGIN
    goodRef=1 
  ENDIF ELSE BEGIN
    goodRef=0
  ENDELSE

  ; 
  ; computes intensity
  ; 

  bragginp.parameters.hmiller=r[0]
  bragginp.parameters.kmiller=r[1]
  bragginp.parameters.lmiller=r[2]
  fhinp = bragg_calc(bragginp,crystalCell=crystalCell,crystalStr=crystalStr, $
         f0=f0,f1=f1,f2=f2,verbose=0)
  ; NO anomalous scattering factor
  ; bragginp2.f1 = inp2.f1*0
  ; bragginp2.f2 = inp2.f2*0
  crystal_fh,fhinp,energy,text=text,out=outint,/forceRatio

  ;print,'<><>STRUCT: ',outInt.struct
  ;print,'<><>Real_STRUCT: ',Real_Part(outInt.struct)
  IF Real_Part(outInt.struct) LE fhEdge THEN goodRef=0

  IF goodRef EQ 1 THEN BEGIN
    ngood = ngood+1


    if verbose then print,'------------------------------'
    if verbose then print,'h,k,l: ',vect2string(Fix(r))

    braggAngleUmweg = outInt.theta*180/!dpi
    ;lorentz = bragg_lorentz(braggAngle)
    ;int_r = bragg_lorentz(braggAngle)*(Real_Part(outInt.struct))^2
    ;IF Finite(Real_Part(outInt.struct)) EQ 0 THEN int_r = 0D
    if verbose then print,'Bragg angle (for Umweg): ',braggAngleUmweg
    beta = alpha - alpha0
    ;y2 =  (knew/cos(beta*!dpi/180))^2+p2new[0]/4  ; 1/lambda^2
    ;y3 = 1D/sqrt(y2)
    y3 = 1D/sqrt((knew/cos(beta*!dpi/180))^2+p2new[0]/4)
    ; oplot,alpha,y3,color=icolor


    ; 
    ; phi values for lambda interval (intersections for unweg)
    ; 
    theta1 = knew[0]^2/( (1D/lambdas)^2-p2new[0]/4 )
    IF abs(theta1[1]) GT 1 THEN BEGIN ; no intesrsection
      theta2=[-1000,-1000,-1000]
      theta3=[-1000,-1000,-1000]
    ENDIF ELSE BEGIN
      theta1 = acos(sqrt(theta1))
      theta1=theta1*180/!pi
      ;print,'theta1: ',theta1
      theta2=alpha0-theta1
      theta3=alpha0+theta1-180
      ;print,'theta2: ',theta2
      ;print,'theta3: ',theta3
    ENDELSE

    ; 
    ; lambda values for phi intervals (for glitches) 
    ; 
    ;lambdaIntersec = cella/sqrt((k/cos((phis-alpha0)*!dpi/180))^2+p2/4)
    lambdaIntersec = 1D/sqrt( (knew/cos((phis-alpha0)*!dpi/180))^2+p2new[0]/4 )
    if verbose then print,'lambdaIntersec: ',lambdaIntersec
    if verbose then print,'d-spacing [A]: ',fhinp.d_spacing*1D8
    braggAngleGlitches = lambdaIntersec[1]/2/fhinp.d_spacing/1D8
    IF abs(braggAngleGlitches) LE 1 THEN $
      braggAngleGlitches = asin(braggAngleGlitches)*180/!dpi ELSE $
      braggAngleGlitches = 0
    if verbose then print,'Bragg angle (for Glitches): ',braggAngleGlitches

    ; 
    ; print/store results
    ;
    out[0:2,ngood-1]=r
    out[3,ngood-1]=alpha0
    out[4,ngood-1]=knew[0]
    out[5,ngood-1]=p2new[0]/4
    out[6:8,ngood-1]=theta2
    out[9:11,ngood-1]=theta3
    out[12:14,ngood-1]=lambdaIntersec
    ;out[15,ngood-1]=braggAngle
    ;out[16,ngood-1]=Real_Part(outInt.struct)
    ;out[17,ngood-1]=lorentz
    out[15,ngood-1]=braggAngleUmweg
    out[16,ngood-1]=braggAngleGlitches
    out[17,ngood-1]=Real_Part(outInt.struct)

    if (verbose NE 1) then print,'[h,k,l] fh: '+vect2string(Fix(r)),$
        String(Real_Part(outInt.struct))
    ;print,'<><>',out[*,ngood-1],Format='(A,3I5,14G9.6)'
    IF (Real_Part(outInt.struct) GT fhMax) THEN BEGIN
       fhMax=Real_Part(outInt.struct)
       fhMaxIndex=ngood-1
    ENDIF
  ENDIF
endfor
endfor
endfor

IF ngood EQ 0 THEN BEGIN
  error=1
  return
ENDIF
out = out[*,0:(ngood-1)]


;
; common header for macros
;

txt1 = [$
';', $ 
'; XOP/IDL macro created by MARE ', $
'; (Do not change this macro. Use Edit Parameters for user customization.) ', $
'; xop/mare multiple diffraction  ',$
'; ',$
'; inputs: ',$
'; crystal index: '+str1.crystal[0], $
'; crystal name: '+crystalnames[crystalIndex], $
'; Main reflection: '+vect2string([str1.h,str1.k,str1.l]), $
'; Max reflections: '+vect2string([str1.hmax,str1.kmax,str1.lmax]), $
'; Wavelength [A]'+StrCompress(str1.lambda), $
'; Delta Wavelength [A]'+StrCompress(str1.deltalambda), $
'; Phi [deg] '+StrCompress(str1.phi), $
'; Delta Phi [deg] '+StrCompress(str1.deltaphi), $
'; Display: '+str1.display[0], $
'; Using reflections with fh > '+StrCompress(fhEdge),$
'; ',$
'; Computed parameters: ',$
'; Number of good reflections: '+StrCompress(nGood,/Rem), $
'; M vector (corresponding to phi=0)  '+vect2string(Fix(M0)), $
'; Intensity of main reflection: '+StrCompress(intMain), $
'; Structure Factor fh of main reflection: '+StrCompress(fhMain),$
'; Reflection with maximum intensity: ',$
';            number: '+StrCompress(fhMaxIndex+1),$
';            miller indices: '+String( out[0:2,fhMaxIndex],Format='(3I12)' ),$
';            fh value: '+StrCompress(fhMax)]


;
; plot macro with spaghettis
;

IF flg_s THEN BEGIN ; plot spaghettis
buffer = [$
  '; (xop/mare spaghetti macro) ', $
  txt1,$
  ';', $
  ";parms = {n:500L, xmin:-90.,xmax:90.,eV:['0','A','eV'],ymin:0.,ymax:3.5}",$
  'alpha = makearray1(parms.n,parms.xmin,parms.xmax,/double)', $
  "IF Fix(parms.eV[0]) EQ 1 THEN ytitle='Photon energy [eV]' ELSE ytitle='Wavelength [A]'", $
  "plot,alpha,alpha*0,xrange=[parms.xmin,parms.xmax],yrange=[parms.ymin,parms.ymax],/nodata,/xstyle,/ystyle,title='MARE-spaghetti, Main diffraction: "+vect2string([str1.h,str1.k,str1.l])+' '+crystalnames[crystalIndex]+"',xtitle='Azimuthal angle [deg]',ytitle=ytitle", $
  'lambdas='+vect2string(lambdas), $
  'phis='+vect2string(phis), $
  "IF Fix(parms.eV[0]) EQ 1 THEN yy=physical_constants('hc')/lambdas ELSE yy=lambdas", $
  "labelflg =  Fix(parms.labels[0])"]
  IF flg_u THEN BEGIN
    buffer = [buffer, $
      'oplot,alpha,alpha*0+yy[1],linestyle=0', $
      ;'oplot,alpha,alpha*0+yy[0],linestyle=0', $
      'oplot,alpha,alpha*0+yy[2],linestyle=0']
  ENDIF
  IF flg_g THEN BEGIN
    buffer = [buffer, $
      'oplot,[phis[0],phis[0]],[-1000000,1000000],linestyle=0', $
      ;'oplot,[phis[1],phis[1]],[-1000000,1000000],linestyle=0', $
      'oplot,[phis[2],phis[2]],[-1000000,1000000],linestyle=0']
  ENDIF

FOR i=0L,ngood-1 DO BEGIN

  buffer = [buffer, $
  '; --------------------------------',$
  '; Reflection nr: '+StrCompress(i+1,/Rem),$
  ';'+String(['h','k','l','alpha0','k','p2/4','th2','th2','th2','th3','th3','th3','lambda','lambda','lambda','BrgAngU','BrgAngG','fh'],Format='(18A12)'), $
  ';'+String( out[*,i],Format='(3I12,15G12.6)' ), $
  'ilabel=randomu(seed)*(parms.n-1)',$
  'y3 = 1D/sqrt(('+ $
        strCompress(out[4,i],/rem)+ '/cos((alpha-'+$
        StrCompress(out[3,i],/Rem)+')*!dpi/180))^2+'+$
        strCompress(out[5,i],/rem)+ ')', $
  "IF Fix(parms.eV[0]) EQ 1 THEN y3=physical_constants('hc',/Double)/y3", $
  'oplot,alpha,y3,color='+StrCompress(i mod 32 + 1), $
  "IF labelflg THEN XYouts,CharS=0.95,alpha[iLabel],y3[iLabel]+.02<parms.ymax,'"+vect2string(Fix(out[0:2,i]))+"',Color="+StrCompress(i mod 32 + 1)    ]

ENDFOR

parms1 = {n:parms.n, xmin:parms.xmin,xmax:parms.xmax,eV:['0','A','eV'],$
                     ymin:parms.ymin,ymax:parms.ymax,labels:['0','No','Yes']}
xwindow,buffer=buffer,parms=parms1,/edit,/zoomflag,WTitle='MARE-Spaghetti'

ENDIF ; plot spaghettis



; 
; plot macro with umweg pattern
;

IF  flg_u THEN BEGIN ; plot umweg

buffer = [$
  '; (xop/mare umweg macro) ', $
  txt1,$
  ';', $
  ";parms = {n:500L, xmin:-90.,xmax:90.,ymin:0.,ymax:0.,labels=['0','No','Yes']}",$
  'alpha = makearray1(parms.n,parms.xmin,parms.xmax,/double)', $
  'umweg = alpha*0',$
  "labels = Replicate(';',"+StrCompress(ngood*2,/Rem)+")"]

FOR i=0L,ngood-1 DO BEGIN

  buffer = [buffer, $
  '; --------------------------------',$
  '; Reflection nr: '+StrCompress(i+1,/Rem),$
  ';'+String(['h','k','l','alpha0','k','p2/4','th2','th2','th2','th3','th3','th3','lambda','lambda','lambda','BrgAngU','BrgAngG','fh'],Format='(18A12)'), $
  ';'+String( out[*,i],Format='(3I12,15G12.6)' ), $
  'theta2 = '+vect2String(out[6:8,i]), $
  'theta3 = '+vect2String(out[9:11,i]) ]
  intens = out[17,i]^2 *bragg_lorentz(out[15,i])
  IF abs(out[8,i]-out[6,i]) GT 1D-6 THEN BEGIN
    ymax = intens/abs(out[8,i]-out[6,i])
    buffer = [buffer, $
      'intens = '+StrCompress(out[17,i])+'^2 *bragg_lorentz('+StrCompress(out[15,i]) +')',$
      'umweg = umweg + (intens/abs(theta2[2]-theta2[0]))*exp(-(alpha-theta2[1])^2/abs(theta2[2]-theta2[0])^2)', $
      "labels["+StrCompress(i*2,/Rem)+"]='xyouts,"+StrCompress(out[7,i],/Rem)+","+StrCompress(ymax,/Rem)+","+'"'+Vect2String(Fix(out[0:2,i]))+'"'+",orient=90'" ]
  ENDIF
  IF abs(out[11,i]-out[9,i]) GT 1D-6 THEN BEGIN
    ymax = intens/abs(out[11,i]-out[9,i])
    buffer = [buffer, $
      'intens = '+StrCompress(out[17,i])+'^2 *bragg_lorentz('+StrCompress(out[15,i]) +')', $
      'umweg = umweg + (intens/abs(theta3[2]-theta3[0]))*exp(-(alpha-theta3[1])^2/abs(theta3[2]-theta3[0])^2)', $
      "labels["+StrCompress(i*2+1,/Rem)+"]='xyouts,"+StrCompress(out[10,i],/Rem)+","+StrCompress(ymax,/Rem)+","+'"'+Vect2String(Fix(out[0:2,i]))+'"'+",orient=45'" ]
  ENDIF

ENDFOR
buffer = [buffer,';',';',';', $
  "plot,alpha,umweg,xrange=[parms.xmin,parms.xmax],yrange=[parms.ymin,parms.ymax],/xstyle,/ystyle,title='MARE-Umweg, Main diffraction: "+vect2string([str1.h,str1.k,str1.l])+' '+crystalnames[crystalIndex]+StrCompress(str1.lambda)+" A', xtitle='Azimuthal angle [deg]',ytitle='Approximate intensity'" , $
  "IF Fix((parms.labels)[0]) EQ 1 THEN FOR iii=0,N_Elements(labels)-1 DO tmp=Execute(labels[iii])" ]

parms = {n:500L, xmin:-90.,xmax:90.,ymin:0.,ymax:0.,labels:['0','No','Yes']}
xwindow,buffer=buffer,parms=parms,/edit,/zoomflag,WTitle='MARE-Umweg'

ENDIF ; plot umweg

; 
; plot macro with glitches pattern
;

IF flg_g THEN BEGIN

buffer = [$
  '; (xop/mare glitches macro) ', $
  txt1,$
  ';', $
  ";parms = {n:500L, xmin:0.5,xmax:3.5,eV:['0','A','eV'],ymin:0.,ymax:0}",$
  "xmin = parms.xmin", $
  "xmax = parms.xmax", $
  "IF Fix(parms.eV[0]) EQ 1 THEN xmin=physical_constants('hc',/Double)/xmin", $
  "IF Fix(parms.eV[0]) EQ 1 THEN xmax=physical_constants('hc',/Double)/xmax", $
  "labels = Replicate(';',"+StrCompress(ngood,/Rem)+")",$
  'xx = makearray1(parms.n,xmin,xmax,/double)', $
  'yy = xx*0']

FOR i=0L,ngood-1 DO BEGIN

  buffer = [buffer, $
  '; --------------------------------',$
  '; Reflection nr: '+StrCompress(i+1,/Rem),$
  ';'+String(['h','k','l','alpha0','k','p2/4','th2','th2','th2','th3','th3','th3','lambda','lambda','lambda','BrgAngU','BrgAngG','fh'],Format='(18A12)'), $
  ';'+String( out[*,i],Format='(3I12,15G12.6)' ), $
  'lambdas = '+vect2String(out[12:14,i]), $
  'intens = '+StrCompress(out[17,i])+'^2 *bragg_lorentz('+StrCompress(out[16,i]) +')']
  IF abs(out[14,i]-out[12,i]) GT 1D-6 THEN BEGIN
    intens = out[17,i]^2 *bragg_lorentz(out[16,i])
    ymax = -(intens/abs(out[14,i]-out[12,i]))
;print,'>>>',out[13,i],ymax
    buffer = [buffer, 'yy = yy + (intens/abs(lambdas[2]-lambdas[0]))*exp(-(xx-lambdas[1])^2/abs(lambdas[2]-lambdas[0])^2)',$
    "labels["+StrCompress(i,/Rem)+"]='xyouts,"+StrCompress(out[13,i],/Rem)+","+StrCompress(ymax,/Rem)+","+'"'+Vect2String(Fix(out[0:2,i]))+'"'+",orient=45'" ]
  ENDIF

ENDFOR
buffer = [buffer,';',';',';', $
  "IF Fix(parms.eV[0]) EQ 1 THEN xx=physical_constants('hc',/Double)/xx", $
  "IF Fix(parms.eV[0]) EQ 1 THEN xtitle='Photon energy [eV]' ELSE xtitle='Wavelength [A]'", $
  "plot,xx,-yy,xrange=[parms.xmin,parms.xmax],yrange=[parms.ymin,parms.ymax],/xstyle,/ystyle,title='MARE-Glitches, Main diffraction: "+vect2string([str1.h,str1.k,str1.l])+' '+crystalnames[crystalIndex]+" "+String(phis[1],Format='(F6.2)')+" deg ', xtitle=xtitle,ytitle='Approximate intensity'",$
  "IF Fix((parms.labels)[0]) EQ 1 THEN FOR iii=0,N_Elements(labels)-1 DO tmp=Execute(labels[iii])" ]




parms = {n:500L, eV:['0','A','eV'],xmin:0.5,xmax:3.5, ymin:0.0,ymax:0.0, $
  labels:['0','No','yes']}
xwindow,buffer=buffer,parms=parms,/edit,/zoomflag,WTitle='MARE-Glitches'

ENDIF ; plot glitches

END
