
;+
; NAME:
;	CW_PERIODICTABLE
;
; PURPOSE:
;	This compound widget is designed for displaying a 
;	periodic table.
;
; CATEGORY:
;	Compound widgets.
;
; CALLING SEQUENCE:
;	Widget = CW_PERIODICTABLE(Parent)
;
; INPUTS:
;	Parent:	  The ID of the parent widget.
;
; KEYWORD PARAMETERS:
;	Parent:	The Id of the parent widget
;	XSize:  The Xsize of the drawing area (pixels)
;	YSize:  The Ysize of the drawing area (pixels)
;	VALUE:	A structure with the periodic table parameters. 
;               This structure may be obtaining by periodictable_plot:
; 
;               IDL>  periodictable_plot,/noPlot,out=tmp
;               IDL> help,/str,tmp
;                  P               STRUCT    -> !PLT Array[1]
;                  X               STRUCT    -> !AXIS Array[1]
;                  Y               STRUCT    -> !AXIS Array[1]
;                  POSITION        FLOAT     Array[4]
;                  BACKGROUND      LONG                 0
;                  ZTOP            INT            119
;                  ZMAX            INT            105
;                  SHOWZ           INT              0
;                  FILL            INT             -1
;                  CLRFILL         FLOAT     Array[119]
;                  BORDER          INT              1
;                  CLRBORDER       LONG                 0
;                  CLRSYMBOL       LONG      Array[119]
;                  Z               LONG      Array[119]
;                  ZX              INT       Array[119]
;                  ZY              INT       Array[119]
;                  SYMBOLS         STRING    Array[119]
;                  NAMES           STRING    Array[119]
;                  FONT            INT              3
;
;	UVALUE: The User value for this widget	
;	
; OUTPUTS:
;	The ID of the created widget is returned.
;
; SIDE EFFECTS:
;
;	CW_PERIODICTABLE widgets generate events when the mouse passes
;	onto an element cell and or when one clicks on it. 
;
;	The returned event has the structure:
;
;       { CW_PERIODICTABLE, ID:0L, TOP:0L, HANDLER:0L, $
;          PRESS:0, Z:0, SYMBOL:'', NAME:'', X:0, Y:0}
;
;	ID is the widget ID of the button generating the event. TOP is the
;	widget ID of the top level widget containing ID. HANDLER contains the
;	widget ID of the widget associated with the handler routine. 
;	PRESS returns 1 when mouse clicks on the element cell, 0 when it
;       passes onto it. Z is the atomic number, SYMBOL is the atomic
;       symbol, X and Y are the grid coordinates of the cell. 
;
; PROCEDURE:
;	It uses:
;	periodictable_plot for displaying the periodic table
;       atomic_names() and atomic_symbols() for getting atomic data. 
;	
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio, srio@esrf.eu
;	October , 2007
;	2008-02-13 srio@esrf.eu updated doc
;
;-
;
;===============================================================
;
Pro CW_PeriodicTable_Set, id, value
;

child=Widget_Info(id, /Child)
Widget_Control, child, Get_UValue=state, /No_Copy

widget_control,state.wids.draw,get_value=windownum
wset,windownum
;
; refresh plot
;
IF Type(value) NE 8 THEN BEGIN
  tmp = state.value
  periodictable_plot,out=tmp
  state.value=tmp
ENDIF ELSE BEGIN
  periodictable_plot,out=value
  state.value=value
ENDELSE

Widget_Control, child, Set_UValue=state, /No_Copy
END
;
;===============================================================
;
Function CW_PeriodicTable_Get, id
child=Widget_Info(id, /Child)
Widget_Control, child, Get_UValue=state, /No_Copy
value = state.value
Widget_Control, child, Set_UValue=state, /No_Copy
;
RETURN,value
END
;
;===============================================================
;
Function CW_PeriodicTable_Event, event

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!error_state.msg
   itmp = Dialog_Message(Dialog_Parent=group, $
   /Error,'CW_PeriodicTable_Event: error caught: '+!error_state.msg)
   catch, /cancel
   on_error,2
   Return,0
endif

child = Widget_Info(event.handler, /Child)
Widget_Control, child, Get_UValue=state, /No_Copy

widget_control,state.wids.draw,get_value=windownum

p_old=!p
x_old=!x
y_old=!y
w_old=!d.window
!p=state.value.p
!x=state.value.x
!y=state.value.y
wset,windownum
coords = convert_coord(event.x,event.y,/device,/to_data)
!p=p_old
!x=x_old
!y=y_old
wset,w_old

coords=Fix(coords)

;
; return event structure
;
z = state.value.z
zx = state.value.zx
zy = state.value.zy
symbols = state.value.symbols
names = state.value.names
zmax = state.value.zmax

Widget_Control, child, Set_UValue=state , /No_Copy

ix = Where( (zx EQ coords[0]) AND (zy EQ coords[1]))
IF ix[0] NE -1 THEN BEGIN
   is = symbols[ix[0]]
   iz = z[ix[0]]
   iName = names[ix[0]]
   IF iz LE zmax THEN $
     return, { CW_PERIODICTABLE, ID:event.handler, TOP:event.top, HANDLER:0L, $
  press:event.press, z:iz, symbol:is, name:iName, x:coords[0], y:11-coords[1]}
ENDIF 
RETURN,0

END
;
;
;===============================================================
;
Function CW_PeriodicTable, parent, XSize=xsize, YSize=ysize, $
  UValue=UValue, Value=Value, _Extra=extra

On_Error,1

IF N_Elements(uvalue) EQ 0 THEN uvalue = 0
IF N_Elements(value) EQ 0 THEN BEGIN
  periodictable_plot,/noPlot,out=value
ENDIF

cw_tlb = Widget_Base(parent, Uvalue=uvalue, $
   Column=1, $
   Event_Func='CW_PeriodicTable_Event',$
   Pro_Set_Value='CW_PeriodicTable_Set', $
   Func_Get_Value='CW_PeriodicTable_Get')
wtmp = Widget_Base(cw_tlb) ; To store state


wDraw = Widget_Draw(cw_tlb,MOTION_EVENTS=1,UVALUE='CURSOR',$
  RETAIN=2, BUTTON_EVENTS=1, XSize=xSize, YSize=ySize)


wids={Draw:wDraw}
state = {wids:wids, value:value, uvalue:uvalue}

child=Widget_Info(cw_tlb, /Child)
Widget_Control, child, Set_UValue=state, /No_Copy

Return, cw_tlb
END
