;-------------------------------------------------------------
;+
; NAME:
;       XEditList
; PURPOSE:
;       Widget based list edit.
; CATEGORY:
; CALLING SEQUENCE:
;       xlistedit, list
; INPUTS:
;	list: a strarr containing the text list to be edit
; KEYWORD PARAMETERS:
;       Keywords:
;         WTITLE=   Widget title text (def="XEditList").
;         TITLE=   Widget label text.
;         /WAIT  means wait for returned result.
; OUTPUTS:
;       list: the updates strarr with the list text
; COMMON BLOCKS:
; NOTES:
; MODIFICATION HISTORY:
;       M. Sanchez del Rio, Feb 24, 1995
;
;-
;-------------------------------------------------------------
 
	pro xeditlist_event, ev
 
	widget_control, ev.top, get_uval=save
	widget_control, ev.id, get_uval=name
 
;	if name eq 'TEXT' then begin
;        endif

	if name eq 'OK' then begin
	  widget_control, ev.top, get_uval=wids
          widget_control, save.ids(0), get_val=text
          for i=1,n_elements(save.ids)-1 do begin
	    widget_control, save.ids(i), get_val=tmp
            text=[text,tmp]
          endfor
          save.text=text
	  widget_control, save.keep, set_uval=text
	  widget_control, ev.top, /dest
	endif
 
	if name eq 'CANCEL' then begin
	  widget_control, save.keep, set_uval=save.text
	  widget_control, ev.top, /dest
	endif
 
	return
	end
 
;
;
;
 
	pro xeditlist, out, wtitle=wtitle, title=title, group=group,$
            wait=wait
 
        if n_params() eq 0 then out=['a)','b)','c)']
	if n_elements(title) eq 0 then title=''
	if n_elements(wait) eq 0 then wait=0
        if n_elements(wtitle) eq 0 then wtitle='XEditList'
	if n_elements(out) gt 15 then scroll=1 else scroll=0
 
	;------  Lay out widget  ----------
	top = widget_base(/column,title=wtitle,scroll=scroll)
	buttons = widget_base(top, /row)
	b_ok = widget_button(buttons, val='OK',uval='OK')
	b_cancel = widget_button(buttons, val='Cancel',uval='CANCEL')
	n = n_elements(out)
	m = max(strlen(out))
	id = widget_label(top,xsize=m,ysize=1,val=title)
        idtxt = intarr(n)
        for i=0,n-1 do $
	idtxt(i) = widget_text(top,/edit,xsize=m,ysize=1,val=out(i),$
          uval='TEXT')
 
	;------  Package and store needed info  ------------
        keep=widget_base()
        save = { text:out, ids:idtxt, keep:keep }
	widget_control, top, set_uval=save
 
	;------  realize widget  -----------
	widget_control, top, /real
 
	;------  Event loop  ---------------
	xmanager, 'xeditlist', top,  modal=wait,  group=group
 
	;------  Get result  ---------------
	widget_control, keep, get_uval=out
 
	return
	end
