FUNCTION peakfinder2d,image,indices1d=tmpi, plot=fPlot,_extra=extra

;+
; NAME:
;	PEAKFINDER2D
;
; PURPOSE:
;	This function finds the peaks of 2-D data. 
;
;       It returns a (2,npeaks) array with the pixel indices
;	of the found peaks
;
;	If no peaks are found, it returns [-1]
;
; CATEGORY:
;	Maths.
;
; CALLING SEQUENCE:
;	result = PeakFinder2D(img)
;
; INPUTS:
;	img: 2D data (an image)
;
; KEYWORD PARAMETERS:
;
;    INPUTS: 
;	plot: set this keyword to overplot the found peaks on the 
;             current graphic. 
;    OUTPUTS:
;	indices1d: set this keyword to a named variable to receive the 
;       1D list with the peak indices.  
;
;
;    EXTRA: Any other keyword accepted by PEAKFINDER
;
; PROCEDURE:
;       It uses PEAKFINDER to find the peaks of i) all the rows 
;       aligned one after the other, and ii) all the columns aligned one
;       after the other. Then, a pizel is considered a "peak" if it is 
;       a peak in both arrays built in i) and ii). 
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio, srio@esrf.eu
;	26 June 2008  
;-
peaks2=-1

 
; peaks along X
a=peakfinder(image,_extra=extra)
tmp = image*0
IF a[0] NE -1 THEN tmp[a]=1

; peaks along Y
imaget=transpose(image)
at=peakfinder(imaget,_extra=extra)
tmpt=imaget*0
IF at[0] NE -1 THEN tmpt[at]=1
tmpt=transpose(tmpt)


tmpi = where(tmp EQ 1 and tmpt eq 1)

ss = size(image)
IF tmpi[0] NE -1 THEN peaks2 = array_indices([ss[1],ss[2]],tmpi,/dim)

IF keyword_set(fplot) THEN BEGIN
    oplot,peaks2[0,*],peaks2[1,*],psym=2
ENDIF

RETURN,peaks2

END

