FUNCTION getbmp,title
;+
; NAME:
;	GETBMP
;
; PURPOSE:
;	This function returns an array with an image. It reads the
;	image in the ['resource', 'bitmaps'] directories of the 
;	IDL distrubution. It is intended to read images to be used 
;	in buttons. 
;
; CATEGORY:
;	Utilities.
;
; CALLING SEQUENCE:
;	im = GetBmp(title) 
;
; INPUTS: 
;       title: the title or file name (with extension). E.g., camera.bmp
;		(this is the default)
;
; OUTPUTS:
;	an array with the image.
;
; EXAMPLE:
;	im = GetBmp('camera.bmp')
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio (srio@esrf.eu) 2007/10/09
;	
;	Modified: 
;
;-

IF N_Elements(title) EQ 0 THEN title='camera.bmp'
; Create a 24-bit image array.  
imageRGB = BYTARR(16,16,3,/NOZERO)  
; Read in the bitmap.  
file=FILEPATH(title, SUBDIR=['resource', 'bitmaps'])  
IF checkfile(file) NE 1 THEN BEGIN
  Message,/Info,'File not found: '+file
  RETURN,imageRGB
ENDIF
image8 = READ_BMP(file, Red, Green, Blue)  
; Pass the image through the color table  
imageRGB[0,0,0] = Red[image8]  
imageRGB[0,0,1] = Green[image8]  
imageRGB[0,0,2] = Blue[image8]  

RETURN,imageRGB
END


