pro filesubset,file,fileout,limits

;+
; NAME:
;	FILESUBSET
; PURPOSE:
;	Creates a file containing a subset of the input file.
; CATEGORY:
;	File Manipulation
; CALLING SEQUENCE:
;	FILESUBSET, filein, fileout, limits
; INPUTS:
;    FILEIN String with the input file name.
;    FILEOUT String with the output file name.
;    LIMITS 2-dim vector with the line limits: [starting_line,ending_line]
; OPTIONAL INPUT PARAMETERS:
;	None.
; KEYWORD PARAMETERS:
;	None.
; OUTPUTS:
;	Creates a new file.
; OPTIONAL OUTPUT PARAMETERS:
;	None.
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Straightforward.
; MODIFICATION HISTORY:
;	Created 01-NOV-1995 by M. Sanchez del Rio (srio@esrf.fr) (c)ESRF
;-

;
;
on_error,2
limits = long(limits)
if checkfile(file) ne 1 then begin
  print,'FILEPOS: file '+ file + ' not found. Returning. '
  return
endif
    openr,Unitin,file,/GET_LUN
    openw,Unitout,fileout,/GET_LUN
    command = ''
    iline = 0L
    while(not(eof(Unitin))) do begin
     readf,Unitin,command
     iline = iline + 1
     if (iline GE limits(0)) and (iline LE limits(1)) then $
       printf,Unitout,command
    endwhile
    free_lun,Unitin
    free_lun,Unitout
print,'FILESUBSET: File '+fileout+' written to disk.'
end


