function fileposition,file,key

;+
; NAME:
;	FILEPOSITION
; PURPOSE:
;	Find the file line number where the string KEY is placed
; CATEGORY:
;	File manipulation.
; CALLING SEQUENCE:
;	Result = FilePosition ( File, Key )
; INPUTS:
;    FILE A string with the file name.
;    KEY  The string to be searched.
; OPTIONAL INPUT PARAMETERS:
;	None.
; KEYWORD PARAMETERS:
;	None.
; OUTPUTS:
;	Returns  the number (of an array of numbers) with the file
;	line(s) where the string KEY has been found.
;	of ARR in ascending order.
; OPTIONAL OUTPUT PARAMETERS:
;	None.
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Loops over the file lines and uses strpos to find the string.
; MODIFICATION HISTORY:
;	Created 01-NOV-1995 by M. Sanchez del RIo (srio@esrf.fr) (c)ESRF
;-

;
; find the lines where a key is placed
;
on_error,2
if checkfile(file) ne 1 then begin
  print,'FILEPOS: file '+ file + ' not found. Returning. '
  return,-1
endif
    openr,Unit,file,/GET_LUN
    command = ''
    iline = 0L
    while (not(eof(Unit))) do begin
     readf,Unit,command
     iline = iline+1
      for i=0,n_elements(key)-1 do begin
        Result = strpos(command,key(i))
        if  result NE -1 then  begin
          if not(keyword_set(buffer)) then $
	  buffer = iline else buffer  = [buffer,iline]
        endif
      endfor
    endwhile
    free_lun,Unit
if not(keyword_set(buffer)) then return,-1 else return,buffer
end


