function ess_base1, decimal, base, nchar, return_array=return_array
;+
; NAME:
;   ESS_BASE1
; PURPOSE:
;   Translate a non-negative decimal integer to either hexadecimal
;	or octal string
; CALLING SEQUENCE:
;   VALUE = ess_base1(decimal,base[,nchar])
; INPUTS:
;   	decimal - (scalar) non-negative decimal integer
;	base	- either a sring with
;		  'hex' (hexidecimal)
;		  'oct' (octal)
;		  or an integer with the base (i.e. 8 for octal, 2 for binary)
; OPTIONAL INPUT:
;   NCHAR - number of characters in the output hexadecimal string.
;           If not supplied, then the hex string will contain no 
;           leading zeros.
; OUTPUT:
;   VALUE - (STR) - translation of input integer to either HEX or OCTAL
; KEYWORDS:
;   RETURN_ARRAY - if set, the result is a string array with one
;           character per elements instead a single string [default].
; EXAMPLES:
;   VALUE = ESS_BASE1(7299)
;
; REVISION HISTORY:
;   Written   W. Landsman         March, 1989
;   5-NOV-1991	JKF/ACC		- for use with ESS data.
;   98/08/20 srio@esrf.fr accepts "base" as an integer. Adds "RETURN_ARRAY" 
;		keyword.
;-

case type(base) of
  0: val=10  ; base not defined, return base 10
  7: if strupcase(strtrim(base,2)) eq 'HEX' then val = 16 else val = 8
  else: val = base
endcase
	T = BYTARR(1)
	X = decimal
LOOP:	T = [T, X MOD val]
	IF X LT 1 THEN GOTO, DONE
	X = X/val
	GOTO, LOOP

DONE:	IF N_PARAMS(0) LT 3 THEN NCHAR = (N_ELEMENTS(T)-2) >1
        T = T(NCHAR-INDGEN(NCHAR>1) )
        T = T + 48B + (T GT 9)*7B	; provide padding
	tmp = STRING(BYTE(T))
	if not(keyword_set(return_array)) then RETURN,tmp else begin
	  out = strarr(strlen(tmp))
	  for i=0,strlen(tmp)-1 do out[i]=strmid(tmp,i,1)
	  return,out
	endelse
	END
