;______________________________________________________________________________
;+
; NAME:
;       SPEC_LABELS()
;
; PURPOSE:
;       This function returns the labels of data columns of a particular scan
;       in a SPEC file.
;
; CATEGORY:
;       Input/Output.
;
; CALLING SEQUENCE:
;       Result = SPEC_LABELS(Handle, Scan_Id)
;
; INPUTS:
;       Handle   - Handle to the SPEC data file initialised by a previous call
;                  to SPEC_ACCESS().
;
;       Scan_Id  - Scan identifier. This parameter can be a numeric or string
;                  scalar value that accepts several syntax and keywords as
;                  it is explained in the `SCAN IDENTIFIERS' section at the
;                  beginning of this file). The simplest case is to use
;                  the SPEC scan number as Scan_Id.
;
; KEYWORDS:
;       INDEX:  Set this keyword to interpret a numeric value in Scan_Id
;               as the index of the scan instead of the scan number.
;
; OUTPUT: 
;       This function returns an string array that contains the labels of the
;       the data columns in the SPEC file. The information is extracted from
;       the '#L' line. The dimension of the array depends on the number of
;       columns of this particular scan.
;
; RESTRICTIONS:
;       This function requires a valid handle to a SPEC data file obtained by
;       a previous call to SPEC_ACCESS().
;       If Scan_Id does not represent a valid scan the function produces an
;       error.
;
; EXAMPLE:
;       To load the array NewLabels with the labels of the data columns of the
;       scan no. 27 from a file called 'karaoke', enter:
;
;       Dummy = SPEC_ACCESS(File1_handle, 'karaoke')
;       NewLabels = SPEC_LABELS(File1_handle, 27)
;______________________________________________________________________________
;-

function spec_labels, handle, scan_id, INDEX=idx
   catch, error_status
   if error_status ne 0 then begin
      catch, /cancel
      on_error, 2
      message, __cleanmsg(!err_string);, /traceback
   endif

   ; Check arguments
   if N_PARAMS() ne 2 then message, 'Incorrect number of arguments.'

   __speccheck, handle
   __specload, handle, scan_id, errmsg, INDEX=idx
   if !ERR then message, errmsg
   n=handle.scan(handle.currscan).n_col
   if n gt 0 then return, handle.label(0:n-1) else return, ''
end
