FUNCTION Wiggler_NPhoton,r_m, e_gev, energy_ev

;+
; NAME:
;       WIGGLER_NPHOTON
;
; PURPOSE:
;       Calculates the synchrotron radiation spectrum versus bending radius
;	Assumptions:
;		Electron current = 1 mA
;		Horizontal divergence = 1mA
;		Energy bandwidth = 1 eV
;
; CATEGORY:
;       Mathematics.
;
; CALLING SEQUENCE:
;       Result = Wiggler_NPhoton(r_m,e_GeV,energy_eV)
;
; INPUTS:
;	r_m: the array with the bending radii in m
;	e_GeV: electrons energy in GeV
;       energy_ev:  photon energy in eV
;
; KEYWORD PARAMETERS:
;	POLARIZATION: 0 Total 
;		      1 Parallel       (l2=1, l3=0, in Sokolov&Ternov notation)
;		      2 Perpendicular  (l2=0, l3=1)
;
;
; KEYWORD PARAMETERS (OUTPUT):
;
;
; OUTPUTS:
;       returns the array with the flux [photons/sec/0.1%bw] 
;
; PROCEDURE:
;
;	It uses sync_ene.pro
;
;	References: 
;		G K Green, "Spectra and optics of synchrotron radiation" 
;			BNL 50522 report (1976)
;		A A Sokolov and I M Ternov, Synchrotron Radiation, 
;			Akademik-Verlag, Berlin, 1968
;
; EXAMPLE:
;	The following program was used for testing nphoton
;	
;	
;	IDL> r_m = makearray1(100,1,500)
;	IDL> xplot,r_m,nphoton(r_m,6.0,10000.0)    
;
;
; MODIFICATION HISTORY:
;       Written by:     M. Sanchez del Rio, srio@esrf.fr, 2002-06-24
;
;-

; number of photons in 0.1%bw

; Ec [eV] = 2218.2873 * E_GeV^3 / Rho_m
cte = (3.0d0/4/!dpi)*physical_constants('h')*physical_constants('c')* $
      (1d3/physical_constants('mee'))^3/physical_constants('ec')
nn=sync_ene(0,energy_ev,ec_ev=cte*e_gev^3/r_m,e_gev=e_geV,i_a=1e-3, $
 hdiv_mrad=1.0)
; number of photons in 1 eV
; nn=nn/(energy_ev*1d-3)
RETURN,nn
END
