FUNCTION bragg_metrictensor,aa,b,c,a1,a2,a3, $
  RETURN_REAL_SPACE=return_real_space, $ 
  RETURN_VOLUME=return_volume, $
  HKL=hkl, Verbose=verbose
;+
; Returns the metric tensor in the reciprocal space
; 
; 
; Written by M. Sanchez del Rio and Davide Bianchi, December 2006
;
; 2007-01-30 srio@esrf.fr allows calculation for a matrix of hkl values. 
;
;-


CASE N_PARAMS() OF
  0:BEGIN     ; no input
    a = 5.43D
    b = a
    c = a
    a1 = 90D*!dpi/180
    a2 = a1
    a3 = a1
    END
  1:BEGIN     ; input as array
    a = Double(aa[0])
    b = Double(aa[1])
    c = Double(aa[2])
    a1 = Double(aa[3])*!dpi/180
    a2 = Double(aa[4])*!dpi/180
    a3 = Double(aa[5])*!dpi/180
    END
  else: a=aa
ENDCASE


; 
; tensor in real space
;
g = [ [a*a, a*b*cos(a3), a*c*cos(a2)], $
      [a*b*cos(a3), b*b, b*c*cos(a1)], $
      [a*c*cos(a2), b*c*cos(a1), c*c]]

IF Keyword_Set(return_real_space) THEN RETURN,g

;
; volume of the lattice
;
volume2 = determ(g)
IF Keyword_Set(verbose) THEN message,/info,'Volume: '+StrCompress(sqrt( volume2 ),/Rem)

IF Keyword_Set(return_volume) THEN RETURN,(sqrt(volume2))[0]

;
; tensor in reciprocal space
;
ginv = invert(g)
;print,gInv

itmp = where(abs(ginv) LT 1d-8) 
IF itmp[0] NE -1 THEN ginv[itmp]=0D

IF KeyWord_Set(hkl) THEN BEGIN
  ; computes d-spacing
  dd = hkl##ginv##transpose(hkl)
  dd = 1D/sqrt(diag_matrix(dd))
  IF Keyword_Set(verbose) THEN message,/info,'d-spacing for '+Vect2String(Fix(hkl))+' :'+StrCompress(dd,/rem) 
  RETURN,dd
ENDIF
RETURN,ginv


END

