PRO unpack_files,input,free=free,only_list=only_list,get_list=get_list,$
  inform=inform,confirm=confirm,group=group

;+
; NAME:
;	UNPACK_FILES 
; PURPOSE:
;	This procedure unpacks a number of disk files from an IDL structure.
;	or from a .sav file written using the Pack_Files procedure.
;	Use Pack_Files procedure for packing.
; CATEGORY:
;	utilities.
; CALLING SEQUENCE:
;	UnPack_Files,input
; INPUTS:
;	input   Either the:
;		i) File name with the .sav file
;		ii) a structure with the packed files, as written by
;		    pack_files
;
; KEYWORD PARAMETERS:
;	Free:    If set, the pointers of the variable packed_files are freed 
;		to avoid unused heap variables.
;       Group: The parent id for the caller widget (used to positioning
;               error and information windows).
;	Inform: Informs on the list of files for being written.
;	Confirm: If the file exists, ask for overwritting it.
;	Only_List: Set this keyword to obtain a list of the packed files.
;		(get the list using the Get_List keyword)
;	Get_List: A named variable with the list of packed files. Use
;		it in combination with Only_List keyword. 
;
; EXAMPLES:
;		pack_files,['Letter.doc','begin.dat'],file='tmp.sav',/free
;		unpack_files,'tmp.sav',/free
;
; MODOFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble, 12 May 2006
;-
IF N_Elements(input) EQ 0 THEN BEGIN
   input = Dialog_PickFile(Title='Load file with packed files', $
	Dialog_Parent=group)
   IF input[0] EQ '' THEN RETURN
ENDIF

IF Type(input) EQ 7 THEN BEGIN
  Restore,/Verbose,input
ENDIF ELSE BEGIN
  packed_files=input
ENDELSE

IF Keyword_Set(only_list) THEN BEGIN
  get_list=packed_files.file
  FOR i=0L,N_Elements(packed_files)-1 DO BEGIN
     IF Ptr_Valid(packed_files[i].ptr) THEN Ptr_Free,packed_files[i].ptr
  ENDFOR
  RETURN
ENDIF

IF Keyword_Set(inform) THEN BEGIN
   itmp = Dialog_Message(/Question,Dialog_Parent=group, $
	['Files to unpack: ','',packed_files.file,'','Proceed?'])
   IF itmp EQ 'No' THEN GoTo,free
ENDIF

FOR i=0L,N_Elements(packed_files)-1 DO BEGIN
     iover=1
     ifile = packed_files[i].file
     IF Keyword_Set(confirm) THEN BEGIN
       IF checkfile(ifile) EQ 1 THEN BEGIN
	 itmp = Dialog_Message(Dialog_Parent=group,$
	   ['File exists: '+ifile,'','Overwrite it?'],/Cancel)
         IF itmp EQ 'Cancel' THEN GoTo,free
         IF itmp EQ 'No' THEN BEGIN
	    ifile=Dialog_Pickfile(Dialog_Parent=group,Title=$
		'Enter new name for: '+ifile)
	    IF ifile[0] EQ '' THEN iover=0
	 ENDIF
       ENDIF
     ENDIF
     IF iover EQ 1 THEN BEGIN
       OpenW,unit,ifile,/Get_Lun
       WriteU,unit,*(packed_files[i].ptr)
       Free_Lun,unit
       print,'File unpacked to disk: ',ifile
     ENDIF
ENDFOR

free:
IF KeyWord_Set(free) THEN BEGIN
  FOR i=0L,N_Elements(packed_files)-1 DO BEGIN
     IF Ptr_Valid(packed_files[i].ptr) THEN Ptr_Free,packed_files[i].ptr
  ENDFOR
ENDIF

END

