FUNCTION Create_SubStruct,strin,indices, Group=group

;+
; NAME:
;	CREATE_SUBSTRUCT
;
; PURPOSE:
;	This function create a new structure which is a subset
;	of the input structure.
;
; CATEGORY:
;	General utilities.
;
; CALLING SEQUENCE:
;
;	str_our = Create_SubStruct(str_in, indices)
;
; INPUTS:
;	str_in: the input structure
;	str_out: the output structure
;	indices: an array (integers) containing the tag indices
;	  of str_in to be included in str_out.
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;	Group: The widget id of the called. Used for centering the 
;		Dialog_Message window in case of error messages.
;		
;
; OUTPUTS:
;	The new structure
;
; SIDE EFFECTS:
;
; PROCEDURE:
;	Straightforward.
;
; EXAMPLE:
;	IDL> help,/str,Create_SubStruct(!version,[3,4])   
;	** Structure <78d48>, 2 tags, length=16, refs=1:
;	   RELEASE         STRING    '5.1'
;	   BUILD_DATE      STRING    'Apr 13 1998'
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio (srio@esrf.fr) 98-12-10
;	
;-
Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,Dialog_Parent=group,  $
     ['CREATE_SUBSTRUCT: error caught: ',!err_string,$
      '','Returning structure unchanged.'] )
   Catch, /Cancel
   On_Error,2
   RETURN,strin
ENDIF

n_tags = N_Tags(strin)
names_tags = Tag_Names(strin)
IF N_Elements(indices) EQ 0 THEN indices = IndGen(n_tags)

strout=create_struct(names_tags[indices[0]],strin.(indices[0]))
IF N_Elements(indices) GT 1 THEN $
  FOR i=1,N_Elements(indices)-1 DO $
  strout=Create_Struct(strout,names_tags[indices[i]],strin.(indices[i]))

RETURN,strout
END
