
;+
; NAME:
;	CONIC_PTS2COEFFS
; PURPOSE:
;	this function calculates the conic coefficients
;       from a list of points along the conic curve
; CATEGORY:
;	Maths: conics
;
; CALLING SEQUENCE:
;	c=conic_pts2coeffs(X,Y)
; INPUTS:
;       X: array with abscissas
;       Y: array with ordinates
; OUTPUTS:
;	c:  An 6-dim array with the quadric coefficients: 
;           c[0] + c[1] y + c[2] x + c[3] x y + c[4] y^2 + c[5] x^2
;	
; MODIFICATION HISTORY:
;	by M. Sanchez del Rio. ESRF. Grenoble, Nov 2007
;-	
FUNCTION conic_pts2coeffs,XC,YC

;


npoints = N_Elements(XC)
IF N_Elements(YC) NE npoints THEN Message, $
  'Error: YC must have the same dimension as XC'


CASE npoints OF
  3: BEGIN ; circle
       ;
       ; calculate coefficients of circunference:
       ; c[0] + c[1] y + c[2] x + c[3] x y + c[4] y^2 + c[5] x^2
       ; in circle: c[3]=0, c[4]=c[5]
       ;
       x1=Double(XC[0]) & y1=Double(YC[0])
       x2=Double(XC[1]) & y2=Double(YC[1])
       x3=Double(XC[2]) & y3=Double(YC[2])

       c = $
          [-(x2^2*x3*y1) + x2*x3^2*y1 + x1^2*x3*y2 -  $
             x1*x3^2*y2 + x3*y1^2*y2 - x3*y1*y2^2 -  $
             x1^2*x2*y3 + x1*x2^2*y3 - x2*y1^2*y3 +  $
             x1*y2^2*y3 + x2*y1*y3^2 - x1*y2*y3^2, $
             x1^2*x2 - x1*x2^2 - x1^2*x3 + x2^2*x3 + x1*x3^2 -  $
             x2*x3^2 + x2*y1^2 - x3*y1^2 - x1*y2^2 + x3*y2^2 +  $
             x1*y3^2 - x2*y3^2, $
             x2^2*y1 - x3^2*y1 - x1^2*y2 + x3^2*y2 - y1^2*y2 +  $
             y1*y2^2 + x1^2*y3 - x2^2*y3 + y1^2*y3 - y2^2*y3 -  $
             y1*y3^2 + y2*y3^2, 0,  $
             -(x2*y1) + x3*y1 + x1*y2 - x3*y2 - x1*y3 + x2*y3, $
             -(x2*y1) + x3*y1 + x1*y2 - x3*y2 - x1*y3 + x2*y3]


       c = c/c[5] ; normalize coeff (x^2+y^2) to 1
     END
  4: BEGIN ; unrotated ellipse
       ;
       ; calculate coefficients of circunference:
       ; c[0] + c[1] y + c[2] x + c[3] x y + c[4] y^2 + c[5] x^2
       ; here c[3]=0
       ;
       ;
       x1=Double(XC[0]) & y1=Double(YC[0])
       x2=Double(XC[1]) & y2=Double(YC[1])
       x3=Double(XC[2]) & y3=Double(YC[2])
       x4=Double(XC[3]) & y4=Double(YC[3])


       c = [$
             x3*(x4^2*y1*(y1 - y2)*y2 +  $
            y4*(x1^2*y2*(y2 - y4) + x2^2*y1*(-y1 + y4))) +  $
         x3^2*(x4*y1*y2*(-y1 + y2) +  $
            y4*(x2*y1*(y1 - y4) + x1*y2*(-y2 + y4))) +  $
         y3*(-(x1*(x1 - x4)*x4*y2*(y2 - y3)) +  $
            x2^2*(x4*y1*(y1 - y3) + x1*(y3 - y4)*y4) +  $
            x2*(x4^2*y1*(-y1 + y3) + x1^2*y4*(-y3 + y4))), $
        x1*(x1 - x4)*x4*(y2^2 - y3^2) +  $
         x3^2*(x4*(y1^2 - y2^2) + x1*(y2^2 - y4^2)) +  $
         x2*(x4^2*(y1^2 - y3^2) + x1^2*(y3^2 - y4^2) +  $
            x3^2*(-y1^2 + y4^2)) +  $
         x3*(x4^2*(-y1^2 + y2^2) + x1^2*(-y2^2 + y4^2)) $
         +  $
         x2^2*(x4*(-y1^2 + y3^2) + x3*(y1^2 - y4^2) +  $
            x1*(-y3^2 + y4^2)), $
        -(x4^2*(y1 - y2)*(y1 - y3)*(y2 - y3)) +  $
         x3^2*(y1 - y2)*(y1 - y4)*(y2 - y4) -  $
         (x2^2*(y1 - y3)*(y1 - y4) -  $
            x1^2*(y2 - y3)*(y2 - y4))*(y3 - y4),0, $
        -(x1*(x1 - x4)*x4*(y2 - y3)) +  $
         x3*(x4^2*(y1 - y2) + x1^2*(y2 - y4)) +  $
         x2^2*(x4*(y1 - y3) + x1*(y3 - y4) + x3*(-y1 + y4)) +  $
         x3^2*(x4*(-y1 + y2) + x1*(-y2 + y4)) +  $
         x2*(x4^2*(-y1 + y3) + x3^2*(y1 - y4) +  $
            x1^2*(-y3 + y4)), $
        x4*(y1 - y2)*(y1 - y3)*(y2 - y3) -  $
         x3*(y1 - y2)*(y1 - y4)*(y2 - y4) +  $
         (x2*(y1 - y3)*(y1 - y4) - x1*(y2 - y3)*(y2 - y4))* $
          (y3 - y4)]




     END
  5: BEGIN ; ellipse
       ;
       ; calculate coefficients of circunference:
       ; c[0] + c[1] x + c[2] y + c[3] x^2 + c[4] y^2
       ;
       x1=Double(XC[0]) & y1=Double(YC[0])
       x2=Double(XC[1]) & y2=Double(YC[1])
       x3=Double(XC[2]) & y3=Double(YC[2])
       x4=Double(XC[3]) & y4=Double(YC[3])
       x5=Double(XC[4]) & y5=Double(YC[4])
       c = $
    [y2*(x1*x4*x5*(y2 - y3)*y3* $
             (x5*(y1 - y4) + x1*(y4 - y5) + x4*(-y1 + y5)) +  $
            x3*(-(x1*x5*(y2 - y4)*y4* $
                  (x5*(y1 - y3) + x1*(y3 - y5))) +  $
               x4*(y3 - y4)* $
                (x5^2*y1*(y1 - y2) + x1^2*(y2 - y5)*y5) +  $
               x4^2*(-(x5*y1*(y1 - y2)*(y3 - y5)) +  $
                  x1*(y1 - y3)*(y2 - y5)*y5)) +  $
            x3^2*(x1*x5*(y2 - y4)*y4*(y1 - y5) +  $
               x4*(x5*y1*(y1 - y2)*(y4 - y5) -  $
                  x1*(y1 - y4)*(y2 - y5)*y5))) +  $
         x2^2*(x3*(x5*y1*(y1 - y4)*y4*(y3 - y5) +  $
               (-(x4*y1*(y3 - y4)*(y1 - y5)) -  $
                  x1*(y1 - y3)*y4*(y4 - y5))*y5) +  $
            y3*(-(x1*x5*(y3 - y4)*y4*(y1 - y5)) +  $
               x4*(-(x5*y1*(y1 - y3)*(y4 - y5)) +  $
                  x1*(y1 - y4)*(y3 - y5)*y5))) +  $
         x2*(x4^2*(x5*y1*(y1 - y3)*y3*(y2 - y5) +  $
               (-(x3*y1*(y2 - y3)*(y1 - y5)) -  $
                  x1*(y1 - y2)*y3*(y3 - y5))*y5) +  $
            y4*(x1*x5*y3*(y3 - y4)* $
                (x5*(y1 - y2) + x1*(y2 - y5)) +  $
               x3*(y2 - y3)* $
                (x5^2*y1*(y1 - y4) + x1^2*(y4 - y5)*y5) +  $
               x3^2*(-(x5*y1*(y1 - y4)*(y2 - y5)) +  $
                  x1*(y1 - y2)*(y4 - y5)*y5)) -  $
            x4*(y2 - y4)*(x5^2*y1*(y1 - y3)*y3 +  $
               y5*(x1^2*y3*(y3 - y5) + x3^2*y1*(-y1 + y5)))), $  ; indep
        x3*x4*x5*(y1^2 - y2^2)* $
          (x5*(-y3 + y4) + x4*(y3 - y5) + x3*(-y4 + y5)) +  $
         x1*(x4*x5*(y2^2 - y3^2)* $
             (x5*(-y1 + y4) + x4*(y1 - y5)) -  $
            x3*(y1 - y3)*(x5^2*(-y2^2 + y4^2) +  $
               x4^2*(y2^2 - y5^2)) +  $
            x3^2*(-(x5*(y2^2 - y4^2)*(y1 - y5)) +  $
               x4*(y1 - y4)*(y2^2 - y5^2))) +  $
         x1^2*(-(x4*x5*(y2^2 - y3^2)*(y4 - y5)) +  $
            x3*(x5*(y2^2 - y4^2)*(y3 - y5) -  $
               x4*(y3 - y4)*(y2^2 - y5^2))) +  $
         x2^2*(x4*x5*(y1^2 - y3^2)*(y4 - y5) +  $
            x1*(x5*(y3^2 - y4^2)*(y1 - y5) -  $
               x4*(y1 - y4)*(y3^2 - y5^2)) +  $
            x3*(-(x5*(y1^2 - y4^2)*(y3 - y5)) +  $
               x4*(y3 - y4)*(y1^2 - y5^2) +  $
               x1*(y1 - y3)*(y4^2 - y5^2))) +  $
         x2*(-(x1*x5*(y3^2 - y4^2)* $
               (x5*(y1 - y2) + x1*(y2 - y5))) +  $
            x4*(y2 - y4)*(x5^2*(y1^2 - y3^2) +  $
               x1^2*(y3^2 - y5^2)) +  $
            x4^2*(-(x5*(y1^2 - y3^2)*(y2 - y5)) +  $
               x1*(y1 - y2)*(y3^2 - y5^2)) +  $
            x3^2*(x5*(y1^2 - y4^2)*(y2 - y5) -  $
               x4*(y2 - y4)*(y1^2 - y5^2) -  $
               x1*(y1 - y2)*(y4^2 - y5^2)) +  $
            x3*(y2 - y3)*(x5^2*(-y1^2 + y4^2) +  $
               x4^2*(y1^2 - y5^2) + x1^2*(-y4^2 + y5^2))), $  ; y 
        x2*y2*(x5^2*(y1 - y3)*(y1 - y4)*(y3 - y4) -  $
            x4^2*(y1 - y3)*(y1 - y5)*(y3 - y5) +  $
            (x3^2*(y1 - y4)*(y1 - y5) -  $
               x1^2*(y3 - y4)*(y3 - y5))*(y4 - y5)) +  $
         x3^2*(-(x4*(y1 - y2)*y4*(y1 - y5)*(y2 - y5)) -  $
            (y2 - y4)*(x1*y1*(y2 - y5)*(y4 - y5) -  $
               x5*(y1 - y2)*(y1 - y4)*y5)) +  $
         x2^2*(x4*(y1 - y3)*y4*(y1 - y5)*(y3 - y5) -  $
            x3*y3*(y1 - y4)*(y1 - y5)*(y4 - y5) +  $
            (y3 - y4)*(x1*y1*(y3 - y5)*(y4 - y5) -  $
               x5*(y1 - y3)*(y1 - y4)*y5)) -  $
         (y2 - y3)*(x4*x5*(y1 - y2)*(y1 - y3)* $
             (-(x5*y4) + x4*y5) +  $
            x1^2*(x4*y4*(y2 - y5)*(y3 - y5) +  $
               x5*(y2 - y4)*(-y3 + y4)*y5) +  $
            x1*y1*(x5^2*(y2 - y4)*(y3 - y4) +  $
               x4^2*(y2 - y5)*(-y3 + y5))) +  $
         x3*y3*(x4^2*(y1 - y2)*(y1 - y5)*(y2 - y5) -  $
            (y2 - y4)*(x5^2*(y1 - y2)*(y1 - y4) +  $
               x1^2*(y2 - y5)*(-y4 + y5))), $    ; x 
        x4^2*(x5*(y1 - y2)*(y1 - y3)*(y2 - y3) +  $
            (x2*(y1 - y3)*(y1 - y5) - x1*(y2 - y3)*(y2 - y5))* $
             (y3 - y5)) +  $
         x4*(-(x5^2*(y1 - y2)*(y1 - y3)*(y2 - y3)) -  $
            (x2^2*(y1 - y3)*(y1 - y5) -  $
               x1^2*(y2 - y3)*(y2 - y5))*(y3 - y5)) +  $
         x3^2*(-(x5*(y1 - y2)*(y1 - y4)*(y2 - y4)) +  $
            x4*(y1 - y2)*(y1 - y5)*(y2 - y5) -  $
            (x2*(y1 - y4)*(y1 - y5) - x1*(y2 - y4)*(y2 - y5))* $
             (y4 - y5)) +  $
         x3*(x5^2*(y1 - y2)*(y1 - y4)*(y2 - y4) -  $
            x4^2*(y1 - y2)*(y1 - y5)*(y2 - y5) +  $
            (x2^2*(y1 - y4)*(y1 - y5) -  $
               x1^2*(y2 - y4)*(y2 - y5))*(y4 - y5)) +  $
         (y3 - y4)*(-(x1*(x1 - x5)*x5*(y2 - y3)*(y2 - y4)) +  $
            x2*(-(x5^2*(y1 - y3)*(y1 - y4)) +  $
               x1^2*(y3 - y5)*(y4 - y5)) +  $
            x2^2*(x5*(y1 - y3)*(y1 - y4) +  $
               x1*(y3 - y5)*(-y4 + y5))), $  ; x y
        x2*(-(x3*(y2 - y3)* $
               (x5^2*(-y1 + y4) + x4^2*(y1 - y5))) +  $
            x4*x5*(y1 - y3)*(x5*(-y2 + y4) + x4*(y2 - y5)) +  $
            x3^2*(x4*(y2 - y4)*(y1 - y5) -  $
               x5*(y1 - y4)*(y2 - y5))) +  $
         x2^2*(x3*(-(x4*(y3 - y4)*(y1 - y5)) +  $
               x5*(y1 - y4)*(y3 - y5)) -  $
            x4*x5*(y1 - y3)*(y4 - y5)) +  $
         x1^2*(x3*(x4*(y3 - y4)*(y2 - y5) -  $
               x5*(y2 - y4)*(y3 - y5)) +  $
            x2*(x5*(y3 - y4)*(y2 - y5) -  $
               x4*(y2 - y4)*(y3 - y5) + x3*(y2 - y3)*(y4 - y5))  $
             + x4*x5*(y2 - y3)*(y4 - y5)) +  $
         x3*x4*x5*(y1 - y2)* $
          (x5*(y3 - y4) + x3*(y4 - y5) + x4*(-y3 + y5)) +  $
         x1*(x4*(y1 - y4)*(x5^2*(y2 - y3) + x2^2*(y3 - y5)) +  $
            x4^2*(-(x5*(y2 - y3)*(y1 - y5)) -  $
               x2*(y1 - y2)*(y3 - y5)) +  $
            x3^2*(x5*(y2 - y4)*(y1 - y5) -  $
               x4*(y1 - y4)*(y2 - y5) + x2*(y1 - y2)*(y4 - y5))  $
             + x2*x5*(y3 - y4)*(x5*(y1 - y2) + x2*(-y1 + y5)) +  $
            x3*(y1 - y3)*(x5^2*(-y2 + y4) + x4^2*(y2 - y5) +  $
               x2^2*(-y4 + y5))), $ ; y^2
        x3*((y2 - y4)*(x5*(y1 - y2)*(y1 - y4)*(y3 - y5) +  $
               x1*(y1 - y3)*(y2 - y5)*(y4 - y5)) -  $
            x4*(y1 - y2)*(y3 - y4)*(y1 - y5)*(y2 - y5)) -  $
         (y2 - y3)*(x1*(x5*(y2 - y4)*(-y3 + y4)*(y1 - y5) +  $
               x4*(y1 - y4)*(y2 - y5)*(y3 - y5)) +  $
            x4*x5*(y1 - y2)*(y1 - y3)*(y4 - y5)) +  $
         x2*(-(x5*(y1 - y3)*(y1 - y4)*(y3 - y4)*(y2 - y5)) +  $
            x4*(y1 - y3)*(y2 - y4)*(y1 - y5)*(y3 - y5) -  $
            (x3*(y2 - y3)*(y1 - y4)*(y1 - y5) +  $
               x1*(y1 - y2)*(y3 - y4)*(y3 - y5))*(y4 - y5)) $   ; x^2
            ]

     END
  else: Message,'Bad number od points'
ENDCASE

RETURN,c
END
