FUNCTION abscissas,fstart,fend,npoints
;+
; NAME:
;	ABSCISSAS
;
; PURPOSE:
;       This function returns a one dimensional array with a 
;	grid (useful to create abscissas axes)
;
; CATEGORY:
;	General utilities
;
; CALLING SEQUENCE:
;       x = Abscissas(fStart, fEnd, nPoints)
;
; INPUTS:
;       
;	fStart: the initial point (** WARNING: the type of returned
;		array is the same type of this input**)
;	fEnd: the end point
;	nPoints: the number of points
;
; KEYWORD PARAMETERS
;
; OUTPUTS:
;       This function return a 1-dim array of the same type of fStart
;
; PROCEDURE:
;       Easy.
;
; EXAMPLE:
;	x = Abscissas(5.0,10,100) & plot,x,x^2
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio (srio@esrf.fr), 99-12-23
;
;-

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!error_state.msg
   RETURN,0
ENDIF


IF npoints EQ 0 THEN RETURN,tmp
tmp = IndGen(npoints,TYPE=Type(fstart))
tmp = tmp/(npoints-1)*(fend-fstart)
tmp=tmp+fstart
RETURN,tmp

END ; Abscissas



