;+
;
;==============================  Xurgent   =====================================
;
; Xurgent is an widget based graphical interface to calculate
; spectra of an undulator insertion devices.
; 
; It interfaces the program URGENT written by R.P.Walker and B.Diviacco
; (see Help/Urgent)
;
; DESCRIPTION OF THE CONTROLS IN THE MAIN WINDOW:
;
;  File:
;    Xurgent input parameters: This option allows to save the current
;		parameters to a file for later loading. It also allows
;		to save the current parameters as defaults for being
;		used when the application is initialized. In the last
;		case, the file is named "application".xop (where 
;		"application " is the name of the current XOP
;		application) and is written in the directory pointed
;		by the XOP_DEFAULTS_DIR environment variable (which
;		must be set). The parameter file is ASCII and can be
;		read and edited with care.
;    Urgent file: This option allows to load/write the current parameter
;		and result files for further calculations. The used file
;		formats are those used by URGENT. Therefore, they
;		can be used to run URGENT without the interface or to
;		import URGENT files created outside the XUrgent application.
;    Write Files for XOP/Optics: Saves the current undulator
;		spectrum in the SRCOMPE (flux) and SRCOMPW (Power) files
;		to be used for the other XOP application from Optics
;		menu.
;  Quit: to exit from the program
;
; Set_Parameters:
;  K(gap) Tool: This tool permits to calculate the deflection
;		parameter K as a function of the magnet gap.
;  Set Parameters: to define the parameters for the calculation.
;		The same result is obtained pressing the "Set Parameters"
;		button in the main XUrgent window. 
;               Please refer to the information under the HELP
;		button for a complete description of the parameters. After 
;		pressing the ACCEPT button, URGENT starts running.
;  Set Defaults: Sets the default parameters.
;
;  Show: Display results
;    Plot Results: Plots the URGENT results.
;    Show Numerical Results: Displays the URGENT result file.
;
;  Help:   Shows the URGENT help and the XURGENT help (this text).
;
;
; COPYRIGHT:
;	XURGENT belongs to XOP package and it is distributed within XOP.
;	PLEASE REFER TO THE XOP COPYRIGHT NOTICE
;
; REFERENCE:
;	Published calculations made with XOP should refer:
;
;	M. Sanchez del Rio and R. J. Dejus 
;        "Status of XOP: an x-ray optics software toolkit"
;        SPIE Proceedings Vol. 5536 (2004) pp.171-174
;
;        http://dx.doi.org/10.1117/12.560903
;
;	In addition, published calculations using the URGENT aplication 
;	should also cite:
;
;	  R.P.Walker and B.Diviacco, "Urgent- A computer program for 
;	  calculating undulator radiation spectral, angular, polarization, 
;	  and power density properties.
;	  Rev. Sci. Instrum. 63(1), pp. 392-395, 1992.
;
; LAST MODIFICATION: srio@esrf.eu 2008-02-01
;
;
;-
; -----------------------------------------------------------------------
;       Author: M. Sanchez del Rio (srio@esrf.fr) , ESRF, Nov 1993
;       Modification history:
;       9/94    Francois Legrand (CEA Bruyeres-le-Chatel F-91680)
;               modified "show" menu to plot the results by xplot.
;       10/94   MSR removes common blocks, change the main window look,
;		adds the write/file(s) options and allows xplot graphics
;		for almost all the MODE options.
;		Now multiple copies of Xurgent can be run on the same
;		directory without interference!
;		Now it is also possible to run URGENT in background.
;	11/94 MSR upgrades for xop1.3beta: adds the K(gap) tool and
;		corrects the MODE=(-)6 result options. Eliminates the
;		QuickPlot option.
;	96/01/19 MSR changes labels Xtransmit -> XOP/Optics
;	96/04/29 MSR Changes xop_defaults and adds /ylog to xplot.
;	97/02/05 MSR Adds "help" button in parameters window. Modifies
;		the Br coeff in K(gap) tool and makes some fixes for
;		Windows95.
;	97/10/01 MSR renames read_ascii by rascii
;	97/10/02 MSR fixes a bug with MODE=1, makes use of xop_wd,/defaults,
;		sdep() and dialog_parent in widget_message.
;	97/10/08 MSR uses /SORTED in coor2matr to speed up plots.
;		Retrieves original !p.charsize in xwindow buffers.
;	97/10/27 MSR updated doc.
;	97/11/10 MSR extracts K(GAP) Tool as standalone application.
;	98/11/25 MSR adds the new input file system (xop2.0). Use of
;		catch. Version 1.3. Update menu bar.
;	00/06/14 MSR removes possibility to run several windows.
;		Version 1.5
;
;
;
;=========================================================================
;
FUNCTION xurgent_version
;
RETURN,'1.5'
END ; xurgent_version

;
;=========================================================================
;
; procedure xurgent_mode6: make plots when MODE=+/-6
pro xurgent_mode6,file,inpstr, Group=group
;
imode = -6
iharm = inpstr.iharm ;-3

widget_control,/HOURGLASS

if iharm GT 0 then begin
    data = rascii(file)
    bf0=['a0=!p.charsize','!p.charsize=1.5']
    bf1_1=['coor2matr,/sorted,data(0:2,*),z,x,y', $
       "surface,z,x,y,xtitle='X mm\mrad',ytitle='Y mm\mrad',ztitle='E [eV]'"]
    bf1_2=['coor2matr,/sorted,data([0,1,3],*),z,x,y', $
       "surface,z,x,y,xtitle='X mm\mrad',ytitle='Y mm\mrad',ztitle= 'Power Density'"]
    bf1_3=['coor2matr,/sorted,data([0,1,4],*),z,x,y', $
       "surface,z,x,y,xtitle='X mm\mrad',ytitle='Y mm\mrad',ztitle= 'Phot/sec '"]
    bf2=["xyouts,.4,.9,'Harmonic "+strcompress(iharm,/rem)+ $
     "',/norm,chars=2.",'!p.charsize=a0']
    widget_control,/hourglass
    xwindow,buffer=[bf0,bf1_1,bf2],data=data, group=group,Edit=2,$
	Wtitle='Urgent results'
    xwindow,buffer=[bf0,bf1_2,bf2],data=data, group=group,Edit=2,$
	Wtitle='Urgent results'
    xwindow,buffer=[bf0,bf1_3,bf2],data=data, group=group,Edit=2,$
	Wtitle='Urgent results'
    return
endif


;
; multiple plots
;
h_start = intarr(abs(iharm))
for i=0,abs(iharm)-1 do $
 h_start(i) = fileposition(file,' HARMONIC   '+strcompress(i+1,/rem))

hs_start = fileposition(file,' HARMONICS')
histo_start = fileposition(file,'HARMONIC    E (EV)')
total_start = fileposition(file,'TOTAL :')

  menutxt = 'harmonic '+ string ( LINDGEN(abs(iharm)) + 1 )
  menutxt = [menutxt,'All harmonics','Histogram']
  imenu = wmenu2(menutxt,Dialog_Parent=group)
  if imenu LE abs(iharm)-2 then $
    filesubset,file,'xurgent.tmp',[h_start(imenu),h_start(imenu+1)-1]
  if imenu EQ abs(iharm)-1 then $
    filesubset,file,'xurgent.tmp',[h_start(imenu),hs_start-1]
  if imenu EQ abs(iharm) then $
    filesubset,file,'xurgent.tmp',[hs_start,histo_start-1]
  if imenu EQ abs(iharm)+1 then $
    filesubset,file,'xurgent.tmp',[histo_start,total_start-1]

  if imenu LE abs(iharm)-1 then begin	; individual harmonics
    data = rascii('xurgent.tmp')
    bf0=['a0=!p.charsize','!p.charsize=3.0']
    bf1_1=['coor2matr,/sorted,data(0:2,*),z,x,y', $
       "surface,z,x,y,xtitle='X mm\mrad',ytitle='Y mm\mrad',ztitle='E [eV]'"]
    bf1_2=['coor2matr,/sorted,data([0,1,3],*),z,x,y', $
       "surface,z,x,y,xtitle='X mm\mrad',ytitle='Y mm\mrad',ztitle='Power Density'"]
    bf1_3=['coor2matr,/sorted,data([0,1,4],*),z,x,y', $
       "surface,z,x,y,xtitle='X mm\mrad',ytitle='Y mm\mrad',ztitle='Phot/sec '"]
    bf2=["xyouts,.4,.9,'Harmonic "+strcompress(imenu+1,/rem)+ $
     "',/norm,chars=2.",'!p.charsize=a0']
    widget_control,/hourglass
    xwindow,buffer=[bf0,bf1_1,bf2],data=data, group=group,Edit=2,$
	Wtitle='Urgent results'
    xwindow,buffer=[bf0,bf1_2,bf2],data=data, group=group,Edit=2,$
	Wtitle='Urgent results'
    xwindow,buffer=[bf0,bf1_3,bf2],data=data, group=group,Edit=2,$
	Wtitle='Urgent results'
  endif    
  if imenu EQ abs(iharm) then begin	; all harmonics
    widget_control,/hourglass
    data = rascii('xurgent.tmp')
    bf0=['a0=!p.charsize','!p.charsize=2.0']
    bf1_1=['coor2matr,/sorted,data(0:2,*),z,x,y', $
       "surface,z,x,y,xtitle='X mm\mrad',ytitle='Y mm\mrad',ztitle='Power Density'"]
    bf1_2=['coor2matr,/sorted,data([0,1,3],*),z,x,y', $
       "surface,z,x,y,xtitle='X mm\mrad',ytitle='Y mm\mrad',ztitle='Phot/sec'"]
    bf2=["xyouts,.4,.9,'All Calculated Harmonics ',/norm,chars=2.", $
	'!p.charsize=a0']
    xwindow,buffer=[bf0,bf1_1,bf2],data=data, group=group,Edit=2,$
	Wtitle='Urgent results'
    xwindow,buffer=[bf0,bf1_2,bf2],data=data, group=group,Edit=2,$
	Wtitle='Urgent results'
  endif
  if imenu EQ abs(iharm)+1 then begin
    data = rascii('xurgent.tmp')
    bf0=['!p.charsize=0','!p.multi=[0,2,2]']
    bf1=["boxchart,data(2,*)*100./total(data(2,*)),"+ $
	"xtitle='Harmonic',ytitle='Power Density (% of total)',"+$
	"names="+vect2string(strcompress(indgen(abs(iharm))+1,/rem))]
    bf1=[bf1,"boxchart,data(4,*)*100./total(data(4,*)),"+ $
	"xtitle='Harmonic',ytitle='Flux (% of total)',"+$
	"names="+vect2string(strcompress(indgen(abs(iharm))+1,/rem))]
    bf1=[bf1,"boxchart,data(3,*)*100./total(data(3,*)),"+ $
	"xtitle='Harmonic',ytitle='Power (% of total)',"+$
	"names="+vect2string(strcompress(indgen(abs(iharm))+1,/rem))]
    bf2=["xyouts,.55,.4,/norm,charsize=1.2,'Total Power Density: "+ $
	strcompress(total(data(2,*)),/rem)+" Watts/(mm\mrad)^2'"]
    bf2=[bf2,"xyouts,.55,.2,/norm,charsize=1.2,'Total Flux: "+ $
	strcompress(total(data(4,*)),/rem)+" Phot/sec'"]
    bf2=[bf2,"xyouts,.55,.3,/norm,charsize=1.2,'Total Power: "+ $
	strcompress(total(data(3,*)),/rem)+" Watts'"]
    bf3=['!p.multi=0']
    xwindow,buffer=[bf0,bf1,bf2,bf3],data=data, group=group,Edit=2,$
	Wtitle='Urgent results'
  endif
  Delete_Files,'xurgent.tmp',Group=group

end ; xurgent_mode6


; 
;
;=======================================================================
;
FUNCTION  XURGENT_INP_READ,file,struct
;
; read an Urgent input file, ans stores the result in struct
;
; the returned value is the error flag: 
;
on_error,2
catch,error_status

if error_status NE 0 then begin
  print,'XURGENT_INP_READ: Error reading urgent input file.'
  return,error_status
endif


openr,Unit,file,/get_lun
;
line1 = fltarr(6)
line2 = fltarr(3)
line3 = fltarr(6)
line4 = fltarr(7)
line5 = fltarr(3)
line6 = fltarr(6)
readf,Unit, line1
readf,Unit, line2
readf,Unit, line3
readf,Unit, line4
readf,Unit, line5
readf,Unit, line6
free_lun,Unit
;
struct = xop_defaults('xurgent')
;
; write the read values into the structure tags
;
struct.TITLE= 'Urgent input file: '+file
struct.ITYPE= fix( line1(0) )
struct.PERIOD= line1(1)
struct.KX= line1(2)
struct.KY= line1(3)
struct.PHASE= line1(4)
struct.N= fix( line1(5) )
struct.EMIN= line2(0)
struct.EMAX= line2(1)
struct.NENERGY= line2(2)
struct.ENERGY= line3(0)
struct.CUR= line3(1)
struct.SIGX= line3(2)
struct.SIGY= line3(3)
struct.SIGX1= line3(4)
struct.SIGY1= line3(5)
struct.D= line4(0)
struct.XPC= line4(1)
struct.YPC= line4(2)
struct.XPS= line4(3)
struct.YPS= line4(4)
struct.NXP= line4(5)
struct.NYP= line4(6)
struct.MODE= fix( line5(0) )
struct.ICALC= fix( line5(1) )
struct.IHARM= fix( line5(2) )
struct.NPHI= fix( line6(0) )
struct.NSIG= fix( line6(1) )
struct.NALPHA= fix( line6(2) )
struct.DALPHA= line6(3)
struct.NOMEGA= fix( line6(4) )
struct.DOMEGA= fix( line6(5) )
; i_out = 0     ; successful completation of work
return,error_status
end 
;
;
;=======================================================================
;
PRO XURGENT_INP_WRITE,urinpstr,NAME=name
;
; write the contents of the structure with parameters for running URGENT
;
IF NOT(KEYWORD_SET(name)) THEN name='urgent.inp'
;
OPENW,unit,name,/GET_LUN

  PrintF,unit,STRCOMPRESS(urinpstr.ITYPE,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.PERIOD,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.KX,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.KY,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.PHASE,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.N,/REMOVE_ALL)

  PrintF,unit,STRCOMPRESS(urinpstr.EMIN,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.EMAX,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.NENERGY,/REMOVE_ALL)

  PrintF,unit,STRCOMPRESS(urinpstr.ENERGY,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.CUR,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.SIGX,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.SIGY,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.SIGX1,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.SIGY1,/REMOVE_ALL)

  PrintF,unit,STRCOMPRESS(urinpstr.D,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.XPC,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.YPC,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.XPS,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.YPS,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.NXP,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.NYP,/REMOVE_ALL)

  PrintF,unit,STRCOMPRESS(urinpstr.MODE,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.ICALC,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.IHARM,/REMOVE_ALL)

  PrintF,unit,STRCOMPRESS(urinpstr.NPHI,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.NSIG,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.NALPHA,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.DALPHA,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.NOMEGA,/REMOVE_ALL)
  PrintF,unit,STRCOMPRESS(urinpstr.DOMEGA,/REMOVE_ALL)
FREE_LUN,unit
;
END
;
;=======================================================================
;
PRO xurgent_out_read,filein,data,urinpstr,ERROR=error
;
;
; read an URGENT output file and returns the numerical data and
; (optionally) a structure with the input parameters. 
;
;
;	    ERROR: error flag set to 1 if completed correctly. MUST
;		BE INITILIZED BEFORE to -1
;
on_error,2
catch, error
if error NE 0 then begin
  print,'XURGENT_OUT_READ: Error reading urgent output file.'
  return
endif
npp = n_params()
if npp LT 2 then begin
  print, $
   'XURGENT_OUT_READ: Usage: XURGENT_OUT_READ,filename,arrayout[,inpstr]'
  return
endif
;
;if sdep() EQ 'WINDOWS' then skip = 9 else skip = 0
skip = 0
data = rascii(filein,header=header,skip=skip)
;header = header(9:n_elements(header)-1)
newdata=strarr(8)
;
; extracts from the header the useful information
;
for i=1,8 do begin
 ;
 ; eliminate alphabetic characters
 ;
 line = byte(header(i))
 ; for undulator or cross undulator check if the first character
 ; is a "U" or a "C" and replace by a "1" or "2" respectively
 if i eq 1 then begin
   if line(1) eq 85 then line(1)=byte('1') else line(1)=byte('2')
 endif
 lineup = byte(strupcase(string(line)))
 linelow = byte(strlowcase(string(line)))
 linenew = abs ( fix(lineup) - fix(linelow))
 line = line ( where (linenew eq 0))  
 ; eliminare = and :
 line = line ( where (line ne 61) )
 line = line ( where (line ne 58) )
 newdata(i-1) = strcompress(string(line))
endfor

if npp EQ 3 then begin   ;optionally gets the input urgent structure
  ;
  ; write the urgent input file
  ;
  openw,unit,'xopxur.tmp',/get_lun
   printf,unit,''
   printf,unit,newdata(0)
   printf,unit,newdata(1)
   ; the line 3 is a little conflictive
   tmp = strparse(newdata(3),' ',list)
   printf,unit,newdata(2),list([0,1,3,5]) 
   ;
   printf,unit,newdata(4)+newdata(5)
   printf,unit,newdata(6)
   printf,unit,newdata(7)
   printf,unit,''
  free_lun,unit
  ;
  ; store the file in a structure
  ;
  k_err = -1
    k_err = XURGENT_INP_READ('xopxur.tmp',urinpstr)
    if k_err lt 0 then $
      print,'XURGENT_OUT_READ: error when calling XURGENT_INP_READ'
  ;if sdep() EQ 'WINDOWS' then command = 'rm xopxur.tmp' else $
  ;  command = '/bin/rm -f xopxur.tmp'
  ;message,/info,'Executing: '+command  
  ;spawn,command
  Delete_Files,'xopxur.tmp'
endif

end ; xurgent_out_read
;
;
;=======================================================================
;
PRO XURGENT_RUN,state,GROUP=group
;
; set the input parameters for URGENT and run it
;
;
;WIDGET_CONTROL,Event.top,GET_UVALUE=state
urinpstr = state.urinpstr


action = ''
job=-1
XUrgent_Set,urinpstr,Action=action,Job=job,Group=group

IF (action EQ 'ACCEPT') THEN BEGIN
  tmp=state.urinpstr
  Copy_Structure,urinpstr,tmp
  state.urinpstr=tmp
  filein = 'urgent.inp'
  XURGENT_INP_WRITE,urinpstr,NAME= filein
  CASE job OF
  0: BEGIN
     Widget_control,/HourGlass
     command = 'urgent < '+filein
     Print,'	--> URGENT calculation in process...'+$
	' please wait up to few minutes...'
     Xop_Spawn,command,CleanFiles=['urgent.out']
     for i=0,2 do print,string(7b)  ; ring the bell
     END
  1: BEGIN
     if sdep() EQ 'WINDOWS' then begin
       itmp = Dialog_Message(dialog_parent=group,$
	/ERROR,['This option is not implemented','under Windows.'])
       Return
     endif
     command=''
     Xop_Spawn,'urgent < '+filein,OnlyGetCommand=command
     openw,Unit,'xopxurgent.job',/Get_Lun
     printf,Unit,"echo ---------------------"
     printf,Unit,'echo "running: '+command+'"'
     printf,Unit,"echo ---------------------"
     printf,Unit,command
     printf,Unit,"/usr/bin/echo \\a"
     printf,Unit,"echo ---------------------"
     printf,Unit,"echo XUrgent job finished."
     printf,Unit,"echo ---------------------"
     ;printf,Unit,'xhelp -N "xurgent" -M "Urgent_job_completed"'
     printf,Unit,'/bin/rm -f xopxurgent.job'
     free_lun,Unit
     command = 'chmod 755 xopxurgent.job'
     print,command  
     spawn,command
     command = 'xterm -e ./xopxurgent.job &'
     print,command 
     Spawn,command
     END
  ENDCASE
ENDIF
;
END
;
;=======================================================================
;		
PRO XURGENT_PLOT,file,GROUP=group
;
; Plots the results of an urgent output file
;
on_error,2
;
; gets data and header structure
;
xurgent_out_read,file,data,inpstr,ERROR=error
if error NE 0 then begin
  tmp = Dialog_Message(dialog_parent=group,$
	/ERROR,['Urgent File not found.','Set Parameters', $
	'AND RUN URGENT.'])
  return
endif
title='URGENT2.0,  File: '+strcompress(file,/rem)+', Ky='+ $
  strcompress(inpstr.ky)
if (abs(inpstr.mode) NE 6) then $
if (inpstr.iharm eq (-1)) then title=title+', ALL HARMONICS' else if $
  (inpstr.iharm eq 0) then title=title+', LOWEST HARMONIC' else $
   title=title+', HARMONIC '+strcompress(inpstr.iharm,/REM)

wtitle='URGENT Results'
;
if (inpstr.mode eq 1) then begin
  if (inpstr.d le 1e-3) then begin
   title=title+', Angular Flux Density'
   xtitle='X [mrad]'
   ytitle='Y [mrad]'
   ztitle='Phot/sec/(mrad)^2/0.1% bw'
  endif else begin
   title=title+', Irradiance'
   xtitle='X [mm]'
   ytitle='Y [mm]'
   ztitle='Phot/sec/(mm)^2/0.1% bw'
  endelse
  title=title+', Photon Energy: '+strcompress(inpstr.emin,/REM)
  coor2matr,/sorted,data(0:2,*),z,x,y
  buffer=['a0 = !p.charsize','!p.charsize=1.5',$
    "surface,data.z,data.x,data.y,xtitle=data.xtitle,"+$
    "ytitle=data.ytitle,ztitle=data.ztitle",$
    'xyouts,.2,.9,data.title,/norm',$
    '!p.charsize=a0']
  xwindow,buffer=buffer,wtitle='URGENT results',Group=group,Edit=2,$
    data={x:x,y:y,z:z,title:title,xtitle:xtitle,ytitle:ytitle,ztitle:ztitle}
endif
;
if (inpstr.mode eq 2) then begin
  xtitle='Photon Energy [eV]'
  if (inpstr.d le 1e-3) then begin
    ytitle1='Phot/sec/mrad^2/0.1% bw'
    ytitle2='Watt/eV/mrad^2'
  endif else begin
    ytitle1='Phot/sec/mm^2/0.1% bw'
    ytitle2='Watt/eV/mm^2'
  endelse
  if keyword_set(group) then widget_control,group,sensitive=0
  imenu=wmenu2(['Cancel','Irradiance','Spectral Power Density'], $
	Dialog_Parent=group)
  if keyword_set(group) then widget_control,group,sensitive=1
  case imenu of
    0: return
    1: BEGIN
       title=title+', Irradiance'
       XPlot,data,YCOL=3,xtitle=xtitle,$
         ytitle=ytitle1,title=title,Wtitle=wtitle,/ylog
       END
    2: BEGIN
       title=title+', Spectral Power Density'
       xplot,data,YCOL=4,xtitle=xtitle,$
       ytitle=ytitle2,title=title,Wtitle='URGENT results',/ylog
       END
  endcase
endif
;
;
if (inpstr.mode eq 3) then begin
  xtitle='Photon Energy [eV]'
  ytitle='Phot/sec/mrad^2/mm^2/0.1% bw'
  xplot,data,YCOL=3,xtitle=xtitle,$
    ytitle=ytitle,title=title,Wtitle=wtitle,/ylog
endif
;
;
if ((inpstr.mode eq 4) or (inpstr.mode eq 5)) then begin
  xtitle='Photon Energy [eV]'
  ytitle1='Phot/sec/0.1% bw'
  ytitle2='Watt/eV'
  if keyword_set(group) then widget_control,group,sensitive=0
  imenu=wmenu2(['Cancel','Flux','Spectral Power'], $
	Dialog_Parent=group)
  if keyword_set(group) then widget_control,group,sensitive=1
  case imenu of
    0: return
    1: BEGIN
      xplot,data,YCOL=3,xtitle=xtitle,$
      ytitle=ytitle1,title=title,Wtitle=wtitle,/ylog
      END
    2: BEGIN
      xplot,data,YCOL=4,xtitle=xtitle,$
      ytitle=ytitle2,title=title,Wtitle='URGENT results' ,/ylog
      END
  endcase
endif
;
;
if ((inpstr.mode eq -6) OR (inpstr.mode eq 6)) then begin
  xurgent_mode6,file,inpstr, Group=group
endif
;
end


;
;=======================================================================
;		

PRO Xurgent_Event, Event


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=event.top, $
     'XURGENT_EVENT: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF

  WIDGET_CONTROL,Event.top,GET_UVALUE=state
  WIDGET_CONTROL,Event.id,GET_UVALUE=uval

; help,uval
  CASE uval OF 

  'FILEINPUT': BEGIN
    action=''
    Widget_Control,event.id, Get_Value=action
    CASE action OF
      'Load from file...': BEGIN
        ;if sdep() EQ 'UNIX' then filter='*.xop' else filter=0
	filter='*.xop'
        str_par = Xop_Input_Load(Title=$
        'Select Xurgent input file...',$
        /NoConf,Filter=filter,Group=event.top)
        IF Type(str_par) EQ 8 THEN BEGIN
          tmp = state.urInpStr
          Copy_Structure,str_par, tmp, Group=event.top ; , /OnlyFirstField
          state.urInpStr = tmp
        ENDIF
      END
      'Save to file...': BEGIN
        str_par = state.urInpStr
        Xop_Input_Save,str_par,File='xurgent.xop',$
          /Write, Group=event.top, Comment='; xop/xurgent(v'+$
        xurgent_version()+') input file on '+SysTime()
      END
      'Save as default': BEGIN
        str_par = state.urInpStr
        Xop_Input_Save,str_par,Group=event.top, $
          Default='xurgent.xop',Comment='; xop/xurgent(v'+$
        xurgent_version()+') input file on '+SysTime()
      END
    ENDCASE
  END

  'File.Load Urgent.Input File': BEGIN
    infile_old = ''
    filter='*.inp'
    infile=Dialog_PICKFILE(/READ,GROUP=event.top,/NOCONF,FILTER=filter)
    IF (infile_old NE infile) THEN BEGIN
      k_err = XURGENT_INP_READ(infile,tmp)
      IF k_err ne 0 THEN begin
        tmp = Dialog_Message(dialog_parent=event.top,/ERROR, $
	['',' Error reading file...',$
        ' This seems not an Urgent input file  '])
        return
      ENDIF
      tmp_to = state.urinpstr
      Copy_Structure,tmp,tmp_to
      state.urinpstr = tmp_to
    ENDIF
    END
  'File.Load Urgent.Output File': BEGIN
    ;PRINT, 'Event for File.Load Urgent.Output File'
    outfile_old = ''
    ;if sdep() EQ 'UNIX' then filter='*.out' else filter=0
    filter='*.xop'
    outfile=Dialog_PICKFILE(/READ,GROUP=event.top,/NOCONF,FILTER=filter)
    IF (outfile_old NE outfile) THEN BEGIN
      XURGENT_OUT_READ,outfile,data,tmp,ERROR=k_err
      IF k_err LT 0 THEN BEGIN
        tmp = Dialog_Message(dialog_parent=event.top,$
	/ERROR, ['',' Error reading file...',$
        ' This seems not an Urgent input file  '])
      ENDIF ELSE BEGIN
	Delete_Files,'urgent.out',group=event.top
	if sdep() EQ 'WINDOWS' then tmp = 'copy ' else tmp = 'cp '
        command= tmp+outfile+'  urgent.out'
        message,/info,'Executing: '+command
	spawn,command
      ENDELSE
    ENDIF
    END
  'File.Write Urgent.Input File': BEGIN
    ;PRINT, 'Event for File.Write Urgent.Input File'
    file = Dialog_pickfile(/WRITE,FILE='xurgent.inp',GROUP=Event.Top)
    if file NE '' then begin
      command = '/bin/cp urgent.inp '+file
      print,command  &  spawn,command
    endif
    END
  'File.Write Urgent.Output File': BEGIN
    ;PRINT, 'Event for File.Write Urgent.Output File'
    filein = 'urgent.out'
    if checkfile(filein) NE 1 then begin
      itmp = Dialog_Message(dialog_parent=event.top,/ERROR,$
	['File '+filein+' not found','Select Set_Parameters and run urgent.'])
      goto,out
    endif
    file = Dialog_pickfile(/WRITE,FILE='xurgent.out',GROUP=Event.Top)
    if file NE '' then begin
      command = '/bin/cp urgent.out '+file
      print,command  &  spawn,command
    endif
    END
  'File.Write Files for XOP/Optics': BEGIN
    ;PRINT, 'Event for File.Write Files for XOP/Optics'
    fileurgent = 'urgent.out'
    if checkfile(fileurgent) NE 1 then begin
      tmp = Dialog_Message(dialog_parent=event.top,$
	/ERROR,'Urgent Data not found.')
      goto,out
    endif
    if sdep() EQ 'WINDOWS' then begin
      openr,unit,fileurgent,/GET_LUN
      nlines = 0
      stmp = ''
      while not eof(unit) do begin
	readf,unit,stmp
	nlines = nlines+1
      endwhile
      free_lun,unit
    endif else begin
      spawn,'wc '+fileurgent,nlines
      nlines = fix(nlines)
    endelse
    nlines(0) = nlines(0) - 32
    if sdep() EQ 'WINDOWS' then nlines(0) = nlines(0) - 9
    ddata = fltarr(10,nlines(0)-3)
    tmp = fltarr(10)
    openr,Unit,fileurgent,/GET_LUN
    line = ' '
    if sdep() EQ 'WINDOWS' then for i=1,9 do readf,Unit,line
    for i=1,32 do readf,Unit,line
    imin=33
    imax=nlines(0)+33-4
    for i=imin,imax do begin
      readf,Unit,tmp
      ddata(*,i-33) = tmp
    endfor
    free_lun,Unit
    tmp1 = fltarr(2,n_elements(ddata(0,*)))
    tmp2 = tmp1
    tmp1(0,*) = ddata(0,*)
    tmp1(1,*) = ddata(2,*)
    tmp2(0,*) = ddata(0,*)
    tmp2(1,*) = ddata(3,*)
    ;
    openw,Unit,'SRCOMPE',/GET_LUN
    printf,Unit,tmp1
    free_lun,Unit
    ;
    openw,Unit,'SRCOMPW',/GET_LUN
    printf,Unit,tmp2
    free_lun,Unit
    print,'XURGENT: Files SRCOMPE and SRCOMPW written to disk'
    tmp = Dialog_Message(dialog_parent=event.top,$
	/INFO,['  Files SRCOMPE & SRCOMPW  ',$
    ' written to current directory '])
    END

  'File.Quit': BEGIN
    files = ['urgent.inp ','urgent.out']
    Delete_Files,files,Group=event.top
    widget_control,Event.Top,/DESTROY
    return
    END
  'K(gap) Tool': BEGIN
     tmp = state.urinpstr
     Br = state.Br
     Bp = state.Bp
     kgap_tool,inp=tmp,Br=Br,Bp=Bp
     state.urinpstr = tmp
     state.Br = Br
     state.Bp = Bp
     END
  'Set Parameters': BEGIN
    ;PRINT, 'Event for Set Paremeters'
    ;help,/str,state.urinpstr
    ;print,'***** calling XURGENT_RUN'
    widget_control,/hourglass
    XURGENT_RUN,state,group=event.top
    ;widget_control,event.top,set_uvalue=state ;,/NO_COPY
    ;print,'***** back from XURGENT_RUN'
    ;help,/str,state.urinpstr
    END
  'Set Defaults': BEGIN
    itmp = Dialog_Message(Dialog_Parent=event.top, $
      /Question,['This option initializes the',$
      'xurgent parameters to their default values.',$
      'Then you must click Set_parameters to run the program.',$
      'Please confirm'],title='xurgent: set defaults')
    IF itmp EQ 'No' THEN RETURN  ; GOTO,out
    state.urInpStr = state.urInpStr_Default
    END
  'Results.Plot': BEGIN
    ;PRINT, 'Event for Results.Plot'
    widget_control,/hourglass
    xurgent_plot,'urgent.out', GROUP=event.top
    END
  'Results.Show Numerical data': BEGIN
    ;PRINT, 'Event for Results.Show Numerical data'
      file = 'urgent.out'
      if checkfile(file) NE 1 then begin
        tmp = Dialog_Message(dialog_parent=event.top,$
	/ERROR,'Urgent data not found.')
        goto,out
      endif
      XDISPLAYFILE1,'urgent.out', $
	GROUP=event.top
    END
  'Results.Quick Plot': BEGIN
      file = 'urgent.out'
      if checkfile(file) NE 1 then begin
        tmp = Dialog_Message(dialog_parent=event.top,$
	/ERROR,'Urgent data not found.')
        goto,out
      endif
    ;PRINT, 'Event for Results.Quick Plot'
    ;SPAWN,'arch',machine 
    ;if machine(0) NE 'sun4' then begin
    ;  tmp = Dialog_Message(/ERROR,'Option available only in Sun')
    ;  goto,out
    ;endif
    ;dir_path = '$XOP_HOME/bin/'+STRCOMPRESS(machine,/REM)+'/'
    command = 'echo "1" | '+'xupl urgent.out'
    PRINT,'*************** starting xupl **********'
    PRINT,command  &  SPAWN,command
    PRINT,'*************** end xupl ***************
    END
  'Help.Urgent': BEGIN
     ds = SDep(/ds)
     file = DosPath(Xop_GetEnv('XOP_HOME'))+ds+'doc'+ds+'txt'+ds+'urgent.txt'
     XDISPLAYFILE1,file,GROUP=Event.Top, WIDTH=85
    END
  'Help.Xurgent': Xhelp,'xurgent',GROUP=event.top
  ENDCASE

out:
widget_control,event.top,set_uvalue=state,/NO_COPY
END
;
;===================================================================
;
PRO xurgent, GROUP=Group, InputFile=inputFile

Forward_Function xop_defaults
Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'XURGENT: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF

;
;go to the default XOP working directory when xrgent is not called
;from the main XOP window
;
; if not(keyword_set(group)) then xop_wd,/default

IF N_ELEMENTS(Group) EQ 0 THEN GROUP=0

IF XRegistered('xurgent') THEN RETURN


;
; widget definition
;
WTITLE='xurgent '+XUrgent_Version()
wWindow = Widget_base(title=Wtitle,MBAR=wMenuBar)	; base window

wBase = Widget_base(wWindow,/Column)	; base widget

;
; build the menu bar
;

wFileMenu =  WIDGET_BUTTON(wMenuBar, VALUE='File', /MENU)

  wtmp0 = widget_button(wFileMenu,VALUE='Xurgent input parameters', /Menu)
    wtmp = widget_button(wtmp0,VALUE='Load from file...',UValue='FILEINPUT')
    wtmp = widget_button(wtmp0,VALUE='Save to file...',UValue='FILEINPUT')
    wtmp = widget_button(wtmp0,VALUE='Save as default',UValue='FILEINPUT')

  wUrgentFile=WIDGET_BUTTON(wFileMenu, VALUE='Urgent file', /MENU)
    wtmp=WIDGET_BUTTON(wUrgentFile, VALUE='Load input file...', $
     Uvalue='File.Load Urgent.Input File')
    wtmp=WIDGET_BUTTON(wUrgentFile, VALUE='Load output file...', $
     Uvalue='File.Load Urgent.Output File')
    wtmp=WIDGET_BUTTON(wUrgentFile, VALUE='Write input File...', $
     Uvalue='File.Write Urgent.Input File')
    wtmp=WIDGET_BUTTON(wUrgentFile, VALUE='Write output File...', $
     Uvalue='File.Write Urgent.Output File')

  wtmp=WIDGET_BUTTON(wFileMenu, VALUE='Write Files for XOP/Optics', $
    Uvalue='File.Write Files for XOP/Optics')

  wtmp=WIDGET_BUTTON(wFileMenu, VALUE='Quit', Uvalue= 'File.Quit',/Sep)



;========
;  wtmp = widget_button(wButtons,Value='K(gap) Tool',Uvalue='K(gap) Tool')
;  wtmp = widget_button(wButtons,Value='Set Parameters',Uvalue='Set Parameters')
;  wtmp = widget_button(wButtons,Value='Plot Results',Uvalue='Results.Plot')
;  wtmp = widget_button(wButtons,Value='Show Numerical Results',Uvalue= $
;     'Results.Show Numerical data')


wSetParameters = widget_button(wMenuBar,VALUE='Set_Parameters', /MENU)
  wtmp = widget_button(wSetParameters,VALUE='K(Gap) Tool', $
	UVALUE='K(gap) Tool')
  wtmp = widget_button(wSetParameters,VALUE='Set Parameters', $
	UVALUE='Set Parameters')
  wtmp = widget_button(wSetParameters,VALUE='Set Defaults', $
	UVALUE='Set Defaults')

wResults = widget_button(wMenuBar,VALUE='Show',/MENU)
  wSpec = widget_button(wResults,VALUE='Plot Results',UVALUE='Results.Plot')
  wTraj = widget_button(wResults,VALUE='Show Numerical Results', $
	UVALUE='Results.Show Numerical data')


;========


;wResultsMenu =  WIDGET_BUTTON(wMenuBar, VALUE='Results', /MENU)
;  wtmp=WIDGET_BUTTON(wResultsMenu, VALUE='Plot', Uvalue='Results.Plot')
;  wtmp=WIDGET_BUTTON(wResultsMenu, VALUE='Show Numerical data', Uvalue= $
;   'Results.Show Numerical data')

wHelpMenu = WIDGET_BUTTON(wMenuBar, VALUE='Help', /HELP)
  wHelptmp = WIDGET_BUTTON(wHelpMenu, VALUE='Urgent', UVALUE='Help.Urgent')
  wHelptmp = WIDGET_BUTTON(wHelpMenu, VALUE='Xurgent', UVALUE='Help.Xurgent')
;
; build the buttons panel
;


  wtmp = widget_button(wBase,Value='Set Parameters',Uvalue='Set Parameters')

;  wButtons = widget_base(wBase,/Row)
;  wtmp = widget_button(wButtons,Value='K(gap) Tool',Uvalue='K(gap) Tool')
;  wtmp = widget_button(wButtons,Value='Set Parameters',Uvalue='Set Parameters')
;  wtmp = widget_button(wButtons,Value='Plot Results',Uvalue='Results.Plot')
;  wtmp = widget_button(wButtons,Value='Show Numerical Results',Uvalue= $
;     'Results.Show Numerical data')

;if sdep() EQ 'WINDOWS' then font = 'VERDANA*BOLD*ITALIC*36' else $
;  font='-b&h-lucida-bold-i-normal-sans-24-240-75-75-p-151-iso8859-1'

if sdep() EQ 'WINDOWS' then font = 'VERDANA*BOLD*ITALIC*24' else  $
  font = '-adobe-helvetica-bold-o-normal--18-180-75-75-p-104-iso8859-1'

  tmp = WIDGET_LABEL( wBase, FONT= font, VALUE='      URGENT      ')
  tmp = WIDGET_LABEL( wBase, FONT= font, $
	VALUE='    Undulator Radiation   ')
;
;
  WIDGET_CONTROL, wWindow, /REALIZE
;
 urinpstr = xop_defaults('xurgent')


 urinpstr_default = urinpstr
 IF KeyWord_Set(inputFile) THEN BEGIN
   str_par = Xop_Input_Load(InputFile=inputFile)
   IF Type(str_par) EQ 8 THEN BEGIN
     tmp = urinpstr
     Copy_Structure,str_par, tmp, Group=group
     urinpstr = tmp
   ENDIF
 ENDIF

 job = 0 ; 0=foreground 1=background
 state = {urinpstr:urinpstr, $
   urinpstr_default:urinpstr_default, br:1.57, Bp:!pi, job:job }
 Widget_Control, wWindow, Set_Uvalue=state,/NO_COPY
 XMANAGER, 'xurgent', wWindow, Group=group

END ; xurgent
