;
;=====================================================================
;
FUNCTION EDF_GetKeyword,inpdata,kwname,headernumber=headernumber, $
   lineindex=lineindex
;
; this function extracts from a inpdata (a strarr with one keyword 
; per line, as result of READHEADER) the value of a given keyword. The result
; is string type. The output is 'ErrorFindingKeyword' if the keyword is
; not found.   MSR 21-June-1993
;
; the input may be a file name, a file map, a bytearray with the
; header or a textarray with the header text
;
; srio@esrf.fr 99/11/16 renamed from getkeywordval to edf_getkeyword.
; srio@esrf.fr 2002/07/18 bug fixed when multiple lines found for the same
;	keyword
; srio@esrf.fr 2004/07/23 added lineindex kw
;
on_error,2
;
; search for the keyword
;
if not(keyword_set(headernumber)) then headernumber=0
;
headertype = type(inpdata)
;
; if type is a file
;
; 
if (headertype eq 7 and n_elements(inpdata) eq 1) then begin
  edf_analyzer,inpdata,filemap
endif
;
; if file is a filemap (structure)
;
if (headertype eq 8) then filemap = inpdata
;
; extracts from the inpdata the text to analyze and put it in header
;
if ( (headertype eq 7) and (n_elements(inpdata) gt 1) ) then begin
  header = inpdata
endif else begin
  ;
  ; first build the byte array
  ;
  if (headertype eq 1 ) then begin
    bytedata = indata 
  endif else begin
    bytedata = edf_extract(filemap, header = '0')
    if (headernumber ne 0) then bytedata = $
		[bytedata,byte(10),edf_extract(filemap,header=headernumber)]
  endelse  
  ; 
  ; now convert to text
  ;
  header = bytetotext(bytedata)
endelse

;
; now process the header

headernew = strlowcase(header)
kwnamenew = strlowcase(kwname)
out='ErrorFindingKeyword'
for i=0,n_elements(headernew)-1 do begin
  a1 = strpos(headernew(i),kwnamenew)
  if (a1 ge 0) then begin
   tt1 = strpos(headernew(i),'=')
   tt2 = strlen(headernew(i)) - tt1
   tt3 = strmid(header(i),tt1+1,tt2)
   aa = strparse(tt3,';',tt4)        ; to eliminate the comment
   out = tt4(0)
   lineindex=i
   GoTo,OUT
  endif
endfor
OUT:
return,strcompress(out)
end
;
