FUNCTION xpowder_calchkl,str, ask=ask, Group=group,  $
  crystalCell1=crystalCell1,crystalStr1=crystalStr1, $
  wavelength=wavelength,limitFlg=limitFlg,limitValue=limitValue,$
  debyeFlag=debyeFlag,anomalousFlag=anomalousFlag,intCutOff=intCutOff

;
;+
;FUNCTION xpowder_calchkl,str, ask=ask, Group=group,  $
;  crystalCell1=crystalCell1,crystalStr1=crystalStr1, $
;  wavelength=wavelength,limitFlg=limitFlg,limitValue=limitValue,$
;  debyeFlag=debyeFlag,anomalousFlag=anomalousFlag,intCutOff=intCutOff
;
; This function computes and X-ray diffraction pattern for a powder
; crystal
;
;
; Modification history: 
;
;   2007-03-19 srio@esrf.fr dubigging: avoid piling up different 
;              reflections with the same d-spacing if one of the
;              cell dimension is a multiplier of another.
;-

;==============================================================
; INPUTS
;==============================================================

IF Keyword_Set(ask) THEN BEGIN
   ss = xpowder_defaults()
   str = ss.hklStr
   flags = ss.hklStr_Flags
   titles = ss.hklStr_Titles
   XSCRMENU,str,/interpret,/notype,Titles=titles,flags=flags, $
          Action=action,Dialog_Parent=group,NCOL=2, $
          Wtitle='Calc Reflections',Help='xpowder_helphkl'
   IF action EQ 'DONT' THEN RETURN,0
ENDIF

IF N_Elements(str) NE 0 THEN BEGIN ; inputs trough structure

  IF StrCompress((str.ucFrom)[0],/Rem) EQ '1' THEN BEGIN ; ucell from file
          file=StrCompress(str.ucellfile,/Rem)
          IF file EQ '?' THEN BEGIN
             file = Dialog_PickFile(Filter='*.ucell', $
	            Title='Select a file with unit cell')
	  ENDIF
          IF file EQ '' THEN RETURN,0
          IF CheckFile(file) NE 1 THEN BEGIN
             itmp = Dialog_Message(/Error,'File not found: '+f)
             Return,0
          ENDIF
          str.ucellfile=file
	  ; if group is defined, update the structure stored in it
          IF N_Elements(group) NE 0 THEN BEGIN
	    Widget_Control,group,Get_UValue=info
	    info.str.hklStr = str
	    Widget_Control,group,Set_UValue=info
	  ENDIF

          crystalStr1=rascii(file,Skip=1,Header=h)
          crystalCell1=FltArr(6)
          openR,unit,file,/Get_Lun
          readF,unit,crystalCell1
          Free_Lun,unit
  ENDIF ELSE BEGIN ; ucell from "Unit cell" TAB
          IF N_Elements(group) EQ 0 THEN Message,'Define group keyword for reading data from TAB'
          Widget_Control,group, Get_UValue=info
          Widget_Control,info.wids.ucAtoms, Get_Value=CrystalStr1
          Widget_Control,info.wids.ucCell,Get_Value=CrystalCell1
  ENDELSE

  wavelength = str.wavelength
  limitFlg = Fix( (str.limitFlg)[0] )
  limitValue =str.limitValue
  debyeFlag = str.debyeW ; set this to '1' or '?'
  anomalousFlag = Fix( (str.anomalousFlg)[0] ) ; set this 0=No or 1=Yes
  intCutOff = str.cutOff ; cutoff intensity (%)
  filef0 = (str.filef0)[0]
  filef1f2 = (str.filef1f2)[0]
ENDIF ELSE BEGIN
  IF N_Elements(wavelength) EQ 0 THEN wavelength  = 1.0D0
  IF N_Elements(limitFlg) EQ 0 THEN limitFlg  = '0'
  IF N_Elements(limitValue) EQ 0 THEN limitValue  = 80.0
  IF N_Elements(DebyeFlag) EQ 0 THEN DebyeFlag  = '1'
  IF N_Elements(anomalousFlag) EQ 0 THEN anomalousFlag  = '0'
  IF N_Elements(intCutOff) EQ 0 THEN intCutOff  = 1e-3
  IF N_Elements(crystalCell1) EQ 0 THEN $
	crystalCell1=[5.43070,5.43070,5.43070,90.,90.,90.] ; Silicon
  IF N_Elements(crystalStr1) EQ 0 THEN $
	crystalStr1=[ $
                    [14,1.0,0.0,0.0,0.0], $
                    [14,1.0,0.0,0.5,0.5], $
                    [14,1.0,0.5,0.0,0.5], $
                    [14,1.0,0.5,0.5,0.0], $
                    [14,1.0,.25,.25,.25], $
                    [14,1.0,.25,.75,.75], $
                    [14,1.0,.75,.25,.75], $
                    [14,1.0,.75,.75,.25] ]
  IF N_Elements(filef0) EQ 0 THEN filef0 ='0'
  IF N_Elements(filef1f2) EQ 0 THEN filef1f2 ='0'
ENDELSE
;==============================================================



CASE limitFlg OF
  '0': BEGIN
       hklMax=-1
       dspacingmin=wavelength/2/sin(limitValue/2*!dpi/180)
       END
  '1': BEGIN
       hklMax=-1
       dspacingmin=limitValue
       END
  '2': BEGIN
       hklMax=limitValue
       dspacingmin=0
       END
ENDCASE
       
crystalCell = Double(crystalCell1) 
crystalStr = Double(crystalStr1[0:4,*]) 

;
; calculation of useful reflections
;
; loop over permutations on operatinal reflections

IF hklmax EQ -1 THEN BEGIN
     hmax = Fix(crystalCell[0]/dspacingmin)
     kmax = Fix(crystalCell[1]/dspacingmin)
     lmax = Fix(crystalCell[2]/dspacingmin)
     print,'Max k,h,l: ',hmax,kmax,lmax
ENDIF ELSE BEGIN
     hmax=hklmax
     kmax=hklmax
     lmax=hklmax
ENDELSE
nmiller = (Float(2*hmax)+1)*(Float(2*kmax)+1)*(Float(2*lmax)+1)-1
print,'Number of h k l permutations: ',nmiller
miller = IntArr(3,nmiller)
ngood=-1
for ih=-hmax,hmax,1 do begin
for ik=-kmax,kmax,1 do begin
for il=-lmax,lmax,1 do begin
     IF (ih EQ 0) AND (ik EQ 0) AND (il EQ 0) THEN BEGIN
     ENDIF ELSE BEGIN
       ngood=ngood+1
       miller[0,ngood]=ih
       miller[1,ngood]=ik
       miller[2,ngood]=il
     ENDELSE
endfor
endfor
endfor

IF hklmax EQ -1 THEN BEGIN
      ddd = bragg_metrictensor(crystalCell,hkl=miller)
      igood = Where(ddd GE dspacingmin)
      miller = miller[*,igood]
ENDIF

nlines = N_Elements(miller[0,*])
print,'Number of reflections in the selected limits: ',nlines
mult = Replicate(1,N_Elements(miller[0,*])) ; multiplicity

;
; start calculations using bragg_calc
;

inp = bragg_inp(ask=0)
energy = physical_constants('hc')/wavelength
print,'energy: ',energy

inp.parameters.emin=energy-5
inp.parameters.emax=energy+5
inp.parameters.estep=1
inp.parameters.temper=debyeflag
tmp = (inp.parameters.filef0)
tmp[0] = filef0
inp.parameters.filef0=tmp
tmp = (inp.parameters.filef1f2)
tmp[0] = filef1f2
inp.parameters.filef1f2=tmp

;
; define arrays for storing results
;
out_d = FltArr(nlines) ; d-spacing
out_f = FltArr(nlines) ; |Fhkl|
out_t = FltArr(nlines) ; Bragg angle
out_i = FltArr(nlines) ; intensity

;
; first call to bragg_inp for reading files for subsequential calls
;
f0=0
f1=0
f2=0
M0=0 ; Make M0 undefined for being calculated 
fhinp = bragg_calc(inp,crystalCell=crystalCell,crystalStr=crystalStr, $
  f0=f0,f1=f1,f2=f2,M0=M0,verbose=0,anomalous=anomalousFlag)


;
; main loop for getting the structure factor over all reflections
;
t0=systime(1)
FOR i=0,nlines-1 DO BEGIN
  inp.parameters.hmiller=miller[0,i]
  inp.parameters.kmiller=miller[1,i]
  inp.parameters.lmiller=miller[2,i]
  inp2 = bragg_calc(inp,verbose=0, $
         crystalCell=crystalCell,crystalStr=crystalStr,f0=f0,f1=f1,f2=f2,M0=M0)

  crystal_fh,inp2,energy,text=text,out=out,/forceRatio
  braggAngle=out.theta*180/!dpi
  lorentz = bragg_lorentz(braggAngle,Ret=4)

  ; store results
  out_d[i]=inp2.d_spacing*1d8
  struct = sqrt(Real_Part(out.struct)^2+Imaginary(out.struct)^2)
  out_f[i]=struct
  out_t[i]=braggAngle
  out_i[i]=(out_f[i])^2*mult[i]*bragg_lorentz(out_t[i],Ret=4)
  ;print,'Bragg angle (deg): ',braggAngle
  ;print,'Lorentz: ',lorentz
  ;print,'Struct (complex): ',out.struct
  ;print,'Struct (modulus): ',struct
ENDFOR
print,'Main loop time: ',systime(1)-t0


;
; sort reflections
;

; 
; set zeroes
;
t0=systime(1)
itmp = Where(out_i LE 1D-8)
IF itmp[0] NE -1 THEN out_i[itmp]=0

;
; sort by bragg angle and compute multiplicities
;
;ibrg = uniq(out_t,sort(out_t))

; define a flag that distinguishes different reflections 
out_flag = abs(miller[0,*]) + abs(miller[1,*])*2 + abs(miller[2,*])*4
tmp = out_t*(1D0+out_flag*1d-5)
; use Bsort to avoid problems in windows (sort is OS-dependent)
; 2009-10-08
ibrg = uniq(tmp,Bsort(tmp))



IF ibrg[0] EQ -1 THEN Message,'Error: no good reflections'

out2 = DblArr(10,N_Elements(ibrg))
FOR i=0,N_Elements(ibrg)-1 DO BEGIN
  ;'h','k','l','2*Theta','d-spc','|F|','Int','M'
  ii = ibrg[i]
  mm = Where( (out_t EQ out_t[ii]) AND (out_flag EQ out_flag[ii]))
  ;mm = Where(out_t EQ out_t[ii])
  intAll = Total(out_i[mm])
  out2[0:2,i]=miller[*,ii]
  out2[3,i]=2*out_t[ii]
  out2[4,i]=out_d[ii]
  out2[5,i]=out_f[ii]
  out2[6,i]=out_i[ii]
  out2[7,i]=N_Elements(mm)
  out2[8,i]=intAll
  out2[9,i]=0
ENDFOR
out2[9,*]=out2[8,*]/max(out2[8,*])*100

;; remove forbidden reflections:
igood = Where(out2[9,*] GT intCutOff)
out2=out2[*,igood]


RETURN,out2


END


