;
;=================================================================
;
Function crl_descriptor,ptr,iname=iname,imix=imix,Group=group

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'CRL_DESCRIPTOR: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN,''
ENDIF

mat_flag = fix( (*ptr).parameters.mat_flag[0] )
case mat_flag of
0: begin
    iname = 0 
           descriptor = strcompress( (*ptr).parameters.descriptor,/rem)
           if strlen(descriptor) EQ 1 then descriptor=descriptor+' '
    imix = 0
   end
1: begin
    iname = 0 
           descriptor = strcompress( (*ptr).parameters.descriptor,/rem)
           if strlen(descriptor) EQ 1 then descriptor=descriptor+' '
    density = (*ptr).parameters.density
    imix = 1
   end
2: begin
    iname = 1 & descriptor = (*ptr).parameters.mat_list($
	fix( (*ptr).parameters.mat_list[0])+1 )
    density = 0
    imix = 1
   end
endcase
return,descriptor
end ; crl_descriptor

;
;=================================================================
;
Pro crl_calc_main,ptr,group=group

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'CRL_CALC_MAIN: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF

str_par = (*ptr).parameters

;get f1f2 file
f1f2 = str_par.f1f2(fix( str_par.f1f2[0])+1)
;get Mu file
CS = str_par.CS(fix( str_par.CS[0])+1)
;get Energy
energy=str_par.e

;
; get descriptor
;

; mat_flag : 0=element, 1=mixture(form) 2=mixture(table)
mat_flag = fix( str_par.mat_flag[0] )
case mat_flag of
0: begin
    iname = 0 
           descriptor = strcompress(str_par.descriptor,/rem)
           if strlen(descriptor) EQ 1 then descriptor=descriptor+' '
    imix = 0
   end
1: begin
    iname = 0 
           descriptor = strcompress(str_par.descriptor,/rem)
           if strlen(descriptor) EQ 1 then descriptor=descriptor+' '
    density = str_par.density
    imix = 1
   end
2: begin
    iname = 1 & descriptor = str_par.mat_list($
	fix(str_par.mat_list(0))+1)
    density = 0
    imix = 1
   end
endcase

;
; calculate delta and Mu
;
if imix then begin
  delta = f1f2_calc_mix(f1f2,descriptor,energy,f=3,name=iname,density=density,$
  group=group) 
  betaf = f1f2_calc_mix(f1f2,descriptor,energy,f=4,name=iname,density=density,$
  group=group) 
  Mu = cross_calc_mix(CS,descriptor,energy,partial='TotalCrossSection',$
  name=iname,density=density,group=group,unit=3) 
endif else begin
  delta = f1f2_calc(f1f2,descriptor,energy,f=3,group=group)
  betaf = f1f2_calc(f1f2,descriptor,energy,f=4,group=group)
  Mu = cross_calc(CS,descriptor,energy,partial='TotalCrossSection',$
  group=group,unit=3) 
endelse
delta=delta(0)
betaf=betaf(0)
mu=mu(0)

;
; calculate F
;

n = Float(str_par.N[0])
r = Float(str_par.R[0])
f = 1e-3*r/( 2.0*n * delta)

;
; calculate q
;
p=Float(str_par.p(0))
q = f * p / (p - f)

;
; calculate A (effective aperture)
; (formulas 15 & 16 of Snigirev et al. Appl. Optics 37 (1998) 653)
;
lambda =  12396.0 / energy
lambda = lambda * 1e-10 ; m
At =  2.0 * R * (4.0*lambda*F/(R*1e-3)^2)^(0.25)
Aa =  2.0 * R * (2.0 /(Mu* R*1e-2 *N))^(0.5)
A = At< Aa < (2.0*R)


;
; calculate Difraction Limit
;
DifLim =  lambda*Q/(A*1e-3) ; m
;
; calculate ideal Gain
;
Gain = (A*1e-3 /DifLim)*(1.0+ (Q/P))

; 
; calculate Nmax 
;
Nmax = 1.0/(Mu*100.0 *sqrt(lambda*F))


; 
; calculate GainMax 
;
GainMax = 4.0*Delta/!pi/betaf

; 
; calculate real gain 
;
dholes = float(str_par.dholes(0))*1e-6 ; m
sourceSize = float(str_par.sourcesize(0))*1e-6 ; m

realGain = (P/Q)*(DifLim/SourceSize)*Gain*exp(-Mu*1e2*N*dholes)

;
; calculate RMS lens acceptance [Elleaume, NIM A412 (1998) p.483, eq.9]
;
rms_acceptance = Sqrt(delta*(f*1e3)/(mu/10.0) )  ; microns

;
; display results
;
text = [' ',$
	'********************** inputs *****************************',$
	'Material:                            '+descriptor, $
	'E (Photon Beam Energy) [eV]:         '+strcompress(energy,/rem), $
	"R (Holes' curvature radius) [mm]:    "+strcompress(r,/rem),$
	'N (Number of holes):                 '+strcompress(n,/rem),$
	'p (source-CRL distance) [m]:         '+strcompress(p,/rem),$
	'd (inter-hole distance) [microns]:   '+strcompress(dholes*1e6,/rem),$
	'S Sorce Size RMS [microns]:          '+strcompress(SourceSize*1e6,$
		/rem),$
	' ',$
	'********************** references *************************',$
	'Ref 1: P. Elleaume, NIM A412 (1988) pp.483-505  ',$
	'Ref 2: A. Snigirev et al. Applied Optics (1998) pp.653-656', $
	' ',$
	'********************** outputs ****************************',$
	' ',$
	'Delta and Beta from DABAX file:  '+f1f2,$
	'Mu from DABAX file:              '+CS,$
	'Delta:             '+strcompress(delta,/rem),$
	'Beta:              '+strcompress(betaf,/rem),$
	'Mu [cm^-1]:        '+strcompress(Mu,/rem), $
	' ',$
	'Focal distance [m] F=R/(2N Delta):           '+strcompress(f,/rem), $
	'q CRL-focus distance [m] (1/F)=(1/p)+(1/q):  '+strcompress(Q,/rem), $
	' ',$
	'Effective "transparent" lens aperture [mm] (Ref 2 eq.15):   '+$
        	strcompress(At,/rem),$
	'Effective "absorber" lens aperture [mm] (Ref 2 eq. 16):     '+$
        	strcompress(Aa,/rem), $
	'Diffraction Limited Resolution [microns] (Ref 2 eq. 18):    '+$
		strcompress(DifLim*1e6,/rem), $
	'Ideal RMS image size [microns] S*(q/p) :                    '+$
		strcompress(SourceSize*1e6*Q/P,/rem), $
	'RMS lens acceptance [mm] (Ref 1 eq. 9) :                    '+$
		strcompress(rms_acceptance,/rem), $
	' ',$
	'Nmax (maximum number of holes) (Ref 1 eq. 21):              '+$
		strcompress(long(Nmax),/rem),$
	'Ideal Gain: (Ref 1 eq. 19)                                  '+$
		strcompress(Gain,/rem),$
	'Maximum Ideal Gain (with N=Nmax, Ref 1 eq. 21):             '+$
		strcompress(GainMax,/rem),$
	'Real Gain (Ref 1 eq. 22):                                   '+$
		strcompress(RealGain,/rem)]
XDisplayFile1,Text=text, Title='CRL results',Group=group,HEIGH=32
end ; crl_calc_main


;
;=================================================================
;

function crl_und,emittance=emittance,beta=beta,energy=energy,$
  UndLength=UndLength, Group=group
;
; calculate sigma and sigma prime from undulator parameters and returns
; a 2-dim array with them
;

catch, error_status
if error_status ne 0 then begin
   message,/info,'error catched: '+!err_string
   if sdep(/w) then itmp = Dialog_Message(/Error,Dialog_Parent=group,$
	'CRL_UND: error catched (returned [0,0]): '+!err_string)
   catch, /cancel
   on_error,2
   return,[0,0]
endif

if not(keyword_set(emittance)) then emittance=.039 ; nm
if not(keyword_set(beta)) then beta=2.5 ; m
if not(keyword_set(energy)) then energy=24 ; keV
if not(keyword_set(undLength)) then undLength=1.6 ; m

sigma=(emittance*beta/1000)^.5 ; sigma (mm)
sigmapr=(emittance/(beta*1e9)+(1.24e-9/energy)/(2*UndLength))^.5
return,[sigma,sigmapr]
end ; crl_und

;
;=================================================================
;

PRO CRL_MapPanels,wids,Group=group

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'CRL_MAPPANELS: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF

val=0
;
; main/ray-tracing calculations
;
Widget_Control,wids.calc_type,Get_Value=val
IF val[0] EQ 0 THEN map=0 else map=1

Widget_Control,wids.cyl_flag,Map=map
Widget_Control,wids.q,Map=map
Widget_Control,wids.rt_base,Map=map
Widget_Control,wids.sourceDiv,Map=map
Widget_Control,wids.parab_aperture,Map=map

IF val[0] EQ 1 THEN BEGIN ; parab_aperture
  tmp=0
  Widget_Control,wids.cyl_flag,Get_Value=tmp
  IF tmp[0] EQ 0 THEN map=0 else map=1
  Widget_Control,wids.parab_aperture,Map=map
ENDIF


END ; CRL_MapPanels

;
;=================================================================
;
Pro CRL_Update,wid,group=group
;
; updates the values in (*state.ptr).parameters from the 
; values currently displayed in the widgets.
; 

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'CRL_UPDATE: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF

stateid = Widget_Info(wid,/Child)
Widget_control, stateid,  Get_uvalue=state

;
; get values
; 

; Source parameters 

sourceSize=0
Widget_Control,state.wids.sourceSize,Get_Value=sourceSize
sourceSize = Float(sourceSize[0])
(*state.ptr).parameters.sourceSize=sourceSize

sourceDiv=0
Widget_Control,state.wids.sourceDiv,Get_Value=sourceDiv
sourceDiv = Float(sourceDiv[0])
(*state.ptr).parameters.sourceDiv=sourceDiv

energy = 0 
Widget_Control,state.wids.E,Get_Value=energy
energy=Float(energy[0])
(*state.ptr).parameters.e=energy

; CRL parameters

r=0
Widget_Control,state.wids.R,Get_Value=R
r = Float(r[0])
(*state.ptr).parameters.r=r

n=0
Widget_Control,state.wids.N,Get_Value=n
n = Long(n[0])
(*state.ptr).parameters.n=n

dHoles=0
Widget_Control,state.wids.dHoles,Get_Value=dHoles
dHoles = Float(dHoles[0])
(*state.ptr).parameters.dHoles=dHoles

parab_aperture=0
Widget_Control,state.wids.parab_aperture,Get_Value=parab_aperture
parab_aperture = Float(parab_aperture[0])
(*state.ptr).parameters.parab_aperture=parab_aperture

; Layout parameters 

p=0
Widget_Control,state.wids.P,Get_Value=P
p=Float(p[0])
(*state.ptr).parameters.p=p

q=0
Widget_Control,state.wids.q,Get_Value=q
q=Float(q[0])
(*state.ptr).parameters.q=q

; Ray-tracing parameters

nrays=0
Widget_Control,state.wids.nrays,Get_Value=nrays
nrays=Long(nrays[0])
(*state.ptr).parameters.nrays=nrays

seed=0
Widget_Control,state.wids.seed,Get_Value=seed
seed=Long(seed[0])
(*state.ptr).parameters.seed=seed

END  ; CRL_Update

;
;=================================================================
;
pro crl_set_event,event

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=event.top, $
     'CRL_SET_EVENT: error caught: '+!err_string)
   Catch, /Cancel
   If Type(stateid) EQ 3 THEN $
     If Widget_Info(stateid,/Valid_Id) AND N_Elements(state) NE 0 THEN $
     Widget_Control,stateid,Set_UValue=state
   On_Error,2
   RETURN
ENDIF


Widget_control, event.id, Get_uvalue=uvalue
stateid = Widget_Info(event.handler,/Child)
Widget_control, stateid,  Get_uvalue=state

case uvalue of 
  'CLOSE': BEGIN
	;CRL_Update,state, Group=event.top
	CRL_Update,event.handler, Group=event.top
	Widget_Control,event.top,/DESTROY
	RETURN
	END
  'CALC_TYPE': BEGIN
	CRL_MapPanels,state.wids,Group=event.top
	val=0
	Widget_Control,event.id,Get_Value=val
	(*state.ptr).parameters.calc_type=val
	END
  'CYL_FLAG': BEGIN
	CRL_MapPanels,state.wids,Group=event.top
	val=0
	Widget_Control,event.id,Get_Value=val
	(*state.ptr).parameters.cyl_flag[0]=StrCompress(val,/Rem)
	END
  'CALC_METHOD': BEGIN
	Widget_Control,event.id,Get_Value=val
	(*state.ptr).parameters.calc_method[0]=StrCompress(val,/Rem)
	END
  'RT_SHOW': BEGIN
	val=0
	Widget_Control,event.id,Get_Value=val
	(*state.ptr).parameters.rt_show[0]=StrCompress(val,/Rem)
	END
  'UNDULATOR': BEGIN
	val=0
	Widget_Control,state.wids.undulator,Get_Value=val
	(*state.ptr).parameters.und_flag[0]=val
	IF val EQ 0 THEN GoTo,out
	str_par = (*state.ptr).parameters
	tmp = {UND_emittance:str_par.UND_emittance, $
	       UND_beta:str_par.UND_beta, $
	       UND_length:str_par.UND_length, $
	       e:str_par.e}
	action=''
	XScrMenu,tmp,/interp,/notype,WTitle='Undulator parameters',titles=$
	  ['Emittance [nm.rad]','Beta function [m]','Length [m]',$
	  'Photon Energy [eV]'],Action=Action
	if Action EQ 'DONT' then return
	Copy_Structure,tmp, str_par 
	(*state.ptr).parameters = str_par
	sigmas = CRL_Und(emittance=tmp.UND_emittance, beta=tmp.UND_beta, $
	  energy=tmp.e/1000.0,undLength=tmp.UND_length) 
	Widget_Control,state.wids.e,Set_Value=StrCompress(tmp.e,/Rem)
	Widget_Control,state.wids.sourceSize,Set_Value=$
	  StrCompress(sigmas[0]*1e3,/Rem)
	Widget_Control,state.wids.sourceDiv,Set_Value=$
	  StrCompress(sigmas[1]*1e6,/Rem)
	END
  'HELP': xhelp,'crl',Group=event.top
  'ChangeDataSet': begin
	tmp = Create_SubStruct( (*state.ptr).parameters, $
	  IndGen( ((*state.ptr).n_database) ) )
	xscrmenu,tmp,/interp,/notype,WTitle='CRL data sets',titles=$
	  ['f1f2 file:','Cross Sectios file: '],Action=Action
	if Action EQ 'DONT' then return
	str_par = (*state.ptr).parameters
	Copy_Structure,tmp, str_par 
	(*state.ptr).parameters = str_par
	end
  'ChangeMaterial': begin
	tmp = Create_SubStruct( (*state.ptr).parameters, $
	  (IndGen((*state.ptr).n_material ) + ((*state.ptr).n_database)) )
	action=''
	titles=(*state.ptr).titles_material
	flags=(*state.ptr).flags_material
	xscrmenu,tmp,/interp,/notype,WTitle='CRL material selection', $
	  titles=titles, Flags=flags,Action=Action
	if Action EQ 'DONT' then return
	str_par = (*state.ptr).parameters
	Copy_Structure,tmp, str_par 
	(*state.ptr).parameters = str_par
	widget_control,/hourglass

	descriptor = crl_descriptor(state.ptr)
	widget_control,state.wids.material,set_value=' ('+ descriptor +') '

	end
   'Go Calculate': begin	
	widget_control,/hourglass
	CRL_Update,event.handler,Group=event.top
	Widget_Control,/HourGlass
	CASE StrCompress( (*state.ptr).parameters.calc_type[0],/Rem ) OF
	  '0': BEGIN
		CRL_Calc_Main,state.ptr,Group=event.top
		END
	  '1': BEGIN
		CRL_Calc_RT,state.ptr,Group=event.top
		END
	ENDCASE
	end
   else:
endcase
out:
If Type(stateid) EQ 3 THEN $
  IF Widget_Info(stateid,/Valid_Id) AND N_Elements(state) GT 0 THEN $
  Widget_control,stateid,set_uvalue=state

end ; crl_set_event

;
;=================================================================
;
pro crl_set,ptr, group = group, No_Block=no_block, Parent=wbase

;
;=================================================================
;
;+
; NAME:
;	crl_set
;
; PURPOSE:
;       This procedure creates the main window for definning the 
;	parameters in the CRL application.
;
; CATEGORY:
;	optics
;
; CALLING SEQUENCE:
;       CRL_Set, pointer
;
; INPUTS:
;       pointer: a pointer to the CRL parameter structure (as defined by
;		Dabax_Defaults() )
; KEYWORD PARAMETERS:
;	Group: the id of the called widget (to manage error window).
;	no_block: set this keyword to call XManager with the /No_Block keyword.
;	parent: The id of the parent application (to be used with crl.pro)
;
; OUTPUTS:
;       Creates the window and drives the calculations (it needs the
;	external CRL_CALC_RT)
;
; EXAMPLE:
;       CRL_Set,Ptr_New(dabax_Defaults('crl'))
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio (srio@esrf.fr), December 1998
;
;-

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'CRL_SET: error caught: '+!err_string)
   Catch, /Cancel
   RETURN
ENDIF

pars = (*ptr).parameters
;
; widget def
;
; wBaseData = widget_base()
wbase = widget_base(title='Set CRL Parameters',/col)

wbuttons = widget_base(wbase,/ROW) ; also to store state
wcancel = widget_button(wbuttons,VALUE='Close',UVALUE='CLOSE')
wtmp = widget_button(wbuttons,VALUE='Go Calculate',UVALUE='Go Calculate')

;wdone = widget_button(wbuttons,VALUE='Accept',UVALUE='DONE')
whelp = widget_button(wbuttons,VALUE='Help',UVALUE='HELP')

wtxt = widget_base(wbase,/COL)
; wtmp = widget_label(wtxt,VALUE='Enter CRL values (and press <Calculate>):')

;
; select calculation type
;
wtmp0 = Widget_Base(wtxt,/Col,/Frame)
  wtmp1 = Widget_Base(wtmp0,/Row)
    wtmp=Widget_Label(wtmp1,Value='Calculate: ')
    wcalc_type= cw_bgroup(wtmp1, ['Main Parameters','Ray Tracing'], $
	/Exclusive,Uvalue='CALC_TYPE',/Row,/Return_Index,$
	Set_Value=pars.calc_type,/No_Rel)

;
; source definiion
;
wtmp0 = Widget_Base(wtxt,/Col,/Frame)
  wtmp = Widget_Label(wtmp0,Value='--Source Parameters--',/Align_Left)
  wundulator = CW_DropList(wtmp0,value=pars.UND_flag, Title='Undulator: ',$
    UValue='UNDULATOR')
  wtmp1 = widget_base(wtmp0,/ROW)
    wtmp = widget_label(wtmp1,VALUE="Sorce Size RMS [microns]: ")
    wSourceSize = widget_text(wtmp1,/EDIT,UVALUE='SourceSize',VALUE=$
	strcompress(pars.SourceSize,/rem) )
  wtmp1 = widget_base(wtmp0,/ROW)
    wtmp = widget_label(wtmp1,VALUE="Sorce Divergence RMS [microrad]: ")
    wSourceDiv = widget_text(wtmp1,/EDIT,UVALUE='SourceDiv',VALUE=$
	strcompress(pars.SourceDiv,/rem) )
  wtmp1 = widget_base(wtmp0,/ROW)
    wtmp = widget_label(wtmp1,VALUE="E (Photon Beam Energy) [eV]:  ")
    wE = widget_text(wtmp1,/EDIT,UVALUE='E',VALUE=strcompress(pars.E,/rem) )

;
; CRL definition
;
wtmp0 = Widget_Base(wtxt,/Col,/Frame)
  wtmp = Widget_Label(wtmp0,Value='--CRL Parameters--',/Align_Left)
  wtmp1 = widget_base(wtmp0,/Row)
    wtmp = widget_button(wtmp1,UVALUE='ChangeMaterial',VALUE=$
	'Change Material...' )
    wMaterial = widget_label(wtmp1,VALUE='********************',$
      Scr_XSize=150, /align_left)
    wtmp = widget_button(wtmp1,UVALUE='ChangeDataSet',VALUE=$
        'Change Data Sets...' )
  ;wtmp = widget_button(wtmp0,UVALUE='ChangeDataSet',VALUE=$
  ;      'Change Cross Section Data Sets...' )
  wtmp1 = widget_base(wtmp0,/Row)
    wtmp = widget_label(wtmp1,VALUE="Holes: R (radius) [mm]:")
    wR = widget_text(wtmp1,/EDIT,UVALUE='R',VALUE=strcompress(pars.R,/rem),$
      XSize=6 )
  ;wtmp1 = widget_base(wtmp0,/Row)
    wtmp = widget_label(wtmp1,VALUE="  N (Number):  ")
    wN = widget_text(wtmp1,/EDIT,UVALUE='N',VALUE=strcompress(pars.N,/rem),$
      XSize=6 )
  wtmp1 = widget_base(wtmp0,/Row)
    wtmp = widget_label(wtmp1,VALUE="d (inter-hole distance) [microns]: ")
    wDHoles = widget_text(wtmp1,/EDIT,UVALUE='dholes',VALUE=$
	strcompress(pars.dholes,/rem) )
  wtmp1 = widget_base(wtmp0,/Row)
    wcyl_flag = CW_DropList(wtmp1,value=pars.cyl_flag, Title='Shape: ',$
      UValue='CYL_FLAG')
    wtmp2 = widget_base(wtmp1,/Row) ; new base to be able to map parab_aperture
      wtmp = widget_label(wtmp2,VALUE="Aperture [mm]: ")
      wparab_aperture = widget_text(wtmp2,/EDIT,UVALUE='parab_aperture',$
	VALUE=strcompress(pars.parab_aperture,/rem) )
;
; system layout
;
wtmp0 = Widget_Base(wtxt,/Col,/Frame)
  wtmp = Widget_Label(wtmp0,Value='--Layout Parameters--',/Align_Left)
  wtmp1 = widget_base(wtmp0,/Row)
    wtmp = widget_label(wtmp1,VALUE="p (source-CRL distance) [m]:  ")
    wP = widget_text(wtmp1,/EDIT,UVALUE='P',VALUE=strcompress(pars.p,/rem) )
  wtmp1 = widget_base(wtmp0,/Row)
    wtmp = widget_label(wtmp1,VALUE="q (CRL-image distance) [m]:  ")
    wQ = widget_text(wtmp1,/EDIT,UVALUE='Q',VALUE=strcompress(pars.q,/rem) )

;
; RT specifics
;
wrt_base = Widget_Base(wtxt,/Col,/Frame)
  wtmp = Widget_Label(wrt_base,Value='--Ray Tracing Parameters--',/Align_Left)
  wtmp1 = widget_base(wrt_base,/Row)
    wtmp = widget_label(wtmp1,VALUE="Number of rays:  ")
    wnrays = widget_text(wtmp1,/EDIT,UVALUE='nrays',VALUE=$
	StrCompress(pars.nrays,/Rem))
    wtmp = widget_label(wtmp1,VALUE="Seed:  ")
    wseed = widget_text(wtmp1,/EDIT,UVALUE='seed',$
	VALUE=strcompress(pars.seed,/rem) )
  wtmp1 = widget_base(wrt_base,/Row)
    wtmp = CW_DropList(wtmp1,value=pars.calc_method, $
	Title='Ray sampling: ',UValue='CALC_METHOD')
    wtmp = CW_DropList(wtmp1,value=pars.rt_show, $
	Title='Output: ',UValue='RT_SHOW')


;
; store status
; 

wids = { R:wR, N:wN, E:wE, P:wP, dholes:wDHoles, $
	SourceSize:wSourceSize,Material:wMaterial, $
	SourceDiv:wSourceDiv, parab_aperture:wparab_aperture, $
	q:wq, rt_base:wrt_base, nrays:wnrays, seed:wseed, $
	calc_type:wcalc_type, undulator:wundulator, cyl_flag:wcyl_flag }

state = { wids:wids, ptr:ptr, str_default:(*ptr).parameters }
;
; update Material
;
descriptor = crl_descriptor(state.ptr)
widget_control,state.wids.material,set_value=' ('+ descriptor +')          '

; Widget_control,wbasedata,set_uval={inpstr:inpstr}
; Widget_control,wbase,set_uval=state

Widget_control,Widget_Info(wbase,/Child),Set_uvalue=state,/No_Copy
widget_control,wbase,/REALIZE
CRL_MapPanels,wids,Group=group
xmanager, 'crl_set', wbase, group = group, No_block=no_block
end ; crl_set

