      PROGRAM CRYSTAL_FH
      IMPLICIT REAL*8(A-H,O-Z)

      REAL*8 MU,LAMBDA
	dimension iunits(3)
      PARAMETER (R0=2.817938070D-15)

        DATA    TODEG   / 57.2957 79513 08232 08767 98155 D0 /
        DATA    TORAD   /  0.0174 53292 51994 32957 69237 D0 /
        DATA    TWOPI   /  6.2831 85307 17958 64679 25287 D0 /
        DATA    PI      /  3.1415 92653 58979 32384 62643 D0 /

        complex*16   struct

c new structure factors (with Bragg 2.1) 

        character*80    file_refl
        complex*16      f_0,f_h,f_hbar
        complex*16      psi_0,psi_h,psi_hbar
        complex*16      refrac

      
c	defines output units
	iunits(1) = 6
	iunits(2) = 10
	iunits(3) = 12

c opens output files

C this is to write the ooutput rocking curve. 
C not used in this example
      open (10,file='cryst_fh.dat',status='unknown',err=101)

C this is to write information
      open (12,file='cryst_fh.inf',status='unknown',err=101)

	      file_refl = 'xcrystal.bragg'
	      PHOT = 8000.0          !photon energy [eV]

C set idebigger = 0 to turn off debigging comments
	      idebugger = 1

C                                                                       
C     USER'S INPUT SECTION                                              
C                                                                       
      do i=6,12,6
      write(i,*)' '
      write(i,*)' '
      write(i,*)' '
      write(i,*)'******************************************************'
      write(i,*)'*                   CRYSTAL_FH                       *'
      write(i,*)'* calculates the Structure factor from a DABAX file  *'
      write(i,*)'*                                                    *'
      write(i,*)'******************************************************'
      write(i,*)' '
      enddo


      write(*,*)  ' '

C 
C END OF INPUT SECTION
C

	    lambda = 12398.54/phot       ! Angstrom

C 
C  STRUCTURE FACTOR CALCULATION
C


C Call crystal_fh to read the BRAGG file
	    call crystal_fh(-1,file_refl,phot,theta,
     $f_h,f_hbar,f_0,psi_h,psi_hbar,psi_0,refrac,
     $rn,d_spacing)

	     theta = dasin(lambda/2.0E8/d_spacing)
	     if (idebugger.eq.1) then 
	     write(*,*)'d_spacing [cm]: ',d_spacing
      write(*,*)'Lambda [A]: ',Lambda
c     write(*,*)'Phot: ',Phot
	     write(*,*)'Theta [deg]: ',theta*todeg
	     write(*,*)'Theta [rad]: ',theta
	     endif

C
	     write(12,*)'##############################################'
	     write(12,*)'Starts data from Structure Factor calculation.'
	     call crystal_fh(12,file_refl,phot,theta,
     $f_h,f_hbar,f_0,psi_h,psi_hbar,psi_0,refrac,
     $rn,d_spacing)
	     write(12,*)'Ends data from Structure Factor calculation.'
	     write(12,*)'##############################################'
	     write(12,*)' '
	     write(12,*)' '

#if lahey
	     MU =  2.0d0 * TWOPI *(-AIMAG(REFRAC)) / (LAMBDA*1.0D-8)
#else
	     MU =  2.0d0 * TWOPI *(-IMAG(REFRAC)) / (LAMBDA*1.0D-8)
#endif

	     if (idebugger.EQ.1) then
	     write (*,*) '** RN         : ',RN
	     write (*,*) '** D_SPACING  : ',D_SPACING
	     write (*,*) '** F_H     : ',F_H
	     write (*,*) '** F_HBAR  : ',F_HBAR
	     write (*,*) '** F_0     : ',F_0
	     write (*,*) ' '
	     write (*,*) '** PSI_H   : ',PSI_H
	     write (*,*) '** PSI_HBAR: ',PSI_HBAR
	     write (*,*) '** PSI_0   : ',PSI_0
	     write (*,*) ' '
	     write (*,*) '** REFRAC  : ',REFRAC
	     write (*,*) '** MU      : ',MU
	     endif

	       close(10)
	       close(12)
	       write (*,*) 
     $'Files cryst_fh.dat and cryst_fh.inf written to disk.'
101	continue

      END

C+++
C	SUBROUTINE	CRYSTAL_FH
C
C	PURPOSE		Computes the structute factor of a crystal
C			from data in bragg's output file.
C
C	ALGORITHM	
C
C	MODIFIED	Created by M. Sanchez del Rio  (Feb. 1996)
C
C			Modified by MSR 96/12/19 to include the number
C			of coefficients in the f0 parametrization. This
C			number is 9 for the CromerMann data and 11 for
C			the Waasmaier Kirfel data. Note that the crystal
C			file has changed!
C
C---
     	SUBROUTINE	CRYSTAL_FH (
     $ KWHAT, FILE, PHOT, THETA			   ! inputs
     $,FH,FH_BAR,F_0,PSI_H,PSI_HBAR,PSI_0,REFRAC   ! outputs when kwhat>0
     $,RN1,D_SPACING1)				   ! outputs when kwhat<0

C 
C INPUT PARAMETERS:
C   KWHAT: Flag
C     KWHAT<0 reads data file
C     KWHAT>=0 performs calculations
C	in particular, if KWHAT GT 3 it also writes results in the 
C	fortran unit kwhat
C   FILE [string]: File name with crystal data [useless if kwhat GE 0]  
C   PHOT [real]: Photon energy in eV [Useless if kwhat<0]
C   THETA [real]: Scattering grazing angle in rads [Useless if kwhat<0]
C
C OUTPUT PARAMETERS:
C   When kwhat>=0
C   FH           |
C   FH_BAR       |
C   F_0          |    Complex with the returned structure factors 
C   PSI_H        |    F, Psi and the refraction index.
C   PSI_HBAR     |
C   PSI_0        |
C   REFRAC       |
C
C INPUT AND OUTPUT PARAMETERS:
C   RN1: the constant (e^2/mc^2)/V or the ration between the classical e- 
C        radius and the volume of the unit cell [cm^(-2)]
C   D_SPACING1: The crystal d-spacingin Angstroms
C   Note that:
C       IF KWHAT LT 0  then RN1 and D_SPACING1 are returned parameters 
C       (from file)
C       IF KWHAT GE 0  then D_SPACING1 is useless and RN1 is an input 
C       parameter:
C	if negative, forget it and use the saved ones (from file)
C	if positive, consider it for the calculations.
C	(this feature will allow the study of crystal with a gradient in d)
C
C
	implicit none
	integer		NMAXENER,NMAXATOMS
        parameter       (NMAXENER=1000)
        parameter       (NMAXATOMS=100)
                                       

        real*8  pi,twopi,tocm,toangs,todeg
        DATA    PI      /  3.1415 92653 58979 32384 62643 D0 /
        DATA    TWOPI   /  6.2831 85307 17958 64679 25287 D0 /
        DATA    TOCM    /  1.239 852    D-4                  /
        DATA    TOANGS  /  1.239 852    D+4                  /
        DATA    TODEG   / 57.2957 79513 08232 08767 98155 D0 /



	real*8		PHOT,THETA 
	integer*4	KWHAT

        character*80    file,filename
	character*80	text                                !file
	real*8		rn,d_spacing,rn1,d_spacing1
	real*8		temper(NMAXATOMS),G_0(NMAXATOMS)
	real*8		fract(NMAXATOMS)
        integer*4       nbatom,atnum(NMAXATOMS),npoint,if0center
        complex*16      psi_h,psi_hbar,psi_0,psi_conj
        complex*16      G(NMAXATOMS),G_BAR(NMAXATOMS)
        real*8          f0coeff(NMAXATOMS,11)
	integer*4	nf0coeff
        real*8          energy(NMAXENER)
        real*8		fpp(NMAXATOMS,NMAXENER),fp(NMAXATOMS,NMAXENER)

	integer*4	i,j,nener,ierr
        integer*4	i_debug,itype
	real*8		F0(NMAXATOMS),F1(NMAXATOMS),F2(NMAXATOMS)
	real*8		r_lam0,ratio,version
	complex*16	ci,F(NMAXATOMS),F_0,FH,FH_BAR,STRUCT,REFRAC
	real*8		delta_ref,absorp

C
C SAVE the variables that need to be saved across subsequent invocations
C of this subroutine. Note: D_SPACING is not included in the SAVE block
C because it's included in the COMMON.BLK file.
C
c NOT LONGET TRUE:warning: d_spacing to be removed!!!!!!!
	SAVE		RN, d_spacing,
     $			ATNUM,TEMPER,NBATOM,
     $			G,G_BAR,G_0,
     $			NF0COEFF,F0COEFF,
     $			NPOINT, ENERGY, FP, FPP,
     $			FRACT,filename

C
	i_debug = 0
	CI	= (0.0D0,1.0D0)

	if (i_debug.EQ.1) write (*,*)'<><>CRYSTAL_FH: '//
     $'******** crystal_fh called with flag ********',kwhat

C***************************************************
C If flag is < 0, reads in the reflectivity data
C***************************************************
     	IF (KWHAT.LT.0) THEN
	if (i_debug.EQ.1) write(*,*) '<><> CRYSTAL_FH: file is: ',file
C#if vms
C	  OPEN	(25,FILE=file,STATUS='OLD',READONLY,
C     $FORM='FORMATTED',ERR=77)
C#elif unix
	  OPEN	(25,FILE=file,STATUS='OLD', FORM='FORMATTED',ERR=77)
C#endif
        read(25,'(A)',err=79)  text
        read(25,*,err=79)  version, itype
	if (version.NE.2.2) then
          write (*,*) 'SHADOW-E-Error: '
          write (*,*) 'Module     : CRYSTAL_FH'
          write (*,*) 'Message    : Data files does not corrspond to '//
     $ ' current version.'
	endif
	if (itype.NE.1) then 
	  write (*,*) 'SHADOW-E-Error: '
          write (*,*) 'Module     : CRYSTAL_FH'
          write (*,*) 'Message    : Data file type not yet implemented.'
	  stop
	end if
        read(25,'(A)',err=79)  text
        read(25,*,err=79)  RN,d_spacing  !,TEMPER
        read(25,'(A)',err=79)  text
        read(25,*,err=79)  nbatom
	if (nbatom.GT.NMAXATOMS) then
          write (*,*) 'SHADOW-E-Error: '
          write (*,*) 'Module     : CRYSTAL_FH'
          write (*,*) 'Message    : '//
     $' Maximum number of atoms allowad: ',NMAXATOMS
	end if

        read(25,'(A)',err=79) text
        read(25,*,err=79)  (ATNUM(I),i=1,nbatom)

        read(25,'(A)',err=79) text
        read(25,*,err=79)  (FRACT(I),i=1,nbatom)

        read(25,'(A)',err=79) text
        read(25,*,err=79)  (TEMPER(I),i=1,nbatom)

	read(25,'(A)',err=79) text
	read(25,*,err=79) (G_0(i),i=1,nbatom)

        read(25,'(A)',err=79)  text
	do i=1,nbatom
          read(25,*,err=79)  G(I)
          read(25,*,err=79)  G_BAR(I)
	end do

        read(25,'(A)',err=79) text
	do i=1,nbatom
          read(25,*,err=79)  nf0coeff,(f0coeff(i,j),j=1,nf0coeff)
	end do
        read(25,'(A)',err=79)  text
        read(25,*,err=79)  NPOINT
	read(25,'(A)',err=79)  text
        DO 199 I = 1, NPOINT
          read(25,*,err=79)  energy(i)
	  do j=1,nbatom
            read (25,*,err=79) FP(j,i),FPP(j,i)
	  end do
 199      CONTINUE

C rn and d_spacing are saved, rn1 and d_spacing1 are returned

	  rn1 = rn
	  d_spacing1 = d_spacing
	  filename = file

C
C Check for file reading errors
C
	go to 88
77	write(*,*) ' CRYSTAL_FH: Error opening file: '//file
	stop
79	write(*,*) ' CRYSTAL_FH: Error reading file: '//file
	stop
88	continue
	  CLOSE	(25)
     	  RETURN
     	ELSE
C***************************************************
C If flag is >= 0, general calculation
C***************************************************
C
C If rn1 (NOW INPUTS) is positive, then use it for
C the calculations; otherwise use the saved value.
C
	IF (RN1.lt.0)        rn1 = rn
C
C Computes structure factor at given wavelength and angle.
C
	if (i_debug.EQ.1) write (*,*) 
     $'<><>CRYSTAL_FH: working at energy: ',phot
	if (i_debug.EQ.1) write (*,*) 
     $'<><>CRYSTAL_FH: working at angle [rads] : ',theta
	if (i_debug.EQ.1) write (*,*) 
     $'<><>CRYSTAL_FH: working at angle [deg] : ',theta*todeg

	IF (PHOT.LT.ENERGY(1).OR.PHOT.GT.ENERGY(npoint)) THEN
	  write (*,*) 'SHADOW-E-Error: '
	  write (*,*) 'Module     : CRYSTAL_FH'
	  write (*,*) 'Message    : '//
     $'Incoming photon energy is out of range: ',PHOT
	  ierr = -1
	  write (*,*) 'Error flag : ',IERR
	  RETURN
	END IF	  
C
C Build the fo scattering form factor from its coefficients
C
	ratio 	= sin(theta)/(toangs/phot)
	if (ratio.GT.2) then 
	  write (*,*) 'CRYSTAL_FH: ratio sin(theta)/lambda > 2'
	  write (*,*) '    ratio : ',ratio
	  write (*,*) '    Paramatrizatiog for Fo may fail.'
	end if
	if (i_debug.EQ.1) write (*,*) 'CRYSTAL_FH: ratio is : ',ratio
	if0center = (1+nf0coeff)/2
	do j=1,nbatom
	  f0 (j) = f0coeff(j,if0center)
          do 666 i=1,if0center-1
            f0(j) = f0(j) + f0coeff(j,i) * 
     $		dexp(-1.0d0*f0coeff(j,i+if0center)*ratio**2)
	if (i_debug.EQ.1) write (*,*) '<><>CRYSTAL_FH:  f0 i,j = ',f0(j),i,j
666       continue
	  if (i_debug.EQ.1) write (*,*) '<><>CRYSTAL_FH: F0(j) = ',F0(j)
	end do
C
C Interpolate for the atomic scattering factor.
C
	DO 299 I = 1, npoint
299	  IF (ENERGY(I).GT.PHOT)	GO TO 101
C
	I	= npoint
101	NENER	= I - 1	
	do j=1,nbatom
	  F1(j)	= FP(j,NENER) + (FP(j,NENER+1) - FP(j,NENER)) * 
     $		  (PHOT - ENERGY(NENER)) / (ENERGY(NENER+1) - ENERGY(NENER))
	  F2(j)	= FPP(j,NENER) + (FPP(j,NENER+1) - FPP(j,NENER)) * 
     $		  (PHOT - ENERGY(NENER)) / (ENERGY(NENER+1) - ENERGY(NENER))
	  if (i_debug.EQ.1) write (*,*) '<><>CRYSTAL_FH: F1 = ',F1(j)
	  if (i_debug.EQ.1) write (*,*) '<><>CRYSTAL_FH: F2 = ',F2(j)
	end do
	R_LAM0 	= TOCM/PHOT
	if (i_debug.EQ.1) write (*,*) '<><>CRYSTAL_FH:  R_LAM0  =', R_LAM0

	do j=1,nbatom
	  F(j)	= F0(j) + F1(j) + CI*F2(j)
	  if (i_debug.EQ.1) write (*,*) '<><>CRYSTAL_FH: F = ',F(j)
	end do
C	
C FH and FH_BAR are the structure factors for (h,k,l) and (-h,-k,-l).
C
	F_0 = (0.0D0, 0.0D0)
	FH = (0.0D0, 0.0D0)
	FH_BAR = (0.0D0, 0.0D0)
C	write (24,*) nbatom
	do i=1,nbatom
C	  write (24,*) TEMPER(i),FRACT(i)
C	  write (24,*) real(G(i)), imag(G(i))
C	  write (24,*) real(F(i)), imag(F(i))
	  FH 	= FH + (G(i) * F(i) * TEMPER(i) * FRACT(i)) 
C From Brennan's private communication:
C Changing the temperature doesn't change F0, but it does change
C Chi0, due to changing the size of the unit cell, which changes
C gamma.
C MSR 96/02/14

	  F_0 	= F_0 + G_0(i) * 
     $	     (atnum(i) + F1(i) + CI * F2(i)) * FRACT(i) 
C	  F_0 	= F_0 + G_0(i) * 
C     $		(atnum(i) + F1(i) + CI * F2(i)) * TEMPER(i) * FRACT(i)
	  FH_BAR	= FH_BAR + 
     $          (G_BAR(i) * F(i) * TEMPER(i) * FRACT(i))
	end do
C	FH =  FH * TEMPER
C	FH_BAR = FH_BAR * TEMPER
	STRUCT 	= sqrt(FH * FH_BAR) 

	if (i_debug.EQ.1) then 
	  write (*,*) '<><>CRYSTAL_FH: FH = ',FH
	  write (*,*) '<><>CRYSTAL_FH: FH_BAR = ',FH_BAR
	  write (*,*) '<><>CRYSTAL_FH: f_0 = ',f_0
	  write (*,*) '<><>CRYSTAL_FH: STRUCT = ',STRUCT
	endif
C
C   PSI_CONJ = F*( note: PSI_HBAR is PSI at -H position and is
C   proportional to fh_bar but PSI_CONJ is complex conjugate os PSI_H) 
C
	psi_h = rn1*r_lam0**2/pi*fh
	psi_hbar = rn1*r_lam0**2/pi*fh_bar
	psi_0 = rn1*r_lam0**2/pi*f_0
	psi_conj = rn1*r_lam0**2/pi*conjg(fh)
	if (i_debug.EQ.1) write (*,*) '<><>CRYSTAL_FH: PSI_H = ',
     $PSI_H
	if (i_debug.EQ.1) write (*,*) '<><>CRYSTAL_FH: PSI_HBAR = ',
     $PSI_HBAR
	if (i_debug.EQ.1) write (*,*) '<><>CRYSTAL_FH: PSI_0 = ',
     $PSI_0
C
C computes refractive index.
C ([3.171] of Zachariasen's book)
C
     	REFRAC = (1.0D0,0.0D0) - R_LAM0**2*RN1*F_0/TWOPI
Clinux	DELTA_REF  = 1.0D0 - REAL(REFRAC)
#if lahey
	DELTA_REF  = 1.0D0 - REAL(REFRAC,8)
	ABSORP	= 2.0d0 * TWOPI *(-AIMAG(REFRAC)) / R_LAM0
#else
	DELTA_REF  = 1.0D0 - DREAL(REFRAC)
	ABSORP	= 2.0d0 * TWOPI *(-IMAG(REFRAC)) / R_LAM0
#endif
	if (i_debug.EQ.1) write (*,*) '<><>CRYSTAL_FH: REFRAC = ',
     $REFRAC
	if (i_debug.EQ.1) write (*,*) '<><>CRYSTAL_FH: DELTA_REF = ',
     $DELTA_REF
	if (i_debug.EQ.1) write (*,*) '<><>CRYSTAL_FH: ABSORP = ',
     $ABSORP
C
C if kwhat > 3, write text to unit kwhat
C
	if (kwhat.gt.3) then 
        write(kwhat,*) ' '
        write(kwhat,*) 
     $'******************************************************'
        write(kwhat,*) 'Crystal data from file ',filename
        WRITE(kwhat,*) '       at energy    = ',PHOT,' eV'
        WRITE(kwhat,*) '                    = ',R_LAM0*1E8,' Angstroms'
        WRITE(kwhat,*) '       and at angle = ',THETA*TODEG,' degrees'
        WRITE(kwhat,*) '                    = ',THETA,' rads'
        write(kwhat,*) 
     $'******************************************************'
        WRITE(kwhat,*) ' '
        do j=1,nbatom
          WRITE(kwhat,*) 'For atom ',j,':'
          WRITE(kwhat,*) '       fo + fp+ i fpp = '
          WRITE(kwhat,*) '        ',f0(j),'+',f1(j),'+ i',f2(j),'= '
          WRITE(kwhat,*) '        ',f0(j)+f1(j)+ci*f2(j)
          WRITE(kwhat,*) '       Z = ',atnum(j)
        end do
        WRITE(kwhat,*) 'Structure factor F(0,0,0) = ',F_0
        WRITE(kwhat,*) 'Structure factor FH = ',FH
        WRITE(kwhat,*) 'Structure factor FH_BAR = ',FH_BAR
        WRITE(kwhat,*) 'Structure factor F(h,k,l) = ',STRUCT
        WRITE(kwhat,*) 'Psi_0  = ',psi_0
        WRITE(kwhat,*) 'Psi_H  = ',psi_h
        WRITE(kwhat,*) 'Psi_HBar  = ',psi_hbar
C        WRITE(kwhat,*) 'Temperature factor = ',TEMPER
        WRITE(kwhat,*) 'Refraction index = 1 - delta - i*beta :'
        WRITE(kwhat,*) '           delta = ',DELTA_REF
#if lahey
        WRITE(kwhat,*) '            beta = ',-1.0D0*AIMAG(REFRAC)
#else
        WRITE(kwhat,*) '            beta = ',-1.0D0*IMAG(REFRAC)
#endif
        WRITE(kwhat,*) 'Absorption coeff = ',ABSORP,' cm^-1'
        WRITE(kwhat,*) ' '
        WRITE(kwhat,*) 'e^2/(mc^2)/V = ',rn,' cm^-2'
        WRITE(kwhat,*) 'd-spacing = ',d_spacing*1.0E8,' Angstroms'
C        WRITE(kwhat,*) 'Photon Energy        = ',PHOT,' eV'
C        WRITE(kwhat,*) 'Lambda               = ',R_LAM0*1E8,' Angstroms'
        WRITE(kwhat,*) 'SIN(theta)/Lambda = ',Ratio
C        WRITE(kwhat,*) 'theta = ',theta,' rads'
C        WRITE(kwhat,*) '      = ',theta*TODEG,' degrees'
        WRITE(kwhat,*) ' '
	
	endif
     	ENDIF
     	END
