FUNCTION xop_defaults,program_name
;+
; NAME:
;	XOP_DEFAULTS
;
; PURPOSE:
;	Define the data structure for each program of the Xop application.
;	The purpose of this function is to contain all the default input 
;	parameter definitions in order to allow different Xop users to
;	customize their particular input defaults. 
;
; CATEGORY:
;	Xop application.
;
; CALLING SEQUENCE:
;
;	inp = XOP_DEFAULTS('xprogram')
;
; INPUTS:
;	xprogram:	Name of the program interface in Xop.
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;	The input structure with the data necessary to run the program.
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;
; RESTRICTIONS: 
;       *** WARNING  ***
;     Be careful with the type of the variables. Setting for instance
;     A:4 initializes the variable A as a short integer (16-bit) and it will
;     NEVER be used as a floating point variable. Use A:4.0 to set it as
;     a floating point variable.
;
; PROCEDURE:
;	Straightforward.
;
; EXAMPLE:
;	inp = xop_defaults('xurgent')
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio
;	October, 1994	
;	95/10/24 MSR adds xopmap (mapping option)
;	95/10/31 MSR adds filedir keyword , to allow users to create
;		a file ~/.xop_defaults with his own customization.
;	96/01/11 MSR+RJD include xus and xws for realeasing xop1.3
;	96/01/17 MSR removes case 'Printer' (obsoleted by GetSysPrinter
;		function)
;	96/01/22 srio@esrf.fr adds XOPMAP.editor and XOPMAP.idlcommand
;	96/04/23 srio@esrf.fr adds XCOM and ABSORP
;	96/06/26 srio@esrf.fr adds xsrcomp/rb_choice and xsrcomp/bfield_t
;	96/07/29 srio@esrf.fr adds xpenpol
;	96/12/19 srio@esrf.fr small modifications in xpenpol
;	97/01/03 srio@esrf.fr introduces xcrystal_bent which obsoletes
;		xreflex and xpenpol (deleted).
;	97/01/06 srio@esrf.fr adds xpower
;	97/01/16 srio@esrf.fr adapts for Windows95.
;	97/03/13 MSR removes xopmap (mapping option). It is now handled
;		by $XOP_HOME/data/xop_menu.dat file.
;	97/03/24 bug in xcrystal/thickness label mm->cm. Introduce dummy
;		values in xpower structure to get better parameter
;		presentation under idl5.0-b5
;	97/10/01 srio@esrf.fr removes obsoleted shadow applications:
;		(xsrcomp, xabrefc, xtransmit, xbragg). Makes use of sdep()
;	97/10/06 srio@esrf.fr removes obsoleted shadow application: xmlayer
;	97/10/07 srio@esrf.fr some fixes in xcrystal
;	97/10/09 srio@esrf.fr some changes in xcrystal_bent
;	97/11/10 srio@esrf.fr added K(GAP) tool entry in xwiggler.
;	97/11/11 srio@esrf.fr added xop.LogUsersFile entry.
;	97/11/17 RJD+MSR included RJD modificactions from APS version:
;       	97/09/08 RJD: set the keyword remove_all in strcompress and
;               rewrote latter part of the function related to using data from
;               the .xop_defaults data files. Minor modifications to some text.
;               Added the forward_function statement for the function spec_name
;               so that it will be recognized upon execution (and for an error
;               free compilation). Added an entry for the interface for 
;		the tuning curve program XTC.
;	98/11/04 srio@esrf.fr removed code dependencies for IDL version 4.
;		Looks for file xop_defaults instead of .xop_defaults under 
;		WINDOWS. Use of Catch.
;	98/11/24 srio@esrf.fr reads now defaults (sequentially) from 
;		files $XOP_HOME/defaults/<application>.xop and 
;		$XOP_DEFAULTS_DIR/<application>.xop 
;		(the last one, in Unix, usually points to
;		$HOME/.xop/<application>.xop).
;	98/12/14 srio@esrf.fr Adapted for XOP2.0. Deletex xop and www
;		entries.
;
;	
;
;-

forward_function spec_name, crystal_bent_theories


catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,'XOP_DEFAULTS: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   IF N_Tags(out) GT 0 THEN RETURN,out ELSE RETURN,0
endif

program_name = strupcase(program_name)

case program_name of
	'XBFIELD': begin                   ; (yaup preprocessor)
		if sdep() EQ 'WINDOWS' then file='undulbf' else FILE='undul.bf'
		xbfield	  =  {  Xbfield, $
		PERIOD: 4.0, $
		NPER: 42, $
		NPTS: 40, $
		IMAGNET: ['0','Nd-Fe-B','Sm-Co'], $
		ITYPE: ['0','planar undulator','tapered undulator'], $
		K: 1.38,   $           ; only if ITYPE = 1
		GAP: 2.0,	$      ; Gap at zmin (cm)
		GAPTAP: 10.0,	$      ; Gap taper (%)
		FILE:file}
		end
	'XFILTER': begin
		xfilter	  =  { Xfilter, $
	        Empty1: '              ', $
	        Empty2: '              ', $
		Nelements:['1','1','2','3','4','5'], $
		source: ['0',   'Normalized to 1           ', $
				'From external file.       ', $
				'xop/source SRCOMPE (Flux) ',$
				'xop/source SRCOMPW (Power)'], $
		ener_min: 1000., $
		ener_max: 50000., $
		ener_n: 100, $
		source_file: 'SRCOMPW', $
		;
		el1_sym:'Be', $
		el1_thi:500.0, $
		;
		el2_sym:'Al', $
		el2_thi:50.0, $
		;
		el3_sym:'Pt', $
		el3_thi:10.0, $
		;
		el4_sym:'Au', $
		el4_thi:10.0, $
		;
		el5_sym:'Cu', $
		el5_thi:10.0 }
		end
	'XTRANS': begin
		xtrans	  =  { Xtrans, $
	        Empty1: '              ', $
	        Empty2: '              ', $
		Nelements:['1','1','2','3','4','5'], $
		source: ['1',   'Normalized to 1 (Standard E grid)     ', $
				'Normalized to 1 (E grid from keyboard)',$
				'From external file.       ', $
				'xop/source SRCOMPE (Flux) ',$
				'xop/source SRCOMPW (Power)'], $
		ener_min: 1000., $
		ener_max: 50000., $
		ener_n: 100, $
		source_file: 'SRCOMPW', $
		;
		el1_sym:'Be', $
		el1_thi:0.5, $
		;
		el2_sym:'Al', $
		el2_thi:0.050, $
		;
		el3_sym:'Pt', $
		el3_thi:0.010, $
		;
		el4_sym:'Au', $
		el4_thi:0.010, $
		;
		el5_sym:'Cu', $
		el5_thi:0.010 }
		end
	'XINPRO': begin
		titles = [ 'Crystal material: ', $
                  'Calculation mode:', $
                  'Energy [eV]:', $
                  'Miller index H:', $
                  'Miller index K:', $
                  'Miller index L:', $
                  'Asymmetry angle:', $
                  'Crystal thickness [microns]:', $
                  'Crystal temperature [K]:', $
		  'Number of points: ', $
		  'Angular limits: ', $
		  'Theta min [arcsec]:', $
		  'Theta max [arcsec]:' ]
		flags = ['1','1','1','1','1','1','1','1','1','1','1', $
		  'w(10) eq 1','w(10) eq 1']
		xinpro	  =  { titles:titles, flags:flags, $
			parameters:{ Crystal_material: $
			  ['0','Silicon','Germanium','Diamond',$
			'GaAs','GaP','InAs','InP','InSb','SiC','CsF', $
			'KCl','LiF','NaCl','Graphite','Beryllium'] , $
			Mode: ['0','Reflectivity in Bragg case', $
		 	'Transmission in Bragg case', $
		 	'Reflectivity in Laue case', $
		 	'Transmission in Laue case'], $
			Energy: 8000., $
			Miller_index_h: 1, $
			Miller_index_k: 1, $
			Miller_index_l: 1, $
			Asymmetry_angle: 0.0, $
			Thickness: 500., $
			Temperature: 300.0, $
			Npoints: 100, $
			Scale: ['0','Automatic','External'], $
			xfrom:-50., $
			xto:+50. }}
		end

	'XCRYSTAL': begin
		a = dabax_defaults('bragg')
		a.parameters.outfil = 'xcrystal.bra'
		;if sdep() EQ 'WINDOWS' then $
		;  a.parameters.outfil = 'xcrystal.bra' else $
		;  a.parameters.outfil = 'xcrystal.bragg'
		energy_shift = 100.
		energy_step = 5.
		titles = ['DABAX f0 file:','DABAX f1f2 file:',$
			'Crystal:',$
			'h Miller index','k Miller index','l Miller index',$
			'Include absorption:','Temperature factor [see help]:',$
			'Mosaic Crystal:',$
			'Geometry:','Scan:','Scan Units:',$
			'Min Scan value:','Max Scan value:','Scan Points:', $
			'Fix value (E[eV] or Theta[deg])','Asymmetry angle [deg] (to surf.)',$
			'Crystal Thickness [cm]:','Mosaicity [deg, fwhm]: ']
		flags = ['1','1',$
			'1',$
			'1','1','1',$
			'0','1',$    ; always absorption
			'1',$    ; w8
			'1','1','w(10) LE 2',$
			'1','1','1',$
			'1','w(8) EQ 0', $
			'1','w(8) EQ 1']
		;flags(6) = 0 ; by now, do not ask to include absorption
		xcrystal = { titles:titles, flags:flags, bragg:a, $
			energy_shift:energy_shift, $
			energy_step:energy_step, $
			parameters:{ filef0:a.parameters.filef0, $
			filef1f2:a.parameters.filef1f2, $
			Crystal_material: a.parameters.ilattice, $
			Miller_index_h:  a.parameters.hmiller, $
			Miller_index_k:  a.parameters.kmiller, $
			Miller_index_l:  a.parameters.lmiller, $
			i_absorp: a.parameters.i_absorp, $
			temper: a.parameters.temper, $
			mosaic: ['0','No','Yes'],$
			Geometry: ['0','BRAGG: diffr beam','LAUE: diffr beam', $
                  	  'BRAGG: transm beam','LAUE: transm beam'] , $
			Scan:['2','Theta (absolute)','Th - ThBragg(corrected)',$
                          'Th - Th Bragg','Energy [eV]','y (Zachariasen)'], $
			Unit:['1','Radians','micro rads','Degrees','ArcSec'],$
			ScanFrom:-100.0, ScanTo:100.0, ScanPoints:200, $
			Energy:8000.0, Asymmetry_angle:0.0, $
			Thickness:0.70, Mosaic_fwhm:0.1} $
			} 
		end
	'XCRYSTAL_BENT': begin
		a = dabax_defaults('bragg')
		if sdep() EQ 'WINDOWS' then $
		  a.parameters.outfil = 'xcrystal.bra' else $
		  a.parameters.outfil = 'xcrystal.bragg'
		energy_shift = 100.
		energy_step = 5.
		titles = ['DABAX f0 file:','DABAX f1f2 file:',$
			'Crystal:',$
			'h miller index','k miller index','l miller index',$
			'Include absorption:','Temperature factor [see help]:',$
			'Calculation theory:',$
			'Geometry:',$
			'Min Y value:','Max Y value:','Number of points:', $
			'Photon Energy [eV]','Asymmetry angle [deg] (to surf.)',$
			'Polarization:',$
			'Radius of Curvature [m]', $
			'Crystal Thickness [mm]:','Poisson ratio: ']
		flags = replicate('1',n_elements(titles))
		;flags(6) = 0 ; by now, do not ask to include absorption
		tt_titles=['window [microns]',$
			  'step [microns]',$
			  'Write file with network?',$
			  'Write file with all diff prof?']
		tt_flags = replicate('1',n_elements(tt_titles))
;		tt_pars={window:-1.0, $
;			step:-1.0, $
;			net:['0','No','Yes'],$
;			all:['0','No','Yes']}
		xcrystal_bent = { $
;			tt_pars:tt_pars, $
			n_main:19, $
			n_tt:4, $
			tt_titles:tt_titles,$
			tt_flags:tt_flags,$
			titles:titles, flags:flags, bragg:a, $
			energy_shift:energy_shift, $
			energy_step:energy_step, $
			codes:crystal_bent_theories(),$
			parameters:{ filef0:a.parameters.filef0, $
			  filef1f2:a.parameters.filef1f2, $
			  Crystal_material: a.parameters.ilattice, $
			  Miller_index_h:  a.parameters.hmiller, $
			  Miller_index_k:  a.parameters.kmiller, $
			  Miller_index_l:  a.parameters.lmiller, $
			  i_absorp: a.parameters.i_absorp, $
			  temper: a.parameters.temper, $
			  theory: ['0',crystal_bent_theories(/NAMES)],$
			  Geometry: ['1','BRAGG','LAUE'], $
			  Y_start:-25.0, $
			  Y_end:25.0, $
			  npts:200L, $
			  Energy:33144.0, $
			  Asymmetry_angle:63.78, $
			  Polarization:['0','Sigma','Pi','Non polarized'],$
			  Radius_min_m:12.98, $
			  Thickness:0.70, $
			  Elastic: 0.2202, $ ; END MAIN PARAMETERS (19)
			    window:-1.0, $
			    step:-1.0, $
			    net:['0','No','Yes'],$
			    all:['0','No','Yes'] $  ; END TT PARS (2)
; ;
; IF CHANGED THE NUMBER OF PARS< ALSO CHANGE N_MAIN AND N_TT
;
			  } $ ;end parameters
			}
		end

	'XPOWER': begin
		filecomp = 'Compounds.dat'
		iden_mu = 'CrossSec_'
		ipos = 9
		iden_f = 'f1f2_'
                list = dabax_ls()
                dataf1f2 = list[where(strpos(list,iden_f) NE -1)]
                ;list = dabax_ls()
                dataMu = list[where(strpos(list,iden_mu) NE -1)]
                ; take only names with a single "_"
                dataMu = dataMu(where( strpos(dataMu,'_',ipos) EQ -1))
		file = dabax_pathf(filecomp)
		h = dabax_access(file)
		n = spec_access(h)
		mat_list = strarr(n)
		for i=0,n-1 do mat_list[i]=spec_name(h,i+1,/index)
		filecomp = 'Compounds.dat'
		iden_mu = 'CrossSec_'
		ipos = 9
		iden_f = 'f1f2_'
                list = dabax_ls()
                dataf1f2 = list[where(strpos(list,iden_f) NE -1)]
                ;list = dabax_ls()
                dataMu = list[where(strpos(list,iden_mu) NE -1)]
                ; take only names with a single "_"
                dataMu = dataMu(where( strpos(dataMu,'_',ipos) EQ -1))
		file = dabax_pathf(filecomp)
		h = dabax_access(file)
		n = spec_access(h)
		mat_list = strarr(n)
		for i=0,n-1 do mat_list[i]=spec_name(h,i+1,/index)
		titles = ['    f1f2 dataset:     ','Mu dataset:',$
                  'Source:', 'DUMMY1','DUMMY2','DUMMY3', $
		  'From energy [eV]:      ', 'To energy [eV]:', $
                  'Energy points:  ', 'File with source:', $
		  'Number of elements:',$
                  '1st oe formula','kind:',$
			'Filter thick[mm]','Mirror angle[mrad]',$
			'Roughness[A]', 'Density [g/cm^3]', $
                  '2nd oe formula','kind:',$
			'Filter thick[mm]','Mirror angle[mrad]',$
			'Roughness[A]', 'Density [g/cm^3]', $
                  '3rd oe formula','kind:',$
			'Filter thick[mm]','Mirror angle[mrad]',$
			'Roughness[A]', 'Density [g/cm^3]', $
                  '4th oe formula','kind:',$
			'Filter thick[mm]','Mirror angle[mrad]',$
			'Roughness[A]', 'Density [g/cm^3]', $
                  '5th oe formula','kind:',$
			'Filter thick[mm]','Mirror angle[mrad]',$
			'Roughness[A]', 'Density [g/cm^3]' ]
		flags = replicate('1',n_elements(titles))
		flags(3:5)='0' ;dummy values
		flags(6) = 'w(2) eq 1'
		  flags(7) = 'w(2) eq 1'
		    flags(8) = 'w(2) eq 1'
		      flags(9) = 'w(2) eq 2'
		  istart = 11
		for i=0,4 do begin
		  flags(istart+0+6*i) = ' w(10) ge '+strcompress(i,/rem)
		  flags(istart+1+6*i) = ' w(10) ge '+strcompress(i,/rem)
		  flags(istart+2+6*i) = $
			'w('+strcompress(istart+1+6*i,/rem)+') eq 0 and' +$
			' w(10) ge '+strcompress(i,/rem)
		  flags(istart+3+6*i) = $
			'w('+strcompress(istart+1+6*i,/rem)+') ne 0 and' +$
			' w(10) ge '+strcompress(i,/rem)
		  flags(istart+4+6*i) = $
			'w('+strcompress(istart+1+6*i,/rem)+') ne 0 and'+$
			' w(10) ge '+strcompress(i,/rem)
		  flags(istart+5+6*i) = ' w(10) ge '+strcompress(i,/rem)
		endfor
		xpower= { titles:titles, flags:flags, $
		mat_list:mat_list,$
		parameters:{ xpower, $
	        f1f2: ['0',dataf1f2],$
	        Mu: ['0',dataMu],$
		source: ['1',   'Normalized to 1 (Standard E grid)  ',$
				'Normalized to 1 (E from keyboard)  ',$
				'From external file.                ',$
				'xop/source Flux (file: SRCOMPE)    ',$
				'xop/source Power (file: SRCOMPW)   '],$
		dummy1:'', $
		dummy2:'', $
		dummy3:'', $
		ener_min: 1000., $
		ener_max: 50000., $
		ener_n: 100, $
		source_file: '?', $
		Nelements:['1','1','2','3','4','5'], $
		;
		el1_for:'Be', $
		el1_flag:['0','Filter','Mirror'], $
		el1_thi:0.5, el1_ang:3.0, el1_rou:0.0, el1_den:'?', $
		;
		el2_for:'Rh', $
		el2_flag:['1','Filter','Mirror'], $
		el2_thi:0.5, el2_ang:3.0, el2_rou:0.0, el2_den:'?', $
		;
		el3_for:'Al', $
		el3_flag:['0','Filter','Mirror'], $
		el3_thi:0.5, el3_ang:3.0, el3_rou:0.0, el3_den:'?', $
		;
		el4_for:'B', $
		el4_flag:['0','Filter','Mirror'], $
		el4_thi:0.5, el4_ang:3.0, el4_rou:0.0, el4_den:'?', $
		;
		el5_for:'Pt', $
		el5_flag:['1','Filter','Mirror'], $
		el5_thi:0.5, el5_ang:3.0, el5_rou:0.0, el5_den:'?'} } 
		end
        'XTC': BEGIN
                xtc       =  { Xtc, $
                title: 'APS Undulator A, Beam Parameters from SPIE vol. 2856/16-25', $
                energy: 7.00, $
                cur: 100.00, $
                sige:0.00100, $
                text_machine: '', $
                sigx: 0.300, $
                sigy: 0.060, $
                sigx1: 0.0250, $
                sigy1: 0.0053, $
                text_beam: '', $
                period: 3.30, $
                np: 70, $
                text_undulator: '', $
                emin: 2900.0, $
                emax: 13500.0, $
                n: 20, $
                text_energy: '', $
                ihmin: 1, $
                ihmax: 5, $
                ihstep: 2, $
                text_harm: '', $
                ihel: 0, $
                method: 1, $
                ik: 1, $
                neks: 100, $
                text_parm: '', $
                run_mode_name: 'foreground' }
                END
	'XUS': BEGIN
		xus	  =  { Xus, $
		title: 'APS Undulator A, Beam Parameters from SPIE vol. 2856/16-25', $
  		energy: 7.00, $
  		cur: 100.00, $
		text_machine: '', $
      		sigx: 0.300, $
		sigy: 0.060, $
		sigx1: 0.0250, $
		sigy1: 0.0053, $
		text_beam: '', $
		period:	3.30, $
		np: 70, $
		kx: 0.000, $
		ky: 2.760, $
		text_undulator: '', $
		emin: 1000.0, $
		emax: 50000.0, $
		n: 5000L, $
		text_energy: '', $
		d: 30.000, $
		xpc: 0.000, $
		ypc: 0.000, $
		xps: 2.500, $
		yps: 1.000, $
		nxp: 25, $
		nyp: 10, $
		text_pinhole: '', $
		mode: 2, $
		method: 4, $
		iharm: 0, $
		text_mode: '', $
		nphi: 0, $
		nalpha: 0, $
		calpha2: 0.0, $
		nomega: 64, $
		comega: 8.0, $
		nsigma: 0, $
		text_calc: '', $
		run_mode_name: 'foreground' }
		END
	'XURGENT': begin
		xurgent	  =  { $
		; title
		TITLE: 'ESRF HIGH BETA UNDULATOR', $
		; machine
		ENERGY: 6.04, $
		CUR: 0.1, $
		SIGX: 0.4, $
		SIGY: 0.08, $
		SIGX1: 0.0160, $
		SIGY1: 0.0090, $
		; undulator
		ITYPE: 1, $
		PERIOD: 0.046, $
		N: 32, $
		KX: 0.0, $
		KY: 1.7, $
		PHASE: 0.0, $
		; Scan
		EMIN: 10000., $
		EMAX: 50000., $
		NENERGY: 100, $
		; pinhole
		D: 27.0, $
		XPC: 0.0, $
		YPC: 0.0, $
		XPS: 3.0, $
		YPS: 3.0, $
		NXP: 25, $
		NYP: 25, $
		; calculation
		MODE: 4, $
		ICALC: 2, $
		IHARM: -1, $
		NPHI: 0, $
		; advanced
		NSIG: 0, $
		NALPHA: 0, $
		DALPHA: 0., $
		NOMEGA: 0, $
		DOMEGA: 0. }
		end
	'XWIGGLER': begin
		titles= [ 'Magnetic field: ', $
			  'Number of periods', $
		          'Wiggler period [m]', $
		          'K value', $
		          'Beam energy [GeV]', $
		          'Min Photon Energy [eV]', $
		          'Max Photon Energy [eV]', $
		          'Number of energy points', $
		          'Energy points spacing', $
		          'Number of traj points per period', $
		          'Electron Beam Current [mA]' ,$
			  'File with Magnetic Field' ]
		Flags= ['1','1','w(0) ne 1','w(0) eq 0','1','1','1','1', $
		  '1','w(0) ne 1','1','w(0) ne 0']
		xwiggler = { titles:titles, flags:flags, $
		kgap_tool:{Br:1.57,Bp:!pi},$
		parameters:{Xwiggler, $
		  Field: ['0','Sinusoidal','B from file', $
				'B from harmonics'], $
		  Nperiods: 12L, $
		  Ulambda: 0.125D0, $
		  K: 14.0D0, $
		  Energy: 6.04D0, $
		  Phot_energy_min: 100.0D0, $
		  Phot_energy_max: 100100.0D0, $
		  nPoints: 100L , $
		  logPlot: ['1','Lin','Log'] , $
		  nTrajPoints: 101L , $
		  Current: 200.0D0 , $
		  File: '?' }}
		end
	'XYAUP': begin
		if sdep() EQ 'WINDOWS' then BFILE='undulbf' else $
			BFILE='undul.bf'
		xyaup	  =  { Xyaup, $
		TITLE: 'YAUP EXAMPLE (ESRF BL-8)', $
		PERIOD:4.0, $
		NPER: 42, $
		NPTS: 40,$ 

		EMIN: 3000.0, $
		EMAX: 30000.0, $
		NENERGY: 100, $
		
		ENERGY: 6.04, $
		CUR: 0.1, $
		SIGX: 0.426, $
		SIGY: 0.085, $
		SIGX1: 0.017, $
		SIGY1: 0.0085, $

		D: 30.0, $
		XPC: 0.0, $
		YPC: 0.0, $
		XPS: 2.0, $
		YPS: 2.0, $
		NXP: 0, $   ;25, $
		NYP: 0,  $   ;25, $

		MODE: 4, $
		NSIG: 2, $
		TRAJECTORY:'new+keep',	$
		XSYM:'yes',	$
		HANNING:0,	$

		BFILE:bfile,	$
		TFILE:'undul.traj'}
		end
	'XXCOM': begin
		titles=[ 'Name','Substance:','Description:',$
			'fraction','grid','grid points','grid points [MeV]/file name', $
			'Output quantity' ] ; , $
			;'Conversion factor from file units to MeV']
		flags=['1','1','1', $
			'w(1) EQ 3','1','w(4) NE 0','(w(4) NE 0)', $
			'w(1) LE 1'] ; , '(w(4) NE 0) and (w(5) NE 0)']
		xxcom	  =  { titles:titles, flags:flags, $
		parameters:{ NAME:'Pyrex Glass', $
		SUBSTANCE:['3','Element (Atomic number)','Element (Symbol)', $
			'Compound (Formula)','Mixture (F1:F2:F3...)'], $
		DESCRIPTION:'SiO2:B2O3:Na2O:Al2O3:K2O', $
		FRACTION:'0.807:0.129:0.038:0.022:0.004', $
		GRID:['1','Standard','Standard+points','Points only'], $
		GRIDINPUT:['0','From Keyboard','From file'], $
		GRIDDATA:'0.0804:0.2790:0.6616:1.3685:2.7541', $
		ELEMENTOUTPUT:['0','Cross section [b/atom]',$
		   'Cross section [b/atom] & Attenuation coeff [cm2/g]',$ 
		   'Partial interaction coeff & Attenuation coeff [cm2/g]'] }} ; , $
		;FILECONV:1e-6}}
		end
	'XHENKE': begin
		xhenke	  =  { Xhenke, $
		NAME:' a sample protein', $
		SUBSTANCE:'protein', $
		DENSITY:'?', $
		GRID:['1','Standard','Standard+points','Points only'], $
		GRIDINPUT:['0','From Keyboard','From file'], $
		GRIDDATA:'1000:2000:3000:4000',$
		ANGLEOPT:['1','No','Grazing angle [mrad]', $
			'Grazing angle [deg]','Incidence angle [deg]'],$
		ANGLEVAL:5.0 }
		end
	'XATTEN': begin
		xatten	  =  { Xatten, $
		NAME:' a sample protein', $
		SUBSTANCE:'protein', $
		DENSITY:'?', $
		GRID:['0','Standard','Standard+points','Points only'], $
		GRIDINPUT:['0','From Keyboard','From file'], $
		GRIDDATA:'1000:2000:3000:4000',$
		MUUNITS:['0','Linear','Mass'] }
		end
	'EXODUS': begin
		titles=[ 'Lines to skip in ASCII files:', $
		         'Import filter:', $
                         'Copy SPEC scan number?', $
	                 'Default ColX', $
	                 'Default ColY', $
			 'Default X axis', $
                         'Default Y axis']
		flags=Replicate(1,N_Elements(titles))
		exodus	  =  { titles:titles, flags:flags, $
		          parameters:{ rascii_skip:0, $
			     import_filter:'y=read_edf(file)', $
			     specNumbering:['1','No','Yes'], $
			     xcol:'col1', $
			     ycol:'col2', $
                             xlog:['0','Lin','Log'], $
                             ylog:['0','Lin','Log'] } }
		end

	'FUFIFA': begin

        	titles=['Fitting tolerance','Max of fitting iterations',$
	          'Use errors from third column (if exists)',$
	          'Data errors', 'Report printing frequency', $
		  'Fit time limit (per scan) [sec]', $
		  'Show Log window for fit',$
		  'Information Mode' ]

	        flags=Replicate('1',N_Elements(titles))
                flags[3]='w(2) NE 0'
	
		fufifa =  { titles:titles, flags:flags, $
		  	parameters:{ tol:1D-10, $
			maxIter:200, $
		  	errorsFrom:['1','Yes','No'], $
		  	errors:['0','Constant','Statistical'],$ 
		  	nPrint:10, $
			tMax:30.0, $
			log:['1','No','Yes'], $
			expert:['0','Verbose','Expert']  } }

		end

	else:   begin
		message,/info,'Error: Program not found'
		out = 0
		end
	endcase

;
;----------------------- WARNING !! -------------------------------
; If this section is modified, please check also dabax_defaults.pro
;------------------------------------------------------------------
;
; rename the structure to out
;
out = 0
command = 'out = '+program_name
;print,command 
tmp = Execute(command)

;
; Overwrite data with values from defaults files
; (when changing this code, also check xop_ifc.pro) 
;
sep = sdep(/ds)
filedir = [Xop_GetEnv('XOP_HOME')+sep+'defaults'] 
filedir = [filedir]
IF Xop_GetEnv('XOP_DEFAULTS_DIR') NE '' THEN $
   filedir = [filedir,Xop_GetEnv('XOP_DEFAULTS_DIR')]

nfiles = n_elements(filedir)
if nfiles EQ 1 then filedir = [filedir]
tmp=0
for i=0,nfiles-1 do begin
  file = filedir[i]+sep+StrLowCase(program_name)+'.xop'
  tmp = checkfile(file)
  if tmp EQ 1 then begin
    str_par = Xop_Input_Load(inputFile=file)
    ;IF N_Tags(out.parameters) NE 0 THEN BEGIN
    IF (Where(StrUpCase(Tag_Names(out)) EQ 'PARAMETERS'))(0) NE -1 THEN BEGIN
      tmp = out.parameters
      Copy_Structure,str_par, tmp
      out.parameters = tmp
    ENDIF ELSE BEGIN
      tmp = out
      Copy_Structure,str_par, tmp
      out = tmp
    ENDELSE
    message,/info,'Defaults from file: '+file+'
  endif
endfor
;
; return
;
return,out
end
