function xplot2d_defaults
;
;+ 
; function xplot2d_defaults
;
; returns an structure with inputs for xplot2d
;
; for internal use of xplot2d.pro
;
; released: 
; 2007-12-19 srio@esrf.eu for xplot2d 2.00
;
; modified: 
;
; 2008/04/24 srio@esrf.eu axis_properties all in float.
; 
;-

;
; def
;
imageformat={format:['0','EDF','XRD','MAR','RIGAKU R-AXIS','PRINCETON',$
                     'BINARY','PNG/TIFF/etc','External Reader'],$
       filter:'*.edf',float:['1','No','Yes'], $
       corrections_sequence:['0','No','Yes'],$
       substitute:['1','add image','substitute CURRENT image'],wait:0.0,$
       cs:['0','No','Yes'], applyMask:['0','No','Yes'], $
       recalibrate:['0','No','Yes'], $
       fileIncrementExpression:'[0-9]{4}', $
       saveAzimuthal:['0','No', $
              'in a single spec/scan file: xplot2d_azi.spec', $
              'in separated spec/scan files: <imageFile>_azi.spec', $
              'in a single spec/mca file:  xplot2d_azi.mca', $
              'in separated spec/mca files:  <imageFile>_azi.mca'],$
       externalReader:'image=read_rigaku(file)'}

imageformat_titles= $
     ['Format','Filter', $
     'Convert to float ([needed for masks and operations)',$
     'Apply sequence of corrections (set it in Calculations->Corrections)', 'Store image', $
     'Wait time [sec]','Apply cs (color stretch)','Apply current mask', $
     'Auto-multiring-recalibration',$
     'Regular Expression to match indices for file increment',$
     'Save azimuthal integration to file',$
     'External reader command (use image and file)']

imageformat_flags=Replicate('1',N_Elements(imageformat_titles))
imageformat_flags[N_Elements(imageformat_titles)-1]='w(0) EQ 7'



display = {$
  ; space left for the axes to be drawn to the left and the right
  ; of the image
  margin_space:25, $ 
  ;scrolling step. Each time a scroll action is performed the image 
  ; will be scrolled by an amount of step pixels
  scroll_step:20, $ 
  ;the value which determines how big the display window can be 
  ; relative to the screen size
  max_acceptable_screen_size_factor:0.75,  $
;  scroll_vec:[0,0], $
  image_position:[0,0], $
  ScaleType:'linear',$
  Stretch:-5.0, $
  scale:0.0 } 

cursor1={$
  type:['0','pixelX pixelY Intens','2theta dSpacing Intensity','axisX axisY Intensity']}
cursor_titles=['Cursor displays: ']


roi = {$
         last:'', $
         list:'', $
         annulus:33.0 }

detector={$
         energy:10000D0, $     ; photon energy in eV
         pixelsize:78.94D0,$   ; pixel size in microns
         x0:0D0, $         ; beam intersection with detector plane
         y0:0D0, $         ; beam intersection with detector plane
         xS:0D0,$          ; sample position [pixels] in detector reference
         yS:0D0,$          ; sample position [pixels] in detector reference
         zS:1000D0,$       ; sample position [pixels] in detector reference
         useEllipses:['1','No','Yes'] }   ; use ellipses flag

rings ={abscissas:['1','TwoTheta','d-spacing'], $
           file:'?', $
           ener_flag:['0','Cu Ka1 (8047.78 eV)','Mo Ka1 (17479.34 eV)','Rh Ka1 (20216.1eV)', $
                      'W Ka1 (59318.24 eV)', 'other'], $
           ener_val:10000.0,removeDuplicate:['1','No','Yes']}
rings_titles=['Abscissas', 'File (? for browser)', $
             'Photon energy [eV] of the diffractogram with reference peaks', $
             'Energy value [eV]','Remove duplicated values']
rings_flags=['1','1','w(0) EQ 0', 'w(0) EQ 0 AND w(2) EQ 4','1']



axis_properties = {x_origin:0.0,x_pixel_unit_ratio:1.0,y_origin:0.0,y_pixel_unit_ratio:1.0}

load_bin = { file:'?', header:4096L, xsize:2048L, ysize:2048L, type:['12', $
             'Undefined (NOT IMPLEMENTED)', 'Byte', 'Integer', 'Longword integer', $
             'Floating point', 'Double-precision floating', 'Complex floating', $
             'String (NOT IMPLEMENTED)', 'Structure (NOT IMPLEMENTED)', 'Double-precision complex', $
             'Pointer (NOT IMPLEMENTED)', 'Object reference (NOT IMPLEMENTED)', 'Unsigned Integer', $
             'Unsigned Longword Integer', '64-bit Integer', 'Unsigned 64-bit Integer'] }

load_bin_titles=['File (? for launching browser)','Header [bytes]', 'X size [pixels]',$
           'Y size [pixels]','Data type']


simul_dspacing={file:'?', $
      xsize:100,ysize:100, $
      energy:1000.0, $
      xc:0.0, yc:0.0, $
      xs:0.0, ys:0.0, zs:0.0, width:0.02,  $
      output:['0','New Image','New Window']}

simul_dspacing_titles=[$
             'File (? for browser)',$
             'Pixels in X','Pixels in Y','Energy for created image [eV]', $
             'Beam on Detector in X [pixel]', $
             'Beam on Detector in Y [pixel]', $
             'Sample in X [pixel]', 'Sample in Y [pixel]','Sample in Z [pixel]',$
             'Peak width FWHM [deg]',  'Output to']


simul_fromprofile={file_profile:'?', $
      detector_dist:100D0,  $
      dummy_pixels:2, $
      pixelsize:detector.pixelsize,  $
      xsize:0L, $
      ysize:0L, $
      e0:8047.7798, $
      e1:detector.energy, $
      x:0D0, $
      y:0D0, $
      output:['0','New Image','New Window']}

simul_fromprofile_titles= [ $
              'File (? for browser)', $
              'Distance sample-image [cm]', $
              'dummy pixels', $
              'pixelsize [microns]', $
              'Pixels in X', $
              'Pixels in Y', $
              'Energy of XRD profile [eV]', $
              'Energy of current image [eV]', $
              'Center in X [pixel]', $
              'Center in Y [pixel]', $
              'Output to']

pref = {  $
          step_azimuth:1.0D0, $
          step_azimuth_axial:0.01D0, $
          annulus_nsectors:100L, $
          force_azimuth_axial:['1','No','Yes'], $
          ring_linestyle:['1','0:Solid','1:Dotted','2:Dashed','3:Dash-Dot','4:-...','5:Long Dash'], $
          ring_thick:1.0,$
          overplotDiffFlag:['0','No','Yes'],$
          overplotDiffAngle:0.0,$
          overplotDiffBackground:['1','No','Yes'],$
          overplotDiffColor:2 }

pref_titles = ['Step for azimuthal integration (circles) [pixels]', $
               'Step for axial azimuthal integration (ellipses) [deg]',$
               'Number of sector for binning annuli',$
               'Force axial azimuthal full calculation',$
               'Linestyle for overplotted rings',$
               'Thickness for overplotted rings/diffractogram',$
               'Overplot diffractogram [if azimuthal integ. autorefresh=on]',$
               'Diffractogram rotation angle [deg]',$
               'Diffractogram: substract background',$
               'Diffractogram color index']

pref_flags = ['1','1','1','1','1','1','1',$
             'w(6) EQ 1','w(6) EQ 1','w(6) EQ 1']

xy2rphi = {  $
          ;pars:['0','Default (x0,y0 from detector)','User Specified','Test case'],$
          pars:['0','User Specified','Test case'],$
          x0:0D0, $
          y0:0D0, $
          phimin:0D0, $
          phimax:359D0, $
          nphi:360L, $
          rmin:0D0, $
          rmax:0D0, $
          nr:500L } 
xy2rphi_titles = ['parameters','X center [pixel]','Y center [pixel]',$
               'Phi min [deg]','Phi max [deg]','Number of Phi points',$
               'R min [pixel]','R max [pixel] (Default: set Rmax=Rmin)','Number of R points (Default: set 0)']
xy2rphi_flags = Replicate('w(0) EQ 0',N_Elements(xy2rphi_titles))
xy2rphi_flags[0] = '1'

xy2rphi_axial = {  $
          twoThetaMin:0D0, $
          twoThetaMax:45D0, $
          twoThetaStep:0.05D0, $
          phimin:0D0, $
          phimax:360D0, $
          phiStep:1.0D0 } 
xy2rphi_axial_titles = [$
          'twoTheta min [deg]','twoTheta max [deg]','twoThetaStep [deg]',$
          'phi min [deg]','phi max [deg]','phi step [deg]']
xy2rphi_axial_flags = Replicate('1',N_Elements(xy2rphi_axial_titles))

calc_generic_operation = { $
          oper:'imgNew = Max(img)-img', $
          res:['0','new window','this window [new image]', $
                                'this window [overwrite image]']}
calc_generic_operation_Titles=['Operation (see help)','Result to']
calc_generic_operation_Flags=['1','1']

calc_corrections_sequence = { $
          substract:['0','No','Yes'], $
          divide:['0','No','Yes'], $
          warping:['0','No','Yes'], $
          rebin:['0','No','Yes'] }
calc_corrections_sequence_titles=['substract image (dark field)',$
          'divide by image (flat field)','correct geometrical distortions (warping)',$
          'change image or pixel size (rebin)']
calc_corrections_sequence_flags=Replicate('1',N_Elements(calc_corrections_sequence_titles))



calc_substract = { $
          from:['0','Loaded image','Image from EDF file'],$
          number:1L, file:'?', $
          shift:['0','No','Yes'], $
          res:['0','new window','this window [new image]', $
                                'this window [overwrite image]'] }
calc_substract_titles = ['Image to substract from',$
                         'Number of image to substract (starting from 1) ',$
                         'EDF file name with image to substract (? for browser)', $
                         'Shift result minimum to zero', $
                         'Result to']
calc_substract_flags = ['1','w(0) EQ 0','w(0) EQ 1','1','1']


calc_divide = { $
          from:['0','Loaded image','Image from EDF file'],$
          number:1L, file:'?',coefficient:1.0,  $
          res:['0','new window','this window [new image]','this window [overwrite image]'] }
calc_divide_titles = ['Image to divide from',$
          'Number of flat field (starting from 1): newImage=image/flatField ',$
          'EDF file with flat field (? for browser): newImage=image/flatField', $
          'Multiplicative factor for result (newImage=newImage*factor)', $
          'Result to']
calc_divide_flags = ['1','w(0) EQ 0','w(0) EQ 1','1','1']


calc_warping = { $
          file:'?',$
          method:['0','warping by Thin Plate Spline interpolation',$
                      'warping by triangulation ', $
                      'polynomial spatial warping'], $
          interpolation:['1','Linear','Smooth Quintic'],  $
          degree:2, $
          res:['0','new window','this window [new image]', $
                                'this window [overwrite image]'] }
calc_warping_Titles= $
           ['File (? for browser) with control points Xfrom Yfrom Xto Yto',$
             'Method','Interpolation','Polynomial degree','Result to']
calc_warping_Flags=['1','1','w(1) EQ 1','w(1) EQ 2','1']

calc_rebin = { $
          what:['0','Image size','Pixel size'], $
          sampling:['1','Nearest neighbour','Linear interpolation','Cubic interpolation'],$
          newSizeX:1000L,newSizeY:1000L,$
          pixelX:100.0,pixelY:100.0, $
          newPixelX:25.0,newPixelY:50.0, $
          res:['0','new window','this window [new image]', $
                                'this window [overwrite image]'] }
calc_rebin_titles = ['Define new image from','Sampling method',$
          'new size X [pixels]','new size Y [pixels]',$
          'old X pixels size [microns]','old Y pixels size [microns]', $
          'new X pixels size [microns]','new Y pixels size [microns]', $
          'Result to']
calc_rebin_flags = ['1','1','w(0) EQ 0','w(0) EQ 0',$
                    'w(0) EQ 1','w(0) EQ 1','w(0) EQ 1','w(0) EQ 1','1']

create_grid_image = { $
      itype:['0','Gaussian dots','Mesh dots'],$
      s1:2048L, s2:2048L,$
      thick:50.0, period:200.0, amplitude:1000.0, $
      negative:['0','Light image (positive)','Absorption image (negative)'],$
      res:['0','new window','this window [new image]','this window [overwrite image]'] }
create_grid_image_titles=$
          ['Type','Pixels in X','Pixels in Y', $
           'Dot thickness/FWHM [pixels]','Period [pixels]','Amplitude',$
           'Transmission/Absorption','Result to']
create_grid_image_flags = Replicate('1',N_Elements(create_grid_image_titles))


;
; TEXT 
;
;auAtoms = ['8  1.0  0.0  0.0  0.0  O1',   $
;           '8  1.0  0.0  0.0  0.0  O2']
;

str = Create_Struct('imageFormat',imageFormat,$
        'imageFormat_titles',imageFormat_titles, 'imageFormat_flags',imageFormat_Flags, $
        'load_bin',load_bin, 'load_bin_titles',load_bin_titles, $
        'display',display,$
        'cursor',cursor1,'cursor_titles',cursor_titles, $
        'roi',roi,$
        'rings',rings,'rings_titles',rings_titles,'rings_flags',rings_flags, $
        'axis_properties',axis_properties, $
        'simul_dspacing',simul_dspacing, 'simul_dspacing_titles',simul_dspacing_titles, $
        'simul_fromprofile',simul_fromprofile, 'simul_fromprofile_titles',simul_fromprofile_titles, $
        'pref',pref,'pref_titles',pref_titles,'pref_flags',pref_flags,$
        'detector',detector, $
        'xy2rphi',xy2rphi,'xy2rphi_titles',xy2rphi_titles,'xy2rphi_flags',xy2rphi_flags, $
        'xy2rphi_axial',xy2rphi_axial,'xy2rphi_axial_titles',xy2rphi_axial_titles,'xy2rphi_axial_flags',xy2rphi_axial_flags, $
        'calc_generic_operation',calc_generic_operation,'calc_generic_operation_titles',calc_generic_operation_titles, 'calc_generic_operation_flags',calc_generic_operation_flags, $
        'calc_corrections_sequence',calc_corrections_sequence,'calc_corrections_sequence_titles',calc_corrections_sequence_titles,'calc_corrections_sequence_flags',calc_corrections_sequence_flags, $
        'calc_substract',calc_substract,'calc_substract_titles',calc_substract_titles,'calc_substract_flags',calc_substract_flags, $
        'calc_divide',calc_divide,'calc_divide_titles',calc_divide_titles,'calc_divide_flags',calc_divide_flags, $
        'calc_warping',calc_warping,'calc_warping_titles',calc_warping_titles,'calc_warping_flags',calc_warping_flags, $
        'calc_rebin',calc_rebin,'calc_rebin_titles',calc_rebin_titles,'calc_rebin_flags',calc_rebin_flags, $
        'create_grid_image',create_grid_image,'create_grid_image_titles',create_grid_image_titles,'create_grid_image_flags',create_grid_image_flags $
                    )
;str = Create_Struct(str, 'hklStr',hklStr,'hklStr_Titles',hklStr_Titles,'hklStr_Flags',hklStr_Flags, 'hkl',hkl)
;str = Create_Struct(str, 'ucCell',ucCell)

RETURN,str
END
