FUNCTION HISTOERROR,y1,y2,n1,verbose=verbose

;+
; NAME:
;	HISTOERROR
; PURPOSE:
;	Calculates the error of a histogram
; CATEGORY:
;	General
; CALLING SEQUENCE:
;	ysigma = histoerror(y,y2,n)
; INPUTS:
;	y array with the ordinates of the histogram (counts of function values)
;	y2 (optional) the squared function values used for computing error bars 
;       n (optional) the number of events (default n=total(y) ) 
;	
; REFERENCE
;	
;	See Pag 17 in Salvat, Fernandez-varea and Sempau
;       Penelope, A Code System for Monte Carlo Simulation of 
;       Electron and Photon Transport, AEN NEA  (2003)
;
;       See James, Rep. Prog. Phys., Vol 43 (1980) pp 1145-1189 (special attention
;       to pag. 1184)
;
;
; MODIFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble April 2011
;
;-


on_error,2

y = Reform(y1)
IF N_Elements(verbose) EQ 0 THEN verbose=1
IF N_Elements(y2) NE 0 THEN ySquare=Reform(y2) ELSE ySquare = y
IF N_Elements(n1) GT 0 THEN n = Double(n1) ELSE n=Total(y)
i = N_Elements(y)/2
ysigma= sqrt(ySquare-(y^2)/n)
IF verbose THEN BEGIN
print,'% HISTOERROR: center: sigma, %     : ',ysigma[i],100.0*ysigma[i]/y[i]
print,'%             counts,counts-squared: ',y[i],ySquare[i]
print,'% HISTOERROR: Total(counts), Number of events: ',Total(y),n
ENDIF
;ysigma2= sqrt(ySquare-(y^2)/n)
;print,'Sigmia2 at center: ',ysigma2[i]
;print,' counts,counts2: ',y[i],ySquare[i]
RETURN,ySigma
END

